/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.initiator.deleteiscsipaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.deleteiscsipaths.SJctrDeleteIscsiPathsAC;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.deleteiscsipaths.SJctrDeleteIscsiPathsConfirmDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.deleteiscsipaths.SJctrDeleteIscsiPathsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrDeleteIscsiPathsSubWizard
extends SJctrSubWizard {
    private static final String TITLE = "DELETE_ISCSI_PATHS";
    private static final Class<?> CONFIRM_DC = SJctrDeleteIscsiPathsConfirmDC.class;

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrDeleteIscsiPathsAC applyCntl = new SJctrDeleteIscsiPathsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoIscsiTargetPathInfo> deleteIscsiPathsList = dc.getProxy().getCache("KEY_SELECTED_ISCSI_PATHS");
            if (null == deleteIscsiPathsList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                throw SJctrIscsiUtility.makeException(107001);
            }
            if (0 == deleteIscsiPathsList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                throw SJctrIscsiUtility.makeException(107001);
            }
            SJctrIscsiUtility.getSJmoPortDetailList(dc);
            List<SJmoPortIscsiTargetPathInfo> portIscsiTargetPathInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(dc);
            SJmoExdTargetPortInfoMgr exdTargetPortInfoMgr = SJctrIscsiUtility.getSJmoExdTargetPortInfoMgr(dc);
            ArrayList exdTargetPortInfoList = exdTargetPortInfoMgr.getAlExdTargetPortInfo();
            List<SJmoIscsiTargetPathInfo> iscsiPathList = SJctrIscsiUtility.checkAndGetIscsiTargetPathInfo(portIscsiTargetPathInfoList, deleteIscsiPathsList);
            this.checkSelectIscsiPathUsedUvm(iscsiPathList, exdTargetPortInfoList);
            SJctrDeleteIscsiPathsConfirmData confirmData = new SJctrDeleteIscsiPathsConfirmData();
            Collections.sort(iscsiPathList, new SJctrIscsiTargetPathInfoComparator());
            ArrayList<SJctrDeleteIscsiPathsConfirmData> confirmDataList = new ArrayList<SJctrDeleteIscsiPathsConfirmData>();
            confirmData.setNeedData(dc);
            confirmData.setIscsiPathList(iscsiPathList);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrDeleteIscsiPathsConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdTargetPortInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void checkSelectIscsiPathUsedUvm(List<SJmoIscsiTargetPathInfo> selectIscsiPathList, List<SJmoExdTargetPortInfo> exdTargetPortInfoList) {
        for (SJmoIscsiTargetPathInfo iscsiPath : selectIscsiPathList) {
            if (!SJctrIscsiUtility.isUsedUvmIscsiPath(iscsiPath, exdTargetPortInfoList)) continue;
            throw SJctrIscsiUtility.makeException(206272);
        }
    }
}

