/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.initiator.testloginiscsitarget;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.testloginiscsitarget.SJctrGetThroughRmiDataTestLoginIscsiTarget;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;

public class SJctrTestLoginIscsiTargetDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 0x3000011;
    private static final String LOG_TITLE = SJctrTestLoginIscsiTargetDC.class.getSimpleName();

    public SJctrTestLoginIscsiTargetDC() {
        super(0x3000011);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrSimpleDataModel model = new SJctrSimpleDataModel();
        this.addDataObjectModel("COM_ERROR", model);
        String strFuncID = String.valueOf(12);
        String strModuleID = String.valueOf(22);
        String strMsgID = String.valueOf(209010);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        Object dataObject = model.getManageData();
        ((SJctrDataObject)dataObject).setData("COM_MSG", msg);
        Set<SJctrFooterDataModel.Button> footerButton = Collections.unmodifiableSet(EnumSet.of(SJctrFooterDataModel.Button.OK, SJctrFooterDataModel.Button.DLG_CANCEL));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(footerButton));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> iSCSIPathsList = this.getProxy().getCache("KEY_SELECTED_ISCSI_PATHS");
        if (iSCSIPathsList == null) {
            SJctrLogUty.error(LOG_TITLE, "checkStartData", "Inherited list data is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (iSCSIPathsList.size() == 0) {
            SJctrLogUty.error(LOG_TITLE, "checkStartData", "Size of inherited list data is zero.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return ret;
    }

    @Override
    protected void dialogOkAction() {
        List<SJcMessage> resultMessageList = this.executeTestLogin();
        SJcMessage msg = resultMessageList.get(0);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        this.addUpdateDisp(related);
        super.dialogOkAction();
    }

    private List<SJcMessage> executeTestLogin() {
        List<SJcMessage> resultMessageList = new ArrayList<SJcMessage>();
        try {
            SJmoGetAgent modelAgent = this.getOwner().getModelAgent();
            SanRequest connectTestRequest = this.createExecConnectionTestRequest(modelAgent);
            SanResponse connectTestResult = this.getSanResponseModelDirect(connectTestRequest);
            if (SJctrIscsiUtility.hasErrorSanResponse(connectTestResult)) {
                SanObject errorInfo = connectTestResult.getObj("ErrorInfo");
                int errorCode = errorInfo.getInt("ErrorCode");
                if (7000 <= errorCode && errorCode < 8000) {
                    resultMessageList = this.createExecConnectTestResultList(connectTestResult);
                } else {
                    SJcException exception = SJctrIscsiUtility.createExceptionKeyValueError(connectTestResult);
                    resultMessageList.add(exception.getMsg());
                }
            } else {
                resultMessageList = this.createExecConnectTestResultList(connectTestResult);
            }
        }
        catch (SJcException e) {
            SJctrLogUty.error(LOG_TITLE, "executeTestLogin", e.getMessage());
            SJcException exception = SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
            resultMessageList.add(exception.getMsg());
        }
        catch (SanDataException e) {
            SJctrLogUty.error(LOG_TITLE, "executeTestLogin", e.getMessage());
            SJcException exception = SJctrIscsiUtility.makeException(107004);
            resultMessageList.add(exception.getMsg());
        }
        return resultMessageList;
    }

    private SanRequest createExecConnectionTestRequest(SJmoGetAgent modelAgent) throws SanDataException {
        List<SJmoIscsiTargetPathInfo> iSCSIPathsList = this.getProxy().getCache("KEY_SELECTED_ISCSI_PATHS");
        SanRequest sanRequest = modelAgent.newRequest("iSCSIexecConnectionTest");
        SanList reqPortList = sanRequest.newList("iScsiPaths");
        this.setPortListParam(reqPortList, iSCSIPathsList);
        return sanRequest;
    }

    private void setPortListParam(SanList reqPortList, List<SJmoIscsiTargetPathInfo> pathInfos) throws SanDataException {
        for (SJmoIscsiTargetPathInfo pathInfo : pathInfos) {
            SanObject reqPathObj = reqPortList.addObj();
            SanObject localObj = reqPathObj.newObj("iScsiPort");
            localObj.putInt("Id", (int)pathInfo.getSPort());
            int virtualId = pathInfo.getIVirtualPortID();
            if (virtualId != -1) {
                SanObject virtualObj = localObj.newObj("iScsiVirtualPort");
                virtualObj.putInt("Id", virtualId);
            }
            SanObject remotePortObj = reqPathObj.newObj("RemoteiScsiPort");
            this.setRemotePortParam(remotePortObj, pathInfo);
        }
    }

    private void setRemotePortParam(SanObject remotePortObj, SJmoIscsiTargetPathInfo pathInfo) throws SanDataException {
        int ipType = pathInfo.getIIpType();
        remotePortObj.putInt("IpType", ipType);
        if (ipType == 0) {
            remotePortObj.putIntArray("Ipv4Address", pathInfo.getIIpv4Address());
        } else if (ipType == 1) {
            remotePortObj.putIntArray("Ipv6Address", pathInfo.getIIpv6Address());
        }
        SanObject remoteTargetObj = remotePortObj.newObj("RemoteiScsiTarget");
        remoteTargetObj.putString("Name", pathInfo.getStrTargetName());
    }

    private SanResponse getSanResponseModelDirect(SanRequest sanRequest) {
        SJctrGetThroughRmiDataTestLoginIscsiTarget requestKind = new SJctrGetThroughRmiDataTestLoginIscsiTarget(sanRequest);
        List<SanResponse> rmiDataList = this.getSJmoThroughRmiDataList(requestKind);
        SanResponse rmiObj = rmiDataList.get(0);
        if (rmiObj == null) {
            SJctrLogUty.error(LOG_TITLE, "getSanResponseModelDirect", "SanResponse object is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return rmiObj;
    }

    private List<SanResponse> getSJmoThroughRmiDataList(SJmoGetThroughRmiData kind_IF) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetThroughRmiData kind = kind_IF;
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = this.getProxy().getDataInf(set);
        List<SanResponse> rmiData = map.get(directWrapper);
        return rmiData;
    }

    private List<SJcMessage> createExecConnectTestResultList(SanResponse responseData) throws SanDataException {
        ArrayList<SJcMessage> resultMessageList = new ArrayList<SJcMessage>();
        SanList iscsiPathList = responseData.getList("iScsiPaths");
        SJcMessage msg = new SJcMessage(Integer.toString(12), Integer.toString(22), Integer.toString(209011));
        for (SanObject pathInfo : iscsiPathList) {
            SanObject errorInfoObj = pathInfo.getObj("ErrorInfo");
            int[] messageId = errorInfoObj.getIntArray("MessageId");
            if (messageId[1] != 0) {
                int funcCode = messageId[0] / 100;
                int moduleCode = messageId[0] % 100;
                int errorCode = messageId[1];
                SJcMessage errMsg = new SJcMessage(Integer.toString(funcCode), Integer.toString(moduleCode), Integer.toString(errorCode));
                resultMessageList.add(errMsg);
                continue;
            }
            resultMessageList.add(msg);
        }
        return resultMessageList;
    }
}

