/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.removechapusers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrChapUserNameComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechapusers.SJctrRemoveChapUsersAC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechapusers.SJctrRemoveChapUsersConfirmDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechapusers.SJctrRemoveChapUsersConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechapusers.SJctrRemoveChapUsersConfirmTableDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrRemoveChapUsersSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "REMOVE_CHAP_USERS";
    private static final Class<?> CONFIRM_DC = SJctrRemoveChapUsersConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrErrorColumnData errData;
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrRemoveChapUsersAC applyCntl = new SJctrRemoveChapUsersAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<?> selectedChapUserList = dc.getProxy().getCache("KEY_SELECTED_CHAP_USERS");
            if (null == selectedChapUserList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err2 = new SJctrError(12, 22, 107002);
                SJcException exp = err2.createException();
                throw exp;
            }
            if (0 == selectedChapUserList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err3 = new SJctrError(12, 22, 107002);
                SJcException exp = err3.createException();
                throw exp;
            }
            List<SJmoPortIscsiTargetInfo> portIscsiList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(dc);
            SJctrIscsiUtility.getSJmoPortDetailList(dc);
            List<SJmoRSGgetAllRsgs> allRsgList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(dc);
            List<SJctrChapUserWithTgInfo> allChapList = SJctrIscsiUtility.getAllChapUserInfo(portIscsiList);
            List<Object> transInfoList = new ArrayList();
            if (selectedChapUserList.get(0) instanceof SJmoChapUserInfo) {
                for (SJmoChapUserInfo chapInfo : selectedChapUserList) {
                    ArrayList<SJmoIscsiTargetIndex> arrayList = chapInfo.getAlIscsiTargets();
                    for (SJmoIscsiTargetIndex sJmoIscsiTargetIndex : arrayList) {
                        SJmoIscsiTargetInfo iscsiTargetInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portIscsiList, sJmoIscsiTargetIndex);
                        if (iscsiTargetInfo == null) {
                            iscsiTargetInfo = new SJmoIscsiTargetInfo();
                            iscsiTargetInfo.setSPort(sJmoIscsiTargetIndex.getSPort());
                            iscsiTargetInfo.setSIscsiTarget(sJmoIscsiTargetIndex.getSIscsiTarget());
                            SJmoChapUserInfo chap = new SJmoChapUserInfo();
                            chap.setStrUserName(chapInfo.getStrUserName());
                        }
                        SJctrChapUserWithTgInfo info = new SJctrChapUserWithTgInfo(chapInfo, iscsiTargetInfo);
                        transInfoList.add(info);
                    }
                }
            } else {
                transInfoList = selectedChapUserList;
            }
            Collections.sort(transInfoList, new SJctrChapUserNameComparator());
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectedChapUserList.size());
            for (SJctrChapUserWithTgInfo sJctrChapUserWithTgInfo : transInfoList) {
                SJmoIscsiTargetInfo targetInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portIscsiList, (SJmoIscsiTargetIndex)sJctrChapUserWithTgInfo.getIscsiTargetInfo());
                if (targetInfo != null) continue;
                dc.getLogUty().putlog("constructConfirmData", "Inherited iSCSI target info is not exist.");
                SJctrError sJctrError = new SJctrError(12, 22, 206513);
                errData = new SJctrErrorColumnData(sJctrChapUserWithTgInfo, sJctrError);
                errList.add(errData);
            }
            if (errList.size() == 0) {
                Collections.sort(allChapList);
                for (SJctrChapUserWithTgInfo sJctrChapUserWithTgInfo : transInfoList) {
                    int rev = Collections.binarySearch(allChapList, sJctrChapUserWithTgInfo);
                    if (rev >= 0) continue;
                    dc.getLogUty().putlog("constructConfirmData", "Inherited CHAP user info is not exist.");
                    SJctrError sJctrError = new SJctrError(12, 22, 206515);
                    errData = new SJctrErrorColumnData(sJctrChapUserWithTgInfo, sJctrError);
                    errList.add(errData);
                }
            }
            if (errList.size() == 0) {
                SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(wizard.getOwner(), allRsgList.get(0));
                List<SJmoHostGroupIndex> list = SJctrIscsiUtility.getEnableResourceHgList(rsgUtil);
                for (SJctrChapUserWithTgInfo sJctrChapUserWithTgInfo : transInfoList) {
                    SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
                    SJmoIscsiTargetInfo iscsiTargetIndex = sJctrChapUserWithTgInfo.getIscsiTargetInfo();
                    hgIndex.setSPort(iscsiTargetIndex.getSPort());
                    hgIndex.setSHostGroup(iscsiTargetIndex.getSIscsiTarget());
                    int index = Collections.binarySearch(list, hgIndex);
                    if (index >= 0) continue;
                    dc.getLogUty().putlog("constructConfirmData", "There is no authority of the iSCSI Target assigned to selected CHAP user.");
                    SJctrError err4 = new SJctrError(12, 22, 206236);
                    SJctrErrorColumnData errData2 = new SJctrErrorColumnData(sJctrChapUserWithTgInfo, err4);
                    errList.add(errData2);
                }
            }
            this.createError(dc, transInfoList, errList);
            SJctrRemoveChapUsersConfirmData confirmData = new SJctrRemoveChapUsersConfirmData();
            ArrayList<SJctrRemoveChapUsersConfirmData> arrayList = new ArrayList<SJctrRemoveChapUsersConfirmData>();
            confirmData.setChapUserList(transInfoList);
            confirmData.setNeedData(dc);
            arrayList.add(confirmData);
            dc.getProxy().putCache(SJctrRemoveChapUsersConfirmData.class, arrayList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void createError(SJctrWizardWindowDC dc, List<SJctrChapUserWithTgInfo> transInfoList, List<SJctrErrorColumnData> errList) {
        if (!errList.isEmpty()) {
            SJctrRemoveChapUsersConfirmTableDataModel chapUserTable = new SJctrRemoveChapUsersConfirmTableDataModel();
            chapUserTable.setPaging(false);
            chapUserTable.setDataController(dc);
            chapUserTable.setBasicDataList(transInfoList);
            chapUserTable.initGuidance(this.getComUtility());
            chapUserTable.createModelDirect();
            chapUserTable.divideModelData(dc.getProxy().getModelDataMap());
            chapUserTable.makeDataModel();
            SJctrRelatedDispDataObject rel = dc.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)dc.getOwner().getDataController(rel);
            errDc.setParameter(chapUserTable, errList);
            SJctrError errInfo = errDc.getRepresentativeError(errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
    }
}

