/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.removehosts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrIscsiNameWithAliasComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.removehosts.SJctrRemoveHostsAC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removehosts.SJctrRemoveHostsConfirmDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removehosts.SJctrRemoveHostsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.removehosts.SJctrRemoveHostsConfirmTableDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrRemoveHostsSubWizard
extends SJctrSubWizard {
    private static final String TITLE = "REMOVE_HOSTS";
    private static final Class<?> CONFIRM_DC = SJctrRemoveHostsConfirmDC.class;

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrRemoveHostsAC applyCntl = new SJctrRemoveHostsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<?> selectedHostList = dc.getProxy().getCache("KEY_SELECTED_HOSTS");
            if (null == selectedHostList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(12, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == selectedHostList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(12, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoPortIscsiTargetInfo> portIscsiList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(dc);
            List<Object> transInfoList = new ArrayList();
            if (selectedHostList.get(0) instanceof SJmoIscsiName) {
                List<?> selectedHost = selectedHostList;
                for (SJmoIscsiName nameInfo : selectedHost) {
                    ArrayList<SJmoIscsiTargetIndex> indexList = nameInfo.getAlIscsiTargets();
                    for (SJmoIscsiTargetIndex index : indexList) {
                        void var16_21;
                        SJmoIscsiTargetInfo sJmoIscsiTargetInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portIscsiList, index);
                        if (sJmoIscsiTargetInfo == null) {
                            SJmoIscsiTargetInfo sJmoIscsiTargetInfo2 = new SJmoIscsiTargetInfo();
                            sJmoIscsiTargetInfo2.setSPort(index.getSPort());
                            sJmoIscsiTargetInfo2.setSIscsiTarget(index.getSIscsiTarget());
                        }
                        SJctrIscsiNameWithTgInfo info = new SJctrIscsiNameWithTgInfo(nameInfo, (SJmoIscsiTargetInfo)var16_21);
                        transInfoList.add(info);
                    }
                }
            } else {
                transInfoList = selectedHostList;
            }
            List<SJmoPortDetail> portDetailInfo = SJctrIscsiUtility.getSJmoPortDetailList(dc);
            List<SJmoRSGgetAllRsgs> allRsgList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(dc);
            List<SJmoPortIscsiNameInfo> ptIscsiNameInfoList = SJctrIscsiUtility.getSJmoPortIscsiNameInfoList(dc);
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectedHostList.size());
            SJctrError errInfo = null;
            for (SJctrIscsiNameWithTgInfo sJctrIscsiNameWithTgInfo : transInfoList) {
                SJmoIscsiTargetInfo chkIscsiTarget = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portIscsiList, (SJmoIscsiTargetIndex)sJctrIscsiNameWithTgInfo.getIscsiTargetInfo());
                if (chkIscsiTarget != null) continue;
                dc.getLogUty().putlog("constructConfirmData", "No iSCSI Target in the list.");
                SJctrError sJctrError = new SJctrError(12, 22, 206513);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(sJctrIscsiNameWithTgInfo, sJctrError);
                errList.add(errData);
                if (errInfo != null) continue;
                errInfo = sJctrError;
            }
            if (errList.size() == 0) {
                for (SJctrIscsiNameWithTgInfo sJctrIscsiNameWithTgInfo : transInfoList) {
                    SJmoPortIndex portIndex = new SJmoPortIndex();
                    portIndex.setSPort(sJctrIscsiNameWithTgInfo.getIscsiTargetInfo().getSPort());
                    SJmoPortIscsiNameInfo sJmoPortIscsiNameInfo = (SJmoPortIscsiNameInfo)SJctrIscsiUtility.getPortInfoByPortIndex(ptIscsiNameInfoList, portIndex);
                    int index = Collections.binarySearch(sJmoPortIscsiNameInfo.getAlPortIscsiName(), sJctrIscsiNameWithTgInfo.getIscsiNameInfo());
                    if (index >= 0) continue;
                    dc.getLogUty().putlog("constructConfirmData", "No iSCSI Name in the list.");
                    SJctrError err = new SJctrError(12, 22, 206514);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(sJctrIscsiNameWithTgInfo, err);
                    errList.add(errData);
                    if (errInfo != null) continue;
                    errInfo = err;
                }
            }
            if (errList.size() == 0) {
                SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(wizard.getOwner(), allRsgList.get(0));
                List<SJmoHostGroupIndex> list = SJctrIscsiUtility.getEnableResourceHgList(rsgUtil);
                for (SJctrIscsiNameWithTgInfo sJctrIscsiNameWithTgInfo : transInfoList) {
                    SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
                    hgIndex.setSPort(sJctrIscsiNameWithTgInfo.getIscsiTargetInfo().getSPort());
                    hgIndex.setSHostGroup(sJctrIscsiNameWithTgInfo.getIscsiTargetInfo().getSIscsiTarget());
                    int index = Collections.binarySearch(list, hgIndex);
                    if (index >= 0) continue;
                    dc.getLogUty().putlog("constructConfirmData", "There is no authority of the iSCSI Target assigned to selected iSCSI Name.");
                    SJctrError err = new SJctrError(12, 22, 206226);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(sJctrIscsiNameWithTgInfo, err);
                    errList.add(errData);
                    if (errInfo != null) continue;
                    errInfo = err;
                }
            }
            SJctrRemoveHostsConfirmData confirmData = new SJctrRemoveHostsConfirmData();
            Collections.sort(transInfoList, new SJctrIscsiNameWithAliasComparator());
            if (errList.size() > 0) {
                this.createError(confirmData, dc, transInfoList, errList, errInfo);
            }
            ArrayList<SJctrRemoveHostsConfirmData> arrayList = new ArrayList<SJctrRemoveHostsConfirmData>();
            confirmData.setIscsiNameInfo(transInfoList);
            confirmData.setNeedData(dc);
            arrayList.add(confirmData);
            dc.getProxy().putCache(SJctrRemoveHostsConfirmData.class, arrayList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void createError(SJctrRemoveHostsConfirmData confirmData, SJctrWizardWindowDC dc, List<SJctrIscsiNameWithTgInfo> transInfoList, List<SJctrErrorColumnData> errList, SJctrError errInfo) {
        Collections.sort(transInfoList, new SJctrIscsiNameWithAliasComparator());
        SJctrRemoveHostsConfirmTableDataModel hostTable = new SJctrRemoveHostsConfirmTableDataModel();
        hostTable.setPaging(false);
        hostTable.setDataController(dc);
        hostTable.setBasicDataList(transInfoList);
        hostTable.initGuidance(this.getComUtility());
        hostTable.createModelDirect();
        hostTable.divideModelData(dc.getProxy().getModelDataMap());
        hostTable.makeDataModel();
        SJctrRelatedDispDataObject rel = dc.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)dc.getOwner().getDataController(rel);
        errDc.setParameter(hostTable, errList);
        SJctrError err = errDc.getRepresentativeError(errList);
        SJcException exp = err.createException();
        exp.setErrDisp(rel);
        throw exp;
    }
}

