/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.relhostreserve.com;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.LUNMgetHostReserved;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrPortIndexComparator;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.com.SJctrGetHostReserve;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;

public class SJctrRsvStatusColumnFromPortLunTableKey
extends SJctrColumn {
    public SJctrRsvStatusColumnFromPortLunTableKey(String key) {
        super(key);
        this.setPartsId("HOST_RESERVED_STATUS");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<LUNMgetHostReserved> list = new ArrayList<LUNMgetHostReserved>();
        SJctrPortLunTableKey ptLunTblKey = (SJctrPortLunTableKey)index;
        List<?> htRsvList = modelData.get(SJctrGetHostReserve.class);
        if (htRsvList != null) {
            for (LUNMgetHostReserved htRsv : htRsvList) {
                if (htRsv.getSHostGroupId() != ptLunTblKey.getPortLunDetail().getSHostGroup() || htRsv.getSLUN() != ptLunTblKey.getPortLunDetail().getSLUN()) continue;
                list.add(htRsv);
                break;
            }
        }
        return list;
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return new SJctrPortIndexComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                SJctrPortLunTableKey port1 = (SJctrPortLunTableKey)o1;
                SJctrPortLunTableKey port2 = (SJctrPortLunTableKey)o2;
                return super.compare(port1.getPortLunInfo(), port2.getPortLunInfo());
            }
        };
    }

    @Override
    public String toDispString(List<?> dataList) {
        LUNMgetHostReserved getHstRsv = (LUNMgetHostReserved)dataList.get(0);
        long hstRsv = getHstRsv.getLHostReserved();
        String result = null;
        SJctrPortUtility portUtil = this.getTable().getComUtility().getPortUtility();
        if (portUtil.isHostRsv(hstRsv)) {
            List<String> gidList = portUtil.getHostRsvStatusGuidanceId(hstRsv);
            result = portUtil.getHostRsvDispString(gidList);
        }
        return result;
    }
}

