/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editmoncus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.common.Robj_interface_MonMonitoringCU;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrCUIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorCUInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorCUsMonTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.editmoncus.SJctrEditMonitoringCUsConfirmData;
import sanproject.sn2.controller.wizard.monitor.optmon.editmoncus.SJctrSelectByParityGroupsDC;
import sanproject.sn2.controller.wizard.monitor.optmon.viewcumatrix.SJctrViewCUMatrixDC;
import sanproject.sn2.controller.wizard.monitor.optmon.viewcumatrix.SJctrViewCUMatrixViewData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetMonMonitoringInfoLDKC;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrEditMonitoringCUsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17827937;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.EDIT_MON_CU;
    private static final String KEY_NON_MON_CU_INIT = "COM_NON_MON_CU_INIT";
    private static final String KEY_MON_CU_INIT = "COM_MON_CU_INIT";
    private static final String KEY_TABLE_NON_MON_CUS = "COM_TABLE_NON_MON_CUS";
    private static final String KEY_TABLE_MON_CUS = "COM_TABLE_MON_CUS";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    private static final String KEY_SELECT_BY_PG = "COM_SELECT_BY_PG";
    private static final String KEY_VIEW_CU_MATRIX = "COM_VIEW_CU_MATRIX";
    public static final String KEY_NUM_OF_LDEVS_PER_CU = "COM_NUM_OF_LDEVS_PER_CU";
    private static final SJctrCUIndexComparator CU_COMP = new SJctrCUIndexComparator();

    public SJctrEditMonitoringCUsDC() throws SJcException {
        super(17827937);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetMonMonitoringInfoLDKC();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgScatteredInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgLdevInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_NON_MON_CUS, new SJctrMonitorCUsMonTableModel());
        this.addDataObjectModel(KEY_TABLE_MON_CUS, new SJctrMonitorCUsMonTableModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringCUsDC.this.fireMessageEvent(EDIT_MON_CU_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringCUsDC.this.fireMessageEvent(EDIT_MON_CU_MSG.SELECT_REMOVE);
            }
        });
        SJctrButtonDataModel selectByPGsButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_SELECT_BY_PG, selectByPGsButton);
        selectByPGsButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringCUsDC.this.fireMessageEvent(EDIT_MON_CU_MSG.SELECT_BY_PG);
            }
        });
        SJctrButtonDataModel viewCuMatrixButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_VIEW_CU_MATRIX, viewCuMatrixButton);
        viewCuMatrixButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringCUsDC.this.fireMessageEvent(EDIT_MON_CU_MSG.SELECT_CU_MATRIX);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_MON_CU_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringCUsDC.this.addMonCusAction(event, dstModel);
                SJctrEditMonitoringCUsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(EDIT_MON_CU_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringCUsDC.this.removeMonCusAction(event, dstModel);
                SJctrEditMonitoringCUsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(EDIT_MON_CU_MSG.SELECT_BY_PG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringCUsDC.this.makeSelectByPG(event, dstModel);
            }
        });
        this.addMessageEventListener(EDIT_MON_CU_MSG.SELECT_CU_MATRIX, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringCUsDC.this.makeViewCUMatrix(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringCUsDC.this.exitSelectByPG(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        try {
            MonMonitoringInfoLDKC monInfo = SJctrOptionMonitorUtility.getMonMonitoringInfoLDKC(this);
            List<SJmoLdevDetail> ldevDetails = SJctrOptionMonitorUtility.getSJmoLdevDetail(this);
            SJctrOptionMonitorUtility.getSJmoPgDetail(this);
            SJctrOptionMonitorUtility.getSJmoPgScatteredInfo(this);
            SJctrOptionMonitorUtility.getSJmoPgLdevInfo(this);
            int[] cuLdevsCount = SJctrOptionMonitorUtility.getCUNumberOfLdevs(ldevDetails);
            String ENABLED = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.ENABLED);
            String DISABLED = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISABLED);
            ArrayList<SJctrMonitorCUInfo> monitorCu = new ArrayList<SJctrMonitorCUInfo>();
            ArrayList<SJctrMonitorCUInfo> nonMonitorCu = new ArrayList<SJctrMonitorCUInfo>();
            Robj_interface_MonMonitoringCU[] monCuInfo = monInfo.getTargetCU();
            boolean[] monCuFlgList = new boolean[SJmoDataMacro_IF.CUMAX_LDKC];
            for (Robj_interface_MonMonitoringCU monCU : monCuInfo) {
                short cuNo;
                if (!monCU.isTarget() || 0 > (cuNo = monCU.getSCU()) || cuNo >= monCuFlgList.length) continue;
                monCuFlgList[monCU.getSCU()] = true;
            }
            for (int cuNo = 0; cuNo < monCuFlgList.length; ++cuNo) {
                SJctrMonitorCUInfo cuInfo = new SJctrMonitorCUInfo(SJctrOptionMonitorUtility.getCUNumberString(cuNo), (short)cuNo, cuLdevsCount[cuNo]);
                if (monCuFlgList[cuNo]) {
                    cuInfo.setStrMonitoring(ENABLED);
                    monitorCu.add(cuInfo);
                    continue;
                }
                cuInfo.setStrMonitoring(DISABLED);
                nonMonitorCu.add(cuInfo);
            }
            SJctrMonitorCUsMonTableModel monCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_CUS);
            Collections.sort(monitorCu, CU_COMP);
            monCuTable.setBasicDataList(monitorCu);
            SJctrMonitorCUsMonTableModel nonMonCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_CUS);
            Collections.sort(nonMonitorCu, CU_COMP);
            nonMonCuTable.setBasicDataList(nonMonitorCu);
            this.putCache(KEY_MON_CU_INIT, monitorCu);
            this.putCache(KEY_NON_MON_CU_INIT, nonMonitorCu);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        SJctrEditMonitoringCUsConfirmData confirmData = new SJctrEditMonitoringCUsConfirmData();
        List<SJctrMonitorCUInfo> initMonCuTableData = this.getCache(KEY_MON_CU_INIT);
        SJctrMonitorCUsMonTableModel monCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_CUS);
        List<Object> monCuTableData = monCuTable.getAllRowData();
        List<SJctrMonitorCUInfo> setMonCuList = this.getEditedCusList(initMonCuTableData, monCuTableData);
        List<SJctrMonitorCUInfo> initNonMonCuTableData = this.getCache(KEY_NON_MON_CU_INIT);
        SJctrMonitorCUsMonTableModel nonMonCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_CUS);
        List<Object> nonMonCuTableData = nonMonCuTable.getAllRowData();
        List<SJctrMonitorCUInfo> releaseMonCuList = this.getEditedCusList(initNonMonCuTableData, nonMonCuTableData);
        if (0 == setMonCuList.size() && 0 == releaseMonCuList.size()) {
            SJctrError err = new SJctrError(51, 22, 105102);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.isWarningMsgCheck(initMonCuTableData.size(), monCuTableData.size())) {
            confirmData.setViewWarningMsg(1);
        } else {
            confirmData.setViewWarningMsg(0);
        }
        Collections.sort(setMonCuList, CU_COMP);
        Collections.sort(releaseMonCuList, CU_COMP);
        confirmData.setMonitorCus(setMonCuList);
        confirmData.setNonmonitorCus(releaseMonCuList);
        List<SJmoThroughRmiData> rmiData = this.getCache(SJmoGetMonMonitoringInfoLDKC.class);
        confirmData.setMonMonitoringInfo(rmiData);
        ArrayList<SJctrEditMonitoringCUsConfirmData> confirmDataList = new ArrayList<SJctrEditMonitoringCUsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditMonitoringCUsConfirmData.class, confirmDataList);
        this.setFinishChangeCheck(false);
        return ret;
    }

    private List<SJctrMonitorCUInfo> getEditedCusList(List<SJctrMonitorCUInfo> initTableData, List<SJctrMonitorCUInfo> editedTableData) {
        ArrayList<SJctrMonitorCUInfo> editedCusList = new ArrayList<SJctrMonitorCUInfo>();
        for (SJctrMonitorCUInfo cuInfo : editedTableData) {
            if (initTableData.contains(cuInfo)) continue;
            editedCusList.add(cuInfo);
        }
        return editedCusList;
    }

    private void addMonCusAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            MonMonitoringInfoLDKC monInfo = SJctrOptionMonitorUtility.getMonMonitoringInfoLDKC(this);
            SJctrMonitorCUsMonTableModel nonMonCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_CUS);
            SJctrMonitorCUsMonTableModel monCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_CUS);
            List<Object> addCheckData = nonMonCuTable.getSelectedRowData();
            List<Object> selectedCheckData = monCuTable.getAllRowData();
            if (SJctrOptionMonitorUtility.isOverMonitoringCUsMax(addCheckData, selectedCheckData, monInfo)) {
                SJctrError err = null;
                err = SJctrOptionMonitorUtility.isProductModel_H() ? new SJctrError(51, 22, 205096) : new SJctrError(51, 22, 105114);
                SJcException exp = err.createException();
                throw exp;
            }
            List<Object> addData = nonMonCuTable.removeSelectedRowData();
            monCuTable.addRowData(addData, 0);
            List<Object> selectingList = monCuTable.getFilterData(addData);
            monCuTable.setRowSelectionList(selectingList);
            monCuTable.setCurrentPage(Integer.toString(1));
            monCuTable.setVScrollReset(true);
            monCuTable.setSortColumn(null, Boolean.TRUE);
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107004);
        }
    }

    private void removeMonCusAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrMonitorCUsMonTableModel monCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_CUS);
        List<Object> removeData = monCuTable.removeSelectedRowData();
        SJctrMonitorCUsMonTableModel nonMonCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_CUS);
        nonMonCuTable.addRowData(removeData, 0);
        List<Object> selectingList = nonMonCuTable.getFilterData(removeData);
        nonMonCuTable.setRowSelectionList(selectingList);
        nonMonCuTable.setCurrentPage(Integer.toString(1));
        nonMonCuTable.setVScrollReset(true);
        nonMonCuTable.setSortColumn(null, Boolean.TRUE);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void makeSelectByPG(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        HashMap param = new HashMap();
        try {
            List<SJmoPgDetail> pgDetails = SJctrOptionMonitorUtility.getSJmoPgDetail(this);
            List<SJmoPgScatteredInfo> pgSctInfo = SJctrOptionMonitorUtility.getSJmoPgScatteredInfo(this);
            List<SJmoPgLdevInfo> pgLdevInfo = SJctrOptionMonitorUtility.getSJmoPgLdevInfo(this);
            List<SJmoLdevDetail> ldevDetails = SJctrOptionMonitorUtility.getSJmoLdevDetail(this);
            int[] cuLdevsCount = SJctrOptionMonitorUtility.getCUNumberOfLdevs(ldevDetails);
            ArrayList<int[]> viewDataList = new ArrayList<int[]>();
            viewDataList.add(cuLdevsCount);
            param.put(SJmoGetPgDetail.class.getName(), pgDetails);
            param.put(SJmoGetPgScatteredInfo.class.getName(), pgSctInfo);
            param.put(SJmoGetPgLdevInfo.class.getName(), pgLdevInfo);
            param.put(KEY_NUM_OF_LDEVS_PER_CU, viewDataList);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107004);
        }
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrSelectByParityGroupsDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    private void makeViewCUMatrix(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrViewCUMatrixViewData viewData = new SJctrViewCUMatrixViewData(1);
        List<?> rmiData = this.getCache(SJmoGetMonMonitoringInfoLDKC.class);
        List<SJctrMonitorCUInfo> initMonCuTableData = this.getCache(KEY_MON_CU_INIT);
        SJctrMonitorCUsMonTableModel monCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_CUS);
        List<Object> monCuTableData = monCuTable.getAllRowData();
        List<Integer> setMonCuNos = this.getEditedCuNumberList(initMonCuTableData, monCuTableData);
        List<SJctrMonitorCUInfo> initNonMonCuTableData = this.getCache(KEY_NON_MON_CU_INIT);
        SJctrMonitorCUsMonTableModel nonMonCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_CUS);
        List<Object> nonMonCuTableData = nonMonCuTable.getAllRowData();
        List<Integer> releaseMonCuNos = this.getEditedCuNumberList(initNonMonCuTableData, nonMonCuTableData);
        viewData.setMonitorCus(setMonCuNos);
        viewData.setNonMonitorCus(releaseMonCuNos);
        ArrayList<SJctrViewCUMatrixViewData> viewDataList = new ArrayList<SJctrViewCUMatrixViewData>();
        viewDataList.add(viewData);
        HashMap param = new HashMap();
        param.put(SJctrViewCUMatrixViewData.class.getName(), viewDataList);
        param.put(SJmoGetMonMonitoringInfoLDKC.class.getName(), rmiData);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrViewCUMatrixDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    private List<Integer> getEditedCuNumberList(List<SJctrMonitorCUInfo> initTableData, List<SJctrMonitorCUInfo> editedTableData) {
        ArrayList<Integer> editedCuNumberList = new ArrayList<Integer>();
        for (SJctrMonitorCUInfo cuInfo : editedTableData) {
            if (initTableData.contains(cuInfo)) continue;
            editedCuNumberList.add(Integer.valueOf(cuInfo.getSCu()));
        }
        return editedCuNumberList;
    }

    private void exitSelectByPG(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Map param = (Map)event.getNofifyObject();
        List selectCus = (List)param.get(SJctrSelectByParityGroupsDC.class.getName());
        if (selectCus == null) {
            return;
        }
        SJctrMonitorCUsMonTableModel nonMonCuTable = (SJctrMonitorCUsMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_CUS);
        nonMonCuTable.clearSelectRow();
        if (selectCus.size() != 0) {
            List<Object> dispRowData = nonMonCuTable.getTargetRowData();
            ArrayList<Object> selectList = new ArrayList<Object>();
            for (SJctrMonitorCUInfo sJctrMonitorCUInfo : dispRowData) {
                short cuNo = sJctrMonitorCUInfo.getSCu();
                if (!selectCus.contains(cuNo)) continue;
                selectList.add(sJctrMonitorCUInfo);
            }
            nonMonCuTable.addRowSelectionList(selectList);
            nonMonCuTable.setCurrentPage(Integer.toString(1));
        }
        this.updateFooter();
        nonMonCuTable.setDirty();
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    private boolean isWarningMsgCheck(int initTableDataSize, int editedTableDataSize) {
        boolean ret = false;
        int cuboundary = SJctrOptionMonitorUtility.getMonitoringCUBoundary();
        if (initTableDataSize <= cuboundary && cuboundary < editedTableDataSize) {
            ret = true;
        }
        if (initTableDataSize > cuboundary && cuboundary >= editedTableDataSize) {
            ret = true;
        }
        return ret;
    }

    public static enum EDIT_MON_CU_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE,
        SELECT_BY_PG,
        SELECT_CU_MATRIX;

    }
}

