/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editmonwwns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrMonPortWWNComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorPortWWNInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorPortWWNStatusMonInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorWWNsStatusMonTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorWWNsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.editmonwwns.SJctrEditMonitoringWWNsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPPCALLPortWWNInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortWwnInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.monitor.SJmoPPCALLPortWWNInfo;

public class SJctrEditMonitoringWWNsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100881;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.EDIT_MON_WWN;
    private static final String KEY_NON_MON_WWN_INIT = "COM_NON_MON_WWN_INIT";
    private static final String KEY_MON_WWN_INIT = "COM_MON_WWN_INIT";
    private static final String KEY_TABLE_NON_MON_WWNS = "COM_TABLE_NON_MON_WWNS";
    private static final String KEY_TABLE_MON_WWNS = "COM_TABLE_MON_WWNS";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    protected static final SJctrMonPortWWNComparator PORT_WWN_COMP = new SJctrMonPortWWNComparator();

    public SJctrEditMonitoringWWNsDC() throws SJcException {
        super(0x1100881);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPPCALLPortWWNInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortWwnInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_NON_MON_WWNS, new SJctrMonitorWWNsStatusMonTableModel());
        this.addDataObjectModel(KEY_TABLE_MON_WWNS, new SJctrMonitorWWNsStatusMonTableModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringWWNsDC.this.fireMessageEvent(EDIT_MON_WWNS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringWWNsDC.this.fireMessageEvent(EDIT_MON_WWNS_MSG.SELECT_REMOVE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() throws SJcException {
        this.addMessageEventListener(EDIT_MON_WWNS_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringWWNsDC.this.addMonWwnsAction(event, dstModel);
                SJctrEditMonitoringWWNsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(EDIT_MON_WWNS_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringWWNsDC.this.removeMonWwnsAction(event, dstModel);
                SJctrEditMonitoringWWNsDC.this.setFinishChangeCheck(true);
            }
        });
    }

    @Override
    public boolean checkConstructData() throws SJcException {
        ArrayList wwnList;
        SJmoPortDetail portDetail;
        int portId;
        String MONITOR_MODE_ENABLED = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.ENABLED);
        String MONITOR_MODE_DISABLED = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISABLED);
        String STATUS_NORMAL = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.NORMAL);
        String STATUS_NONINTEGRITY = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.NON_INTEGRITY);
        List<?> ppcAllPortWwnInfoList = this.getCache(SJmoGetPPCALLPortWWNInfo.class);
        if (null == ppcAllPortWwnInfoList) {
            this.logUty.putlog("checkConstructData", "List of PPCALLPortWWNInfo is null.");
            SJctrError err = new SJctrError(51, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        if (null == portDetailList) {
            this.logUty.putlog("checkConstructData", "List of PortDetail is null.");
            SJctrError err = new SJctrError(51, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portWwnInfoList = this.getCache(SJmoGetPortWwnInfo.class);
        if (null == portWwnInfoList) {
            this.logUty.putlog("checkConstructData", "List of PortWwnInfo is null.");
            SJctrError err = new SJctrError(51, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portHgInfoList = this.getCache(SJmoGetPortHostGroupInfo.class);
        if (null == portHgInfoList) {
            this.logUty.putlog("checkConstructData", "List of PortHostGroupInfo is null.");
            SJctrError err = new SJctrError(51, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        HashMap<String, SJctrMonitorPortWWNStatusMonInfo> monWwnMap = new HashMap<String, SJctrMonitorPortWWNStatusMonInfo>();
        HashMap<String, SJctrMonitorPortWWNStatusMonInfo> nonMonWwnMap = new HashMap<String, SJctrMonitorPortWWNStatusMonInfo>();
        HashMap<String, String[]> nickNameMap = new HashMap<String, String[]>();
        ArrayList<SJctrMonitorPortWWNStatusMonInfo> monWwnList = new ArrayList<SJctrMonitorPortWWNStatusMonInfo>();
        for (SJmoPPCALLPortWWNInfo monWwnInfo : ppcAllPortWwnInfoList) {
            portId = monWwnInfo.getIndex();
            portDetail = SJctrOptionMonitorUtility.getAvailableMonPort(portId, portDetailList);
            if (null == portDetail) continue;
            wwnList = monWwnInfo.getWwns();
            for (SJmoWwn wwnInfo : wwnList) {
                SJctrMonitorPortWWNStatusMonInfo tmpAddData = new SJctrMonitorPortWWNStatusMonInfo(wwnInfo, portDetail, MONITOR_MODE_ENABLED, STATUS_NORMAL, 0);
                monWwnList.add(tmpAddData);
                String hba = SJctrComUtility.toWWNDisplay(wwnInfo);
                monWwnMap.put(hba, tmpAddData);
            }
        }
        for (SJmoPortHostGroupInfo portHgInfo : portHgInfoList) {
            portId = portHgInfo.getIndex();
            portDetail = SJctrOptionMonitorUtility.getAvailableMonPort(portId, portDetailList);
            if (null == portDetail) continue;
            ArrayList hgList = portHgInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo hostGroup : hgList) {
                ArrayList wwnList2 = hostGroup.getAlHostGroupWwn();
                for (SJmoWwn wwnInfo : wwnList2) {
                    String hba = SJctrComUtility.toWWNDisplay(wwnInfo);
                    String hbaPort = hba + portId;
                    SJctrMonitorPortWWNStatusMonInfo rowData = (SJctrMonitorPortWWNStatusMonInfo)monWwnMap.get(hba);
                    if (rowData != null) {
                        SJmoWwn tmpWwnInfo = rowData.getWwn();
                        SJctrMonitorPortWWNStatusMonInfo tmpAddData = new SJctrMonitorPortWWNStatusMonInfo(tmpWwnInfo, portDetail, MONITOR_MODE_DISABLED, STATUS_NONINTEGRITY, 1);
                        nonMonWwnMap.put(hbaPort, tmpAddData);
                        continue;
                    }
                    this.checkNickName(nickNameMap, wwnInfo, portId);
                    SJctrMonitorPortWWNStatusMonInfo tmpAddData = new SJctrMonitorPortWWNStatusMonInfo(wwnInfo, portDetail, MONITOR_MODE_DISABLED, STATUS_NORMAL, 0);
                    nonMonWwnMap.put(hbaPort, tmpAddData);
                }
            }
        }
        for (SJmoPortWwnInfo portWwnInfo : portWwnInfoList) {
            portId = portWwnInfo.getIndex();
            portDetail = SJctrOptionMonitorUtility.getAvailableMonPort(portId, portDetailList);
            if (null == portDetail) continue;
            wwnList = portWwnInfo.getAlPortWwn();
            for (SJmoWwn wwnInfo : wwnList) {
                String hba = SJctrComUtility.toWWNDisplay(wwnInfo);
                String hbaPort = hba + portId;
                SJctrMonitorPortWWNStatusMonInfo rowData = (SJctrMonitorPortWWNStatusMonInfo)monWwnMap.get(hba);
                if (rowData != null) {
                    SJmoWwn tmpWwnInfo = rowData.getWwn();
                    SJctrMonitorPortWWNStatusMonInfo tmpAddData = new SJctrMonitorPortWWNStatusMonInfo(tmpWwnInfo, portDetail, MONITOR_MODE_DISABLED, STATUS_NONINTEGRITY, 1);
                    nonMonWwnMap.put(hbaPort, tmpAddData);
                    continue;
                }
                this.checkNickName(nickNameMap, wwnInfo, portId);
                SJctrMonitorPortWWNStatusMonInfo tmpAddData = new SJctrMonitorPortWWNStatusMonInfo(wwnInfo, portDetail, MONITOR_MODE_DISABLED, STATUS_NORMAL, 0);
                nonMonWwnMap.put(hbaPort, tmpAddData);
            }
        }
        for (SJctrMonitorPortWWNStatusMonInfo monWwn : monWwnList) {
            String hba = SJctrComUtility.toWWNDisplay(monWwn.getWwn());
            int portId2 = monWwn.getPortDetail().getIndex();
            String hbaPort = hba + portId2;
            nonMonWwnMap.remove(hbaPort);
        }
        ArrayList<SJctrMonitorPortWWNStatusMonInfo> nonMonWwnList = new ArrayList<SJctrMonitorPortWWNStatusMonInfo>();
        for (String hbaPort : nonMonWwnMap.keySet()) {
            SJctrMonitorPortWWNStatusMonInfo nonMonWwn = (SJctrMonitorPortWWNStatusMonInfo)nonMonWwnMap.get(hbaPort);
            if (nonMonWwn.getStrStatusValue() == 0) {
                String hba = SJctrComUtility.toWWNDisplay(nonMonWwn.getWwn());
                String[] nickName = (String[])nickNameMap.get(hba);
                nonMonWwn.getWwn().setStrWWNNickName(nickName[1]);
            }
            nonMonWwnList.add(nonMonWwn);
        }
        if (monWwnList.size() == 0 && nonMonWwnList.size() == 0) {
            SJctrError err = new SJctrError(51, 22, 105105);
            SJcException exp = err.createException();
            throw exp;
        }
        this.putCache(KEY_NON_MON_WWN_INIT, nonMonWwnList);
        this.putCache(KEY_MON_WWN_INIT, monWwnList);
        SJctrMonitorWWNsStatusMonTableModel nonMonWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_WWNS);
        SJctrMonitorWWNsStatusMonTableModel monWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWNS);
        Collections.sort(nonMonWwnList, PORT_WWN_COMP);
        nonMonWwnTable.setBasicDataList(nonMonWwnList);
        Collections.sort(monWwnList, PORT_WWN_COMP);
        monWwnTable.setBasicDataList(monWwnList);
        return true;
    }

    @Override
    public boolean checkEndData() throws SJcException {
        String tmpStr;
        String STATUS_NORMAL = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.NORMAL);
        String STATUS_NONINTEGRITY = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.NON_INTEGRITY);
        boolean ret = true;
        SJctrEditMonitoringWWNsConfirmData confirmData = new SJctrEditMonitoringWWNsConfirmData();
        List<?> initNonMonWwnTableData = this.getCache(KEY_NON_MON_WWN_INIT);
        if (initNonMonWwnTableData == null) {
            this.logUty.putlog("checkEndData", "List of InitNonMonWwnTableData is null.");
            SJctrError err = new SJctrError(51, 22, 107003);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> initMonWwnTableData = this.getCache(KEY_MON_WWN_INIT);
        if (initMonWwnTableData == null) {
            this.logUty.putlog("checkEndData", "List of InitMonWwnTableData is null.");
            SJctrError err = new SJctrError(51, 22, 107003);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrMonitorWWNsStatusMonTableModel nonMonWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_WWNS);
        List<Object> nonMonWwnTableData = nonMonWwnTable.getAllRowData();
        SJctrMonitorWWNsStatusMonTableModel monWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWNS);
        List<Object> monWwnTableData = monWwnTable.getAllRowData();
        ArrayList<SJctrMonitorPortWWNStatusMonInfo> releaseMonWwnList = new ArrayList<SJctrMonitorPortWWNStatusMonInfo>();
        ArrayList<SJctrMonitorPortWWNStatusMonInfo> setMonWwnList = new ArrayList<SJctrMonitorPortWWNStatusMonInfo>();
        HashMap<String, SJctrMonitorPortWWNStatusMonInfo> initNonMonMap = new HashMap<String, SJctrMonitorPortWWNStatusMonInfo>();
        for (SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo : initNonMonWwnTableData) {
            String string = sJctrMonitorPortWWNStatusMonInfo.toString();
            initNonMonMap.put(string, sJctrMonitorPortWWNStatusMonInfo);
        }
        for (SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo : nonMonWwnTableData) {
            String string = sJctrMonitorPortWWNStatusMonInfo.toString();
            SJctrMonitorPortWWNStatusMonInfo initNonMonWwn = (SJctrMonitorPortWWNStatusMonInfo)initNonMonMap.get(string);
            if (initNonMonWwn != null) continue;
            releaseMonWwnList.add(sJctrMonitorPortWWNStatusMonInfo);
        }
        HashMap<String, SJctrMonitorPortWWNStatusMonInfo> initMonMap = new HashMap<String, SJctrMonitorPortWWNStatusMonInfo>();
        for (SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo : initMonWwnTableData) {
            tmpStr = sJctrMonitorPortWWNStatusMonInfo.toString();
            initMonMap.put(tmpStr, sJctrMonitorPortWWNStatusMonInfo);
        }
        for (SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo : monWwnTableData) {
            tmpStr = sJctrMonitorPortWWNStatusMonInfo.toString();
            SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo2 = (SJctrMonitorPortWWNStatusMonInfo)initMonMap.get(tmpStr);
            if (sJctrMonitorPortWWNStatusMonInfo2 != null) continue;
            setMonWwnList.add(sJctrMonitorPortWWNStatusMonInfo);
        }
        if (0 == setMonWwnList.size() && 0 == releaseMonWwnList.size()) {
            SJctrError sJctrError = new SJctrError(51, 22, 105107);
            SJcException sJcException = sJctrError.createException();
            throw sJcException;
        }
        if (0 < releaseMonWwnList.size()) {
            confirmData.setViewWarningMsg(1);
        } else {
            confirmData.setViewWarningMsg(0);
        }
        for (SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo : setMonWwnList) {
            sJctrMonitorPortWWNStatusMonInfo.setStrStatus(STATUS_NORMAL);
        }
        for (SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo : releaseMonWwnList) {
            for (SJctrMonitorPortWWNStatusMonInfo sJctrMonitorPortWWNStatusMonInfo3 : monWwnTableData) {
                if (!Arrays.equals(sJctrMonitorPortWWNStatusMonInfo.getWwn().getByWWN(), sJctrMonitorPortWWNStatusMonInfo3.getWwn().getByWWN())) continue;
                sJctrMonitorPortWWNStatusMonInfo.setStrStatus(STATUS_NONINTEGRITY);
            }
        }
        Collections.sort(setMonWwnList, PORT_WWN_COMP);
        Collections.sort(releaseMonWwnList, PORT_WWN_COMP);
        confirmData.setMonitorWwns(setMonWwnList);
        confirmData.setNonmonitorWwns(releaseMonWwnList);
        ArrayList<SJctrEditMonitoringWWNsConfirmData> arrayList = new ArrayList<SJctrEditMonitoringWWNsConfirmData>();
        arrayList.add(confirmData);
        this.putCache(SJctrEditMonitoringWWNsConfirmData.class, arrayList);
        this.setFinishChangeCheck(false);
        return ret;
    }

    private void addMonWwnsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<Object> selectedCheckList;
        SJctrMonitorWWNsStatusMonTableModel nonMonWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_WWNS);
        SJctrMonitorWWNsStatusMonTableModel monWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWNS);
        List<Object> addCheckList = nonMonWwnTable.getSelectedRowDataOrder();
        boolean errChk = SJctrOptionMonitorUtility.isOverMonitoringWWNsMax(addCheckList, selectedCheckList = monWwnTable.getAllRowData());
        if (errChk) {
            SJctrError err = new SJctrError(51, 22, 105115);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJctrMonitorPortWWNInfo> overPorts = SJctrOptionMonitorUtility.getOverMonitoringWWNsMaxPorts(addCheckList, selectedCheckList);
        if (0 < overPorts.size()) {
            SJctrError err = new SJctrError(51, 22, 105116);
            SJctrMonitorWWNsTableModel overPortsTable = new SJctrMonitorWWNsTableModel();
            overPortsTable.initGuidance(this.getComUtility());
            overPortsTable.setPaging(false);
            overPortsTable.addRowData(overPorts, 0);
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(overPortsTable);
            SJcException exp = err.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        errChk = SJctrOptionMonitorUtility.isDuplicationWWNName(addCheckList, selectedCheckList);
        if (errChk) {
            SJctrError err = new SJctrError(51, 22, 105106);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> addList = nonMonWwnTable.removeSelectedRowData();
        monWwnTable.addRowData(addList, 0);
        List<Object> selectingList = monWwnTable.getFilterData(addList);
        monWwnTable.setRowSelectionList(selectingList);
        monWwnTable.setCurrentPage(Integer.toString(1));
        monWwnTable.setVScrollReset(true);
        monWwnTable.setSortColumn(null, Boolean.FALSE);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void removeMonWwnsAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrMonitorWWNsStatusMonTableModel monWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_MON_WWNS);
        SJctrMonitorWWNsStatusMonTableModel nonMonWwnTable = (SJctrMonitorWWNsStatusMonTableModel)this.getDataObjectModel(KEY_TABLE_NON_MON_WWNS);
        List<Object> removeData = monWwnTable.removeSelectedRowData();
        nonMonWwnTable.addRowData(removeData, 0);
        List<Object> selectingList = nonMonWwnTable.getFilterData(removeData);
        nonMonWwnTable.setRowSelectionList(selectingList);
        nonMonWwnTable.setCurrentPage(Integer.toString(1));
        nonMonWwnTable.setVScrollReset(true);
        nonMonWwnTable.setSortColumn(null, Boolean.FALSE);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    private void checkNickName(Map<String, String[]> nickNameMap, SJmoWwn wwnInfo, int portId) {
        String hba = SJctrComUtility.toWWNDisplay(wwnInfo);
        String[] mapValue = nickNameMap.get(hba);
        if (mapValue == null) {
            nickNameMap.put(hba, new String[]{String.valueOf(portId), wwnInfo.getStrWWNNickName()});
        } else if (mapValue[1].equals("")) {
            nickNameMap.put(hba, new String[]{String.valueOf(portId), wwnInfo.getStrWWNNickName()});
        } else if (!wwnInfo.getStrWWNNickName().equals("") && portId < Integer.parseInt(mapValue[0])) {
            nickNameMap.put(hba, new String[]{String.valueOf(portId), wwnInfo.getStrWWNNickName()});
        }
    }

    public static enum EDIT_MON_WWNS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

