/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrDispObjDataInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrDispObjDataModel;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrMonitorPerformanceUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectDispTermInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectedObjectInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.table.SJctrAvailableObjectsTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.table.SJctrSelectedObjectsTableModel;

public class SJctrEditGraphDispObjDC
extends SJctrDialogDataController {
    protected static final int DISP_ID = 33595458;
    public static final String KEY_TABLE_MON_AVAILABLE = "COM_TABLE_MON_AVAILABLE";
    public static final String KEY_TABLE_MON_OBJECT = "COM_TABLE_MON_OBJECT";
    public static final String KEY_DISP_OBJ = "COM_DISP_OBJ";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_DELETE = "COM_DELETE";
    public static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    public static final String KEY_SEL_DISP_OBJ_CMB = "KEY_SEL_DISP_OBJ_CMB";
    public static final String KEY_MONITOR_OBJECT_NUM = "KEY_OBJECT_NUM";

    public SJctrEditGraphDispObjDC() throws SJcException {
        super(33595458);
        this.initDataModel();
        this.initListener();
    }

    public SJctrEditGraphDispObjDC(int dispID) {
        super(dispID);
    }

    protected void makeDataModelParent() {
        super.makeDataModel();
    }

    public int getMonitorObjectNum() {
        int ret = 0;
        List<?> objNumObj = this.getCache(KEY_MONITOR_OBJECT_NUM);
        if (objNumObj != null && objNumObj.size() > 0 && objNumObj.get(0) != null) {
            ret = (Integer)objNumObj.get(0);
        }
        return ret;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = false;
        this.getMonMonitoringInfo();
        this.getSelectDispTermInfo();
        List<?> selList = this.getCache("KEY_SELECT_OBJ");
        if (selList == null || selList.size() == 0) {
            this.logUty.putlog("checkStartData", "KEY_SELECT_OBJ data error");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        List<?> panelNo = this.getCache("KEY_EDT_GRAPH_PANEL_NO");
        if (panelNo == null || panelNo.size() == 0) {
            this.logUty.putlog("checkStartData", "KEY_EDT_GRAPH_PANEL_NO data error");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        ret = true;
        return ret;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        try {
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            SJctrDispObjDataModel dispObjDataModel = (SJctrDispObjDataModel)this.getDataObjectModel(KEY_DISP_OBJ);
            SJctrSelectedObjectsTableModel selectedTable = (SJctrSelectedObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_OBJECT);
            List<Object> selList = this.getCache("KEY_SELECT_OBJ");
            Comparator<Object> comp = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    int ret = 0;
                    SJctrSelectedObjectInfo obj1 = (SJctrSelectedObjectInfo)o1;
                    SJctrSelectedObjectInfo obj2 = (SJctrSelectedObjectInfo)o2;
                    ret = obj1.compareToTableData(obj2);
                    return ret;
                }
            };
            ArrayList<Object> workList = new ArrayList<Object>();
            workList.addAll(selList);
            Collections.sort(workList, comp);
            selectedTable.clearRowData();
            selectedTable.addRowData(workList);
            dispObjDataModel.setMonitorObjComboData(termInfo.getMonDataType(), null, selList);
            SJctrDispObjDataInfo dispObjInfo = this.getDispObjDataInfo();
            SJctrAvailableObjectsTableModel avaTable = dispObjDataModel.changeMonitoringObject(dispObjInfo);
            this.addDataObjectModel(KEY_TABLE_MON_AVAILABLE, avaTable);
            avaTable.makeDataModel();
            avaTable.initGuidance(this.getComUtility());
            avaTable.updateTableData(termInfo.getMonDataType(), selList);
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
    }

    protected SJctrDispObjDataInfo getDispObjDataInfo() {
        SJctrDispObjDataInfo dispObjInfo = null;
        List<?> listData = this.getCache(KEY_SEL_DISP_OBJ_CMB);
        if (listData == null || listData.size() <= 0 || listData.get(0) == null) {
            this.logUty.putlog("getDispObjDataInfo", "listData error");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        dispObjInfo = (SJctrDispObjDataInfo)listData.get(0);
        return dispObjInfo;
    }

    public SJctrSelectDispTermInfo getSelectDispTermInfo() {
        SJctrSelectDispTermInfo termInfo = SJctrMonitorPerformanceUtility.getSelectDispTermInfo(this, this.logUty);
        return termInfo;
    }

    public MonMonitoringInfoLDKC getMonMonitoringInfo() {
        return SJctrMonitorPerformanceUtility.getMonMonitoringInfo(this, this.logUty);
    }

    @Override
    public boolean checkEndData() {
        boolean ret = false;
        SJctrSelectedObjectsTableModel selTable = (SJctrSelectedObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_OBJECT);
        List<Object> selList = selTable.getAllRowData();
        this.putCache("KEY_EDIT_SELECT_OBJ", selList);
        this.putCache("KEY_EDT_GRAPH_PANEL_NO", this.getCache("KEY_EDT_GRAPH_PANEL_NO"));
        ret = true;
        return ret;
    }

    protected void doChgMonObject() {
        try {
            SJctrDispObjDataModel dispObjDataModel = (SJctrDispObjDataModel)this.getDataObjectModel(KEY_DISP_OBJ);
            SJctrSelectedObjectsTableModel selectedTable = (SJctrSelectedObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_OBJECT);
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            SJctrDispObjDataInfo dispObjInfo = this.getDispObjDataInfo();
            List<Object> selList = selectedTable.getAllRowData();
            dispObjDataModel.setMonitorObjComboData(termInfo.getMonDataType(), dispObjInfo, selList);
            SJctrAvailableObjectsTableModel avaTable = (SJctrAvailableObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_AVAILABLE);
            dispObjInfo = this.getDispObjDataInfo();
            avaTable = dispObjDataModel.changeMonitoringObject(dispObjInfo);
            this.addDataObjectModel(KEY_TABLE_MON_AVAILABLE, avaTable);
            avaTable.makeDataModel();
            avaTable.initGuidance(this.getComUtility());
            avaTable.updateTableData(termInfo.getMonDataType(), selList);
            avaTable.setDirty();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107015);
        }
    }

    protected void doSelectAdd() {
        try {
            SJctrAvailableObjectsTableModel availableTable = (SJctrAvailableObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_AVAILABLE);
            SJctrSelectedObjectsTableModel selectedTable = (SJctrSelectedObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_OBJECT);
            int oldSelected = selectedTable.getRowCount();
            int monitorObjNum = this.getMonitorObjectNum();
            int selRowCnt = 0;
            if (availableTable.getSelectedRowData() != null) {
                selRowCnt = availableTable.getSelectedRowData().size();
            }
            if (oldSelected + selRowCnt > 8) {
                this.logUty.putlog("doSelectAdd", "monitor object of one graph max num over");
                SJctrError error = new SJctrError(51, 22, 105254);
                throw error.createException();
            }
            if ((monitorObjNum = monitorObjNum + oldSelected + selRowCnt) > 16) {
                this.logUty.putlog("doSelectAdd", "monitor object max num over");
                SJctrError error = new SJctrError(51, 22, 105111);
                throw error.createException();
            }
            List<Object> list = null;
            list = availableTable.getDispMonitorObjects();
            availableTable.removeSelectedRowData();
            selectedTable.addRowData(list, 0);
            selectedTable.setRowSelectionList(list);
            if (oldSelected == 0) {
                SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
                SJctrDispObjDataModel dispObjDataModel = (SJctrDispObjDataModel)this.getDataObjectModel(KEY_DISP_OBJ);
                SJctrDispObjDataInfo dispObjInfo = this.getDispObjDataInfo();
                dispObjDataModel.setMonitorObjComboData(termInfo.getMonDataType(), dispObjInfo, selectedTable.getAllRowData());
            }
            selectedTable.setVScrollReset(true);
            selectedTable.setSortColumn(null, Boolean.TRUE);
            this.updateFooter();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107015);
        }
    }

    protected void doSelectDelete() {
        try {
            SJctrAvailableObjectsTableModel availableTable = (SJctrAvailableObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_AVAILABLE);
            SJctrSelectedObjectsTableModel selectedTable = (SJctrSelectedObjectsTableModel)this.getDataObjectModel(KEY_TABLE_MON_OBJECT);
            SJctrSelectDispTermInfo termInfo = this.getSelectDispTermInfo();
            selectedTable.removeSelectedRowData();
            int selectedNum = selectedTable.getRowCount();
            List<Object> selList = selectedTable.getAllRowData();
            if (selectedNum == 0) {
                SJctrDispObjDataModel dispObjDataModel = (SJctrDispObjDataModel)this.getDataObjectModel(KEY_DISP_OBJ);
                SJctrDispObjDataInfo dispObjInfo = this.getDispObjDataInfo();
                dispObjDataModel.setMonitorObjComboData(termInfo.getMonDataType(), dispObjInfo, selList);
            }
            availableTable.updateTableData(termInfo.getMonDataType(), selList, true);
            this.updateFooter();
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107015);
        }
    }

    protected void initListener() {
        this.addMessageEventListener(MON_EDTOBJ_MSG.CHG_MON_OBJECT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditGraphDispObjDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.CHG_MON_OBJECT Start");
                SJctrEditGraphDispObjDC.this.doChgMonObject();
                SJctrEditGraphDispObjDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.CHG_MON_OBJECT End");
            }
        });
        this.addMessageEventListener(MON_EDTOBJ_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditGraphDispObjDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.SELECT_ADD Start");
                SJctrEditGraphDispObjDC.this.doSelectAdd();
                SJctrEditGraphDispObjDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.SELECT_ADD End");
            }
        });
        this.addMessageEventListener(MON_EDTOBJ_MSG.SELECT_DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditGraphDispObjDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.SELECT_DELETE Start");
                SJctrEditGraphDispObjDC.this.doSelectDelete();
                SJctrEditGraphDispObjDC.this.getLogUty().putlog("doMessageAction", "MON_EDTOBJ_MSG.SELECT_DELETE End");
            }
        });
    }

    protected void initDataModel() {
        SJctrAvailableObjectsTableModel avaTable = new SJctrAvailableObjectsTableModel();
        this.addDataObjectModel(KEY_TABLE_MON_AVAILABLE, avaTable);
        this.addDataObjectModel(KEY_DISP_OBJ, new SJctrDispObjDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                ArrayList param = new ArrayList();
                SJctrEditGraphDispObjDC.this.fireMessageEvent(MON_EDTOBJ_MSG.SELECT_ADD, param);
            }
        });
        SJctrSelectedObjectsTableModel selTable = new SJctrSelectedObjectsTableModel();
        this.addDataObjectModel(KEY_TABLE_MON_OBJECT, selTable);
        SJctrButtonDataModel deleteButton = selTable.getButton(KEY_DELETE);
        deleteButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                ArrayList param = new ArrayList();
                SJctrEditGraphDispObjDC.this.fireMessageEvent(MON_EDTOBJ_MSG.SELECT_DELETE, param);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    public static enum MON_EDTOBJ_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_DELETE,
        CHG_MON_OBJECT;

    }
}

