/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.com;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrWarnPGRecommendedCapFromPGDetail
extends SJctrCapacityColumn {
    private Map<String, Long> pageNumMap = null;
    private Map<String, Long> lbaNumMap = null;
    private static final String HALF_SPACE = " ";

    public SJctrWarnPGRecommendedCapFromPGDetail(String key) {
        super(key);
        this.setPartsId("RECOMMENDED");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        return list;
    }

    @Override
    public boolean hasDpVolume(Map<Class<?>, List<?>> basicData) {
        return true;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        SJmoPgDetail pgDtl = (SJmoPgDetail)index;
        List<SJmoVdevDetail> vdevDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPgScatteredInfo> scPGInfoList = basicData.get(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        List<SJmoVdevDetail> scVdevList = SJctrPoolUtility.getScatteredVdevDtlList(pgDtl, vdevDtlList, scPGInfoList);
        retList.add(scVdevList);
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)basicData.get(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL).get(0);
        retList.add(poolDtl);
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (this.pageNumMap == null || this.lbaNumMap == null) {
            int rowCount = this.getTable().getRowCount();
            this.pageNumMap = new HashMap<String, Long>(rowCount);
            this.lbaNumMap = new HashMap<String, Long>(rowCount);
        }
        if (dataList != null && dataList.size() >= 2) {
            List scVdevDtlList = (List)dataList.get(0);
            SJmoVdevDetail pdevDtl = (SJmoVdevDetail)scVdevDtlList.get(0);
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)dataList.get(1);
            SJmoPgIndex pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(pdevDtl.getFB4());
            pgIndex.setPG(pdevDtl.getPG());
            long lPoolFMCActualPages = poolDtl.getLPoolFmcActualPages();
            if (lPoolFMCActualPages <= 0L) {
                this.pageNumMap.put(pgIndex.toString(), Long.valueOf(SJctrPoolUtility.HAIFUN_NUM));
                this.lbaNumMap.put(pgIndex.toString(), Long.valueOf(SJctrPoolUtility.HAIFUN_NUM));
                return SJctrPoolUtility.HAIFUN_STR;
            }
            int recommendExpantionRate = SJctrPoolUtility.getRecommendExpantionRate(poolDtl);
            long lVdevPhyMaxLba = 0L;
            for (SJmoVdevDetail scVdev : scVdevDtlList) {
                lVdevPhyMaxLba += scVdev.getLVdevPhyMaxLba();
            }
            long recommendExpantionCap = lVdevPhyMaxLba * (long)recommendExpantionRate / 100L;
            this.lbaNumMap.put(pgIndex.toString(), recommendExpantionCap);
            long pageSize = poolDtl.getPageSize() * 2L;
            long recommendExpantionPage = recommendExpantionCap / pageSize;
            this.pageNumMap.put(pgIndex.toString(), recommendExpantionPage);
            String select = this.getUnitSelect();
            SJctrCapacityUtility.UNIT unit = SJctrCapacityUtility.UNIT.GB;
            if (select.length() > 0) {
                unit = SJctrCapacityUtility.UNIT.valueOf(select);
            }
            SJctrCapacityUtility capUtil = this.getTable().getComUtility().getCapacityUtility();
            StringBuffer buf = new StringBuffer();
            if (unit.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                buf.append(recommendExpantionPage);
            } else {
                buf.append(capUtil.toString(recommendExpantionCap, unit));
            }
            buf.append(HALF_SPACE);
            buf.append(capUtil.getUnitString(unit));
            ret = buf.toString();
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoPgDetail pgDtl = (SJmoPgDetail)this.getPrimaryKeyObject(dat);
        Long lbaCap = this.lbaNumMap.get(pgDtl.toString());
        if (lbaCap == null) {
            return -2L;
        }
        return lbaCap;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJmoPgDetail pgDtl = (SJmoPgDetail)this.getPrimaryKeyObject(dat);
        Long pageCap = this.pageNumMap.get(pgDtl.toString());
        if (pageCap == null) {
            return -2L;
        }
        return pageCap;
    }
}

