/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.editpools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.model.SJctrCheckBoxAreaDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDC;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolPgKindInfo;
import sanproject.sn2.model.data.group.SJmoPoolTierInfo;

public class SJctrEditPoolsTierBufNewPageArea
extends SJctrCheckBoxAreaDataModel {
    private SJctrTextBoxDataModel newPageTier1TextBox = new SJctrTextBoxDataModel();
    private SJctrTextBoxDataModel newPageTier2TextBox = new SJctrTextBoxDataModel();
    private SJctrTextBoxDataModel newPageTier3TextBox = new SJctrTextBoxDataModel();
    private SJctrEditPoolsDC edPDC = null;
    private SJctrComUtility comUtil = null;

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.addDataModel("COM_BUFFER_NEW_PAGE_TIER1", this.newPageTier1TextBox);
        this.addDataModel("COM_BUFFER_NEW_PAGE_TIER2", this.newPageTier2TextBox);
        this.addDataModel("COM_BUFFER_NEW_PAGE_TIER3", this.newPageTier3TextBox);
        this.comUtil = util;
        this.edPDC = (SJctrEditPoolsDC)this.getDataController();
    }

    public void initTierBufNewPageArea(boolean bSelEnaOrDis, String strSelMultiTierKey) {
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(this.edPDC.getCache("KEY_CLASS_CHK_EDIT_POOLDTL"));
        this.initTierTextArea(bSelEnaOrDis, strSelMultiTierKey, poolDtlList, 1);
        this.initTierTextArea(bSelEnaOrDis, strSelMultiTierKey, poolDtlList, 2);
        this.initTierTextArea(bSelEnaOrDis, strSelMultiTierKey, poolDtlList, 3);
        if (!bSelEnaOrDis) {
            this.setEnableCheckBox(false);
        } else if (strSelMultiTierKey == null || strSelMultiTierKey.equals("COM_DISABLE")) {
            this.setEnableCheckBox(false);
        }
    }

    public void refTierBufNewPageArea(String strSelMultiTierKey) {
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(this.edPDC.getCache("KEY_CLASS_CHK_EDIT_POOLDTL"));
        this.refTierTextArea(strSelMultiTierKey, poolDtlList, 1);
        this.refTierTextArea(strSelMultiTierKey, poolDtlList, 2);
        this.refTierTextArea(strSelMultiTierKey, poolDtlList, 3);
    }

    private void initTierTextArea(boolean bSelEnaOrDis, String strSelMultiTierKey, List<SJmoPoolDetail> poolDtlList, int iTierNum) {
        String strMinBufNewPage = "";
        String strMaxBufNewPage = "";
        String strTierText = "";
        int sDefBufNewPage = -1;
        boolean bActivityFlg = false;
        if (!bSelEnaOrDis) {
            this.refTierText(strMinBufNewPage, strMaxBufNewPage, strTierText, bActivityFlg, iTierNum);
            return;
        }
        for (int i = 0; i < poolDtlList.size(); ++i) {
            SJmoPoolDetail poolDtl = poolDtlList.get(i);
            int sBufNewPage = -1;
            if ((poolDtl.getITierControlInfo() & 0x80) != 128) {
                if (strSelMultiTierKey != null && strSelMultiTierKey.equals("COM_ENABLE")) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "initTierTextArea", "DP Kind Error PoolID = " + poolDtl.getPoolId());
                    SJctrPoolUtility.SJctrErrorDialog(107007);
                }
                ArrayList<SJmoPoolPgKindInfo> alPoolPgKind = poolDtl.getAlPoolPgKind();
                HashSet poolDriveTypeSet = this.comUtil.getPoolUtility().getDriveTypeRpminPool(alPoolPgKind);
                if (poolDriveTypeSet.size() < iTierNum) continue;
                sBufNewPage = iTierNum == 1 && this.comUtil.getPoolUtility().checkSsdDrive(alPoolPgKind) ? 0 : 8;
            } else {
                if (strSelMultiTierKey != null && strSelMultiTierKey.equals("COM_DISABLE")) continue;
                if (strSelMultiTierKey == null || strSelMultiTierKey.equals("COM_ENABLE")) {
                    SJmoPoolTierInfo defPoolTierInf = this.getTierInfo(poolDtl.getAlTierInfo(), iTierNum);
                    if (defPoolTierInf == null) continue;
                    sBufNewPage = defPoolTierInf.getSTierAlocateCapa();
                    if (strSelMultiTierKey != null && strSelMultiTierKey.equals("COM_ENABLE")) {
                        bActivityFlg = true;
                    }
                }
            }
            if (sDefBufNewPage < 0) {
                sDefBufNewPage = sBufNewPage;
            }
            if (sDefBufNewPage == sBufNewPage) continue;
            sDefBufNewPage = -1;
            break;
        }
        strTierText = sDefBufNewPage < 0 ? "" : SJctrComUtility.toDecString(sDefBufNewPage);
        if (bActivityFlg) {
            strMinBufNewPage = SJctrComUtility.toDecString(0);
            strMaxBufNewPage = SJctrComUtility.toDecString(50);
        }
        this.refTierText(strMinBufNewPage, strMaxBufNewPage, strTierText, bActivityFlg, iTierNum);
    }

    private void refTierTextArea(String strSelMultiTierKey, List<SJmoPoolDetail> poolDtlList, int iTierNum) {
        String strMinBufNewPage = "";
        String strMaxBufNewPage = "";
        String strTierText = "";
        boolean bActivityFlg = false;
        strTierText = this.getTierText(iTierNum).getValue();
        this.refTierText(strMinBufNewPage, strMaxBufNewPage, new String(""), true, iTierNum);
        if (strSelMultiTierKey.equals("COM_ENABLE")) {
            if (iTierNum == 1) {
                strMinBufNewPage = SJctrComUtility.toDecString(0);
                strMaxBufNewPage = SJctrComUtility.toDecString(50);
                this.refTierText(strMinBufNewPage, strMaxBufNewPage, strTierText, true, iTierNum);
            } else {
                for (int iCnt = 0; iCnt < poolDtlList.size(); ++iCnt) {
                    SJmoPoolDetail poolDtl = poolDtlList.get(iCnt);
                    if ((poolDtl.getITierControlInfo() & 0x80) != 0) {
                        SJmoPoolTierInfo defPoolTierInf = this.getTierInfo(poolDtl.getAlTierInfo(), iTierNum);
                        if (defPoolTierInf == null) continue;
                        bActivityFlg = true;
                        break;
                    }
                    HashSet poolDriveTypeSet = this.comUtil.getPoolUtility().getDriveTypeRpminPool(poolDtl.getAlPoolPgKind());
                    if (poolDriveTypeSet.size() < iTierNum) continue;
                    bActivityFlg = true;
                    break;
                }
                if (bActivityFlg) {
                    strMinBufNewPage = SJctrComUtility.toDecString(0);
                    strMaxBufNewPage = SJctrComUtility.toDecString(50);
                }
                this.refTierText(strMinBufNewPage, strMaxBufNewPage, strTierText, bActivityFlg, iTierNum);
            }
        } else if (strSelMultiTierKey.equals("COM_DISABLE")) {
            this.refTierText(strMinBufNewPage, strMaxBufNewPage, strTierText, false, iTierNum);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "refTierTextArea", "Multi-Tier Pool Selection Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    private SJmoPoolTierInfo getTierInfo(ArrayList<SJmoPoolTierInfo> alPoolTier, int iTierNum) {
        SJmoPoolTierInfo poolTierInf = null;
        for (int iTierCnt = 0; iTierCnt < alPoolTier.size(); ++iTierCnt) {
            if (iTierNum != alPoolTier.get(iTierCnt).getSTierNum()) continue;
            poolTierInf = alPoolTier.get(iTierCnt);
            break;
        }
        return poolTierInf;
    }

    private SJctrTextBoxDataModel getTierText(int iTierNum) {
        SJctrTextBoxDataModel retText = null;
        switch (iTierNum) {
            case 1: {
                retText = this.newPageTier1TextBox;
                break;
            }
            case 2: {
                retText = this.newPageTier2TextBox;
                break;
            }
            case 3: {
                retText = this.newPageTier3TextBox;
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getTierText", "Tier Num Error Tier Num = " + iTierNum);
            }
        }
        return retText;
    }

    private void refTierText(String strMin, String strMax, String strText, boolean bEnable, int iTierNum) {
        SJctrTextBoxDataModel tierText = this.getTierText(iTierNum);
        tierText.setMin(strMin);
        tierText.setMax(strMax);
        tierText.setValue(strText);
        tierText.setEnable(bEnable);
    }

    public String getStrTierBufNewPageText(int iTierNum) {
        SJctrTextBoxDataModel tierTextBox = this.getTierText(iTierNum);
        return tierTextBox.getValue();
    }

    public boolean isTextBoxEnable(int iTierNum) {
        SJctrTextBoxDataModel tiertextBox = this.getTierText(iTierNum);
        return tiertextBox.isEnable();
    }
}

