/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.expandpool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.serverux.dataimpl.AddPoolData3;
import sanproject.serverux.dataimpl.POOLsetAddPool3_IN;
import sanproject.serverux.dataimpl.POOLsetAddPool3_OUT;
import sanproject.serverux.dataimpl.PoolVolData;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolError;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrExpandPoolAC
extends SJctrApplyController {
    private ArrayList<SJmoPoolDetail> expPoolDtlList = null;
    private ArrayList<SJmoPoolVolDetail> expPoolVolDtlList = null;
    private HashMap<String, Short> expExtLdevPerformance = null;
    private POOLsetAddPool3_OUT expRst = null;
    private int iPoolTopErr = 0;
    private int iPoolVolTopErr = 0;

    public void setApplyList(ArrayList<SJmoPoolDetail> poolDtlList, ArrayList<SJmoPoolVolDetail> poolVolDtlList, HashMap<String, Short> selExtLdevPerformance) {
        this.expPoolDtlList = poolDtlList;
        this.expPoolVolDtlList = poolVolDtlList;
        this.expExtLdevPerformance = selExtLdevPerformance;
    }

    @Override
    public ArrayList<?> getSetList() {
        AddPoolData3[] qsAddPooldtEx;
        POOLsetAddPool3_IN setQSAddPoolEx;
        ArrayList<POOLsetAddPool3_IN> applyList = new ArrayList<POOLsetAddPool3_IN>();
        if (null != this.expPoolDtlList && 0 != this.expPoolDtlList.size() && null != this.expPoolVolDtlList && 0 != this.expPoolVolDtlList.size()) {
            setQSAddPoolEx = new POOLsetAddPool3_IN();
            qsAddPooldtEx = new AddPoolData3[this.expPoolDtlList.size()];
            for (int iEXPCnt = 0; iEXPCnt < this.expPoolDtlList.size(); ++iEXPCnt) {
                SJmoPoolDetail poolDtl = this.expPoolDtlList.get(iEXPCnt);
                qsAddPooldtEx[iEXPCnt] = new AddPoolData3();
                qsAddPooldtEx[iEXPCnt].setSPoolId((short)poolDtl.getPoolId());
                qsAddPooldtEx[iEXPCnt].setByPoolKind(poolDtl.getPoolKind());
                qsAddPooldtEx[iEXPCnt].setSPoolThreshold(poolDtl.getPoolThreshold());
                qsAddPooldtEx[iEXPCnt].setSPoolFixThreshold((short)0);
                qsAddPooldtEx[iEXPCnt].setSPoolGrainSize(poolDtl.getPoolGrainSize());
                qsAddPooldtEx[iEXPCnt].setIMaxSubscription(poolDtl.getMaxSubscription());
                qsAddPooldtEx[iEXPCnt].setSTierControlInfo((short)poolDtl.getITierControlInfo());
                qsAddPooldtEx[iEXPCnt].setSExecutionCycle((short)poolDtl.getIExecutionCycle());
                qsAddPooldtEx[iEXPCnt].setByRelocateStartPeriodHour(poolDtl.getByRelocateStartPeriodHour());
                qsAddPooldtEx[iEXPCnt].setByRelocateStartPeriodMinute(poolDtl.getByRelocateStartPeriodMin());
                qsAddPooldtEx[iEXPCnt].setByRelocateEndPeriodHour(poolDtl.getByRelocateEndPeriodHour());
                qsAddPooldtEx[iEXPCnt].setByRelocateEndPeriodMinute(poolDtl.getByRelocateEndPeriodMin());
                qsAddPooldtEx[iEXPCnt].setByMonitorStartPeriodHour(poolDtl.getByMonStartPeriodHour());
                qsAddPooldtEx[iEXPCnt].setByMonitorStartPeriodMinute(poolDtl.getByMonStartPeriodMin());
                qsAddPooldtEx[iEXPCnt].setByMonitorEndPeriodHour(poolDtl.getByMonEndPeriodHour());
                qsAddPooldtEx[iEXPCnt].setByMonitorEndPeriodMinute(poolDtl.getByMonEndPeriodMin());
                qsAddPooldtEx[iEXPCnt].setITierRelocatePolicy(poolDtl.getITierRelocatePolicy());
                this.setDepletionThreshold(qsAddPooldtEx[iEXPCnt], poolDtl);
                qsAddPooldtEx[iEXPCnt].setSPoolThresholdMode(poolDtl.getSPoolThresholdMode());
                SJmoPoolVolDetail poolVolDtl = this.expPoolVolDtlList.get(iEXPCnt);
                ArrayList poolVolInfList = poolVolDtl.getAlPoolInfo();
                PoolVolData[] qsPoolVoldt = new PoolVolData[poolVolInfList.size()];
                for (int iEXPVolCnt = 0; iEXPVolCnt < poolVolInfList.size(); ++iEXPVolCnt) {
                    SJmoLdevDetail poolVolInf = (SJmoLdevDetail)poolVolInfList.get(iEXPVolCnt);
                    qsPoolVoldt[iEXPVolCnt] = new PoolVolData();
                    qsPoolVoldt[iEXPVolCnt].setSLDKC(poolVolInf.getSLdkc());
                    qsPoolVoldt[iEXPVolCnt].setSCU(poolVolInf.getSCu());
                    qsPoolVoldt[iEXPVolCnt].setSLDEV(poolVolInf.getSLdev());
                    if (poolVolInf.getByVolumeType() == 1) {
                        if (this.expExtLdevPerformance.containsKey(poolVolInf.getIndexKey())) {
                            qsPoolVoldt[iEXPVolCnt].setSExtLDEVAttribute(this.expExtLdevPerformance.get(poolVolInf.getIndexKey()));
                            continue;
                        }
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "getSetList", "ExternalLdevPerformanceMap Error");
                        SJctrPoolUtility.SJctrErrorDialog(107007);
                        continue;
                    }
                    qsPoolVoldt[iEXPVolCnt].setSExtLDEVAttribute((short)0);
                }
                qsAddPooldtEx[iEXPCnt].setObjPoolVolData(qsPoolVoldt);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getSetList", "PoolDetail or PoolVolDetail is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        setQSAddPoolEx.setObjPoolData(qsAddPooldtEx);
        applyList.add(setQSAddPoolEx);
        return applyList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        ArrayList<Object> rstList = null;
        if (null == resultObject) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The parameter is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (resultObject instanceof List) {
            rstList = (ArrayList<Object>)resultObject;
        } else {
            rstList = new ArrayList<Object>();
            rstList.add(resultObject);
        }
        for (int iCnt = 0; iCnt < rstList.size(); ++iCnt) {
            if (null != rstList.get(iCnt) && rstList.get(iCnt) instanceof POOLsetAddPool3_OUT) {
                this.expRst = (POOLsetAddPool3_OUT)rstList.get(iCnt);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The element in the list is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    @Override
    protected List<List<SJctrError>> getResultDataEx() {
        ArrayList<List<SJctrError>> expErrList = new ArrayList<List<SJctrError>>();
        int iTopErrCode = 0;
        if (null == this.expRst || null == this.expRst.getObjPoolData() || this.expRst.getObjPoolData().length == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getResultDataEx", "The ApplyResult is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        AddPoolData3[] poolErrInf = this.expRst.getObjPoolData();
        List<SJctrError> poolErrList = this.getPoolError(poolErrInf);
        expErrList.add(poolErrList);
        for (int iCnt = 0; iCnt < poolErrInf.length; ++iCnt) {
            if (null != poolErrInf[iCnt].getObjPoolVolData() && poolErrInf[iCnt].getObjPoolVolData().length != 0) {
                List<SJctrError> poolVolErrList = this.getPoolVolError((PoolVolData[])poolErrInf[iCnt].getObjPoolVolData());
                expErrList.add(poolVolErrList);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getResultDataEx", "The element in the array is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (this.iPoolTopErr == 0 && this.iPoolVolTopErr == 0) {
            super.setApplyResult(expErrList);
        } else {
            iTopErrCode = this.iPoolTopErr != 0 ? this.iPoolTopErr : this.iPoolVolTopErr;
            SJctrError topErr = new SJctrError(31, 22, iTopErrCode);
            this.setError(topErr);
        }
        return expErrList;
    }

    @Override
    public int getLeadTime() {
        int iLeadTime = 0;
        int iAddPoolVolNum = 0;
        double dAddPoolVolCapa = 0.0;
        for (int iCnt = 0; iCnt < this.expPoolVolDtlList.size(); ++iCnt) {
            SJmoPoolVolDetail poolVolDtl = this.expPoolVolDtlList.get(iCnt);
            ArrayList ldevDtlList = poolVolDtl.getAlPoolInfo();
            iAddPoolVolNum += ldevDtlList.size();
            for (int iVolCnt = 0; iVolCnt < ldevDtlList.size(); ++iVolCnt) {
                SJmoLdevDetail ldevDtl = (SJmoLdevDetail)ldevDtlList.get(iVolCnt);
                long lLdevSize = ldevDtl.getLLDEVLBASize() * 512L / 1024L;
                double dLdevSize = lLdevSize / 0x100000L;
                dAddPoolVolCapa += dLdevSize;
            }
        }
        iLeadTime = (int)(45.0 + (double)iAddPoolVolNum * 0.2 + dAddPoolVolCapa / 20.0 * 0.2);
        return iLeadTime;
    }

    private List<SJctrError> getPoolError(AddPoolData3[] poolErr) {
        ArrayList<SJctrError> poolErrList = new ArrayList<SJctrError>();
        for (int iCnt = 0; iCnt < poolErr.length; ++iCnt) {
            if (null != poolErr[iCnt]) {
                if (poolErr[iCnt].getLErrorCode() == 0L) continue;
                if (this.iPoolTopErr == 0) {
                    this.iPoolTopErr = 106061;
                }
                SJctrPoolError poolIndexErr = new SJctrPoolError(30, 5, (int)poolErr[iCnt].getLErrorCode());
                SJmoPoolIndex poolIdx = new SJmoPoolIndex();
                poolIdx.setPoolId(poolErr[iCnt].getSPoolId());
                poolIndexErr.setkeyData(poolIdx);
                poolIndexErr.setStrAssignTableKey("COM_TABLE_POOLNAME");
                poolErrList.add(poolIndexErr);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolError", "The array element is null.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return poolErrList;
    }

    private List<SJctrError> getPoolVolError(PoolVolData[] poolVolErr) {
        ArrayList<SJctrError> poolVolErrList = new ArrayList<SJctrError>();
        for (int iCnt = 0; iCnt < poolVolErr.length; ++iCnt) {
            if (null != poolVolErr[iCnt]) {
                if (poolVolErr[iCnt].getLErrorCode() == 0L) continue;
                if (this.iPoolVolTopErr == 0) {
                    this.iPoolVolTopErr = 106061;
                }
                SJctrPoolError ldevIndexErr = new SJctrPoolError(30, 5, (int)poolVolErr[iCnt].getLErrorCode());
                SJmoLdevIndex ldIdx = new SJmoLdevIndex();
                ldIdx.setLdevIndex(poolVolErr[iCnt].getSLDKC(), poolVolErr[iCnt].getSCU(), poolVolErr[iCnt].getSLDEV());
                ldevIndexErr.setkeyData(ldIdx);
                ldevIndexErr.setStrAssignTableKey("COM_TABLE");
                poolVolErrList.add(ldevIndexErr);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolVolError", "The array element is null.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return poolVolErrList;
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    private void setDepletionThreshold(AddPoolData3 applyData, SJmoPoolDetail srcData) {
        short sSetDepletionThreshold = 0;
        if (srcData.getSPoolThresholdMode() == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON) {
            sSetDepletionThreshold = srcData.getSPoolDepletionThreshold();
        }
        applyData.setSPoolDepletionThreshold(sSetDepletionThreshold);
    }
}

