/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs.selectsecondaryvols;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrSelectionObjectComboDataModel
extends SJctrComboBoxDataModel {
    private static final String KEY_FIBRE = "COM_FIBRE";
    private static final String KEY_ISCSI = "COM_ISCSI";
    private static final String KEY_HNAS_USER = "COM_HNAS_USER";
    private HashMap<String, Object> ITEM_FIBRE = null;
    private HashMap<String, Object> ITEM_ISCSI = null;
    private HashMap<String, Object> ITEM_NAS = null;
    private Map<Short, Set<Short>> portHGMap_Fibre = Collections.emptyMap();
    private Map<Short, Set<Short>> portHGMap_iSCSI = Collections.emptyMap();
    private Map<Short, Set<Short>> portHGMap_NAS = Collections.emptyMap();
    private List<SJmoPortDetail> portDtlList = Collections.emptyList();
    private SJctrItemSelectListener itemSelectListener = null;

    public SJctrSelectionObjectComboDataModel() {
        this.initListener();
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.ITEM_FIBRE = this.createItem(KEY_FIBRE, util.getGuidance("FIBRE"));
        this.ITEM_ISCSI = this.createItem(KEY_ISCSI, util.getGuidance("ISCSI"));
        this.ITEM_NAS = this.createItem(KEY_HNAS_USER, util.getGuidance("HNAS_USER_LU"));
        super.initGuidance(util);
    }

    public void initListener() {
        if (this.itemSelectListener != null) {
            return;
        }
        this.itemSelectListener = new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrSelectionObjectComboDataModel.this.fireMessageEvent(CHGSELOBJ_MSG.CHG_SELOBJ);
                }
            }
        };
        this.addItemSelectListener(this.itemSelectListener);
    }

    public void initSelectionObject(List<SJmoPortDetail> portDtlList, Map<Short, Set<Short>> portHGMap) {
        this.portDtlList = portDtlList;
        this.refSelectionObject(portHGMap);
    }

    public void refSelectionObject(Map<Short, Set<Short>> portHGMap) {
        if (portHGMap == null || portHGMap.isEmpty()) {
            return;
        }
        this.portHGMap_Fibre = new HashMap<Short, Set<Short>>(portHGMap.size());
        this.portHGMap_iSCSI = new HashMap<Short, Set<Short>>(portHGMap.size());
        this.portHGMap_NAS = new HashMap<Short, Set<Short>>(portHGMap.size());
        SJmoPortIndex searchPort = new SJmoPortIndex();
        for (Short portId : portHGMap.keySet()) {
            searchPort.setSPort(portId);
            Set<Short> hgSet = portHGMap.get(portId);
            int index = Collections.binarySearch(this.portDtlList, searchPort);
            if (index < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "refSelectionObject", "SJmoPortDetail Not Found. PortID : " + portId);
                continue;
            }
            SJmoPortDetail portDtl = this.portDtlList.get(index);
            if (SJctrPortUtility.isFibrePort(portDtl) || SJctrPortUtility.isFcoePort(portDtl)) {
                this.portHGMap_Fibre.put(portId, hgSet);
            }
            if (SJctrPortUtility.isIscsiPort(portDtl)) {
                this.portHGMap_iSCSI.put(portId, hgSet);
            }
            if (portDtl.getByPortKindNo() != 7) continue;
            this.portHGMap_NAS.put(portId, hgSet);
        }
        this.clearSelection();
        this.removeAllItems();
        if (!this.portHGMap_Fibre.isEmpty()) {
            this.addItem(this.ITEM_FIBRE);
        }
        if (!this.portHGMap_iSCSI.isEmpty()) {
            this.addItem(this.ITEM_ISCSI);
        }
        if (!this.portHGMap_NAS.isEmpty()) {
            this.addItem(this.ITEM_NAS);
        }
        this.setSelectedIndex(0);
    }

    public Map<Short, Set<Short>> getPortHGMap() {
        Map<Short, Set<Short>> ret = Collections.emptyMap();
        String selection = this.getSelection();
        if (selection != null) {
            if (selection.equals(KEY_FIBRE)) {
                ret = this.portHGMap_Fibre;
            } else if (selection.equals(KEY_ISCSI)) {
                ret = this.portHGMap_iSCSI;
            } else if (selection.equals(KEY_HNAS_USER)) {
                ret = this.portHGMap_NAS;
            }
        }
        return ret;
    }

    public static enum CHGSELOBJ_MSG implements SJctrNotifyState
    {
        CHG_SELOBJ;

    }
}

