/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.deletepairs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.local.deletepairs.SJctrDeletePairsAC;
import sanproject.sn2.controller.wizard.replication.local.deletepairs.SJctrDeletePairsConfirmDC;
import sanproject.sn2.controller.wizard.replication.local.deletepairs.SJctrDeletePairsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrDeletePairsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "DELETE_PAIR";
    protected static final Class<?> CONFIRM_DC = SJctrDeletePairsConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrDeletePairsAC applyCntl = new SJctrDeletePairsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoLocalReplicationPairVolInfo> inheritedList = dc.getProxy().getCache("KEY_SELECTED_SVOL");
            if (null == inheritedList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(209, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == inheritedList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(209, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrReplicationUtility.chkCacheLReplicaDetailData(dc);
            SJmoLocalReplicationPairVolInfoMgr allPairVolInfo = SJctrReplicationUtility.getSJmoLocalReplicationPairVolInfoMgr(dc);
            List<SJmoLocalReplicationPairVolInfo> pairVolInfo = this.checkModelData(inheritedList, allPairVolInfo, dc);
            int copytype = this.checkCopyTypeForLocalPairVol(pairVolInfo, dc);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(dc);
            if (copytype == 0) {
                SJctrReplicationUtility.checkSimfPairMixFiconAndNormal(pairVolInfo, ldevDetailList);
            }
            this.checkPairStatusAndAbleDelete(pairVolInfo, allPairVolInfo, copytype, dc);
            SJctrDeletePairsConfirmData confirmData = new SJctrDeletePairsConfirmData();
            ArrayList<SJctrDeletePairsConfirmData> confirmDataList = new ArrayList<SJctrDeletePairsConfirmData>();
            confirmData.setPairsInfo(pairVolInfo);
            confirmData.setCopyType((short)copytype);
            confirmData.setNeedData(dc);
            confirmData.setTiPairDeleteWarning(this.getTiPairDeleteWarning());
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrDeletePairsConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(exp, 107002);
        }
    }

    public List<SJmoLocalReplicationPairVolInfo> checkModelData(List<SJmoLocalReplicationPairVolInfo> inheritedList, SJmoLocalReplicationPairVolInfoMgr manager, SJctrWizardWindowDC dc) {
        return SJctrReplicationUtility.checkAndGetExistPairVolInfo(inheritedList, manager);
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetLocalReplicationPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotSetInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    protected int checkCopyTypeForLocalPairVol(List<SJmoLocalReplicationPairVolInfo> pairExist, SJctrWizardWindowDC dc) {
        if (null == pairExist) {
            dc.getLogUty().putlog("checkCopyTypeForLocalPairVol", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        int copytype = SJctrReplicationUtility.checkCopyTypeForLocalPairVolList(pairExist);
        if (-1 == copytype) {
            dc.getLogUty().putlog("checkCopyTypeForLocalPairVol", "Selected pair is mix.");
            SJctrError err = new SJctrError(209, 22, 106114);
            SJcException exp = err.createException();
            throw exp;
        }
        return copytype;
    }

    protected void checkPairStatusAndAbleDelete(List<SJmoLocalReplicationPairVolInfo> pairExist, SJmoLocalReplicationPairVolInfoMgr allPairVolInfo, int copytype, SJctrWizardWindowDC dc) {
        if (null == pairExist || null == allPairVolInfo) {
            dc.getLogUty().putlog("checkPairStatus", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrReplicationUtility.checkLocalPairVolStatus(pairExist, allPairVolInfo, SJctrReplicationDataMacro.DELETE_PAIR_STATUS_PASS, copytype);
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    public boolean getTiPairDeleteWarning() {
        return false;
    }

    public void setTiPairDeleteWarning(boolean tiPairDelWarn) {
    }
}

