/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.viewpairproperties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrPairPropertiesSummaryModel
extends SJctrSimpleDataModel {
    private final String KEY_COPY_TYPE = "COM_COPY_TYPE";
    private final String KEY_POOL_NAME = "COM_POOL_NAME";
    private final String KEY_MST_SS_DATE = "COM_MST_SS_DATE";
    private final String KEY_LDEVID_P = "COM_PVOL_LDEVID";
    private final String KEY_LDEVNAME_P = "COM_PVOL_LDEVNAME";
    private final String KEY_LDEVID_S = "COM_SVOL_LDEVID";
    private final String KEY_LDEVNAME_S = "COM_SVOL_LDEVNAME";
    private final String KEY_MU = "COM_MU";
    private final String KEY_V_STR_SYS_P = "COM_PVOL_V_STORAGE_SYSTEM";
    private final String KEY_V_LDEVID_P = "COM_PVOL_V_LDEV_ID";
    private final String KEY_V_STR_SYS_S = "COM_SVOL_V_STORAGE_SYSTEM";
    private final String KEY_V_LDEVID_S = "COM_SVOL_V_LDEV_ID";
    private final String KEY_POOL_ENCRYPTION = "COM_POOL_ENCRYPTION";
    private SJmoLocalReplicationPairVolInfoMgr pairVolMgr = null;
    private List<SJmoLdevDetail> ldevDtlList = null;
    private List<SJmoLdevLuseInfo> luseList = null;
    private List<SJmoLdevNicknameInfo> ldevNameList = null;
    private List<SJmoPoolNameInfo> poolNameList = null;
    private List<SJmoHUVMVirtualDkc> vDkcList = null;
    private List<SJmoHUVMVirtualLdev> vLdevList = null;
    private List<SJmoPoolDetail> poolDtlList = null;
    private final String UNIT_PAR = "%";

    public void makeSummary(SJmoLocalReplicationPairVolInfo pairInfo, SJmoLocalReplicationPairVolInfo mostRecentSSPair) {
        SJctrLdevUtility ldevUtil = this.getComUtility().getLdevUtility();
        SJctrComCVSUtility cvsUtili = this.getComUtility().getCVSUtility();
        SJctrRsgUtility rsgUtil = this.getComUtility().getRsgUtility();
        SJctrReplicationUtility replicaUtil = this.getComUtility().getReplicationUtility();
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        SJmoLdevDetail ldevDtl_P = this.getLdevDetail(pairInfo.getPVolIndex());
        SJmoLocalReplicationPairVolInfo pVolPairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(pairInfo.getPVolIndex());
        String strCPType = this.getCopyTypeString(pairInfo);
        String strPoolName = this.getPoolNameDisplay(pairInfo, replicaUtil);
        String strMST_SSDate = "-";
        if (mostRecentSSPair != null) {
            strMST_SSDate = replicaUtil.getSnapshotDateString(mostRecentSSPair);
        }
        String strLdevID_P = ldevUtil.toLdevDisplay(ldevDtl_P);
        String strLdevName_P = this.getLdevNameDisplay(ldevDtl_P);
        short mu = pairInfo.getSMuNum();
        String strMu = SJctrComUtility.toDecString(mu);
        SJmoHUVMVirtualLdev vLdevDtl_P = this.getVLdevDetail(pairInfo.getPVolIndex());
        String strVSS_P = this.getVitualStorageSystemDisplay(vLdevDtl_P, rsgUtil);
        String strVitualLdevID_P = rsgUtil.toDispStringVssLdevID(vLdevDtl_P, ldevUtil);
        String strLdevID_S = "";
        String strLdevName_S = "";
        String strVSS_S = "";
        String strVitualLdevID_S = "";
        if (!SJctrCreatePairUtility.isInvalidIndex(pairInfo)) {
            SJmoLdevDetail ldevDtl_S = this.getLdevDetail(pairInfo);
            strLdevID_S = ldevUtil.toLdevDisplay(ldevDtl_S);
            strLdevName_S = this.getLdevNameDisplay(ldevDtl_S);
            SJmoHUVMVirtualLdev vLdevDtl_S = this.getVLdevDetail(pairInfo);
            strVSS_S = this.getVitualStorageSystemDisplay(vLdevDtl_S, rsgUtil);
            strVitualLdevID_S = rsgUtil.toDispStringVssLdevID(vLdevDtl_S, ldevUtil);
        }
        String strPoolEncryption = this.getPoolEncryptionDisplay(pairInfo, poolUtil);
        Object mgrData = this.getManageData();
        ((SJctrDataObject)mgrData).setData("COM_COPY_TYPE", strCPType);
        ((SJctrDataObject)mgrData).setData("COM_POOL_NAME", strPoolName);
        ((SJctrDataObject)mgrData).setData("COM_MST_SS_DATE", strMST_SSDate);
        ((SJctrDataObject)mgrData).setData("COM_PVOL_LDEVID", strLdevID_P);
        ((SJctrDataObject)mgrData).setData("COM_PVOL_LDEVNAME", strLdevName_P);
        ((SJctrDataObject)mgrData).setData("COM_SVOL_LDEVID", strLdevID_S);
        ((SJctrDataObject)mgrData).setData("COM_SVOL_LDEVNAME", strLdevName_S);
        ((SJctrDataObject)mgrData).setData("COM_MU", strMu);
        ((SJctrDataObject)mgrData).setData("COM_PVOL_V_STORAGE_SYSTEM", strVSS_P);
        ((SJctrDataObject)mgrData).setData("COM_PVOL_V_LDEV_ID", strVitualLdevID_P);
        ((SJctrDataObject)mgrData).setData("COM_SVOL_V_STORAGE_SYSTEM", strVSS_S);
        ((SJctrDataObject)mgrData).setData("COM_SVOL_V_LDEV_ID", strVitualLdevID_S);
        ((SJctrDataObject)mgrData).setData("COM_POOL_ENCRYPTION", strPoolEncryption);
        this.setDirty();
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        List<SJmoGetLocalReplicationPairVolInfoMgr> pairVolMgrList = this.getBasicDataList(SJmoGetLocalReplicationPairVolInfoMgr.class);
        if (pairVolMgrList == null) {
            this.getLogUty().putlog("makeDataModel", "pairVolMgrList not found");
            this.pairVolMgr = new SJmoLocalReplicationPairVolInfoMgr(new SJmoLocalReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC]);
        } else {
            this.pairVolMgr = (SJmoLocalReplicationPairVolInfoMgr)((Object)pairVolMgrList.get(0));
        }
        this.ldevDtlList = this.getBasicDataList(SJmoGetLdevDetail.class);
        if (this.ldevDtlList == null) {
            this.getLogUty().putlog("makeDataModel", "ldevDtlList not found");
            this.ldevDtlList = new ArrayList<SJmoLdevDetail>();
        }
        this.luseList = this.getBasicDataList(SJmoGetLdevLuseInfo.class);
        if (this.luseList == null) {
            this.getLogUty().putlog("makeDataModel", "luseList not found");
            this.luseList = new ArrayList<SJmoLdevLuseInfo>();
        }
        this.ldevNameList = this.getBasicDataList(SJmoGetLdevNicknameInfo.class);
        if (this.ldevNameList == null) {
            this.getLogUty().putlog("makeDataModel", "ldevNameList not found");
            this.ldevNameList = new ArrayList<SJmoLdevNicknameInfo>();
        }
        this.poolNameList = this.getBasicDataList(SJmoGetPoolNameInfo.class);
        if (this.poolNameList == null) {
            this.getLogUty().putlog("makeDataModel", "poolNameList not found");
            this.poolNameList = new ArrayList<SJmoPoolNameInfo>();
        }
        this.poolDtlList = this.getBasicDataList(SJmoGetPoolDetail.class);
        if (this.poolDtlList == null) {
            this.getLogUty().putlog("makeDataModel", "poolDtlList not found");
            this.poolDtlList = new ArrayList<SJmoPoolDetail>();
        }
        this.vDkcList = this.getBasicDataList(SJmoGetHUVMVirtualDkc.class);
        if (this.vDkcList == null) {
            this.getLogUty().putlog("makeDataModel", "vDkcList not found");
            this.vDkcList = new ArrayList<SJmoHUVMVirtualDkc>();
        }
        this.vLdevList = this.getBasicDataList(SJmoGetHUVMVirtualLdev.class);
        if (this.vLdevList == null) {
            this.getLogUty().putlog("makeDataModel", "vLdevList not found");
            this.vLdevList = new ArrayList<SJmoHUVMVirtualLdev>();
        }
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetLocalReplicationPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    private SJmoLdevDetail getLdevDetail(SJmoLdevIndex ldev) {
        SJmoLdevDetail ldevDtl = null;
        int search = Collections.binarySearch(this.ldevDtlList, ldev);
        if (search >= 0) {
            ldevDtl = this.ldevDtlList.get(search);
        }
        return ldevDtl;
    }

    private SJmoHUVMVirtualLdev getVLdevDetail(SJmoLdevIndex ldev) {
        SJmoHUVMVirtualLdev vLdevDtl = null;
        int search = Collections.binarySearch(this.vLdevList, ldev);
        if (search >= 0) {
            vLdevDtl = this.vLdevList.get(search);
        }
        return vLdevDtl;
    }

    private SJmoPoolDetail getPoolDetail(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        SJmoPoolDetail poolDtl = null;
        if (pairVolInfo != null && pairVolInfo.isVolPos(0x800000)) {
            poolDtl = SJctrReplicationUtility.getPoolDetalInfoFromPairVolInfo(pairVolInfo, this.poolDtlList);
        }
        return poolDtl;
    }

    private String getPoolNameDisplay(SJmoLocalReplicationPairVolInfo pairVolInfo, SJctrReplicationUtility replicaUtil) {
        String ret = "?";
        if (pairVolInfo != null) {
            if (pairVolInfo.isVolPos(0x800000)) {
                SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                poolIndex.setPoolId(pairVolInfo.getISVolPoolId());
                int targetPool = Collections.binarySearch(this.poolNameList, poolIndex);
                if (targetPool >= 0) {
                    SJmoPoolNameInfo poolNameInfo = this.poolNameList.get(targetPool);
                    ret = replicaUtil.getPoolNameIdString(pairVolInfo, poolNameInfo);
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    private String getPoolEncryptionDisplay(SJmoLocalReplicationPairVolInfo pairVolInfo, SJctrPoolUtility poolUtil) {
        String ret = "?";
        if (pairVolInfo != null) {
            if (pairVolInfo.isVolPos(0x800000)) {
                SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                poolIndex.setPoolId(pairVolInfo.getISVolPoolId());
                int targetPool = Collections.binarySearch(this.poolDtlList, poolIndex);
                if (targetPool >= 0) {
                    SJmoPoolDetail poolDetailInfo = this.poolDtlList.get(targetPool);
                    ret = poolUtil.getPoolEncryptionString(poolDetailInfo);
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    private String getLdevNameDisplay(SJmoLdevIndex ldev) {
        int search;
        String ret = "?";
        if (ldev != null && (search = Collections.binarySearch(this.ldevNameList, ldev)) >= 0) {
            SJmoLdevNicknameInfo ldevName = this.ldevNameList.get(search);
            ret = ldevName.getStrNickname();
        }
        return ret;
    }

    private String getVitualStorageSystemDisplay(SJmoHUVMVirtualLdev vLdev, SJctrRsgUtility rsgUtil) {
        int search;
        SJmoHUVMVirtualDkc vDkc = null;
        if (vLdev != null && (search = Collections.binarySearch(this.vDkcList, vLdev.getVBoxIndex())) >= 0) {
            vDkc = this.vDkcList.get(search);
        }
        return rsgUtil.toDispStringVssModelSerialNo(vDkc);
    }

    private String getLdevCapacityDisplay(SJmoLdevDetail ldevDtl) {
        String ret = "?";
        if (ldevDtl != null) {
            long lbaSize = -1L;
            if (ldevDtl.getSLUSEEmlCount() == 0) {
                lbaSize = ldevDtl.getLLDEVLBASize();
            } else if (ldevDtl.getSLUSEEmlCount() == 1) {
                lbaSize = ldevDtl.getLLDEVLBASize();
            } else {
                int targetluse = Collections.binarySearch(this.luseList, ldevDtl);
                if (targetluse >= 0) {
                    lbaSize = ldevDtl.getLLDEVLBASize();
                    SJmoLdevLuseInfo luseInfo = this.luseList.get(targetluse);
                    ArrayList ldevList = luseInfo.getAlLUSELdevIndex();
                    for (SJmoLdevIndex ldev : ldevList) {
                        int targetldev = Collections.binarySearch(this.ldevDtlList, ldev);
                        if (targetldev >= 0) {
                            SJmoLdevDetail targetLdevDtl = this.ldevDtlList.get(targetldev);
                            lbaSize += targetLdevDtl.getLLDEVLBASize();
                            continue;
                        }
                        lbaSize = -1L;
                        break;
                    }
                }
            }
            if (lbaSize != -1L) {
                SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
                SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(lbaSize);
                ret = capaUtil.toString(lbaSize, unit);
                ret = ret + unit.toString();
            }
        }
        return ret;
    }

    private String getCopyTypeString(SJmoLocalReplicationPairVolInfo sVolPairInfo) {
        String ret = "?";
        SJctrComUtility comUtil = this.getComUtility();
        if (sVolPairInfo.isVolPos(8)) {
            ret = comUtil.getGuidance("SHADOW_IMG");
        } else if (sVolPairInfo.isVolPos(256)) {
            ret = comUtil.getGuidance("SHADOW_IMG_MF");
        } else if (sVolPairInfo.isVolPos(0x800000)) {
            ret = sVolPairInfo.isExSnapshotInfo(1) ? comUtil.getGuidance("DYNAMIC_SNAPSHOT") : comUtil.getGuidance("QS-VVOL");
        }
        return ret;
    }
}

