/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addquorumdisks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrCuInfoModelSNoComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.remote.addquorumdisks.SJctrAddQuorumAvailableTableModel;
import sanproject.sn2.controller.wizard.replication.remote.addquorumdisks.SJctrAddQuorumDisksConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.addquorumdisks.SJctrAddQuorumDisksSelectedTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetQuorumDiskInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;

public class SJctrAddQuorumDisksDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101501;
    private static final String DISP_TITLE = "ADD_QUORUM_DISKS";
    public static final String KEY_QUORUM_DISK_ID = "COM_QUORUM_DISK_ID";
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_MODEL_SERIAL = "COM_MODEL_SERIAL";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_REMOVE = "COM_REMOVE";
    public static final int SELECT_TOP_INDEX = 0;
    private List<SJmoLdevDetail> availableLdevList = new ArrayList<SJmoLdevDetail>();
    private ArrayList<String> quorumDiskIdItemList = new ArrayList();
    private ArrayList<SJmoRemoteReplicationRCUInfo> modelSNItemList = new ArrayList();

    public SJctrAddQuorumDisksDC() {
        super(0x1101501);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_QUORUM_DISK_ID, new SJctrComboBoxDataModel());
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAddQuorumAvailableTableModel());
        this.addDataObjectModel(KEY_MODEL_SERIAL, new SJctrComboBoxDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAddQuorumDisksDC.this.fireMessageEvent(ADD_QUORUM_MSG.SELECT_ADD);
                }
                SJctrHaUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel(KEY_ADD, addButton);
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrAddQuorumDisksSelectedTableModel());
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAddQuorumDisksDC.this.fireMessageEvent(ADD_QUORUM_MSG.SELECT_REMOVE);
                }
                SJctrHaUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ADD_QUORUM_MSG.SELECT_ADD, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddQuorumDisksDC.this.addAction();
            }
        });
        this.addMessageEventListener(ADD_QUORUM_MSG.SELECT_REMOVE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddQuorumDisksDC.this.removeAction();
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetQuorumDiskInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoQuorumDiskInfo> quorumDiskList = SJctrHaUtility.getSJmoQuorumDiskInfo(this);
            List<SJmoLdevDetail> ldevDetailList = SJctrHaUtility.getSJmoLdevDetailFilteredByAllRsg(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            List<SJmoLdevStatusInfo> ldevStatusList = SJctrHaUtility.getSJmoLdevStatusInfo(this);
            SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrHaUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            List<SJmoRSGgetAllRsgs> rsgList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs rsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, rsgList);
            List<SJmoHUVMVirtualLdev> hUVMVirtualLdev = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
            this.makeQuorumIDList(quorumDiskList);
            if (this.quorumDiskIdItemList.size() == 0) {
                this.logUty.putlog("checkConstructData", "Available quorum id does not exist .");
                throw SJctrHaUtility.createRemoteReplicationException(206152);
            }
            this.makeCmbQuorumDiskID();
            this.makeAvailableLdevList(ldevDetailList, ldevStatusList, hUVMVirtualLdev);
            if (this.availableLdevList.size() == 0) {
                this.logUty.putlog("checkConstructData", "Available ldev does not exist.");
                throw SJctrHaUtility.createRemoteReplicationException(206153);
            }
            SJctrAddQuorumAvailableTableModel AvailableLdevsTable = (SJctrAddQuorumAvailableTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
            AvailableLdevsTable.setBasicDataList(this.availableLdevList);
            this.makeRemoteStorageSystemList(mrcuInfoMgr, rsg);
            if (this.modelSNItemList.size() == 0) {
                this.logUty.putlog("checkConstructData", "Available RCU connection does not exist.");
                throw SJctrHaUtility.createRemoteReplicationException(206154);
            }
            this.makeCmbRemoteStorageSystem();
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrAddQuorumDisksConfirmData confirmData = new SJctrAddQuorumDisksConfirmData();
            SJctrAddQuorumDisksSelectedTableModel selectedQuorumDisksTable = (SJctrAddQuorumDisksSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
            List<Object> rowData = selectedQuorumDisksTable.getAllRowData();
            Collections.sort(rowData);
            confirmData.setQuorumInfo(rowData);
            confirmData.setNeedData(this);
            ArrayList<SJctrAddQuorumDisksConfirmData> confirmDataList = new ArrayList<SJctrAddQuorumDisksConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAddQuorumDisksConfirmData.class, confirmDataList);
            SJctrHaUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void addAction() {
        try {
            SJctrAddQuorumAvailableTableModel availableLDEVsTable = (SJctrAddQuorumAvailableTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
            SJctrAddQuorumDisksSelectedTableModel selectedQuorumDisksTable = (SJctrAddQuorumDisksSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
            SJmoQuorumDiskInfo addQuorumInfo = this.getAddQuorumInfo(availableLDEVsTable, selectedQuorumDisksTable);
            ArrayList<SJmoQuorumDiskInfo> addQuorumList = new ArrayList<SJmoQuorumDiskInfo>();
            addQuorumList.add(addQuorumInfo);
            selectedQuorumDisksTable.addRowDataTop(addQuorumList);
            SJctrComboBoxDataModel quorumDiskId = this.getCmbQuorumDiskId();
            this.quorumDiskIdItemList.remove(quorumDiskId.getSelectedIndex());
            availableLDEVsTable.removeSelectedRowData();
            this.makeCmbQuorumDiskID();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void removeAction() {
        try {
            SJctrAddQuorumAvailableTableModel availableLDEVsTable = (SJctrAddQuorumAvailableTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
            SJctrAddQuorumDisksSelectedTableModel selectedQuorumDisksTable = (SJctrAddQuorumDisksSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
            List<Object> selectedRows = selectedQuorumDisksTable.getSelectedRowData();
            for (Object selectedRow : selectedRows) {
                SJmoQuorumDiskInfo selectedQuorumInfo = (SJmoQuorumDiskInfo)selectedRow;
                String strQuorumDiskID = SJctrComUtility.toHexString(selectedQuorumInfo.getIQuorumDiskID(), 2, true);
                this.quorumDiskIdItemList.add(strQuorumDiskID);
                SJmoLdevIndex ldevIndex = selectedQuorumInfo.getQuorumLdevIndex();
                this.availableLdevList.add((SJmoLdevDetail)ldevIndex);
            }
            Collections.sort(this.availableLdevList);
            availableLDEVsTable.setBasicDataList(this.availableLdevList);
            availableLDEVsTable.doRefresh();
            selectedQuorumDisksTable.removeSelectedRowData();
            this.makeCmbQuorumDiskID();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void makeQuorumIDList(List<SJmoQuorumDiskInfo> quorumDiskList) {
        if (null != quorumDiskList) {
            for (SJmoQuorumDiskInfo quorumInfo : quorumDiskList) {
                int quorumFlg = quorumInfo.getIRegist();
                if (0 != quorumFlg) continue;
                int quorumDiskID = quorumInfo.getIQuorumDiskID();
                String quorumID = SJctrComUtility.toHexString(quorumDiskID, 2, true);
                this.quorumDiskIdItemList.add(quorumID);
            }
        }
    }

    private void makeCmbQuorumDiskID() {
        SJctrComboBoxDataModel cmbQuorumDiskId = this.getCmbQuorumDiskId();
        cmbQuorumDiskId.removeAllItems();
        Collections.sort(this.quorumDiskIdItemList);
        for (String quorumId : this.quorumDiskIdItemList) {
            cmbQuorumDiskId.addItem(quorumId, quorumId);
        }
        cmbQuorumDiskId.setSelectedIndex(0);
    }

    private void makeAvailableLdevList(List<SJmoLdevDetail> ldevDetailList, List<SJmoLdevStatusInfo> ldevStatusList, List<SJmoHUVMVirtualLdev> virtualLdev) {
        Collections.sort(ldevStatusList);
        long MIN_LDEV_VOL_LBA_SIZE = 25174016L;
        long MAX_LDEV_VOL_LBA_SIZE = 0x200000000L;
        for (SJmoLdevDetail ldev : ldevDetailList) {
            int ldevStatusIndex = Collections.binarySearch(ldevStatusList, ldev);
            if (ldevStatusIndex >= 0 && !SJctrCreatePairUtility.checkCreatePiarUsableStatus(ldevStatusList.get(ldevStatusIndex)) || ldev.getIEmulationType() != 625 || SJctrLdevUtility.isAllocateVolume(ldev) || !ldev.getbExternalVolume() || ldev.getbLUPathCmdDev() || ldev.getbRmtComDev() || ldev.getbPoolVol() || ldev.getbQsVvol() || ldev.getBLockVolume() || this.checkHUVMVol(ldev, virtualLdev) || ldev.getLLDEVLBASize() < 25174016L || ldev.getBPoolOnlyLDEV()) continue;
            this.availableLdevList.add(ldev);
        }
    }

    private boolean checkHUVMVol(SJmoLdevDetail ldev, List<SJmoHUVMVirtualLdev> virtualLdevList) {
        boolean hUVMFlg = false;
        int index = Collections.binarySearch(virtualLdevList, ldev);
        if (index >= 0) {
            SJmoHUVMVirtualLdev virtualLdev = virtualLdevList.get(index);
            if (!virtualLdev.isValidIndexVirtualLdev()) {
                hUVMFlg = true;
                return hUVMFlg;
            }
            if (SJctrHaUtility.isHuvmReserve(virtualLdev)) {
                hUVMFlg = true;
            }
        }
        return hUVMFlg;
    }

    private void makeRemoteStorageSystemList(SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr, SJmoRSGgetAllRsgs rsgInfo) {
        HashMap<String, SJmoRemoteReplicationRCUInfo> mapRcuInfo = new HashMap<String, SJmoRemoteReplicationRCUInfo>();
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), rsgInfo);
        SJmoRemoteReplicationMRCUInfo mrcuFreeInfo = mrcuInfoMgr.getMRCUFreeInfo();
        if (mrcuFreeInfo != null && rsgUtil != null) {
            List<SJmoRemoteReplicationRCUInfo> rcuInfoList = mrcuFreeInfo.getTrueCopyRCUInfoList();
            rcuInfoList = SJctrHaUtility.removeNoResourceRCUInfo(rcuInfoList, rsgUtil);
            for (SJmoRemoteReplicationRCUInfo sJmoRemoteReplicationRCUInfo : rcuInfoList) {
                if (sJmoRemoteReplicationRCUInfo.getIControllerID() <= 6 || sJmoRemoteReplicationRCUInfo.getIControllerID() == 19) continue;
                mapRcuInfo.put(String.valueOf(sJmoRemoteReplicationRCUInfo.getIControllerID()) + sJmoRemoteReplicationRCUInfo.getStrSN(), sJmoRemoteReplicationRCUInfo);
            }
            for (Map.Entry entry : mapRcuInfo.entrySet()) {
                this.modelSNItemList.add((SJmoRemoteReplicationRCUInfo)entry.getValue());
            }
        }
    }

    private void makeCmbRemoteStorageSystem() {
        SJctrHaUtility remoteUty = this.getComUtility().getHaUtility();
        SJctrComboBoxDataModel comboObj = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_MODEL_SERIAL);
        Collections.sort(this.modelSNItemList, new SJctrCuInfoModelSNoComparator());
        for (SJmoRemoteReplicationRCUInfo rcuInfo : this.modelSNItemList) {
            String modelSnStr = remoteUty.getModelSNoString(rcuInfo);
            comboObj.addItem(modelSnStr, modelSnStr);
        }
        comboObj.setSelectedIndex(0);
    }

    private SJmoQuorumDiskInfo getAddQuorumInfo(SJctrAddQuorumAvailableTableModel availableLDEVsTable, SJctrAddQuorumDisksSelectedTableModel selectedLDEVsTable) {
        SJmoQuorumDiskInfo addQuorumInfo = new SJmoQuorumDiskInfo();
        try {
            addQuorumInfo.setIQuorumDiskID((short)Integer.parseInt(this.getCmbQuorumDiskId().getSelection(), 16));
        }
        catch (Exception e) {
            throw SJctrHaUtility.createRemoteReplicationException(107004);
        }
        List<Object> selectedLdevs = availableLDEVsTable.getSelectedRowData();
        SJmoLdevIndex index = (SJmoLdevIndex)selectedLdevs.get(0);
        addQuorumInfo.setQuorumLdevIndex(index);
        this.availableLdevList.remove(index);
        int modelSNIndex = this.getCmbModelSN().getSelectedIndex();
        addQuorumInfo.setICtrlID(this.modelSNItemList.get(modelSNIndex).getIControllerID());
        addQuorumInfo.setStrSN(this.modelSNItemList.get(modelSNIndex).getStrSN());
        return addQuorumInfo;
    }

    private SJctrComboBoxDataModel getCmbQuorumDiskId() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_QUORUM_DISK_ID);
    }

    private SJctrComboBoxDataModel getCmbModelSN() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_MODEL_SERIAL);
    }

    public static enum ADD_QUORUM_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

