/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.assignjournalvols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrLDEVDetailWithJnlInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.assignjournalvols.SJctrAssignJournalVolsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.assignjournalvols.SJctrAssignJournalVolsSelTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.assignjournalvols.SJctrAssignJournalVolsTableDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotVvolRelation;
import sanproject.sn2.model.connector.kind.SJmoGetThinProvisioningVolumesStatus;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;

public class SJctrAssignJournalVolsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831217;
    private static final String DISP_TITLE = "ASSIGN_JNL_VOLUMES";
    private static final String KEY_TABLE_UNASSIGNED_JNL_VOL = "COM_TABLE_UNASSIGNED_JNL_VOL";
    private static final String KEY_TABLE_ASSIGNED_JNL_VOL = "COM_TABLE_ASSIGNED_JNL_VOL";
    private static final String KEY_ASSIGN_JNL_INIT = "COM_ASSIGN_JNL_INIT";
    private static final String KEY_VC_IF = "COM_VC_IF";
    private static final String KEY_REPLACE_LDEV = "COM_REPLACE_LDEV";
    private static final int REPLACE_ALL_LDEV = 1;
    private static final int REPLACE_PART_LDEV = 0;
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";

    public SJctrAssignJournalVolsDC() {
        super(17831217);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHDPRelation();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotVvolRelation();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetThinProvisioningVolumesStatus();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_UNASSIGNED_JNL_VOL, new SJctrAssignJournalVolsTableDataModel());
        this.addDataObjectModel(KEY_TABLE_ASSIGNED_JNL_VOL, new SJctrAssignJournalVolsSelTableDataModel());
        this.addDataObjectModel(KEY_VC_IF, new SJctrSimpleDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAssignJournalVolsDC.this.fireMessageEvent(ASSIGN_JNL_VOLS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAssignJournalVolsDC.this.fireMessageEvent(ASSIGN_JNL_VOLS_MSG.SELECT_REMOVE);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ASSIGN_JNL_VOLS_MSG.SELECT_ADD, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAssignJournalVolsDC.this.pushAddAction(event, dstModel);
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(ASSIGN_JNL_VOLS_MSG.SELECT_REMOVE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAssignJournalVolsDC.this.pushRemoveAction(event, dstModel);
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_JOURNAL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (null == viewDataList.get(0)) {
            this.logUty.putlog("checkStartData", "The first Data of Inherited list is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        try {
            SJmoUniversalReplicatorJnlGrpMgr jnlGrpMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            List<SJmoUniversalReplicatorJnlGrp> viewData = this.getProxy().getCache("KEY_SELECTED_JOURNAL");
            List<SJmoUniversalReplicatorJnlGrp> jnlGrpList = SJctrRemoteReplicationUtility.checkAndGetExistJournalInfo(viewData, jnlGrpMgr);
            SJmoUniversalReplicatorJnlGrp jnlGrp = jnlGrpList.get(0);
            ArrayList<SJmoLdevIndex> jnlVolList = jnlGrp.getJnlVols();
            if (jnlVolList.size() == 0) {
                this.logUty.putlog("checkConstructData", "There is no journal volume.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
            }
            List<SJmoRSGgetAllRsgs> allRsgs = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(this.getOwner(), allRsgs.get(0));
            List<SJmoLdevIndex> extractList = rsgUty.extractLdev(jnlVolList);
            if (extractList.size() != jnlVolList.size()) {
                this.logUty.putlog("checkConstructData", "There is no RSG of the journal volume.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206052);
            }
            ArrayList<SJmoLdevDetail> assignedJnlVol = new ArrayList<SJmoLdevDetail>();
            List<SJmoLdevDetail> ldevDetails = SJctrReplicationUtility.getSJmoLdevDetail(this);
            for (SJmoLdevIndex ldevIndex : jnlVolList) {
                int index = Collections.binarySearch(ldevDetails, ldevIndex);
                if (0 <= index) {
                    SJmoLdevDetail ldevDetail = ldevDetails.get(index);
                    assignedJnlVol.add(ldevDetail);
                    continue;
                }
                this.logUty.putlog("checkConstructData", "There is no SJmoLdevDetail of the journal volume.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206505);
            }
            SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
            SJctrReplicationUtility.getSJmoLdevLuseInfo(this);
            List<SJmoHDPRelation> hdpRelationList = SJctrRemoteReplicationUtility.getSJmoHDPRelation(this);
            SJctrReplicationUtility.getSJmoPoolNameInfo(this);
            SJctrRemoteReplicationUtility.getSJmoSnapshotVvolRelation(this);
            SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            List<SJmoHUVMVirtualLdev> vLdevList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
            List<SJmoThinProvisioningVolumesStatus> dpVolStatusList = SJctrRemoteReplicationUtility.getSJmoThinProvisioningVolumesStatus(this);
            SJmoLdevDetail firstLdev = (SJmoLdevDetail)assignedJnlVol.get(0);
            short sClpr = firstLdev.getSCLPR();
            int iRsgId = rsgUty.getRsgId(firstLdev);
            ArrayList<SJmoLdevDetail> unassignedJnlVol = new ArrayList<SJmoLdevDetail>();
            SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
            List<SJmoLdevDetail> permittedLdevDetailList = SJctrRemoteReplicationUtility.getSJmoLdevDetailFilteredByAllRsg(this);
            List<SJmoLdevStatusInfo> ldevStatusList = SJctrRemoteReplicationUtility.getSJmoLdevStatusInfo(this);
            for (SJmoLdevDetail ldevDetail : permittedLdevDetailList) {
                if (rsgUty.getRsgId(ldevDetail) != iRsgId || SJctrRemoteReplicationUtility.isUrVol(urPairVolInfoMgr, ldevDetail) || !SJctrRemoteReplicationUtility.isJournalVolTarget(ldevDetail, ldevStatusList, vLdevList, hdpRelationList, dpVolStatusList) || ldevDetail.getSCLPR() != sClpr) continue;
                unassignedJnlVol.add(ldevDetail);
            }
            boolean addable = SJctrRemoteReplicationUtility.checkAvailableFunction(jnlGrp, SJctrRemoteReplicationDataMacro.FUNC_ASSIGN_JNL_VOLS_ADD);
            boolean removable = SJctrRemoteReplicationUtility.checkAvailableFunction(jnlGrp, SJctrRemoteReplicationDataMacro.FUNC_ASSIGN_JNL_VOLS_REMOVE);
            SJctrAssignJournalVolsSelTableDataModel assignedTable = (SJctrAssignJournalVolsSelTableDataModel)this.getDataObjectModel(KEY_TABLE_ASSIGNED_JNL_VOL);
            if (assignedJnlVol.size() == 2 && !removable) {
                this.logUty.putlog("checkConstructData", "Can't add and remove volumes.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206049);
            }
            if (!addable && !removable) {
                this.logUty.putlog("checkConstructData", "Can't add and remove volumes.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206049);
            }
            if (unassignedJnlVol.size() == 0 && !removable) {
                this.logUty.putlog("checkConstructData", "Can't remove and no volume to add.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206051);
            }
            if (!addable && assignedJnlVol.size() == 1) {
                this.logUty.putlog("checkConstructData", "Can't add and remove volumes.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206049);
            }
            if (unassignedJnlVol.size() == 0 && assignedJnlVol.size() == 1) {
                this.logUty.putlog("checkConstructData", "Can't remove and no volume to add.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206051);
            }
            Collections.sort(unassignedJnlVol);
            Collections.sort(assignedJnlVol);
            SJctrAssignJournalVolsTableDataModel unassignedTable = (SJctrAssignJournalVolsTableDataModel)this.getDataObjectModel(KEY_TABLE_UNASSIGNED_JNL_VOL);
            unassignedTable.setBasicDataList(unassignedJnlVol);
            assignedTable.setBasicDataList(assignedJnlVol);
            HashSet<SJmoLdevIndex> removableLdevSet = new HashSet<SJmoLdevIndex>(unassignedJnlVol);
            if (removable) {
                removableLdevSet.addAll(assignedJnlVol);
            }
            assignedTable.setRemovableLdev(removableLdevSet);
            this.putCache(KEY_ASSIGN_JNL_INIT, assignedJnlVol);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return ret;
    }

    @Override
    public boolean checkEndData() {
        SJctrAssignJournalVolsConfirmData confirmData = new SJctrAssignJournalVolsConfirmData();
        List<SJmoLdevDetail> initAssignedTableData = this.getCache(KEY_ASSIGN_JNL_INIT);
        SJctrAssignJournalVolsSelTableDataModel assignedTable = (SJctrAssignJournalVolsSelTableDataModel)this.getDataObjectModel(KEY_TABLE_ASSIGNED_JNL_VOL);
        List<Object> assignedTableData = assignedTable.getAllRowData();
        List<SJmoLdevDetail> setAssignedList = this.getSelJnlVolTableDiff(initAssignedTableData, assignedTableData);
        List<SJmoLdevDetail> setUnassignedList = this.getSelJnlVolTableDiff(assignedTableData, initAssignedTableData);
        if (0 == setAssignedList.size() && 0 == setUnassignedList.size()) {
            this.logUty.putlog("checkEndData", "not edit.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206076);
        }
        Collections.sort(setAssignedList);
        Collections.sort(setUnassignedList);
        ArrayList<SJctrLDEVDetailWithJnlInfo> setAssignedListWithJnlInfo = new ArrayList<SJctrLDEVDetailWithJnlInfo>();
        int typeAssign = assignedTableData.size() - setAssignedList.size();
        for (SJmoLdevDetail ldevDetail : setAssignedList) {
            SJctrLDEVDetailWithJnlInfo ldevDetailWithJnlInfo = new SJctrLDEVDetailWithJnlInfo(ldevDetail, typeAssign);
            setAssignedListWithJnlInfo.add(ldevDetailWithJnlInfo);
            ++typeAssign;
        }
        ArrayList<SJctrLDEVDetailWithJnlInfo> setUnassignedListWithJnlInfo = new ArrayList<SJctrLDEVDetailWithJnlInfo>();
        SJctrLDEVDetailWithJnlInfo ldevDetailWithJnlInfoUn = null;
        for (SJmoLdevDetail ldevDetail : setUnassignedList) {
            int typeUnassign = SJctrRemoteReplicationUtility.getJnlVolType(ldevDetail, initAssignedTableData);
            ldevDetailWithJnlInfoUn = new SJctrLDEVDetailWithJnlInfo(ldevDetail, typeUnassign);
            setUnassignedListWithJnlInfo.add(ldevDetailWithJnlInfoUn);
        }
        confirmData.setNeedData(this);
        SJmoUniversalReplicatorJnlGrp viewData = (SJmoUniversalReplicatorJnlGrp)this.getProxy().getCache("KEY_SELECTED_JOURNAL").get(0);
        ArrayList<SJmoUniversalReplicatorJnlGrp> jnlGrpList = new ArrayList<SJmoUniversalReplicatorJnlGrp>();
        jnlGrpList.add(viewData);
        confirmData.setJnlgInfo(jnlGrpList);
        confirmData.setAddJnlVolInfo(setAssignedListWithJnlInfo);
        confirmData.setRemoveJnlVolInfo(setUnassignedListWithJnlInfo);
        ArrayList<SJctrAssignJournalVolsConfirmData> confirmDataList = new ArrayList<SJctrAssignJournalVolsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrAssignJournalVolsConfirmData.class, confirmDataList);
        SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        return true;
    }

    private List<SJmoLdevDetail> getSelJnlVolTableDiff(List<SJmoLdevDetail> baseTableData, List<SJmoLdevDetail> selTableData) {
        ArrayList<SJmoLdevDetail> editedList = new ArrayList<SJmoLdevDetail>();
        for (SJmoLdevDetail ldevDtail : selTableData) {
            if (baseTableData.contains(ldevDtail)) continue;
            editedList.add(ldevDtail);
        }
        return editedList;
    }

    private void setReplacedLdev() {
        boolean ret = false;
        List<SJmoLdevDetail> beforeTableData = this.getCache(KEY_ASSIGN_JNL_INIT);
        SJctrAssignJournalVolsSelTableDataModel assignedTable = (SJctrAssignJournalVolsSelTableDataModel)this.getDataObjectModel(KEY_TABLE_ASSIGNED_JNL_VOL);
        List<Object> afterTableData = assignedTable.getAllRowData();
        List<SJmoLdevDetail> ldevDiffList = this.getSelJnlVolTableDiff(beforeTableData, afterTableData);
        SJctrSimpleDataModel vcIf = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_VC_IF);
        if (afterTableData.size() == ldevDiffList.size()) {
            ((SJctrDataObject)vcIf.getManageData()).setData(KEY_REPLACE_LDEV, 1);
        } else {
            ((SJctrDataObject)vcIf.getManageData()).setData(KEY_REPLACE_LDEV, 0);
        }
    }

    private void pushAddAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrAssignJournalVolsTableDataModel unassignedTable = (SJctrAssignJournalVolsTableDataModel)this.getDataObjectModel(KEY_TABLE_UNASSIGNED_JNL_VOL);
        List<Object> selectedRows = unassignedTable.getSelectedRowData();
        if (selectedRows.size() == 0) {
            this.logUty.putlog("pushAddAction", "not selected");
            return;
        }
        SJctrAssignJournalVolsSelTableDataModel assignedTable = (SJctrAssignJournalVolsSelTableDataModel)this.getDataObjectModel(KEY_TABLE_ASSIGNED_JNL_VOL);
        if (assignedTable.getAllRowData().size() + unassignedTable.getSelectedRowCount() > 2) {
            this.logUty.putlog("pushAddAction", "Journal exceeds the maximum value.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206077);
        }
        assignedTable.addRowDataTop(unassignedTable.removeSelectedRowData());
        this.setReplacedLdev();
        this.updateFooter();
        this.setDirtyAll();
    }

    private void pushRemoveAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrAssignJournalVolsSelTableDataModel assignedTable = (SJctrAssignJournalVolsSelTableDataModel)this.getDataObjectModel(KEY_TABLE_ASSIGNED_JNL_VOL);
        List<Object> selectedRows = assignedTable.getSelectedRowData();
        if (selectedRows.size() == 0) {
            this.logUty.putlog("pushRemoveAction", "not selected");
            return;
        }
        SJctrAssignJournalVolsTableDataModel unassignedTable = (SJctrAssignJournalVolsTableDataModel)this.getDataObjectModel(KEY_TABLE_UNASSIGNED_JNL_VOL);
        for (Object selectedRow : selectedRows) {
            SJmoLdevDetail selectedLdev = (SJmoLdevDetail)selectedRow;
            if (assignedTable.getRemovableLdev().contains(selectedLdev)) continue;
            this.logUty.putlog("pushRemoveAction", "Ldev can not remove.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206075);
        }
        unassignedTable.addRowDataTop(assignedTable.removeSelectedRowData());
        this.setReplacedLdev();
        this.updateFooter();
        this.setDirtyAll();
    }

    public static enum ASSIGN_JNL_VOLS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

