/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createpairs;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.comparator.SJctrHostGroupNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.remote.changesettings.SJctrChangeTcSettingsDC;
import sanproject.sn2.controller.wizard.replication.remote.changesettings.SJctrChangeTcmfSettingsDC;
import sanproject.sn2.controller.wizard.replication.remote.changesettings.SJctrChangeUrSettingsDC;
import sanproject.sn2.controller.wizard.replication.remote.changesettings.SJctrChangeUrmfSettingsDC;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrCreatePairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrCreateRemotePairConst;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrCreateRemotePairUtility;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrJnlMirrorInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrBaseSecondaryVolumeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrGetUniversalReplicatorPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrLuSelectionDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrMirrorSelectionDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrRemoteStorageSystemDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrSelectionTypeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreatePairsAvailableTableModelLdev;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreatePairsAvailableTableModelLun;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateTcPairsSelectedTableModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateTrueCopyPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateUniversalReplicatorPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateUrPairsSelectedTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.util.SJmoChaUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrCreatePairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1005101;
    private static final int DIGIT_CU = 2;
    private static final int DIGIT_MODEL_SERIAL = 9;
    private static final int DIGIT_SERIAL_5 = 5;
    private static final int DIGIT_SERIAL_6 = 6;
    private static final int DIGIT_CU_SSID = 9;
    private static final int DIGIT_SSID = 4;
    private static final String KEY_HG_TG_PULLDOWN_TITLE = "COM_HG_TG_PULLDOWN_TITLE";
    private int copyType = -1;
    private String guidanceKey = "";
    private TreeMap<String, TreeSet<Integer>> cuFreeMrcuInfoMap = new TreeMap();
    private TreeMap<Integer, TreeMap<String, TreeSet<String>>> limitedCuMrcuInfoMap = new TreeMap();
    private TreeSet<Integer> availableCuList = new TreeSet();
    private Map<Integer, List<SJmoPortLunInfo>> availablePortLun = null;
    private Map<Integer, List<? extends SJmoPortIndex>> availablePortHg = null;
    private Map<Integer, List<SJmoLdevDetail>> availableLdevsBasicDataListMap = new HashMap<Integer, List<SJmoLdevDetail>>();
    private Map<Integer, List<SJmoLdevDetail>> availableLdevsInitialBasicDataListMap = new HashMap<Integer, List<SJmoLdevDetail>>();
    private List<SJmoTrueCopyPairVolInfo> currentTcPairVolInfoList = null;
    private List<SJmoUniversalReplicatorPairVolInfo> currentUrPairVolInfoList = null;
    private BitSet[] currentMirrorAttribute = null;
    private SJctrJnlMirrorInfo[][] totalJnlMirrorInfo = null;
    private SJctrJnlMirrorInfo[] totalCtgInfo = null;
    private boolean isInitialized = false;
    private int localModelId = -1;

    public SJctrCreatePairsDC() {
        super(0x1005101);
        this.availablePortLun = new HashMap<Integer, List<SJmoPortLunInfo>>();
        this.availablePortHg = new HashMap<Integer, List<? extends SJmoPortIndex>>();
        this.currentTcPairVolInfoList = new ArrayList<SJmoTrueCopyPairVolInfo>();
        this.currentUrPairVolInfoList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        this.currentMirrorAttribute = new BitSet[256];
        this.totalJnlMirrorInfo = new SJctrJnlMirrorInfo[256][4];
        this.totalCtgInfo = new SJctrJnlMirrorInfo[SJmoDataMacro_IF.NUM_MAX_UR_CTG_ID + 1];
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        List<?> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_REPLICATION");
        this.guidanceKey = (String)viewData.get(0);
        String title = this.getComUtility().getGuidance(this.guidanceKey);
        this.getManageData().setData("COM_REMOTE_TITLE", title);
        return title;
    }

    private void initDataModel() {
        SJctrComboBoxDataModel copyTypeModel = new SJctrComboBoxDataModel();
        copyTypeModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreatePairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_COPY_TYPE);
                }
            }
        });
        this.addDataObjectModel("COM_COPY_TYPE", copyTypeModel);
        SJctrComboBoxDataModel localCuModel = new SJctrComboBoxDataModel();
        localCuModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreatePairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_LOCAL_CU);
                }
            }
        });
        this.addDataObjectModel("COM_LOCAL_CU", localCuModel);
        this.addDataObjectModel("COM_REMOTE_STORAGE", new SJctrRemoteStorageSystemDataModel());
        SJctrRadioButtonGroupDataModel useExistUrPairsRadioButtonModel = new SJctrRadioButtonGroupDataModel();
        useExistUrPairsRadioButtonModel.add("COM_YES");
        useExistUrPairsRadioButtonModel.add("COM_NO");
        useExistUrPairsRadioButtonModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreatePairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_USE_EXSIT_UR_PAIRS);
                }
            }
        });
        this.addDataObjectModel("COM_USE_EXIST_UR_PAIRS", useExistUrPairsRadioButtonModel);
        this.addDataObjectModel("COM_LU_SELECTION", new SJctrLuSelectionDataModel());
        this.addDataObjectModel("COM_TABLE_AVAILABLE_LUN", new SJctrCreatePairsAvailableTableModelLun());
        this.addDataObjectModel("COM_TABLE_AVAILABLE_LDEV", new SJctrCreatePairsAvailableTableModelLdev());
        this.addDataObjectModel("COM_SVOL_SELECTION", new SJctrBaseSecondaryVolumeDataModel());
        this.addDataObjectModel("COM_SELECTION_TYPE", new SJctrSelectionTypeDataModel());
        this.addDataObjectModel("COM_MIRROR_SLECTION", new SJctrMirrorSelectionDataModel());
        this.addDataObjectModel("COM_PVOL_FENCE_LEVEL", new SJctrComboBoxDataModel());
        SJctrComboBoxDataModel ctgIdModel = new SJctrComboBoxDataModel();
        this.addDataObjectModel("COM_CTG_ID", ctgIdModel);
        this.addDataObjectModel("COM_INITIAL_COPY_TYPE", new SJctrComboBoxDataModel());
        this.addDataObjectModel("COM_COPY_PACE_TXT", new SJctrTextBoxDataModel());
        this.addDataObjectModel("COM_COPY_PACE_LIST", new SJctrComboBoxDataModel());
        this.addDataObjectModel("COM_INITIAL_COPY_PRIORITY", new SJctrTextBoxDataModel());
        this.addDataObjectModel("COM_CFW_DATA", new SJctrComboBoxDataModel());
        this.addDataObjectModel("COM_DFW_TO_SVOL", new SJctrComboBoxDataModel());
        this.addDataObjectModel("COM_HIO_TIME_STAMP_TRANS", new SJctrRadioButtonGroupDataModel());
        this.addDataObjectModel("COM_ERROR_LEVEL", new SJctrComboBoxDataModel());
        this.addDataObjectModel("COM_CFW", new SJctrComboBoxDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreatePairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_ADD);
                }
            }
        });
        this.addDataObjectModel("COM_ADD", addButton);
        this.addDataObjectModel("COM_TABLE_SELECTED_TC", new SJctrCreateTcPairsSelectedTableModel());
        this.addDataObjectModel("COM_TABLE_SELECTED_UR", new SJctrCreateUrPairsSelectedTableModel());
        SJctrButtonDataModel changeSettingButton = new SJctrButtonDataModel();
        changeSettingButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreatePairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_CHANGE_SETTINGS);
                }
            }
        });
        this.addDataObjectModel("COM_CHG_SETTING", changeSettingButton);
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreatePairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_REMOVE);
                }
            }
        });
        this.addDataObjectModel("COM_REMOVE", removeButton);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_COPY_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.setEnableEventListner(false);
                SJctrCreatePairsDC.this.copyTypeAction();
                SJctrCreatePairsDC.this.setEnableEventListner(true);
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_LOCAL_CU, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.localCuAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_REMOTE_SYSTEM_MODEL_SN, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.modelSerialNumberAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_REMOTE_SYSTEM_CU_SSID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.cuSsidAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_USE_EXSIT_UR_PAIRS, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.useExistUrPairsAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_SELECTION_OBJECT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.setEnableEventListner(false);
                SJctrCreatePairsDC.this.selectionObjectRadioAction();
                SJctrCreatePairsDC.this.setEnableEventListner(true);
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_LU_SELECTION_PORT_ID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.setEnableEventListner(false);
                SJctrCreatePairsDC.this.localPortIdAction();
                SJctrCreatePairsDC.this.setEnableEventListner(true);
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_LU_SELECTION_HOST_GROUP_NAME, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.localHostGroupNameAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_SVOL_SELECTION_SEL_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.selectionTypeRadioAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_MIRROR_SELECTION_MJNL, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.masterJournalAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_MIRROR_SELECTION_MIRROR, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.masterJournalAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_MIRROR_SELECTION_RJNL, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.restoreJournalAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_ADD, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.addAction();
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_CHANGE_SETTINGS, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.makeChangeSettings();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrCreatePairsDC.this.exitDialogAction(param);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_REMOVE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreatePairsDC.this.removeAction();
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public void makeDataModel() throws SJcException {
        this.initAvalablePvolTableBasicData();
        super.makeDataModel();
        try {
            SJctrCreateRemotePairUtility.initCopyPaceTextBoxDataModel(this);
            SJctrCreateRemotePairUtility.initCopyPacePllDownListDataModel(this);
            SJctrCreateRemotePairUtility.initInitCopyPriorityModel(this);
            SJctrCreateRemotePairUtility.initCfwDataModel(this);
            SJctrCreateRemotePairUtility.initDfwToSvol(this);
            SJctrCreateRemotePairUtility.initHioTimeStampTransferModel(this);
            SJctrCreateRemotePairUtility.initCfwModel(this);
            SJmoSubsystemInfo sysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            this.localModelId = this.getComUtility().getRemoteReplicationUtility().getModelIDfromSubsysInfo(sysInfo);
            this.copyTypeAction();
            this.isInitialized = true;
        }
        catch (SJcException e) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107002);
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetTrueCopyPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetChaDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            this.checkCacheData();
            this.checkCurrentRemotePairInfo();
            this.initCopyTypePullDownList();
            this.initRemoteConnectionInfo();
            this.checkAvailebleJnl();
            this.createAllAvailableTableBasicDataList();
            this.checkMrcuInfoAndAvailableLdevs();
            this.initPortLunInfo();
            this.initJnlMirrorInfo();
            try {
                this.getCopyTypeDataModel().setSelectedIndex(0);
            }
            catch (SJcException e) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107002);
            }
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void checkCacheData() {
        try {
            SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            SJctrReplicationUtility.getSJmoLdevLuseInfo(this);
            SJctrRemoteReplicationUtility.getSJmoLdevStatusInfo(this);
            SJctrRemoteReplicationUtility.getSJmoTrueCopyPairVolInfoMgr(this);
            SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
            SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJctrReplicationUtility.getSJmoPortLunInfo(this);
            SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
            SJctrReplicationUtility.getSJmoPortDetail(this);
            SJctrRemoteReplicationUtility.getSJmoPortAttributeInfo(this);
            SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            SJctrRemoteReplicationUtility.getSJmoHUVMVirtualLdev(this);
            SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            SJctrRemoteReplicationUtility.getSJmoChaDetailList(this);
        }
        catch (SJcException e) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107002);
        }
    }

    private void initCopyTypePullDownList() {
        SJctrComboBoxDataModel copyType = this.getCopyTypeDataModel();
        SJctrLicenseContainer lc = this.getOwner().getAuthorizeContainer().getLisenceContainer();
        boolean isEnableTc = false;
        boolean isEnableTcmf = false;
        boolean isEnableUr = false;
        boolean isEnableUrmf = false;
        isEnableTc = lc.checkPP(SJctrLicenseContainer.PPID_HORC);
        isEnableTcmf = lc.checkPP(SJctrLicenseContainer.PPID_HRC);
        if (this.guidanceKey.equals("CREATE_TC_PAIR")) {
            if (isEnableTc) {
                copyType.addItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TC_STR, this.getComUtility().getGuidance("MANAGE_CA_PAIRS"));
            }
            if (isEnableTcmf) {
                copyType.addItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TCMF_STR, this.getComUtility().getGuidance("MANAGE_TRUECOPY_PAIRS"));
            }
            this.checkCopyTypePullDownList(205078);
        } else {
            isEnableUr = isEnableTc & lc.checkPP(SJctrLicenseContainer.PPID_HUR);
            isEnableUrmf = isEnableTcmf & lc.checkPP(SJctrLicenseContainer.PPID_HURMF);
            if (isEnableUr) {
                copyType.addItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_UR_STR, this.getComUtility().getGuidance("MANAGE_CAJ_PAIRS"));
            }
            if (isEnableUrmf) {
                copyType.addItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_URMF_STR, this.getComUtility().getGuidance("MANAGE_UNIVERSAL_REPLICATOR_PAIRS"));
            }
            this.checkCopyTypePullDownList(205001);
        }
    }

    private void initRemoteConnectionInfo() {
        SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
        this.createCuFreeMrcuMap(mrcuInfoMgr);
        this.createLimitedMrcuInfoMap(mrcuInfoMgr);
        SJctrComboBoxDataModel copyType = this.getCopyTypeDataModel();
        if (this.cuFreeMrcuInfoMap.isEmpty()) {
            copyType.removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TC_STR);
        }
        if (this.limitedCuMrcuInfoMap.isEmpty()) {
            copyType.removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TCMF_STR);
        }
        if (!this.hasAvailableCuConnectionForUr(2)) {
            copyType.removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_UR_STR);
        }
        if (!this.hasAvailableCuConnectionForUr(3)) {
            copyType.removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_URMF_STR);
        }
        this.checkCopyTypePullDownList(206022);
    }

    private void createCuFreeMrcuMap(SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr) {
        ArrayList<SJmoRemoteReplicationRCUInfo> sourceList = mrcuInfoMgr.getMRCUFreeInfo().getTrueCopyRCUInfoList();
        List<SJmoRemoteReplicationRCUInfo> cuFreeRcuInfoList = SJctrRemoteReplicationUtility.removeNoResourceRCUInfo(sourceList, this.getResourceGroupUtility());
        for (SJmoRemoteReplicationRCUInfo cuFreeRcuInfo : cuFreeRcuInfoList) {
            String modelSn = this.createModelSnStr(cuFreeRcuInfo);
            TreeSet<Integer> pathGrpIdList = this.cuFreeMrcuInfoMap.get(modelSn);
            if (null == pathGrpIdList) {
                pathGrpIdList = new TreeSet();
                this.cuFreeMrcuInfoMap.put(modelSn, pathGrpIdList);
            }
            pathGrpIdList.add(cuFreeRcuInfo.getIRCUID());
        }
    }

    private void createLimitedMrcuInfoMap(SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr) {
        SJmoRemoteReplicationMRCUInfo[] limitedMrcuInfoArray;
        for (SJmoRemoteReplicationMRCUInfo limitedMrcuInfo : limitedMrcuInfoArray = mrcuInfoMgr.getMRCUInfoList()) {
            ArrayList<SJmoRemoteReplicationRCUInfo> sourceList;
            List<SJmoRemoteReplicationRCUInfo> limitedRcuInfoList;
            if (null == limitedMrcuInfo || (limitedRcuInfoList = SJctrRemoteReplicationUtility.removeNoResourceRCUInfo(sourceList = limitedMrcuInfo.getTrueCopyRCUInfoList(), this.getResourceGroupUtility())).isEmpty()) continue;
            short cuNo = limitedMrcuInfo.getSCu();
            TreeMap<String, TreeSet<String>> limitedRcuInfoMap = this.limitedCuMrcuInfoMap.get(cuNo);
            if (null == limitedRcuInfoMap) {
                limitedRcuInfoMap = new TreeMap();
                this.limitedCuMrcuInfoMap.put(Integer.valueOf(cuNo), limitedRcuInfoMap);
            }
            for (SJmoRemoteReplicationRCUInfo limitedRcuInfo : limitedRcuInfoList) {
                if (limitedRcuInfo.getIControllerID() == 19) continue;
                String modelSn = this.createModelSnStr(limitedRcuInfo);
                TreeSet<String> ssidList = limitedRcuInfoMap.get(modelSn);
                if (null == ssidList) {
                    ssidList = new TreeSet();
                    limitedRcuInfoMap.put(modelSn, ssidList);
                }
                ssidList.addAll(this.createCuSsidList(limitedRcuInfo));
            }
            if (!limitedRcuInfoMap.isEmpty()) continue;
            this.limitedCuMrcuInfoMap.remove(cuNo);
        }
    }

    private SJctrResourceGroupUtility getResourceGroupUtility() {
        SJctrResourceGroupUtility rsgUty = null;
        try {
            List<SJmoRSGgetAllRsgs> allRsgList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, allRsgList);
            rsgUty = new SJctrResourceGroupUtility(this.getOwner(), allRsg);
        }
        catch (SJcException e) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107002);
        }
        return rsgUty;
    }

    private String createModelSnStr(SJmoRemoteReplicationRCUInfo mrcuinfo) {
        int serialNumber = 0;
        try {
            serialNumber = Integer.valueOf(mrcuinfo.getStrSN());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int modelSn = mrcuinfo.getIControllerID() * 1000000 + serialNumber;
        String modelSnStr = SJctrComUtility.toPaddingZeroString(modelSn, 9);
        return modelSnStr;
    }

    private TreeSet<String> createCuSsidList(SJmoRemoteReplicationRCUInfo rcuInfo) {
        TreeSet<String> cuSsidList = new TreeSet<String>();
        String cuSsidStr = null;
        int[] ssidArry = rcuInfo.getISSID();
        for (int ssidIndex = 0; ssidIndex < rcuInfo.getINumofSSID(); ++ssidIndex) {
            int cuSsid = rcuInfo.getSCu() * 100000 + ssidArry[ssidIndex];
            cuSsidStr = SJctrComUtility.toPaddingZeroString(cuSsid, 9);
            cuSsidList.add(cuSsidStr);
        }
        return cuSsidList;
    }

    private boolean hasAvailableCuConnectionForUr(int checkType) {
        boolean ret = false;
        Set<String> modelSnStrList = this.cuFreeMrcuInfoMap.keySet();
        for (String modelSnStr : modelSnStrList) {
            if (!this.isEnableUseRemoteStorageForUr(modelSnStr, checkType)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean isEnableUseRemoteStorageForUr(String modelSnStr, int checkType) {
        boolean ret = true;
        int controllerId = this.getModelIdNumFromModelSnStr(modelSnStr);
        switch (controllerId) {
            case 6: 
            case 7: {
                ret = true;
                break;
            }
            case 18: 
            case 19: {
                ret = checkType == 2;
                break;
            }
            default: {
                ret = this.isAvailableControllerId(controllerId);
            }
        }
        return ret;
    }

    private void checkAvailebleJnl() {
        SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        SJmoUniversalReplicatorJnlGrp[] jnlList = jnlMgr.getJnlGroupList();
        boolean isEnableUr = false;
        boolean isEnableUrmf = false;
        SJctrResourceGroupUtility rsgUty = this.getResourceGroupUtility();
        for (SJmoUniversalReplicatorJnlGrp jnl : jnlList) {
            if (null == jnl) continue;
            if (!SJctrRemoteReplicationUtility.hasTopJnlVolRs(jnl, rsgUty)) {
                this.logUty.putlog("checkAvailebleJnl", "Not authorized journal: " + jnl.getIJnlGroupId());
                continue;
            }
            block0 : switch (jnl.getAttribute()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    switch (jnl.getValidty()) {
                        case 1: {
                            isEnableUr = true;
                            break block0;
                        }
                        case 2: {
                            isEnableUrmf = true;
                            break block0;
                        }
                    }
                    break;
                }
            }
            if (isEnableUr && isEnableUrmf) break;
        }
        if (!isEnableUr) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_UR_STR);
        }
        if (!isEnableUrmf) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_URMF_STR);
        }
        this.checkCopyTypePullDownList(206024);
    }

    private void checkCurrentRemotePairInfo() {
        SJmoTrueCopyPairVolInfoMgr tcPairMgr = SJctrRemoteReplicationUtility.getSJmoTrueCopyPairVolInfoMgr(this);
        this.currentTcPairVolInfoList = SJctrRemoteReplicationUtility.getRemoteCopyPairVolInfoList(tcPairMgr.getTrueCopyPairVolInfoList());
        SJmoUniversalReplicatorPairVolInfoMgr urPairMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        this.currentUrPairVolInfoList = SJctrRemoteReplicationUtility.getRemoteCopyPairVolInfoList(urPairMgr.getPairVolInfoList());
        int currentRemotePairNum = this.currentTcPairVolInfoList.size() + this.currentUrPairVolInfoList.size();
        if (SJmoDataMacro_IF.MAX_RC_PAIR_NUM <= currentRemotePairNum) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206065);
        }
    }

    private void checkMrcuInfoAndAvailableLdevs() {
        this.removeNotAvailableMcu();
        if (this.availableCuList.isEmpty()) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TCMF_STR);
        }
        this.checkCopyTypePullDownList(206025);
    }

    private void removeNotAvailableMcu() {
        Set<Integer> limitedMcuList = this.limitedCuMrcuInfoMap.keySet();
        if (null != this.availableCuList) {
            Iterator<Integer> it = this.availableCuList.iterator();
            while (it.hasNext()) {
                if (limitedMcuList.contains(it.next())) continue;
                it.remove();
            }
        }
    }

    private void initPortLunInfo() {
        List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
        Collections.sort(portLunList);
        List<SJmoPortDetail> portDetailList = SJctrReplicationUtility.getSJmoPortDetail(this);
        Collections.sort(portDetailList);
        List<SJmoPortAttributeInfo> portAttributeList = SJctrRemoteReplicationUtility.getSJmoPortAttributeInfo(this);
        Collections.sort(portAttributeList);
        List<SJmoPortHostGroupInfo> portHgInfoList = SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
        Collections.sort(portHgInfoList);
        List<SJmoPortIscsiTargetInfo> portTgInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
        Collections.sort(portTgInfoList);
        ArrayList<SJmoPortLunInfo> availableTcPortLunList = new ArrayList<SJmoPortLunInfo>();
        ArrayList<SJmoPortIndex> availableTcPortHgList = new ArrayList<SJmoPortIndex>();
        ArrayList<SJmoPortLunInfo> availableUrPortLunList = new ArrayList<SJmoPortLunInfo>();
        ArrayList<SJmoPortIndex> availableUrPortHgList = new ArrayList<SJmoPortIndex>();
        for (SJmoPortLunInfo portLun : portLunList) {
            if (!this.isAvailablePortKind(portDetailList, portLun) || !this.isAvailablePortAttribute(portAttributeList, portLun)) continue;
            this.createAvailablePortLunInfo(portLun, portHgInfoList, this.availableLdevsBasicDataListMap.get(0), availableTcPortLunList, availableTcPortHgList);
            this.createAvailablePortLunInfo(portLun, portHgInfoList, this.availableLdevsBasicDataListMap.get(2), availableUrPortLunList, availableUrPortHgList);
            this.createAvailablePortLunInfoTgPort(portLun, portTgInfoList, this.availableLdevsBasicDataListMap.get(0), availableTcPortLunList, availableTcPortHgList);
            this.createAvailablePortLunInfoTgPort(portLun, portTgInfoList, this.availableLdevsBasicDataListMap.get(2), availableUrPortLunList, availableUrPortHgList);
        }
        Collections.sort(availableTcPortLunList);
        Collections.sort(availableTcPortHgList);
        Collections.sort(availableUrPortLunList);
        Collections.sort(availableUrPortHgList);
        this.availablePortLun.put(0, availableTcPortLunList);
        this.availablePortHg.put(0, availableTcPortHgList);
        if (availableTcPortLunList.isEmpty()) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TC_STR);
        }
        this.availablePortLun.put(2, availableUrPortLunList);
        this.availablePortHg.put(2, availableUrPortHgList);
        if (availableUrPortLunList.isEmpty()) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_UR_STR);
        }
        this.checkCopyTypePullDownList(206023);
    }

    private boolean isAvailablePortKind(List<SJmoPortDetail> portDetailList, SJmoPortIndex portIndex) {
        boolean isAvailblePort = false;
        int index = Collections.binarySearch(portDetailList, portIndex);
        SJmoPortDetail portDetail = null;
        if (index < 0) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "isAvailablePortKind", "Port Detail Info is not found: " + portIndex.getIndex());
            return isAvailblePort;
        }
        portDetail = portDetailList.get(index);
        isAvailblePort |= SJctrPortUtility.isFibrePort(portDetail);
        isAvailblePort |= SJctrPortUtility.isFcoePort(portDetail);
        isAvailblePort |= SJctrIscsiUtility.isIscsiPort(portDetail);
        return isAvailblePort |= SJctrPortUtility.isHnasUserPort(portDetail);
    }

    private boolean isAvailablePortAttribute(List<SJmoPortAttributeInfo> portAttributeList, SJmoPortIndex portIndex) {
        boolean isAvailablePortAttribute = false;
        int index = Collections.binarySearch(portAttributeList, portIndex);
        SJmoPortAttributeInfo portAttribute = null;
        if (index < 0) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "isAvailablePortAttribute", "Port Attribute Info is not found: " + portIndex.getIndex());
            return isAvailablePortAttribute;
        }
        portAttribute = portAttributeList.get(index);
        isAvailablePortAttribute |= portAttribute.getByPortKind() == 3;
        isAvailablePortAttribute |= portAttribute.getByPortKind() == 4;
        return isAvailablePortAttribute |= portAttribute.getByPortKind() == 9;
    }

    private void createAvailablePortLunInfo(SJmoPortLunInfo portLunInfo, List<SJmoPortHostGroupInfo> portHgInfoList, List<SJmoLdevDetail> availableLdevList, List<SJmoPortLunInfo> availablePortLunInfoList, List<SJmoPortIndex> availablePortHgInfoList) {
        if (null == portLunInfo || null == portHgInfoList || null == availableLdevList || null == availablePortLunInfoList || null == availablePortHgInfoList) {
            return;
        }
        int index = Collections.binarySearch(portHgInfoList, portLunInfo);
        if (index < 0) {
            return;
        }
        SJmoPortHostGroupInfo portHgInfo = portHgInfoList.get(index);
        try {
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ArrayList hgInfoList = portHgInfo.getAlPortHostGroup();
            SJmoPortLunInfo availablePortLunInfo = (SJmoPortLunInfo)portLunInfo.clone();
            availablePortLunInfo.getAlPortLun().clear();
            ArrayList<SJmoPortLunDetail> availablePortLunDetailList = new ArrayList<SJmoPortLunDetail>();
            ArrayList<SJmoHostGroupInfo> availableHostGroupInfoList = new ArrayList<SJmoHostGroupInfo>();
            for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                ArrayList portLunDetailList = portLunInfo.getAlHostGroupLun(hgInfo.getSHostGroup());
                for (SJmoPortLunDetail portLunDetail : portLunDetailList) {
                    ldevIndex.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
                    index = Collections.binarySearch(availableLdevList, ldevIndex);
                    if (index < 0) continue;
                    availablePortLunDetailList.add(portLunDetail);
                }
                if (availablePortLunDetailList.isEmpty()) continue;
                availablePortLunInfo.getAlPortLun().addAll(availablePortLunDetailList);
                availableHostGroupInfoList.add(hgInfo);
                availablePortLunDetailList.clear();
            }
            if (!availablePortLunInfo.getAlPortLun().isEmpty()) {
                availablePortLunInfoList.add(availablePortLunInfo);
                SJmoPortHostGroupInfo availablePortHostGroupInfo = (SJmoPortHostGroupInfo)portHgInfo.clone();
                availablePortHostGroupInfo.setAlPortHostGroup(availableHostGroupInfoList);
                availablePortHgInfoList.add(availablePortHostGroupInfo);
            }
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "createAvailablePortLunInfo", "CloneNotSupportedException occured.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
        }
    }

    private void createAvailablePortLunInfoTgPort(SJmoPortLunInfo portLunInfo, List<SJmoPortIscsiTargetInfo> portTgInfoList, List<SJmoLdevDetail> availableLdevList, List<SJmoPortLunInfo> availablePortLunInfoList, List<SJmoPortIndex> availablePortTgInfoList) {
        if (null == portLunInfo || null == portTgInfoList || null == availableLdevList || null == availablePortLunInfoList || null == availablePortTgInfoList) {
            return;
        }
        int index = Collections.binarySearch(portTgInfoList, portLunInfo);
        if (index < 0) {
            return;
        }
        SJmoPortIscsiTargetInfo portTgInfo = portTgInfoList.get(index);
        try {
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ArrayList<SJmoIscsiTargetInfo> tgInfoList = portTgInfo.getAlPortIscsiTarget();
            SJmoPortLunInfo availablePortLunInfo = (SJmoPortLunInfo)portLunInfo.clone();
            availablePortLunInfo.getAlPortLun().clear();
            ArrayList<SJmoPortLunDetail> availablePortLunDetailList = new ArrayList<SJmoPortLunDetail>();
            ArrayList<SJmoIscsiTargetInfo> availableIscsiTargetInfoList = new ArrayList<SJmoIscsiTargetInfo>();
            for (SJmoIscsiTargetInfo tgInfo : tgInfoList) {
                ArrayList portLunDetailList = portLunInfo.getAlHostGroupLun(tgInfo.getSIscsiTarget());
                for (SJmoPortLunDetail portLunDetail : portLunDetailList) {
                    ldevIndex.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
                    index = Collections.binarySearch(availableLdevList, ldevIndex);
                    if (index < 0) continue;
                    availablePortLunDetailList.add(portLunDetail);
                }
                if (availablePortLunDetailList.isEmpty()) continue;
                availablePortLunInfo.getAlPortLun().addAll(availablePortLunDetailList);
                availableIscsiTargetInfoList.add(tgInfo);
                availablePortLunDetailList.clear();
            }
            if (!availablePortLunInfo.getAlPortLun().isEmpty()) {
                availablePortLunInfoList.add(availablePortLunInfo);
                SJmoPortIscsiTargetInfo availablePortIscsiTargetGroupInfo = (SJmoPortIscsiTargetInfo)portTgInfo.clone();
                availablePortIscsiTargetGroupInfo.setAlPortIscsiTarget(availableIscsiTargetInfoList);
                availablePortTgInfoList.add(availablePortIscsiTargetGroupInfo);
            }
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "createAvailablePortLunInfoTgPort", "CloneNotSupportedException occured.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
        }
    }

    private void createAllAvailableTableBasicDataList() {
        List<SJmoLdevDetail> ldevDetailList = SJctrRemoteReplicationUtility.getSJmoLdevDetailFilteredByAllRsg(this);
        List<SJmoLdevStatusInfo> ldevStatusList = SJctrRemoteReplicationUtility.getSJmoLdevStatusInfo(this);
        Collections.sort(ldevStatusList);
        SJmoTrueCopyPairVolInfoMgr tcPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoTrueCopyPairVolInfoMgr(this);
        SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        SJmoUniversalReplicatorJnlGrpMgr jnlGrpMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        List<SJmoHUVMVirtualLdev> virtualLdevList = SJctrRemoteReplicationUtility.getSJmoHUVMVirtualLdev(this);
        Collections.sort(virtualLdevList);
        List<SJmoPortDetail> portDtlList = SJctrReplicationUtility.getSJmoPortDetail(this);
        List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
        List<SJmoLdevIndex> ficonLunList = SJctrReplicationUtility.getFICONPortLUList(portDtlList, portLunList);
        ArrayList<SJmoLdevDetail> tcBasicList = new ArrayList<SJmoLdevDetail>();
        ArrayList<SJmoLdevDetail> tcmfBasicList = new ArrayList<SJmoLdevDetail>();
        ArrayList<SJmoLdevDetail> urBasicList = new ArrayList<SJmoLdevDetail>();
        ArrayList<SJmoLdevDetail> urmfBasicList = new ArrayList<SJmoLdevDetail>();
        SJctrComboBoxDataModel copyType = this.getCopyTypeDataModel();
        boolean hasCopyTypeTc = null != copyType.getItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TC_STR);
        boolean hasCopyTypeTcmf = null != copyType.getItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TCMF_STR);
        boolean hasCopyTypeUr = null != copyType.getItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_UR_STR);
        boolean hasCopyTypeUrmf = null != copyType.getItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_URMF_STR);
        SJctrResourceGroupUtility rsgUty = this.getResourceGroupUtility();
        for (SJmoLdevDetail ldev : ldevDetailList) {
            SJmoUniversalReplicatorJnlGrp jnlInfo;
            SJmoReplicationPairVolInfo urPairVolInfo;
            List<? extends SJmoLdevIndex> remoteVolList;
            SJmoReplicationPairVolInfo tcPairVolInfo;
            int vLdevIndex;
            if (rsgUty.isSelRscLdevInSysRsg(ldev)) continue;
            boolean availableTrueCopy = hasCopyTypeTc;
            boolean availableTrueCopyForMainframe = hasCopyTypeTcmf;
            boolean availableUniversalReplicator = hasCopyTypeUr;
            boolean availableUniversalReplicatorForMainframe = hasCopyTypeUrmf;
            int ldevStatusIndex = Collections.binarySearch(ldevStatusList, ldev);
            if (ldevStatusIndex >= 0 && !SJctrCreatePairUtility.checkCreatePiarUsableStatus(ldevStatusList.get(ldevStatusIndex))) continue;
            if (ldev.getbOpenVolume()) {
                availableTrueCopyForMainframe = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getbMfVolume()) {
                availableTrueCopy = false;
                availableUniversalReplicator = false;
            }
            if (ldev.getbMiddleVolume()) {
                availableTrueCopy = false;
                availableTrueCopyForMainframe = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (!SJctrLdevUtility.isAllocateVolume(ldev)) {
                availableTrueCopy = false;
                availableUniversalReplicator = false;
            }
            if (ldev.getbLUPathCmdDev()) {
                availableTrueCopy = false;
                availableTrueCopyForMainframe = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getbJNLVolume()) {
                availableTrueCopy = false;
                availableTrueCopyForMainframe = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getbPoolVol()) {
                availableTrueCopy = false;
                availableTrueCopyForMainframe = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getIEmulationType() != 625) {
                availableUniversalReplicator = false;
            }
            if (ldev.getIEmulationType() == 155) {
                availableTrueCopyForMainframe = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getIEmulationType() == 32922) {
                availableTrueCopyForMainframe = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getbQsVvol()) {
                availableTrueCopy = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getbSystemDisk()) {
                availableTrueCopy = false;
                availableTrueCopyForMainframe = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getBLockVolume()) {
                availableTrueCopy = false;
                availableTrueCopyForMainframe = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getbExternalMfVolume()) {
                availableTrueCopyForMainframe = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (Collections.binarySearch(ficonLunList, ldev) >= 0) {
                availableTrueCopy = false;
                availableUniversalReplicator = false;
            }
            if ((vLdevIndex = Collections.binarySearch(virtualLdevList, ldev)) >= 0) {
                SJmoHUVMVirtualLdev virtualLdev = virtualLdevList.get(vLdevIndex);
                if (!virtualLdev.isValidIndexVirtualLdev()) {
                    availableTrueCopy = false;
                    availableTrueCopyForMainframe = false;
                    availableUniversalReplicator = false;
                    availableUniversalReplicatorForMainframe = false;
                }
                if (SJctrHaUtility.isHuvmReserve(virtualLdev)) continue;
            }
            if (ldev.getbOdmVol()) {
                availableTrueCopy = false;
                availableUniversalReplicator = false;
            }
            if (SJctrRemoteReplicationUtility.isLuseElement(ldev)) {
                availableTrueCopy = false;
                availableUniversalReplicator = false;
            }
            if (ldev.getbTseVol()) {
                availableTrueCopyForMainframe = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (ldev.getbHIHSMReserve()) {
                availableTrueCopy = false;
                availableTrueCopyForMainframe = false;
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (null != (tcPairVolInfo = tcPairVolInfoMgr.getTrueCopyPairVolInfo(ldev))) {
                if (SJctrRemoteReplicationUtility.checkPairVolPos(tcPairVolInfo, SJctrRemoteReplicationDataMacro.BITMAPDATA_VOL_POS_TC)) {
                    availableTrueCopy = false;
                }
                if (SJctrRemoteReplicationUtility.checkPairVolPos(tcPairVolInfo, SJctrRemoteReplicationDataMacro.BITMAPDATA_VOL_POS_TCMF)) {
                    availableTrueCopyForMainframe = false;
                }
            }
            if ((remoteVolList = SJctrRemoteReplicationUtility.getRemoteVolumeInfoList(urPairVolInfo = urPairVolInfoMgr.getPairVolInfo(ldev))).size() >= 2) {
                availableUniversalReplicator = false;
                availableUniversalReplicatorForMainframe = false;
            }
            if (remoteVolList.size() == 1 && (jnlInfo = jnlGrpMgr.getJnlGroup(SJctrRemoteReplicationUtility.getJnlIdFromPair((SJmoUniversalReplicatorPairVolInfo)remoteVolList.get(0)))) != null && jnlInfo.getValidty() == 1 && jnlInfo.getIsite() != 0) {
                availableUniversalReplicator = false;
            }
            if (availableTrueCopy) {
                tcBasicList.add(ldev);
            }
            if (availableTrueCopyForMainframe) {
                tcmfBasicList.add(ldev);
                this.availableCuList.add(Integer.valueOf(ldev.getSCu()));
            }
            if (availableUniversalReplicator) {
                urBasicList.add(ldev);
            }
            if (!availableUniversalReplicatorForMainframe) continue;
            urmfBasicList.add(ldev);
        }
        Collections.sort(tcBasicList);
        Collections.sort(tcmfBasicList);
        Collections.sort(urBasicList);
        Collections.sort(urmfBasicList);
        this.availableLdevsBasicDataListMap.put(0, tcBasicList);
        this.availableLdevsBasicDataListMap.put(1, tcmfBasicList);
        this.availableLdevsBasicDataListMap.put(2, urBasicList);
        this.availableLdevsBasicDataListMap.put(3, urmfBasicList);
        ArrayList urBasicCopyList = new ArrayList(urBasicList);
        ArrayList urmfBasicCopyList = new ArrayList(urmfBasicList);
        this.availableLdevsInitialBasicDataListMap.put(2, urBasicCopyList);
        this.availableLdevsInitialBasicDataListMap.put(3, urmfBasicCopyList);
        if (tcBasicList.isEmpty()) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TC_STR);
        }
        if (tcmfBasicList.isEmpty()) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_TCMF_STR);
        }
        if (urBasicList.isEmpty()) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_UR_STR);
        }
        if (urmfBasicList.isEmpty()) {
            this.getCopyTypeDataModel().removeItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_URMF_STR);
        }
        this.checkCopyTypePullDownList(206025);
    }

    private void initJnlMirrorInfo() {
        for (SJmoUniversalReplicatorPairVolInfo urPairVolInfo : this.currentUrPairVolInfoList) {
            int mirror = urPairVolInfo.getMirrorId();
            int pathGrp = urPairVolInfo.getPathID();
            int ctg = urPairVolInfo.getCtgId();
            String sn = urPairVolInfo.getPairSN();
            int localPairPos = SJctrRemoteReplicationUtility.getPairPos(urPairVolInfo);
            int mjnl = -1;
            int rjnl = -1;
            if (localPairPos == 0) {
                mjnl = urPairVolInfo.getMJnlGrpId();
                rjnl = urPairVolInfo.getRJnlGrpId();
            } else if (localPairPos == 1) {
                mjnl = urPairVolInfo.getRJnlGrpId();
                rjnl = urPairVolInfo.getMJnlGrpId();
            } else {
                SJctrLdevUtility util = this.getComUtility().getLdevUtility();
                SJctrLogUty.error(this.getClass().getSimpleName(), "initJnlMirrorInfo", "PairPosition is Invalid. LDEV Index : " + util.toLdevDisplay(urPairVolInfo));
                continue;
            }
            BitSet currentMirrorUtilization = this.currentMirrorAttribute[mjnl];
            if (null == currentMirrorUtilization) {
                this.currentMirrorAttribute[mjnl] = currentMirrorUtilization = new BitSet(4);
            }
            currentMirrorUtilization.set(mirror);
            SJctrJnlMirrorInfo jnlMirror = this.totalJnlMirrorInfo[mjnl][mirror];
            if (null == jnlMirror) {
                this.totalJnlMirrorInfo[mjnl][mirror] = jnlMirror = new SJctrJnlMirrorInfo(mjnl, mirror, rjnl, pathGrp, ctg, sn, localPairPos);
            }
            jnlMirror.addPairNum(1);
            if (urPairVolInfo.getCtgEnable() != 1) continue;
            SJctrJnlMirrorInfo ctgInfo = this.totalCtgInfo[ctg];
            if (null == ctgInfo) {
                this.totalCtgInfo[ctg] = ctgInfo = new SJctrJnlMirrorInfo(mjnl, mirror, rjnl, pathGrp, ctg, sn, localPairPos);
            }
            ctgInfo.addPairNum(1);
        }
    }

    private void initAvalablePvolTableBasicData() {
        SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        if (null != this.getCopyTypeDataModel().getItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_UR_STR)) {
            List<SJmoLdevDetail> availableUrLdevList = this.availableLdevsBasicDataListMap.get(2);
            Map<Integer, SJmoUniversalReplicatorPairVolInfo> basicDataForUrMultiPair = SJctrCreateRemotePairUtility.getSingleUrPairMapFromLdevIndex(urPairVolInfoMgr, availableUrLdevList);
            this.getAvailableTableLun().setBasicDataForMultiPair(basicDataForUrMultiPair);
        }
        if (null != this.getCopyTypeDataModel().getItem(SJctrCreateRemotePairConst.KEY_COPY_TYPE_URMF_STR)) {
            List<SJmoLdevDetail> availableUrmfLdevList = this.availableLdevsBasicDataListMap.get(3);
            Map<Integer, SJmoUniversalReplicatorPairVolInfo> basicDataForUrmfMultiPair = SJctrCreateRemotePairUtility.getSingleUrPairMapFromLdevIndex(urPairVolInfoMgr, availableUrmfLdevList);
            this.getAvailableTableLdev().setBasicDataForMultiPair(basicDataForUrmfMultiPair);
        }
    }

    private List<SJmoLdevDetail> getAvailablePvolForUrUrmf(List<SJmoLdevDetail> availableLdevList) {
        List<Object> availablePvolList = new ArrayList();
        String selectUseExistUrPair = this.getUseExistUrPairsDataModel().getSelect();
        if (selectUseExistUrPair.equals("COM_YES")) {
            availablePvolList = this.getAvailablePvolForMultiUrPair(availableLdevList);
        } else if (selectUseExistUrPair.equals("COM_NO")) {
            availablePvolList = this.getAvailablePvolForNormalUrPair(availableLdevList);
        } else {
            availablePvolList = availableLdevList;
            SJctrLogUty.warn(SJctrCreatePairsDC.class.getSimpleName(), "getAvailablePrimaryVolumes", "Use Existing Volumes of UR Pairs value is invalid.");
        }
        return availablePvolList;
    }

    private List<SJmoLdevDetail> getAvailablePvolForNormalUrPair(List<SJmoLdevDetail> availableLdevList) {
        ArrayList<SJmoLdevDetail> availablePvolForNormalUrPair = new ArrayList<SJmoLdevDetail>();
        SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        for (SJmoLdevDetail ldevDetail : availableLdevList) {
            SJmoReplicationPairVolInfo pairVolInfo = urPairVolInfoMgr.getPairVolInfo(ldevDetail);
            if (pairVolInfo != null) continue;
            availablePvolForNormalUrPair.add(ldevDetail);
        }
        return availablePvolForNormalUrPair;
    }

    private List<SJmoLdevDetail> getAvailablePvolForMultiUrPair(List<SJmoLdevDetail> availableLdevList) {
        ArrayList<SJmoLdevDetail> availablePvolForMultiUrPair = new ArrayList<SJmoLdevDetail>();
        SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        for (SJmoLdevDetail ldevDetail : availableLdevList) {
            SJmoReplicationPairVolInfo pairVolInfo = urPairVolInfoMgr.getPairVolInfo(ldevDetail);
            if (pairVolInfo == null) continue;
            availablePvolForMultiUrPair.add(ldevDetail);
        }
        return availablePvolForMultiUrPair;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer;
        boolean dispMsgFlg = false;
        List<Object> urPairList = this.getSelectedUrPairsTable().getAllRowData();
        List<SJmoReplicationPairVolInfo> pairVolInfoList = this.getSelectedUrPairsTable().getReplicationPairVolInfoList();
        for (Object pairInfo : urPairList) {
            SJctrCreateUniversalReplicatorPairVolInfo createUrPair = (SJctrCreateUniversalReplicatorPairVolInfo)pairInfo;
            SJmoReplicationPairVolInfo ldev = SJctrRemoteReplicationUtility.getLocalVolume((SJctrCreateUniversalReplicatorPairVolInfo)pairInfo);
            SJmoUniversalReplicatorPairVolInfo urPair = null;
            int pairVolIndex = Collections.binarySearch(pairVolInfoList, ldev);
            if (pairVolIndex >= 0) {
                SJmoReplicationPairVolInfo pairVolInfo = pairVolInfoList.get(pairVolIndex);
                urPair = SJctrCreateRemotePairUtility.getUrPairVolInfoList(pairVolInfo).get(0);
            }
            if (urPair == null || !SJctrRemoteReplicationUtility.isUrMultiPairDeltaSecodary(createUrPair, urPair)) continue;
            dispMsgFlg = true;
            break;
        }
        if (dispMsgFlg) {
            SJcMessage msg = new SJcMessage(Integer.toString(210), Integer.toString(22), Integer.toString(206292));
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            this.addUpdateDisp(related);
        }
        if ((footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER")) != null && (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH)) != null) {
            finishButton.setDirty();
        }
        return false;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrCreatePairsConfirmData confirmData = new SJctrCreatePairsConfirmData();
            confirmData.setCopyType(this.copyType);
            List<Object> tcPairList = this.getSelectedTcPairsTable().getAllRowData();
            Collections.sort(tcPairList, new SJctrTrueCopyPairInfoComparator());
            confirmData.setTcPairsInfo(tcPairList);
            List<Object> urPairList = this.getSelectedUrPairsTable().getAllRowData();
            Collections.sort(urPairList, new SJctrUniversalReplicatorPairInfoComparator());
            confirmData.setUrPairsInfo(urPairList);
            confirmData.setNeedData(this);
            ArrayList<SJctrCreatePairsConfirmData> confirmDataList = new ArrayList<SJctrCreatePairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrCreatePairsConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void setInitCopyTypeNoneErrInfo(List<Object> allRowData) {
        boolean existNone = false;
        int initCopyType = -1;
        for (Object pairInfo : allRowData) {
            switch (this.copyType) {
                case 0: 
                case 1: {
                    initCopyType = ((SJctrCreateTrueCopyPairVolInfo)pairInfo).getInitCopyType();
                    existNone = initCopyType == 0;
                    break;
                }
                case 2: 
                case 3: {
                    initCopyType = ((SJctrCreateUniversalReplicatorPairVolInfo)pairInfo).getInitCopyType();
                    existNone = initCopyType == 1;
                    break;
                }
            }
            if (!existNone) continue;
            break;
        }
        this.setViewErrInfo(existNone, 0);
    }

    private void setViewErrInfo(boolean existNone, int kind) {
        this.getManageData().setData("COM_VIEW_ALERT_EXIST", existNone);
        if (existNone) {
            this.getManageData().setData("COM_VIEW_ALERT_CODE", kind);
        }
    }

    private void copyTypeAction() {
        this.copyType = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getCopyTypeDataModel());
        SJctrTableDataModel availableTable = null;
        SJctrCreateTcPairsSelectedTableModel selectedTable = null;
        switch (this.copyType) {
            case 0: {
                this.selectCopyTypeTc();
                availableTable = this.getAvailableTableLun();
                selectedTable = this.getSelectedTcPairsTable();
                break;
            }
            case 1: {
                this.selectCopyTypeTcmf();
                availableTable = this.getAvailableTableLdev();
                selectedTable = this.getSelectedTcPairsTable();
                break;
            }
            case 2: {
                this.selectCopyTypeUr();
                availableTable = this.getAvailableTableLun();
                selectedTable = this.getSelectedUrPairsTable();
                break;
            }
            case 3: {
                this.selectCopyTypeUrmf();
                availableTable = this.getAvailableTableLdev();
                selectedTable = this.getSelectedUrPairsTable();
                break;
            }
        }
        availableTable.resetOwnControlData();
        availableTable.setFilterData(new ArrayList<SJctrDataObject>(0));
        selectedTable.resetOwnControlData();
        this.updateFooter();
        this.setDirtyAll();
    }

    private void selectCopyTypeTc() {
        this.updateModelSnModel();
        this.updatePathGrpIdModel();
        this.updateSelectionObjectModel();
        this.updateLocalPortIdModel();
        this.updateLocalHgNameModel();
        this.updateAvailableLdevsTableModelLun();
        this.updateRemotePortId();
        this.getBaseSVolModel().getHgIdModel().setSelectedIndex(0);
        this.getBaseSVolModel().getLunIdModel().setSelectedIndex(0);
        this.getSelectionTypeDataModel().getSelectionTypeRadio().setSelect("COM_INTERVAL");
        this.updateIntervalValueModel();
        this.updatePvolFenceLevelModel();
        this.updateInitCopyTypeModel();
        ((SJctrTextBoxDataModel)this.getDataObjectModel("COM_COPY_PACE_TXT")).setValue(String.valueOf(15));
        ((SJctrTextBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_PRIORITY")).setValue(String.valueOf(32));
        this.updateSelectedPairsTableModel();
    }

    private void selectCopyTypeTcmf() {
        this.updateLocalCuModel();
        this.updateModelSnModel();
        this.updateCuSsidModel();
        this.updateAvailableLdevsTableModelLdev();
        this.updateRemoteCuTxtModel();
        this.getBaseSVolModel().getLdevModel().setSelectedIndex(0);
        this.getSelectionTypeDataModel().getSelectionTypeRadio().setSelect("COM_INTERVAL");
        this.updateIntervalValueModel();
        this.updatePvolFenceLevelModel();
        this.updateInitCopyTypeModel();
        ((SJctrComboBoxDataModel)this.getDataObjectModel("COM_COPY_PACE_LIST")).setSelection(String.valueOf(2));
        ((SJctrTextBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_PRIORITY")).setValue(String.valueOf(32));
        ((SJctrComboBoxDataModel)this.getDataObjectModel("COM_CFW_DATA")).setSelection(String.valueOf(1));
        ((SJctrComboBoxDataModel)this.getDataObjectModel("COM_DFW_TO_SVOL")).setSelection(String.valueOf(0));
        ((SJctrRadioButtonGroupDataModel)this.getDataObjectModel("COM_HIO_TIME_STAMP_TRANS")).setSelect("COM_DISABLE");
        this.updateSelectedPairsTableModel();
    }

    private void selectCopyTypeUr() {
        this.updateModelSnModel();
        this.updatePathGrpIdModel();
        this.updateUseExistUrPairsModel();
        this.updateSelectionObjectModel();
        this.updateLocalPortIdModel();
        this.updateLocalHgNameModel();
        this.updateAvailableLdevsTableModelLun();
        this.updateRemotePortId();
        this.getBaseSVolModel().getHgIdModel().setSelectedIndex(0);
        this.getBaseSVolModel().getLunIdModel().setSelectedIndex(0);
        this.getSelectionTypeDataModel().getSelectionTypeRadio().setSelect("COM_INTERVAL");
        this.updateIntervalValueModel();
        SJctrMirrorSelectionDataModel mirrorSelectionModel = this.getMirrorSelectionDataModel();
        mirrorSelectionModel.updateMasterJournalId(this.copyType, this.getUseExistUrPairsDataModel().getSelect());
        this.updateCurrentNumOfMJnlMirror();
        this.updateTotalNumOfMJnlMirror();
        mirrorSelectionModel.getMirrorIdModel().setSelectedIndex(0);
        mirrorSelectionModel.getRestoreJnlModel().setSelectedIndex(0);
        this.updateCtgIdList(0);
        this.masterJournalAction();
        this.updateInitCopyTypeModel();
        ((SJctrTextBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_PRIORITY")).setValue(String.valueOf(32));
        this.updateErrorLevelModel();
        this.updateSelectedPairsTableModel();
    }

    private void selectCopyTypeUrmf() {
        this.updateModelSnModel();
        this.updatePathGrpIdModel();
        this.updateUseExistUrPairsModel();
        this.updateAvailableLdevsTableModelLdev();
        this.updateRemoteCuPulldownModel();
        this.getBaseSVolModel().getLdevModel().setSelectedIndex(0);
        this.getSelectionTypeDataModel().getSelectionTypeRadio().setSelect("COM_INTERVAL");
        this.updateIntervalValueModel();
        SJctrMirrorSelectionDataModel mirrorSelectionModel = this.getMirrorSelectionDataModel();
        mirrorSelectionModel.updateMasterJournalId(this.copyType, this.getUseExistUrPairsDataModel().getSelect());
        this.updateCurrentNumOfMJnlMirror();
        this.updateTotalNumOfMJnlMirror();
        mirrorSelectionModel.getMirrorIdModel().setSelectedIndex(0);
        mirrorSelectionModel.getRestoreJnlModel().setSelectedIndex(0);
        this.masterJournalAction();
        this.updateInitCopyTypeModel();
        ((SJctrTextBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_PRIORITY")).setValue(String.valueOf(32));
        this.updateErrorLevelModel();
        ((SJctrComboBoxDataModel)this.getDataObjectModel("COM_CFW")).setSelection(String.valueOf(0));
        this.updateSelectedPairsTableModel();
    }

    private void localCuAction() {
        this.updateModelSnModel();
        switch (this.copyType) {
            case 1: {
                this.updateCuSsidModel();
                this.updateAvailableLdevsTableModelLdev();
                this.updateRemoteCuTxtModel();
                break;
            }
        }
    }

    private void modelSerialNumberAction() {
        switch (this.copyType) {
            case 0: {
                this.updatePathGrpIdModel();
                this.updateRemotePortId();
                break;
            }
            case 1: {
                this.updateCuSsidModel();
                this.updateRemoteCuTxtModel();
                break;
            }
            case 2: {
                this.updatePathGrpIdModel();
                this.updateInitCopyTypeModel();
                this.updateRemotePortId();
                break;
            }
            case 3: {
                this.updatePathGrpIdModel();
                this.updateInitCopyTypeModel();
                this.getBaseSVolModel().updateRemoteCuPulldownModel(this.getModelIdNumFromModelSnStr(this.getRemoteSysModel().getModelSnModel().getSelection()));
                break;
            }
        }
    }

    private void cuSsidAction() {
        this.updateRemoteCuTxtModel();
    }

    private void useExistUrPairsAction() {
        this.updateSelectionObjectModel();
        if (this.copyType == 2) {
            this.updateAvailableLdevsTableModelLun();
        } else if (this.copyType == 3) {
            this.updateAvailableLdevsTableModelLdev();
        }
        SJctrMirrorSelectionDataModel mirrorSelectionDataModel = this.getMirrorSelectionDataModel();
        mirrorSelectionDataModel.getMirrorIdModel().setSelectedIndex(0);
        mirrorSelectionDataModel.getRestoreJnlModel().setSelectedIndex(0);
        this.getCtgIdModel().setSelectedIndex(0);
        mirrorSelectionDataModel.updateMasterJournalId(this.copyType, this.getUseExistUrPairsDataModel().getSelect());
    }

    private void selectionObjectRadioAction() {
        this.updateLocalPortIdModel();
        this.updateLocalHgNameModel();
        this.updateAvailableLdevsTableModelLun();
    }

    private void localPortIdAction() {
        this.updateLocalHgNameModel();
        this.updateAvailableLdevsTableModelLun();
    }

    private void localHostGroupNameAction() {
        this.updateAvailableLdevsTableModelLun();
    }

    private void selectionTypeRadioAction() {
        this.updateIntervalValueModel();
    }

    private void masterJournalAction() {
        SJctrMirrorSelectionDataModel mirrorSelectionDataModel = this.getMirrorSelectionDataModel();
        int mjnl = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionDataModel.getMasterJnlModel());
        int mirror = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionDataModel.getMirrorIdModel());
        if (mjnl >= 0 && mirror >= 0) {
            SJctrJnlMirrorInfo jnlMirror = this.totalJnlMirrorInfo[mjnl][mirror];
            if (null != jnlMirror && jnlMirror.getNumOfPair() > 0 && jnlMirror.getLocalPairPosition() == 0) {
                mirrorSelectionDataModel.getRestoreJnlModel().setSelection(String.valueOf(jnlMirror.getRestoreJournalId()));
                if (this.copyType == 2) {
                    this.getCtgIdModel().setSelection(String.valueOf(jnlMirror.getCtgId()));
                    this.getCtgIdModel().setDirtyAll();
                }
            } else if (this.copyType == 2) {
                this.getCtgIdModel().setSelection(String.valueOf(this.getUnusedCtgId()));
                this.getCtgIdModel().setDirtyAll();
            }
        }
        this.updateCurrentNumOfMJnlMirror();
        this.updateTotalNumOfMJnlMirror();
    }

    private void restoreJournalAction() {
        SJctrMirrorSelectionDataModel mirrorSelectionDataModel = this.getMirrorSelectionDataModel();
        int restoreJnlId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionDataModel.getRestoreJnlModel());
        int mjnl = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionDataModel.getMasterJnlModel());
        int mirror = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionDataModel.getMirrorIdModel());
        if (mjnl >= 0 && mirror >= 0) {
            SJctrJnlMirrorInfo jnlMirror = this.totalJnlMirrorInfo[mjnl][mirror];
            if (null != jnlMirror && jnlMirror.getRestoreJournalId() == restoreJnlId && jnlMirror.getLocalPairPosition() == 0) {
                if (this.copyType == 2) {
                    this.getCtgIdModel().setSelection(String.valueOf(jnlMirror.getCtgId()));
                    this.getCtgIdModel().setDirtyAll();
                }
            } else if (this.copyType == 2) {
                this.getCtgIdModel().setSelection(String.valueOf(this.getUnusedCtgId()));
                this.getCtgIdModel().setDirtyAll();
            }
        }
    }

    private int getUnusedCtgId() {
        int ret = 0;
        for (int index = 0; index < this.totalCtgInfo.length; ++index) {
            if (null != this.totalCtgInfo[index]) continue;
            ret = index;
            break;
        }
        return ret;
    }

    private void addAction() {
        switch (this.copyType) {
            case 0: {
                this.addTcPairAction();
                break;
            }
            case 1: {
                this.addTcmfPairAction();
                break;
            }
            case 2: {
                this.addUrPairAction();
                break;
            }
            case 3: {
                this.addUrmfPairAction();
                break;
            }
        }
        SJctrTableDataModel selectedTable = this.getSelectedPairsTable();
        this.setInitCopyTypeNoneErrInfo(selectedTable.getAllRowData());
        this.updateFooter();
        this.setDirtyAll();
    }

    private void addTcPairAction() {
        SJctrCreatePairsAvailableTableModelLun availableTable = this.getAvailableTableLun();
        List<Object> selectedLdevs = availableTable.getSelectedRowDataOrder();
        if (selectedLdevs.isEmpty()) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "addTcPairAction", "Available LDEVs is not Selected.");
            return;
        }
        int pvolCount = selectedLdevs.size();
        int selectedPairsCount = this.getSelectedTcPairsTable().getRowCount();
        this.checkMaxPairNum(pvolCount, selectedPairsCount);
        SJctrCreateTcPairsSelectedTableModel selectedTable = this.getSelectedTcPairsTable();
        String modelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        int modelId = this.getModelIdNumFromModelSnStr(modelSnStr);
        String strSn = this.getSerialNumberStrFromModelSnStr(modelId, modelSnStr);
        List<Integer> usedLuIndexList = this.getUsedLunTc(selectedTable.getAllRowData(), modelId, strSn);
        boolean isRelative = this.getSelectionTypeDataModel().isRelative();
        int selectedInterval = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getIntervalValueDataModel());
        List<SJmoLuIndex> svolIndexList = SJctrCreateRemotePairUtility.getSvolLunList(selectedLdevs, usedLuIndexList, selectedLdevs.size(), modelId, this.getBaseSVolModel(), isRelative, selectedInterval);
        List<SJctrCreateTrueCopyPairVolInfo> pairVolList = this.getSelectedTcPairsList(selectedLdevs, svolIndexList);
        selectedTable.addRowDataTop(pairVolList);
        List<SJmoLdevIndex> selectedLdevIndex = this.getLdevIndexListFromSJctrPortLunTableKey(selectedLdevs);
        this.removeSelectedLdevFromAvailableTableBasicDataList(selectedLdevIndex);
        this.updateAvailableLdevsTableModelLun();
    }

    private List<Integer> getUsedLunTc(List<Object> allRowData, int controllerId, String strSn) {
        ArrayList<Integer> usedLuIndexList = new ArrayList<Integer>();
        Map<Short, String> remotePtMap = SJctrRemoteReplicationUtility.getPortNameMap(controllerId);
        ArrayList<Short> ptIndexList = new ArrayList<Short>(remotePtMap.keySet());
        for (Object rowData : allRowData) {
            SJctrCreateTrueCopyPairVolInfo svolInfo = (SJctrCreateTrueCopyPairVolInfo)rowData;
            if (svolInfo.getIPairControllerID() != controllerId || !svolInfo.getStrPairSN().equals(strSn)) continue;
            SJmoLuIndex luIndex = svolInfo.getPairLU();
            int ptIndex = ptIndexList.indexOf(luIndex.getSPort());
            int ptHgLu = SJctrCreateRemotePairUtility.getPtHgLun(ptIndex, luIndex.getSHostGroup(), luIndex.getILUN());
            usedLuIndexList.add(ptHgLu);
        }
        return usedLuIndexList;
    }

    private void addTcmfPairAction() {
        SJctrCreatePairsAvailableTableModelLdev availableTable = this.getAvailableTableLdev();
        List<Object> selectedLdevs = availableTable.getSelectedRowDataOrder();
        if (selectedLdevs.isEmpty()) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "addTcmfPairAction", "Available LDEVs is not Selected.");
            return;
        }
        int pvolCount = selectedLdevs.size();
        SJctrCreateTcPairsSelectedTableModel selectedTable = this.getSelectedTcPairsTable();
        int selectedPairsCount = selectedTable.getRowCount();
        this.checkMaxPairNum(pvolCount, selectedPairsCount);
        int rcu = -1;
        String cuStr = this.getBaseSVolModel().getCuTextModel().getValue();
        try {
            rcu = Integer.parseInt(cuStr, 16);
        }
        catch (NumberFormatException e) {
            this.logUty.putlog("addTcmfPairAction", "Failed to CU number format. CU :" + cuStr);
        }
        String moslSn = this.getRemoteSysModel().getModelSnModel().getSelection();
        int controllerId = this.getModelIdNumFromModelSnStr(moslSn);
        String strSn = this.getSerialNumberStrFromModelSnStr(controllerId, moslSn);
        List<Integer> usedLdevIndexList = this.getUsedLdevTcmf(selectedTable.getAllRowData(), rcu, controllerId, strSn);
        this.checkTcmfFreeSvolLdevId(usedLdevIndexList.size(), selectedLdevs.size());
        boolean isRelative = this.getSelectionTypeDataModel().isRelative();
        int selectedInterval = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getIntervalValueDataModel());
        List<SJmoLdevIndex> svolIndexList = SJctrCreateRemotePairUtility.getSvolLdevList(selectedLdevs, usedLdevIndexList, selectedLdevs.size(), this.copyType, controllerId, this.getBaseSVolModel(), isRelative, selectedInterval);
        List<SJctrCreateTrueCopyPairVolInfo> pairVolList = this.getSelectedTcmfPairsList(selectedLdevs, svolIndexList);
        selectedTable.addRowDataTop(pairVolList);
        this.removeSelectedLdevFromAvailableTableBasicDataList(selectedLdevs);
        this.updateAvailableLdevsTableModelLdev();
    }

    private List<Integer> getUsedLdevTcmf(List<Object> allRowData, int rcu, int controllerId, String strSn) {
        ArrayList<Integer> usedLdevIndexList = new ArrayList<Integer>();
        for (Object rowData : allRowData) {
            SJctrCreateTrueCopyPairVolInfo svolInfo = (SJctrCreateTrueCopyPairVolInfo)rowData;
            if (svolInfo.getIPairControllerID() != controllerId || svolInfo.getSCu() != rcu || !svolInfo.getStrPairSN().equals(strSn)) continue;
            usedLdevIndexList.add(Integer.valueOf(svolInfo.getSLdev()));
        }
        return usedLdevIndexList;
    }

    private void addUrPairAction() {
        SJctrCreatePairsAvailableTableModelLun availableTable = this.getAvailableTableLun();
        List<Object> selectedLdevs = availableTable.getSelectedRowDataOrder();
        if (selectedLdevs.isEmpty()) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "addUrPairAction", "Available LDEVs is not Selected.");
            return;
        }
        int pvolCount = this.getAvailableTableLun().getSelectedRowCount();
        int selectedPairsCount = this.getSelectedUrPairsTable().getRowCount();
        this.checkMaxPairNum(pvolCount, selectedPairsCount);
        int modelId = this.getModelIdNumFromModelSnStr(this.getRemoteSysModel().getModelSnModel().getSelection());
        SJctrMirrorSelectionDataModel mirrorSelectionModel = this.getMirrorSelectionDataModel();
        int selectedJnlId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMasterJnlModel());
        int selectedMirrorId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMirrorIdModel());
        if ("COM_YES".equals(this.getUseExistUrPairsDataModel().getSelect())) {
            List<SJmoLdevIndex> searchLdevList = SJctrRemoteReplicationUtility.getLdevIndexListFromPortLunTableKey(selectedLdevs);
            List<SJmoUniversalReplicatorPairVolInfo> selectedURPairList = this.getURPairListFromSelectedLDEVs(availableTable.getReplicationPairVolInfoList(), searchLdevList);
            this.checkMultiPairCreate(selectedURPairList);
            SJmoUniversalReplicatorPairVolInfo urPairInfo = selectedURPairList.get(0);
            selectedJnlId = SJctrRemoteReplicationUtility.getJnlIdFromPair(urPairInfo);
        }
        this.checkMaxAddUrPairNumOfJournal(selectedJnlId, pvolCount);
        this.checkMaxAddUrPairNumOfMirror(selectedJnlId, selectedMirrorId, pvolCount);
        int ctg = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getCtgIdModel());
        this.checkMaxAddUrPairNumOfCtg(ctg, pvolCount);
        SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        int initCopyType = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE"));
        int mirror = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getMirrorSelectionDataModel().getMirrorIdModel());
        SJctrCreateRemotePairUtility.checkJnlStatus(jnlMgr, initCopyType, selectedJnlId, mirror);
        this.checkJnlMirrorInfo(modelId, selectedJnlId);
        boolean isRelative = this.getSelectionTypeDataModel().isRelative();
        int selectedInterval = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getIntervalValueDataModel());
        SJctrCreateUrPairsSelectedTableModel selectedTable = this.getSelectedUrPairsTable();
        String strSn = this.getSerialNumberStrFromModelSnStr(modelId, this.getRemoteSysModel().getModelSnModel().getSelection());
        List<Integer> usedSvolIndexList = this.getUsedLunUr(selectedTable.getAllRowData(), modelId, strSn);
        List<SJmoLuIndex> svolIndexList = SJctrCreateRemotePairUtility.getSvolLunList(selectedLdevs, usedSvolIndexList, selectedLdevs.size(), modelId, this.getBaseSVolModel(), isRelative, selectedInterval);
        List<SJctrCreateUniversalReplicatorPairVolInfo> pairVolList = this.getSelectedUrPairsList(selectedLdevs, svolIndexList, selectedJnlId);
        selectedTable.addRowDataTop(pairVolList);
        List<SJmoLdevIndex> selectedLdevIndex = this.getLdevIndexListFromSJctrPortLunTableKey(selectedLdevs);
        this.removeSelectedLdevFromAvailableTableBasicDataList(selectedLdevIndex);
        this.updateAvailableLdevsTableModelLun();
        this.addJnlMirrorPairNum(pvolCount, selectedJnlId);
        this.updateTotalNumOfMJnlMirror();
        int selectedCtgId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getCtgIdModel());
        this.updateCtgIdList(selectedCtgId);
    }

    private List<Integer> getUsedLunUr(List<Object> allRowData, int controllerId, String strSn) {
        ArrayList<Integer> usedLuIndexList = new ArrayList<Integer>(allRowData.size());
        Map<Short, String> remotePtMap = SJctrRemoteReplicationUtility.getPortNameMap(controllerId);
        ArrayList<Short> ptIndexList = new ArrayList<Short>(remotePtMap.keySet());
        for (Object rowData : allRowData) {
            SJctrCreateUniversalReplicatorPairVolInfo svolInfo = (SJctrCreateUniversalReplicatorPairVolInfo)rowData;
            if (svolInfo.getModelId() != controllerId || !svolInfo.getPairSN().equals(strSn)) continue;
            SJmoLuIndex luIndex = svolInfo.getSVolLuPath().getLuPath();
            int ptIndex = ptIndexList.indexOf(luIndex.getSPort());
            int ptHgLu = SJctrCreateRemotePairUtility.getPtHgLun(ptIndex, luIndex.getSHostGroup(), luIndex.getILUN());
            usedLuIndexList.add(ptHgLu);
        }
        return usedLuIndexList;
    }

    private void addUrmfPairAction() {
        SJctrCreatePairsAvailableTableModelLdev availableTable = this.getAvailableTableLdev();
        List<Object> selectedLdevs = availableTable.getSelectedRowDataOrder();
        if (selectedLdevs.isEmpty()) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "addUrmfPairAction", "Available LDEVs is not Selected.");
            return;
        }
        int pvolCount = this.getAvailableTableLdev().getSelectedRowCount();
        int selectedPairsCount = this.getSelectedUrPairsTable().getRowCount();
        this.checkMaxPairNum(pvolCount, selectedPairsCount);
        int modelId = this.getModelIdNumFromModelSnStr(this.getRemoteSysModel().getModelSnModel().getSelection());
        SJctrMirrorSelectionDataModel mirrorSelectionModel = this.getMirrorSelectionDataModel();
        int selectedJnlId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMasterJnlModel());
        int selectedMirrorId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMirrorIdModel());
        if ("COM_YES".equals(this.getUseExistUrPairsDataModel().getSelect())) {
            List<SJmoUniversalReplicatorPairVolInfo> selectedURPairList = this.getURPairListFromSelectedLDEVs(availableTable.getReplicationPairVolInfoList(), selectedLdevs);
            this.checkMultiPairCreate(selectedURPairList);
            SJmoUniversalReplicatorPairVolInfo urPairInfo = selectedURPairList.get(0);
            selectedJnlId = SJctrRemoteReplicationUtility.getJnlIdFromPair(urPairInfo);
        }
        this.checkMaxAddUrPairNumOfJournal(selectedJnlId, pvolCount);
        this.checkMaxAddUrPairNumOfMirror(selectedJnlId, selectedMirrorId, pvolCount);
        SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        int initCopyType = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE"));
        int mirror = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getMirrorSelectionDataModel().getMirrorIdModel());
        SJctrCreateRemotePairUtility.checkJnlStatus(jnlMgr, initCopyType, selectedJnlId, mirror);
        this.checkJnlMirrorInfo(modelId, selectedJnlId);
        boolean isRelative = this.getSelectionTypeDataModel().isRelative();
        int selectedInterval = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getIntervalValueDataModel());
        SJctrCreateUrPairsSelectedTableModel selectedTable = this.getSelectedUrPairsTable();
        String strSn = this.getSerialNumberStrFromModelSnStr(modelId, this.getRemoteSysModel().getModelSnModel().getSelection());
        List<Integer> usedLdevIndexList = this.getUsedLdevUrmf(selectedTable.getAllRowData(), modelId, strSn);
        List<SJmoLdevIndex> svolIndexList = SJctrCreateRemotePairUtility.getSvolLdevList(selectedLdevs, usedLdevIndexList, selectedLdevs.size(), this.copyType, modelId, this.getBaseSVolModel(), isRelative, selectedInterval);
        List<SJctrCreateUniversalReplicatorPairVolInfo> pairVolList = this.getSelectedUrmfPairsList(selectedLdevs, svolIndexList, selectedJnlId);
        selectedTable.addRowDataTop(pairVolList);
        this.removeSelectedLdevFromAvailableTableBasicDataList(selectedLdevs);
        this.updateAvailableLdevsTableModelLdev();
        this.addJnlMirrorPairNum(pvolCount, selectedJnlId);
        this.updateTotalNumOfMJnlMirror();
    }

    private void addJnlMirrorPairNum(int addPairNum, int selectedJnlId) {
        SJctrMirrorSelectionDataModel mirrorSelectionModel = this.getMirrorSelectionDataModel();
        int selectedRestoreJnlId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getRestoreJnlModel());
        int selectedMirrorId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMirrorIdModel());
        int selectedPathId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getPathGrpModel());
        int selectedCtgId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getCtgIdModel());
        String modelSn = this.getRemoteSysModel().getModelSnModel().getSelection();
        int controllerId = this.getModelIdNumFromModelSnStr(modelSn);
        String sn = this.getSerialNumberStrFromModelSnStr(controllerId, modelSn);
        SJctrJnlMirrorInfo jnlMirror = this.totalJnlMirrorInfo[selectedJnlId][selectedMirrorId];
        if (null == jnlMirror) {
            this.totalJnlMirrorInfo[selectedJnlId][selectedMirrorId] = jnlMirror = new SJctrJnlMirrorInfo(selectedJnlId, selectedMirrorId, selectedRestoreJnlId, selectedPathId, selectedCtgId, sn, 0);
        }
        jnlMirror.addPairNum(addPairNum);
        if (this.copyType == 2) {
            SJctrJnlMirrorInfo ctgInfo = this.totalCtgInfo[selectedCtgId];
            if (null == ctgInfo) {
                this.totalCtgInfo[selectedCtgId] = ctgInfo = new SJctrJnlMirrorInfo(selectedJnlId, selectedMirrorId, selectedRestoreJnlId, selectedPathId, selectedCtgId, sn, 0);
            }
            ctgInfo.addPairNum(addPairNum);
        }
    }

    private List<Integer> getUsedLdevUrmf(List<Object> allRowData, int controllerId, String strSn) {
        ArrayList<Integer> usedLdevIndexList = new ArrayList<Integer>(allRowData.size());
        for (Object rowData : allRowData) {
            SJctrCreateUniversalReplicatorPairVolInfo svolInfo = (SJctrCreateUniversalReplicatorPairVolInfo)rowData;
            if (svolInfo.getModelId() != controllerId || !svolInfo.getPairSN().equals(strSn)) continue;
            usedLdevIndexList.add(svolInfo.getIndex());
        }
        return usedLdevIndexList;
    }

    private void removeSelectedLdevFromAvailableTableBasicDataList(List<SJmoLdevIndex> selectedLdevList) {
        List<SJmoLdevDetail> basicDataList = this.availableLdevsBasicDataListMap.get(this.copyType);
        Collections.sort(basicDataList);
        for (SJmoLdevIndex selLdev : selectedLdevList) {
            int index = Collections.binarySearch(basicDataList, selLdev);
            if (index < 0) continue;
            basicDataList.remove(index);
        }
    }

    private List<SJmoLdevIndex> getLdevIndexListFromSJctrPortLunTableKey(List<SJctrPortLunTableKey> portLunList) {
        ArrayList<SJmoLdevIndex> ldevIndexList = new ArrayList<SJmoLdevIndex>(portLunList.size());
        for (SJctrPortLunTableKey portLun : portLunList) {
            SJmoPortLunDetail portLunDetail = portLun.getPortLunDetail();
            SJmoLdevIndex index = new SJmoLdevIndex();
            index.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
            ldevIndexList.add(index);
        }
        return ldevIndexList;
    }

    private List<SJctrCreateTrueCopyPairVolInfo> getSelectedTcPairsList(List<SJctrPortLunTableKey> pvolIndexList, List<SJmoLuIndex> svolIndexList) {
        ArrayList<SJctrCreateTrueCopyPairVolInfo> pairVolInfo = new ArrayList<SJctrCreateTrueCopyPairVolInfo>(pvolIndexList.size());
        if (pvolIndexList.size() != svolIndexList.size()) {
            return pairVolInfo;
        }
        for (int index = 0; index < pvolIndexList.size(); ++index) {
            SJmoPortLunDetail pvolIndex = pvolIndexList.get(index).getPortLunDetail();
            SJmoReplicationPairVolInfo pvol = new SJmoReplicationPairVolInfo();
            pvol.setIPairVolPos(1);
            pvol.setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDEV());
            SJctrCreateTrueCopyPairVolInfo svol = new SJctrCreateTrueCopyPairVolInfo();
            svol.setIPairVolPos(2);
            svol.setPairLU(svolIndexList.get(index));
            svol.setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDEV());
            svol.setLocalPortId(pvolIndex.getSPort());
            svol.setLocalHgId(pvolIndex.getSHostGroup());
            svol.setLocalLunId(pvolIndex.getSLUN());
            this.setTcPairOptionInfo(svol);
            svol.setICUFree(1);
            int pathId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getPathGrpModel());
            svol.setIPairRCUID(pathId);
            int copyPace = SJctrRemoteReplicationUtility.getValueTextBoxNum((SJctrTextBoxDataModel)this.getDataObjectModel("COM_COPY_PACE_TXT"));
            svol.setITracks(copyPace |= 0x80);
            ArrayList<SJctrCreateTrueCopyPairVolInfo> svolList = new ArrayList<SJctrCreateTrueCopyPairVolInfo>(1);
            svolList.add(svol);
            pvol.setAlSVolIndex(svolList);
            ArrayList<SJmoReplicationPairVolInfo> pvolList = new ArrayList<SJmoReplicationPairVolInfo>(1);
            pvolList.add(pvol);
            svol.setAlPVolIndex(pvolList);
            pairVolInfo.add(svol);
        }
        return pairVolInfo;
    }

    private List<SJctrCreateTrueCopyPairVolInfo> getSelectedTcmfPairsList(List<SJmoLdevDetail> pvolIndexList, List<SJmoLdevIndex> svolIndexList) {
        ArrayList<SJctrCreateTrueCopyPairVolInfo> pairVolInfo = new ArrayList<SJctrCreateTrueCopyPairVolInfo>(pvolIndexList.size());
        if (pvolIndexList.size() != svolIndexList.size()) {
            return pairVolInfo;
        }
        for (int index = 0; index < pvolIndexList.size(); ++index) {
            boolean hioTimeStampIsEnable;
            int dfwToSvol;
            SJmoLdevIndex pvolIndex = pvolIndexList.get(index);
            SJmoReplicationPairVolInfo pvol = new SJmoReplicationPairVolInfo();
            pvol.setIPairVolPos(32);
            pvol.setLdevIndex(pvolIndex.getSLdkc(), pvolIndex.getSCu(), pvolIndex.getSLdev());
            SJmoLdevIndex svolIndex = svolIndexList.get(index);
            SJctrCreateTrueCopyPairVolInfo svol = new SJctrCreateTrueCopyPairVolInfo();
            svol.setIPairVolPos(64);
            svol.setLocalPortId(0);
            svol.setLocalHgId(0);
            svol.setLocalLunId(0);
            svol.setLdevIndex(svolIndex.getSLdkc(), svolIndex.getSCu(), svolIndex.getSLdev());
            this.setTcPairOptionInfo(svol);
            svol.setICUFree(0);
            int ssid = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getCuSsidModel()) % 100000;
            svol.setIPairSSID(ssid);
            int copyPace = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_COPY_PACE_LIST"));
            svol.setITracks(copyPace);
            int cfwData = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_CFW_DATA"));
            if (1 == cfwData) {
                svol.getBehaviorBitSet().set(0);
            }
            if (1 == (dfwToSvol = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_DFW_TO_SVOL")))) {
                svol.getBehaviorBitSet().set(1);
            }
            if (hioTimeStampIsEnable = ((SJctrRadioButtonGroupDataModel)this.getDataObjectModel("COM_HIO_TIME_STAMP_TRANS")).getSelect().equals("COM_ENABLE")) {
                svol.getBehaviorBitSet().set(12);
            }
            ArrayList<SJctrCreateTrueCopyPairVolInfo> svolList = new ArrayList<SJctrCreateTrueCopyPairVolInfo>(1);
            svolList.add(svol);
            pvol.setAlSVolIndex(svolList);
            ArrayList<SJmoReplicationPairVolInfo> pvolList = new ArrayList<SJmoReplicationPairVolInfo>(1);
            pvolList.add(pvol);
            svol.setAlPVolIndex(pvolList);
            pairVolInfo.add(svol);
        }
        return pairVolInfo;
    }

    private void setTcPairOptionInfo(SJctrCreateTrueCopyPairVolInfo tcSvolInfo) {
        int controllerId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getModelSnModel()) / 1000000;
        tcSvolInfo.setIPairControllerID(controllerId);
        tcSvolInfo.setStrPairSN(this.getSerialNumberStrFromModelSnStr(controllerId, this.getRemoteSysModel().getModelSnModel().getSelection()));
        int pvolFenceLevel = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_PVOL_FENCE_LEVEL"));
        switch (pvolFenceLevel) {
            case 0: {
                break;
            }
            case 1: {
                tcSvolInfo.getBehaviorBitSet().set(2);
                break;
            }
            case 2: {
                tcSvolInfo.getBehaviorBitSet().set(3);
                break;
            }
        }
        tcSvolInfo.setInitCopyType(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE")));
        int initCopyPriority = SJctrRemoteReplicationUtility.getValueTextBoxNum((SJctrTextBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_PRIORITY"));
        tcSvolInfo.setIPriority(initCopyPriority);
    }

    private List<SJctrCreateUniversalReplicatorPairVolInfo> getSelectedUrPairsList(List<SJctrPortLunTableKey> pvolIndexList, List<SJmoLuIndex> svolIndexList, int selectedJnlId) {
        ArrayList<SJctrCreateUniversalReplicatorPairVolInfo> pairVolInfo = new ArrayList<SJctrCreateUniversalReplicatorPairVolInfo>(pvolIndexList.size());
        if (pvolIndexList.size() != svolIndexList.size()) {
            return pairVolInfo;
        }
        for (int index = 0; index < pvolIndexList.size(); ++index) {
            SJmoPortLunDetail pvolIndex = pvolIndexList.get(index).getPortLunDetail();
            SJmoReplicationPairVolInfo pvol = new SJmoReplicationPairVolInfo();
            pvol.setIPairVolPos(4096);
            pvol.setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDEV());
            SJctrCreateUniversalReplicatorPairVolInfo svol = new SJctrCreateUniversalReplicatorPairVolInfo();
            svol.setIPairVolPos(8192);
            svol.setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDEV());
            SJmoLuIndex pluIndex = new SJmoLuIndex();
            pluIndex.setSPort(pvolIndex.getSPort());
            pluIndex.setSHostGroup(pvolIndex.getSHostGroup());
            pluIndex.setILUN(pvolIndex.getSLUN());
            svol.getPVolLuPath().setLuPath(pluIndex);
            svol.getPVolLuPath().setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDKC());
            svol.getSVolLuPath().setLuPath(svolIndexList.get(index));
            this.setUrPairOptionInfo(svol, selectedJnlId);
            ArrayList<SJctrCreateUniversalReplicatorPairVolInfo> svolList = new ArrayList<SJctrCreateUniversalReplicatorPairVolInfo>();
            svolList.add(svol);
            pvol.setAlSVolIndex(svolList);
            ArrayList<SJmoReplicationPairVolInfo> pvolList = new ArrayList<SJmoReplicationPairVolInfo>();
            pvolList.add(pvol);
            svol.setAlPVolIndex(pvolList);
            pairVolInfo.add(svol);
        }
        return pairVolInfo;
    }

    private List<SJctrCreateUniversalReplicatorPairVolInfo> getSelectedUrmfPairsList(List<SJmoLdevDetail> pvolIndexList, List<SJmoLdevIndex> svolIndexList, int selectedJnlId) {
        ArrayList<SJctrCreateUniversalReplicatorPairVolInfo> pairVolInfo = new ArrayList<SJctrCreateUniversalReplicatorPairVolInfo>(pvolIndexList.size());
        if (pvolIndexList.size() != svolIndexList.size()) {
            return pairVolInfo;
        }
        for (int index = 0; index < pvolIndexList.size(); ++index) {
            SJmoLdevIndex pvolIndex = pvolIndexList.get(index);
            SJmoReplicationPairVolInfo pvol = new SJmoReplicationPairVolInfo();
            pvol.setIPairVolPos(131072);
            pvol.setLdevIndex(pvolIndex.getSLdkc(), pvolIndex.getSCu(), pvolIndex.getSLdev());
            SJmoLdevIndex svolIndex = svolIndexList.get(index);
            SJctrCreateUniversalReplicatorPairVolInfo svol = new SJctrCreateUniversalReplicatorPairVolInfo();
            svol.setIPairVolPos(262144);
            svol.getPVolLuPath().setLdevIndex(pvol.getSLdkc(), pvol.getSCu(), pvol.getSLdev());
            svol.setLdevIndex(svolIndex.getSLdkc(), svolIndex.getSCu(), svolIndex.getSLdev());
            this.setUrPairOptionInfo(svol, selectedJnlId);
            ArrayList<SJctrCreateUniversalReplicatorPairVolInfo> svolList = new ArrayList<SJctrCreateUniversalReplicatorPairVolInfo>();
            svolList.add(svol);
            pvol.setAlSVolIndex(svolList);
            ArrayList<SJmoReplicationPairVolInfo> pvolList = new ArrayList<SJmoReplicationPairVolInfo>();
            pvolList.add(pvol);
            svol.setAlPVolIndex(pvolList);
            pairVolInfo.add(svol);
        }
        return pairVolInfo;
    }

    private void setUrPairOptionInfo(SJctrCreateUniversalReplicatorPairVolInfo urSvolInfo, int selectJnlId) {
        int controllerId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getModelSnModel()) / 1000000;
        urSvolInfo.setModelId(controllerId);
        urSvolInfo.setPairSN(this.getSerialNumberStrFromModelSnStr(controllerId, this.getRemoteSysModel().getModelSnModel().getSelection()));
        int pathGrpId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getPathGrpModel());
        urSvolInfo.setPathID(pathGrpId);
        urSvolInfo.setPathIDEnable(1);
        urSvolInfo.setMJnlGrpId(selectJnlId);
        urSvolInfo.setMirrorId(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getMirrorSelectionDataModel().getMirrorIdModel()));
        urSvolInfo.setRJnlGrpId(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getMirrorSelectionDataModel().getRestoreJnlModel()));
        switch (this.copyType) {
            case 2: {
                urSvolInfo.setCtgEnable(1);
                break;
            }
            case 3: {
                urSvolInfo.setCtgEnable(0);
                break;
            }
        }
        urSvolInfo.setCtgId(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_CTG_ID")));
        urSvolInfo.setInitCopyType(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE")));
        int initCopyPriority = SJctrRemoteReplicationUtility.getValueTextBoxNum((SJctrTextBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_PRIORITY"));
        urSvolInfo.setCopyPriority(initCopyPriority);
        int errorLevel = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_ERROR_LEVEL"));
        urSvolInfo.setErrLv(errorLevel);
        urSvolInfo.setCFW(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_CFW")));
    }

    private void removeAction() {
        SJctrTableDataModel table = this.getSelectedPairsTable();
        List<Object> selectedRowList = table.removeSelectedRowData();
        List<SJmoLdevDetail> availableBasicList = this.availableLdevsBasicDataListMap.get(this.copyType);
        List<SJmoLdevDetail> modelLdevDetail = SJctrReplicationUtility.getSJmoLdevDetail(this);
        Collections.sort(modelLdevDetail);
        for (Object rowData : selectedRowList) {
            SJmoReplicationPairVolInfo pairInfo = (SJmoReplicationPairVolInfo)rowData;
            SJmoLdevIndex pvol = pairInfo.getPVolIndex();
            int index = Collections.binarySearch(modelLdevDetail, pvol);
            if (index >= 0) {
                availableBasicList.add(modelLdevDetail.get(index));
            }
            this.decrementJnlMirrorPairNum(rowData);
        }
        Collections.sort(availableBasicList);
        this.updateAvailableLdevsTable();
        switch (this.copyType) {
            case 2: {
                this.updateTotalNumOfMJnlMirror();
                int ctgId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getCtgIdModel());
                this.updateCtgIdList(ctgId);
                break;
            }
            case 3: {
                this.updateTotalNumOfMJnlMirror();
                break;
            }
        }
        this.setInitCopyTypeNoneErrInfo(table.getAllRowData());
        this.updateFooter();
        this.setDirtyAll();
    }

    private void decrementJnlMirrorPairNum(Object rowData) {
        switch (this.copyType) {
            case 2: {
                SJctrJnlMirrorInfo ctgInfo;
                SJctrCreateUniversalReplicatorPairVolInfo urPairInfo = (SJctrCreateUniversalReplicatorPairVolInfo)rowData;
                SJctrJnlMirrorInfo jnlMirror = this.totalJnlMirrorInfo[urPairInfo.getMJnlGrpId()][urPairInfo.getMirrorId()];
                if (null != jnlMirror) {
                    jnlMirror.addPairNum(-1);
                    if (jnlMirror.getNumOfPair() == 0) {
                        this.totalJnlMirrorInfo[urPairInfo.getMJnlGrpId()][urPairInfo.getMirrorId()] = null;
                    }
                }
                if (null == (ctgInfo = this.totalCtgInfo[urPairInfo.getCtgId()])) break;
                ctgInfo.addPairNum(-1);
                if (ctgInfo.getNumOfPair() != 0) break;
                this.totalCtgInfo[urPairInfo.getCtgId()] = null;
                break;
            }
            case 3: {
                SJctrCreateUniversalReplicatorPairVolInfo urPairInfo = (SJctrCreateUniversalReplicatorPairVolInfo)rowData;
                SJctrJnlMirrorInfo jnlMirror = this.totalJnlMirrorInfo[urPairInfo.getMJnlGrpId()][urPairInfo.getMirrorId()];
                if (null == jnlMirror) break;
                jnlMirror.addPairNum(-1);
                if (jnlMirror.getNumOfPair() != 0) break;
                this.totalJnlMirrorInfo[urPairInfo.getMJnlGrpId()][urPairInfo.getMirrorId()] = null;
                break;
            }
        }
    }

    private void makeChangeSettings() {
        SJctrTableDataModel table = this.getSelectedPairsTable();
        if (null == table) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "makeChangeSettings", "Available Table Object is null.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        List<Object> selectedPairs = table.getSelectedRowDataOrder();
        if (selectedPairs.isEmpty()) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "makeChangeSettings", "Available Table Object is null.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        this.checkSelectedPairRcu(selectedPairs);
        ArrayList<Object> cloneSelectedPairs = new ArrayList<Object>(selectedPairs.size());
        for (Object rowData : selectedPairs) {
            SJmoReplicationPairVolInfo pairInfo = (SJmoReplicationPairVolInfo)rowData;
            try {
                cloneSelectedPairs.add(pairInfo.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "makeChangeSettings", "CloneNotSupportedException occured.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_PAIRS", cloneSelectedPairs);
        List<Object> allRowData = table.getAllRowData();
        allRowData.removeAll(selectedPairs);
        Class clazz = null;
        List<Integer> usedSvolIndexList = null;
        Object selectedPairInfo = selectedPairs.get(0);
        int controllerId = -1;
        String strSn = null;
        switch (this.copyType) {
            case 0: {
                clazz = SJctrChangeTcSettingsDC.class;
                controllerId = ((SJctrCreateTrueCopyPairVolInfo)selectedPairInfo).getIPairControllerID();
                strSn = ((SJctrCreateTrueCopyPairVolInfo)selectedPairInfo).getStrPairSN();
                usedSvolIndexList = this.getUsedLunTc(allRowData, controllerId, strSn);
                break;
            }
            case 1: {
                clazz = SJctrChangeTcmfSettingsDC.class;
                short rcu = ((SJmoLdevIndex)selectedPairs.get(0)).getSCu();
                controllerId = ((SJctrCreateTrueCopyPairVolInfo)selectedPairInfo).getIPairControllerID();
                strSn = ((SJctrCreateTrueCopyPairVolInfo)selectedPairInfo).getStrPairSN();
                usedSvolIndexList = this.getUsedLdevTcmf(allRowData, rcu, controllerId, strSn);
                break;
            }
            case 2: {
                clazz = SJctrChangeUrSettingsDC.class;
                controllerId = ((SJctrCreateUniversalReplicatorPairVolInfo)selectedPairInfo).getModelId();
                strSn = ((SJctrCreateUniversalReplicatorPairVolInfo)selectedPairInfo).getPairSN();
                usedSvolIndexList = this.getUsedLunUr(allRowData, controllerId, strSn);
                break;
            }
            case 3: {
                clazz = SJctrChangeUrmfSettingsDC.class;
                controllerId = ((SJctrCreateUniversalReplicatorPairVolInfo)selectedPairInfo).getModelId();
                strSn = ((SJctrCreateUniversalReplicatorPairVolInfo)selectedPairInfo).getPairSN();
                usedSvolIndexList = this.getUsedLdevUrmf(allRowData, controllerId, strSn);
                break;
            }
        }
        if (null == clazz || null == usedSvolIndexList) {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "makeChangeSettings", "Selected Copy Type is not support.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        param.put("KEY_USED_SVOL_INDEX_LIST", usedSvolIndexList);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(clazz, param);
        this.addUpdateDisp(dialogRelated);
    }

    private void checkSelectedPairRcu(List<Object> selectedPairList) {
        switch (this.copyType) {
            case 0: {
                this.checkSelectedPairRcuTc(selectedPairList);
                break;
            }
            case 1: {
                this.checkSelectedPairRcuTcmf(selectedPairList);
                break;
            }
            case 2: 
            case 3: {
                this.checkSelectedPairRcuUr(selectedPairList);
                break;
            }
        }
    }

    private void checkSelectedPairRcuTc(List<Object> selectedPairList) {
        SJctrCreateTrueCopyPairVolInfo pairInfoTop = (SJctrCreateTrueCopyPairVolInfo)selectedPairList.get(0);
        int topControllerId = pairInfoTop.getIPairControllerID();
        String topSerialNum = pairInfoTop.getStrPairSN();
        for (Object selectedPair : selectedPairList) {
            SJctrCreateTrueCopyPairVolInfo pairInfo = (SJctrCreateTrueCopyPairVolInfo)selectedPair;
            if (topControllerId == pairInfo.getIPairControllerID() && topSerialNum.equals(pairInfo.getStrPairSN())) continue;
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206038);
        }
    }

    private void checkSelectedPairRcuTcmf(List<Object> selectedPairList) {
        SJctrCreateTrueCopyPairVolInfo pairInfoTop = (SJctrCreateTrueCopyPairVolInfo)selectedPairList.get(0);
        int topControllerId = pairInfoTop.getIPairControllerID();
        String topSerialNum = pairInfoTop.getStrPairSN();
        short topCu = pairInfoTop.getSCu();
        for (Object selectedPair : selectedPairList) {
            SJctrCreateTrueCopyPairVolInfo pairInfo = (SJctrCreateTrueCopyPairVolInfo)selectedPair;
            if (topControllerId == pairInfo.getIPairControllerID() && topSerialNum.equals(pairInfo.getStrPairSN()) && topCu == pairInfo.getSCu()) continue;
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206038);
        }
    }

    private void checkSelectedPairRcuUr(List<Object> selectedPairList) {
        SJctrCreateUniversalReplicatorPairVolInfo pairInfoTop = (SJctrCreateUniversalReplicatorPairVolInfo)selectedPairList.get(0);
        int topControllerId = pairInfoTop.getModelId();
        String topSerialNum = pairInfoTop.getPairSN();
        for (Object selectedPair : selectedPairList) {
            SJctrCreateUniversalReplicatorPairVolInfo pairInfo = (SJctrCreateUniversalReplicatorPairVolInfo)selectedPair;
            if (topControllerId == pairInfo.getModelId() && topSerialNum.equals(pairInfo.getPairSN())) continue;
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206038);
        }
    }

    private void exitDialogAction(Map<String, List<?>> carryMap) {
        List<Object> pairList = carryMap.get("KEY_SELECTED_PAIRS");
        if (pairList != null && pairList.size() > 0) {
            SJctrTableDataModel table = this.getSelectedPairsTable();
            int[] selRowIndex = table.getSelectedRows();
            if (selRowIndex.length != pairList.size()) {
                SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "exitDialogAction", "Selected pair size is unmached.");
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
            }
            table.removeSelectedRowData();
            ArrayList<Object> tmpList = new ArrayList<Object>(1);
            ArrayList<Object> addList = null;
            for (int i = 0; i < pairList.size(); ++i) {
                tmpList.add(pairList.get(i));
                addList = tmpList;
                table.addRowData(addList, selRowIndex[i]);
                tmpList.clear();
            }
            table.addRowSelectionList(pairList);
            this.setInitCopyTypeNoneErrInfo(table.getAllRowData());
            this.updateFooter();
        }
    }

    private void updateLocalCuModel() {
        SJctrComboBoxDataModel localCuModel = this.getLocalCuDataModel();
        localCuModel.removeAllItems();
        for (Integer cuNo : this.availableCuList) {
            localCuModel.addItem(String.valueOf(cuNo), SJctrComUtility.toHexString(cuNo, 2, true));
        }
        localCuModel.setSelectedIndex(0);
        localCuModel.setDirtyAll();
    }

    private void updateModelSnModel() {
        SJctrComboBoxDataModel modelSnModel = this.getRemoteSysModel().getModelSnModel();
        modelSnModel.removeAllItems();
        Collection<Object> modelSnList = new HashSet();
        switch (this.copyType) {
            case 0: 
            case 2: 
            case 3: {
                modelSnList = this.getCuFreeModelSnList();
                break;
            }
            case 1: {
                int selectedLocalCu = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getLocalCuDataModel());
                modelSnList = this.limitedCuMrcuInfoMap.get(selectedLocalCu).keySet();
                break;
            }
        }
        for (String modelSnStr : modelSnList) {
            modelSnModel.addItem(modelSnStr, this.getModelSnDisplayStr(modelSnStr));
        }
        modelSnModel.setSelectedIndex(this.getInitModelSnIndex(modelSnList));
        modelSnModel.setDirtyAll();
    }

    private Collection<String> getCuFreeModelSnList() {
        Collection<String> ret = null;
        switch (this.copyType) {
            case 0: {
                ret = this.cuFreeMrcuInfoMap.keySet();
                break;
            }
            case 2: 
            case 3: {
                ret = this.getCuFreeModelSnListForUr();
                break;
            }
            default: {
                ret = new ArrayList<String>(0);
            }
        }
        return ret;
    }

    private List<String> getCuFreeModelSnListForUr() {
        ArrayList<String> ret = new ArrayList<String>(this.cuFreeMrcuInfoMap.size());
        Set<String> modelSnList = this.cuFreeMrcuInfoMap.keySet();
        for (String modelSnStr : modelSnList) {
            if (!this.isEnableUseRemoteStorageForUr(modelSnStr, this.copyType)) continue;
            ret.add(modelSnStr);
        }
        return ret;
    }

    private int getInitModelSnIndex(Collection<String> modelSnList) {
        int initIndex = 0;
        Object[] modelSnItemList = modelSnList.toArray();
        for (int i = 0; i < modelSnItemList.length; ++i) {
            int controllerId = this.getModelIdNumFromModelSnStr((String)modelSnItemList[i]);
            if (controllerId != this.localModelId) continue;
            initIndex = i;
            break;
        }
        return initIndex;
    }

    private String getModelSnDisplayStr(String modelSnStr) {
        int controllerId = this.getModelIdNumFromModelSnStr(modelSnStr);
        String snStr = this.getSerialNumberStrFromModelSnStr(controllerId, modelSnStr);
        String dispStr = this.getComUtility().getRemoteReplicationUtility().getModelSNoString(controllerId, snStr);
        return dispStr;
    }

    private int getModelIdNumFromModelSnStr(String modelSnStr) {
        int modelId = -1;
        try {
            modelId = Integer.valueOf(modelSnStr);
        }
        catch (NumberFormatException e) {
            return modelId;
        }
        return modelId /= 1000000;
    }

    private String getSerialNumberStrFromModelSnStr(int controllerId, String modelSnStr) {
        int snLength;
        switch (controllerId) {
            case 6: 
            case 7: {
                snLength = 5;
                break;
            }
            case 18: 
            case 19: {
                snLength = 6;
                break;
            }
            default: {
                snLength = SJctrDataController.isHM() ? 6 : 5;
            }
        }
        String snStr = "?";
        if (modelSnStr.length() >= snLength) {
            snStr = modelSnStr.substring(modelSnStr.length() - snLength);
        }
        return snStr;
    }

    private void updatePathGrpIdModel() {
        SJctrComboBoxDataModel pathGrpModel = this.getRemoteSysModel().getPathGrpModel();
        pathGrpModel.removeAllItems();
        String selectedModelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        boolean isEnableUseAllPathId = this.isEnableUseAllPathId(selectedModelSnStr);
        Set pathGrpIdList = this.cuFreeMrcuInfoMap.get(selectedModelSnStr);
        for (Integer pathGrpId : pathGrpIdList) {
            if (!isEnableUseAllPathId && 0 != pathGrpId) continue;
            pathGrpModel.addItem(pathGrpId.toString(), SJctrComUtility.toHexString(pathGrpId, 2, true));
        }
        pathGrpModel.setSelectedIndex(0);
        pathGrpModel.setDirtyAll();
    }

    private void updateUseExistUrPairsModel() {
        List<SJmoLdevDetail> avalableLdevList = this.availableLdevsBasicDataListMap.get(this.copyType);
        SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        boolean isExistUsePairLdev = false;
        boolean isExistNotUsePairLdev = false;
        for (SJmoLdevIndex sJmoLdevIndex : avalableLdevList) {
            if (urPairVolInfoMgr.getPairVolInfo(sJmoLdevIndex) != null) {
                isExistUsePairLdev = true;
            } else {
                isExistNotUsePairLdev = true;
            }
            if (!isExistUsePairLdev || !isExistNotUsePairLdev) continue;
            break;
        }
        SJctrRadioButtonGroupDataModel useExistUrPairsDataModel = this.getUseExistUrPairsDataModel();
        if (isExistUsePairLdev) {
            useExistUrPairsDataModel.setEnable("COM_YES", true);
        } else {
            useExistUrPairsDataModel.setEnable("COM_YES", false);
        }
        if (isExistNotUsePairLdev) {
            useExistUrPairsDataModel.setEnable("COM_NO", true);
            useExistUrPairsDataModel.setSelect("COM_NO");
        } else {
            useExistUrPairsDataModel.setEnable("COM_NO", false);
            useExistUrPairsDataModel.setSelect("COM_YES");
        }
        useExistUrPairsDataModel.setDirty();
    }

    private boolean isEnableUseAllPathId(String controllerIdStr) {
        boolean ret = false;
        block0 : switch (this.copyType) {
            case 0: {
                ret = true;
                break;
            }
            case 2: 
            case 3: {
                int controllerId = this.getModelIdNumFromModelSnStr(controllerIdStr);
                switch (controllerId) {
                    case 5: {
                        ret = false;
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        ret = true;
                        break block0;
                    }
                }
                ret = this.isAvailableControllerId(controllerId);
                break;
            }
        }
        return ret;
    }

    private void updateCuSsidModel() {
        int selectedLocalCu = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getLocalCuDataModel());
        SJctrComboBoxDataModel cuSsidModel = this.getRemoteSysModel().getCuSsidModel();
        cuSsidModel.removeAllItems();
        TreeMap<String, TreeSet<String>> limitedMrcuInfoMap = this.limitedCuMrcuInfoMap.get(selectedLocalCu);
        String selectedModelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        Set cuSsidList = limitedMrcuInfoMap.get(selectedModelSnStr);
        for (String cuSsid : cuSsidList) {
            cuSsidModel.addItem(cuSsid, this.createCuSsidStr(cuSsid));
        }
        cuSsidModel.setSelectedIndex(0);
        cuSsidModel.setDirtyAll();
    }

    private String createCuSsidStr(String cuSsid) {
        int cu = -1;
        int ssid = -1;
        try {
            cu = Integer.valueOf(cuSsid) / 100000;
            ssid = Integer.valueOf(cuSsid) % 100000;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String cuSsidStr = SJctrComUtility.toHexString(cu, 2, true) + " " + "/" + " " + SJctrComUtility.toHexString(ssid, 4, true);
        return cuSsidStr;
    }

    private void updateSelectionObjectModel() {
        SJctrRadioButtonGroupDataModel radSelectionObject = this.getSelectionObjectRadioButtonModel();
        radSelectionObject.setEnable("COM_FIBRE", false);
        radSelectionObject.setEnable("COM_ISCSI", false);
        radSelectionObject.setEnable("COM_HNAS_PLATFORM_USER", false);
        List<SJmoPortDetail> portDetailList = SJctrReplicationUtility.getSJmoPortDetail(this);
        Collections.sort(portDetailList);
        List<SJmoPortLunInfo> availablePortLunInfoList = this.availablePortLun.get(this.copyType);
        if (this.copyType == 2 || this.copyType == 3) {
            List<SJmoLdevDetail> ldevList = this.getAvailablePvolForUrUrmf(this.availableLdevsInitialBasicDataListMap.get(this.copyType));
            availablePortLunInfoList = this.getAvailablePortLunInfoListFromAvailalePvol(availablePortLunInfoList, ldevList);
        }
        for (SJmoPortLunInfo availablePortLunInfo : availablePortLunInfoList) {
            int index = Collections.binarySearch(portDetailList, availablePortLunInfo);
            if (index < 0) {
                SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "updateSelectionObjectModel", "Port Detail is not found: " + availablePortLunInfo.getIndex());
                continue;
            }
            SJmoPortDetail portDetail = portDetailList.get(index);
            if (SJctrPortUtility.isFibrePort(portDetail)) {
                radSelectionObject.setEnable("COM_FIBRE", true);
                continue;
            }
            if (SJctrIscsiUtility.isIscsiPort(portDetail)) {
                radSelectionObject.setEnable("COM_ISCSI", true);
                continue;
            }
            if (!SJctrPortUtility.isHnasUserPort(portDetail)) continue;
            radSelectionObject.setEnable("COM_HNAS_PLATFORM_USER", true);
        }
        if (radSelectionObject.isEnable("COM_FIBRE")) {
            radSelectionObject.setSelect("COM_FIBRE");
        } else if (radSelectionObject.isEnable("COM_ISCSI")) {
            radSelectionObject.setSelect("COM_ISCSI");
        } else if (radSelectionObject.isEnable("COM_HNAS_PLATFORM_USER")) {
            radSelectionObject.setSelect("COM_HNAS_PLATFORM_USER");
        } else {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "updateSelectionObjectModel", "There is no active item.");
        }
        ArrayList<SJmoChaDetail> chaDetailList = SJctrRemoteReplicationUtility.getSJmoChaDetailList(this);
        boolean hfbPackInst = SJmoChaUtility.isHfbPkInstall(chaDetailList);
        SJctrDataObject selectionObjData = this.getManageData();
        selectionObjData.setData("COM_SELECTION_OBJECT_HNAS_VISIBLE", hfbPackInst);
        radSelectionObject.setDirtyAll();
    }

    private List<SJmoPortLunInfo> getAvailablePortLunInfoListFromAvailalePvol(List<SJmoPortLunInfo> availablePortLunInfoList, List<SJmoLdevDetail> ldevList) {
        ArrayList<SJmoPortLunInfo> availableMultiPotLunInfoList = new ArrayList<SJmoPortLunInfo>();
        Collections.sort(ldevList);
        block0: for (SJmoPortLunInfo portLunInfo : availablePortLunInfoList) {
            for (SJmoPortLunDetail portLunDetail : portLunInfo.getAlPortLun()) {
                SJmoLdevIndex ldev = new SJmoLdevIndex();
                ldev.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
                int index = Collections.binarySearch(ldevList, ldev);
                if (index < 0) continue;
                availableMultiPotLunInfoList.add(portLunInfo);
                continue block0;
            }
        }
        return availableMultiPotLunInfoList;
    }

    private void updateLocalPortIdModel() {
        SJctrComboBoxDataModel localPortIdModel = this.getLocalPortIdModel();
        localPortIdModel.removeAllItems();
        List<SJmoPortLunInfo> availablePortList = this.availablePortLun.get(this.copyType);
        List<SJmoPortDetail> portDetailList = SJctrRsgUtility.getSJmoPortDetail(this);
        Collections.sort(portDetailList);
        SJctrRadioButtonGroupDataModel selectionObject = this.getSelectionObjectRadioButtonModel();
        byte kind = -1;
        if ("COM_FIBRE".equals(selectionObject.getSelect())) {
            kind = 2;
        } else if ("COM_ISCSI".equals(selectionObject.getSelect())) {
            kind = 5;
        } else if ("COM_HNAS_PLATFORM_USER".equals(selectionObject.getSelect())) {
            kind = 7;
        } else {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "updateLocalPortIdModel", "Portkind is invalid : [" + kind + "]");
        }
        for (SJmoPortLunInfo portLunInfo : availablePortList) {
            SJmoPortDetail portDetailInfo;
            int index = Collections.binarySearch(portDetailList, portLunInfo);
            if (index < 0 || (portDetailInfo = portDetailList.get(index)).getByPortKindNo() != kind) continue;
            localPortIdModel.addItem(String.valueOf(portDetailInfo.getSPort()), portDetailInfo.getStrPortDisplayName());
        }
        localPortIdModel.setSelectedIndex(0);
        localPortIdModel.setDirtyAll();
    }

    private void updateLocalHgNameModel() {
        SJmoPortIndex portIndexData;
        SJctrComboBoxDataModel localHgPulldownList = this.getLocalHgNameModel();
        localHgPulldownList.removeAllItems();
        List<? extends SJmoPortIndex> hgtgList = this.getSortedByNameHostGroupInfoList();
        if (!hgtgList.isEmpty()) {
            localHgPulldownList.addItem("ANY", this.getComUtility().getGuidance("ANY"));
        }
        if ((portIndexData = hgtgList.get(0)) instanceof SJmoIscsiTargetInfo) {
            List<? extends SJmoPortIndex> tgList = hgtgList;
            for (SJmoIscsiTargetInfo sJmoIscsiTargetInfo : tgList) {
                String tgDispStr = this.getComUtility().getIscsiUtility().getIscsiTargetAliasIdString(sJmoIscsiTargetInfo);
                localHgPulldownList.addItem(String.valueOf(sJmoIscsiTargetInfo.getSIscsiTarget()), tgDispStr);
            }
            this.getManageData().setData(KEY_HG_TG_PULLDOWN_TITLE, this.getComUtility().getGuidance("ISCSI_TARGET_ALIAS"));
        } else {
            List<? extends SJmoPortIndex> hgList = hgtgList;
            for (SJmoHostGroupInfo sJmoHostGroupInfo : hgList) {
                String hgDispStr = this.getComUtility().getPortUtility().toHostGroupNameDisplay(sJmoHostGroupInfo);
                localHgPulldownList.addItem(String.valueOf(sJmoHostGroupInfo.getSHostGroup()), hgDispStr);
            }
            this.getManageData().setData(KEY_HG_TG_PULLDOWN_TITLE, this.getComUtility().getGuidance("HG_NAME"));
        }
        localHgPulldownList.setSelectedIndex(0);
        localHgPulldownList.setDirtyAll();
    }

    private List<? extends SJmoPortIndex> getSortedByNameHostGroupInfoList() {
        int selectedPortId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getLocalPortIdModel());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort((short)selectedPortId);
        List<? extends SJmoPortIndex> portHgTgInfoList = this.availablePortHg.get(this.copyType);
        Collections.sort(portHgTgInfoList);
        int index = Collections.binarySearch(portHgTgInfoList, portIndex);
        Comparator<Object> portInfoComparator = null;
        ArrayList hgInfoList = null;
        if (index >= 0) {
            SJmoPortIndex portObject = portHgTgInfoList.get(index);
            if (portObject instanceof SJmoPortIscsiTargetInfo) {
                SJmoPortIscsiTargetInfo selectedPortTgInfo = (SJmoPortIscsiTargetInfo)portObject;
                hgInfoList = selectedPortTgInfo.getAlPortIscsiTarget();
                portInfoComparator = new SJctrIscsiTargetAliasComparator();
            } else {
                SJmoPortHostGroupInfo selectedPortHgInfo = (SJmoPortHostGroupInfo)portObject;
                hgInfoList = selectedPortHgInfo.getAlPortHostGroup();
                portInfoComparator = new SJctrHostGroupNameComparator();
            }
        } else {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "getSortedByNameHostGroupInfoList", "Host Group / ISCSI Target info is null.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        Collections.sort(hgInfoList, portInfoComparator);
        return hgInfoList;
    }

    private void updateAvailableLdevsTable() {
        switch (this.copyType) {
            case 0: 
            case 2: {
                this.updateAvailableLdevsTableModelLun();
                break;
            }
            case 1: 
            case 3: {
                this.updateAvailableLdevsTableModelLdev();
                break;
            }
        }
    }

    private void updateAvailableLdevsTableModelLun() {
        List<SJmoPortLunInfo> portLunInfoList = this.availablePortLun.get(this.copyType);
        int selectedPortId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getLocalPortIdModel());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort((short)selectedPortId);
        String selectedLocalHgName = this.getLocalHgNameModel().getSelection();
        ArrayList<SJctrPortLunTableKey> basicDataList = new ArrayList();
        List<SJmoLdevIndex> ldevList = this.availableLdevsBasicDataListMap.get(this.copyType);
        if (this.copyType == 2) {
            ldevList = this.getAvailablePvolForUrUrmf(ldevList);
        }
        if ("ANY".equals(selectedLocalHgName)) {
            basicDataList = this.getLunTableKeyListByPort(portLunInfoList, ldevList, portIndex);
        } else {
            List<SJmoPortLunInfo> portLunList = this.getSelectedHostGroupLun(portLunInfoList, portIndex);
            basicDataList = SJctrPortUtility.getPortLunListFromLdevDetail(ldevList, portLunList, new ArrayList<Boolean>());
        }
        Collections.sort(basicDataList);
        SJctrCreatePairsAvailableTableModelLun table = this.getAvailableTableLun();
        table.setCopyType(this.copyType);
        table.setBasicDataList(basicDataList);
        if (SJctrCreateRemotePairConst.REQUIRED_PAIRED_INFO_COPYTYPE.contains(this.copyType)) {
            ArrayList<SJmoLdevIndex> availableLdexIndexList = new ArrayList<SJmoLdevIndex>(basicDataList.size());
            for (SJctrPortLunTableKey tableKey : basicDataList) {
                SJmoPortLunDetail lunDetail = tableKey.getPortLunDetail();
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
                availableLdexIndexList.add(ldevIndex);
            }
            List<SJmoReplicationPairVolInfo> pairVolInfoList = this.getSortedAvaLdevsURReplicaPairVolInfoList(availableLdexIndexList);
            table.setReplicationPairVolInfoList(pairVolInfoList);
        }
        if (this.isInitialized) {
            table.doRefresh();
        }
        table.setDirtyAll();
    }

    private List<SJmoLdevDetail> getLdevDetailListFilteredByLocalCu(List<SJmoLdevDetail> sourceList) {
        ArrayList<SJmoLdevDetail> filteredList = new ArrayList<SJmoLdevDetail>(sourceList.size());
        int selectedLocalCu = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getLocalCuDataModel());
        for (SJmoLdevDetail ldev : sourceList) {
            if (selectedLocalCu != ldev.getSCu()) continue;
            filteredList.add(ldev);
        }
        return filteredList;
    }

    private List<SJctrPortLunTableKey> getLunTableKeyListByPort(List<SJmoPortLunInfo> availablePortLunList, List<SJmoLdevIndex> ldevList, SJmoPortIndex portIndex) {
        List<SJctrPortLunTableKey> portLunKeyList = null;
        int index = Collections.binarySearch(availablePortLunList, portIndex);
        if (index >= 0) {
            ArrayList<SJmoPortLunInfo> needPortList = new ArrayList<SJmoPortLunInfo>();
            needPortList.add(availablePortLunList.get(index));
            portLunKeyList = SJctrPortUtility.getPortLunListFromLdevDetail(ldevList, needPortList, new ArrayList<Boolean>());
        } else {
            portLunKeyList = new ArrayList<SJctrPortLunTableKey>(0);
        }
        List<SJctrPortLunTableKey> basicDataList = this.extractPortLunTableKey(portLunKeyList);
        return basicDataList;
    }

    private List<SJctrPortLunTableKey> extractPortLunTableKey(List<SJctrPortLunTableKey> portLunList) {
        ArrayList<SJctrPortLunTableKey> basicDataList = new ArrayList<SJctrPortLunTableKey>(portLunList.size());
        for (SJctrPortLunTableKey keyPortLun : portLunList) {
            short keyLdkc = keyPortLun.getPortLunDetail().getSLDKC();
            short keyCu = keyPortLun.getPortLunDetail().getSCU();
            short keyLdev = keyPortLun.getPortLunDetail().getSLDEV();
            boolean addFlg = true;
            for (SJctrPortLunTableKey portLun : basicDataList) {
                short ldkc = portLun.getPortLunDetail().getSLDKC();
                short cu = portLun.getPortLunDetail().getSCU();
                short ldev = portLun.getPortLunDetail().getSLDEV();
                if (keyLdkc != ldkc || keyCu != cu || keyLdev != ldev) continue;
                addFlg = false;
                break;
            }
            if (!addFlg) continue;
            basicDataList.add(keyPortLun);
        }
        return basicDataList;
    }

    private List<SJmoPortLunInfo> getSelectedHostGroupLun(List<SJmoPortLunInfo> portLunInfoList, SJmoPortIndex portIndex) {
        ArrayList<SJmoPortLunInfo> selectedPortHgLunInfo = new ArrayList<SJmoPortLunInfo>(1);
        Collections.sort(portLunInfoList);
        int index = Collections.binarySearch(portLunInfoList, portIndex);
        if (index >= 0) {
            SJmoPortLunInfo selectedPortLun = null;
            try {
                selectedPortLun = (SJmoPortLunInfo)portLunInfoList.get(index).clone();
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getSelectedHostGroupLun", "CloneNotSupportedException occured.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
            int hgId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getLocalHgNameModel());
            if (hgId >= 0) {
                selectedPortLun.setAlPortLun(selectedPortLun.getAlHostGroupLun(hgId));
                selectedPortHgLunInfo.add(selectedPortLun);
            }
        }
        return selectedPortHgLunInfo;
    }

    private void updateAvailableLdevsTableModelLdev() {
        List<Object> basicDataList = new ArrayList(0);
        switch (this.copyType) {
            case 1: {
                basicDataList = this.getLdevDetailListFilteredByLocalCu(this.availableLdevsBasicDataListMap.get(this.copyType));
                break;
            }
            case 3: {
                basicDataList = this.getAvailablePvolForUrUrmf(this.availableLdevsBasicDataListMap.get(this.copyType));
                break;
            }
        }
        SJctrCreatePairsAvailableTableModelLdev table = this.getAvailableTableLdev();
        table.setBasicDataList(basicDataList);
        table.setCopyType(this.copyType);
        if (SJctrCreateRemotePairConst.REQUIRED_PAIRED_INFO_COPYTYPE.contains(this.copyType)) {
            List<SJmoReplicationPairVolInfo> pairVolInfoList = this.getSortedAvaLdevsURReplicaPairVolInfoList(basicDataList);
            table.setReplicationPairVolInfoList(pairVolInfoList);
        }
        if (this.isInitialized) {
            table.doRefresh();
        }
        table.setDirty();
    }

    private void updateRemotePortId() {
        SJctrComboBoxDataModel remotePortIdModel = this.getBaseSVolModel().getPortIdModel();
        remotePortIdModel.removeAllItems();
        String selectedModelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        int controllerId = this.getModelIdNumFromModelSnStr(selectedModelSnStr);
        SJctrRemoteReplicationUtility.createRemotePortID(remotePortIdModel, controllerId, this.getComUtility());
        remotePortIdModel.removeItem("");
        remotePortIdModel.setSelectedIndex(0);
        remotePortIdModel.setDirtyAll();
    }

    private void updateRemoteCuPulldownModel() {
        String modelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        this.getBaseSVolModel().updateRemoteCuPulldownModel(this.getModelIdNumFromModelSnStr(modelSnStr));
    }

    private void updateRemoteCuTxtModel() {
        int cu = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getCuSsidModel()) / 100000;
        SJctrTextBoxDataModel cuTextBoxModel = this.getBaseSVolModel().getCuTextModel();
        cuTextBoxModel.setValue(SJctrComUtility.toHexString(cu, 2, true));
        cuTextBoxModel.setFixed(true);
        cuTextBoxModel.setDirtyAll();
    }

    private void updateIntervalValueModel() {
        String selectedSelectionType = this.getSelectionTypeRadioButtonDataModel().getSelect();
        SJctrComboBoxDataModel intervalValueListModel = this.getIntervalValueDataModel();
        intervalValueListModel.removeAllItems();
        if ("COM_INTERVAL".equals(selectedSelectionType)) {
            SJctrCreateRemotePairUtility.initIntervalValueModel(intervalValueListModel, this.copyType);
            intervalValueListModel.setEnable(true);
        } else if ("COM_RELATIVE_PVOL".equals(selectedSelectionType)) {
            intervalValueListModel.addItem("-");
            intervalValueListModel.setSelectedIndex(0);
            intervalValueListModel.setEnable(false);
        }
        this.getSelectionTypeDataModel().setDirtyAll();
    }

    private void updateCurrentNumOfMJnlMirror() {
        SJctrMirrorSelectionDataModel mirrorSelectionModel = this.getMirrorSelectionDataModel();
        int mjnl = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMasterJnlModel());
        if (mjnl >= 0) {
            BitSet currentMirror = this.currentMirrorAttribute[mjnl];
            int numOfMirror = 0;
            if (null != currentMirror) {
                numOfMirror = currentMirror.cardinality();
            }
            mirrorSelectionModel.getCurrentNumOfMJnlMirrorLabelModel().setLabel(String.valueOf(numOfMirror));
        } else if (mjnl == -2) {
            mirrorSelectionModel.getCurrentNumOfMJnlMirrorLabelModel().setLabel("-");
        }
    }

    private void updateTotalNumOfMJnlMirror() {
        SJctrMirrorSelectionDataModel mirrorSelectionModel = this.getMirrorSelectionDataModel();
        int jnlId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMasterJnlModel());
        int mirrorId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(mirrorSelectionModel.getMirrorIdModel());
        if (jnlId >= 0 && mirrorId >= 0) {
            int numOfJnlMirror = 0;
            for (SJctrJnlMirrorInfo mirrorInfo : this.totalJnlMirrorInfo[jnlId]) {
                if (null == mirrorInfo) continue;
                ++numOfJnlMirror;
            }
            mirrorSelectionModel.getTotalNumOfMJnlMirrorLabelModel().setLabel(String.valueOf(numOfJnlMirror));
        } else if (jnlId == -2) {
            mirrorSelectionModel.getTotalNumOfMJnlMirrorLabelModel().setLabel("-");
        }
    }

    private void updateCtgIdList(int selectCtgId) {
        SJctrComboBoxDataModel ctgIdModel = this.getCtgIdModel();
        ctgIdModel.removeAllItems();
        for (int i = 0; i <= SJmoDataMacro_IF.NUM_MAX_UR_CTG_ID; ++i) {
            String dispId = SJctrComUtility.toHexString(i, 3, true);
            if (null != this.totalCtgInfo[i]) {
                dispId = dispId + " " + this.getComUtility().getGuidance("ASTERISK");
            }
            ctgIdModel.addItem(String.valueOf(i), dispId);
        }
        if (0 <= selectCtgId) {
            ctgIdModel.setSelectedIndex(selectCtgId);
        }
        ctgIdModel.setDirtyAll();
    }

    private void updatePvolFenceLevelModel() {
        SJctrComboBoxDataModel pvolFenceLevelModel = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_PVOL_FENCE_LEVEL");
        pvolFenceLevelModel.removeAllItems();
        SJctrCreateRemotePairUtility.initPvolFenceLevelModel(this, this.copyType);
        pvolFenceLevelModel.setDirtyAll();
    }

    private void updateInitCopyTypeModel() {
        SJctrComboBoxDataModel initCopyTypeModel = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE");
        initCopyTypeModel.removeAllItems();
        int controllerId = this.getModelIdNumFromModelSnStr(this.getRemoteSysModel().getModelSnModel().getSelection());
        SJctrCreateRemotePairUtility.initInitCopyTypeModel(this, this.copyType, controllerId);
        initCopyTypeModel.setDirtyAll();
    }

    private void updateErrorLevelModel() {
        SJctrComboBoxDataModel errorLevelModel = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_ERROR_LEVEL");
        errorLevelModel.removeAllItems();
        SJctrCreateRemotePairUtility.initErrorLevelModel(this, this.copyType);
    }

    private void updateSelectedPairsTableModel() {
        SJctrCreateTcPairsSelectedTableModel table = (SJctrCreateTcPairsSelectedTableModel)this.getSelectedPairsTable();
        table.setCopyType(this.copyType);
        if (this.copyType == 2 || this.copyType == 3) {
            List<SJmoLdevDetail> basicDataList = this.availableLdevsBasicDataListMap.get(this.copyType);
            SJctrCreateUrPairsSelectedTableModel urTable = (SJctrCreateUrPairsSelectedTableModel)this.getSelectedPairsTable();
            List<SJmoReplicationPairVolInfo> pairVolInfoList = this.getSortedAvaLdevsURReplicaPairVolInfoList(basicDataList);
            urTable.setReplicationPairVolInfoList(pairVolInfoList);
            this.putCache(SJctrGetUniversalReplicatorPairVolInfo.class, pairVolInfoList);
        }
        if (this.isInitialized) {
            table.doRefresh();
        }
        table.setDirtyAll();
        this.updateFooter();
    }

    private SJctrComboBoxDataModel getCopyTypeDataModel() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel("COM_COPY_TYPE");
    }

    private void checkCopyTypePullDownList(int err) {
        if (this.getCopyTypeDataModel().getItemMap().isEmpty()) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(err);
        }
    }

    private SJctrComboBoxDataModel getLocalCuDataModel() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel("COM_LOCAL_CU");
    }

    private SJctrRemoteStorageSystemDataModel getRemoteSysModel() {
        return (SJctrRemoteStorageSystemDataModel)this.getDataObjectModel("COM_REMOTE_STORAGE");
    }

    private SJctrRadioButtonGroupDataModel getUseExistUrPairsDataModel() {
        return (SJctrRadioButtonGroupDataModel)this.getDataObjectModel("COM_USE_EXIST_UR_PAIRS");
    }

    private SJctrLuSelectionDataModel getLuSelectionDataModel() {
        return (SJctrLuSelectionDataModel)this.getDataObjectModel("COM_LU_SELECTION");
    }

    private SJctrRadioButtonGroupDataModel getSelectionObjectRadioButtonModel() {
        return (SJctrRadioButtonGroupDataModel)this.getLuSelectionDataModel().getDataModel("COM_SELECTION_OBJECT_RADIO");
    }

    private SJctrComboBoxDataModel getLocalPortIdModel() {
        return (SJctrComboBoxDataModel)this.getLuSelectionDataModel().getDataModel("COM_PORT_ID");
    }

    private SJctrComboBoxDataModel getLocalHgNameModel() {
        return (SJctrComboBoxDataModel)this.getLuSelectionDataModel().getDataModel("COM_HG_NAME");
    }

    private SJctrBaseSecondaryVolumeDataModel getBaseSVolModel() {
        return (SJctrBaseSecondaryVolumeDataModel)this.getDataObjectModel("COM_SVOL_SELECTION");
    }

    private SJctrCreatePairsAvailableTableModelLun getAvailableTableLun() {
        return (SJctrCreatePairsAvailableTableModelLun)this.getDataObjectModel("COM_TABLE_AVAILABLE_LUN");
    }

    private SJctrCreatePairsAvailableTableModelLdev getAvailableTableLdev() {
        return (SJctrCreatePairsAvailableTableModelLdev)this.getDataObjectModel("COM_TABLE_AVAILABLE_LDEV");
    }

    private SJctrSelectionTypeDataModel getSelectionTypeDataModel() {
        return (SJctrSelectionTypeDataModel)this.getDataObjectModel("COM_SELECTION_TYPE");
    }

    private SJctrRadioButtonGroupDataModel getSelectionTypeRadioButtonDataModel() {
        return (SJctrRadioButtonGroupDataModel)this.getSelectionTypeDataModel().getDataModel("COM_SELECTION_TYPE_RADIO");
    }

    private SJctrComboBoxDataModel getIntervalValueDataModel() {
        return (SJctrComboBoxDataModel)this.getSelectionTypeDataModel().getDataModel("COM_INTERVAL_VALUE");
    }

    private SJctrMirrorSelectionDataModel getMirrorSelectionDataModel() {
        return (SJctrMirrorSelectionDataModel)this.getDataObjectModel("COM_MIRROR_SLECTION");
    }

    private SJctrComboBoxDataModel getCtgIdModel() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel("COM_CTG_ID");
    }

    private SJctrCreateTcPairsSelectedTableModel getSelectedTcPairsTable() {
        return (SJctrCreateTcPairsSelectedTableModel)this.getDataObjectModel("COM_TABLE_SELECTED_TC");
    }

    private SJctrCreateUrPairsSelectedTableModel getSelectedUrPairsTable() {
        return (SJctrCreateUrPairsSelectedTableModel)this.getDataObjectModel("COM_TABLE_SELECTED_UR");
    }

    private SJctrTableDataModel getSelectedPairsTable() {
        SJctrCreateTcPairsSelectedTableModel ret = null;
        switch (this.copyType) {
            case 0: 
            case 1: {
                ret = this.getSelectedTcPairsTable();
                break;
            }
            case 2: 
            case 3: {
                ret = this.getSelectedUrPairsTable();
                break;
            }
        }
        return ret;
    }

    private void checkMaxPairNum(int pvolCount, int selectedPairsCount) {
        int total = pvolCount + selectedPairsCount + this.currentTcPairVolInfoList.size() + this.currentUrPairVolInfoList.size();
        if (total > SJmoDataMacro_IF.MAX_RC_PAIR_NUM) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206026);
        }
    }

    private void checkMaxAddUrPairNumOfJournal(int jnlId, int selectedPairCount) {
        int jnlPairNum = 0;
        for (SJctrJnlMirrorInfo jnlMirrorPairNum : this.totalJnlMirrorInfo[jnlId]) {
            if (null == jnlMirrorPairNum) continue;
            jnlPairNum += jnlMirrorPairNum.getNumOfPair();
        }
        int totalJnlPairNum = jnlPairNum + selectedPairCount;
        int maxAddPairNumJnl = SJctrRemoteReplicationUtility.getMaxAddPairNumJnl();
        if (totalJnlPairNum > maxAddPairNumJnl) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206027);
        }
    }

    private void checkMaxAddUrPairNumOfMirror(int jnlId, int mirrorId, int selectedPairCount) {
        int maxAddPairNumMirror;
        int totalMirrorPairNum;
        SJctrJnlMirrorInfo mirrorInfo = this.totalJnlMirrorInfo[jnlId][mirrorId];
        int mirrorPairNum = 0;
        if (mirrorInfo != null) {
            mirrorPairNum = mirrorInfo.getNumOfPair();
        }
        if ((totalMirrorPairNum = mirrorPairNum + selectedPairCount) > (maxAddPairNumMirror = SJctrRemoteReplicationUtility.getMaxAddPairNumMirror())) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206286);
        }
    }

    private void checkMaxAddUrPairNumOfCtg(int ctgId, int selectedPairCount) {
        int maxAddPairNumUrCtg;
        int totalPairNum;
        int ctgPairNum = 0;
        SJctrJnlMirrorInfo jnlMirror = this.totalCtgInfo[ctgId];
        if (null != jnlMirror) {
            ctgPairNum = jnlMirror.getNumOfPair();
        }
        if ((totalPairNum = ctgPairNum + selectedPairCount) > (maxAddPairNumUrCtg = SJctrRemoteReplicationUtility.getMaxAddPairNumUrCtg())) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206029);
        }
    }

    private SJmoLdevIndex getAvailableLdevIndex(SJmoLdevIndex index, Object rowDataObj) {
        if (rowDataObj instanceof SJctrPortLunTableKey) {
            SJmoPortLunDetail portLun = ((SJctrPortLunTableKey)rowDataObj).getPortLunDetail();
            index.setLdevIndex(portLun.getSLDKC(), portLun.getSCU(), portLun.getSLDEV());
        } else if (rowDataObj instanceof SJmoLdevDetail) {
            index = (SJmoLdevIndex)rowDataObj;
        } else {
            index.setLdevIndex((short)-1, (short)-1, (short)-1);
        }
        return index;
    }

    private void checkJnlMirrorInfo(int controllerId, int mjnl) {
        int mirror = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getMirrorSelectionDataModel().getMirrorIdModel());
        int pathGrp = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getPathGrpModel());
        String modelSn = this.getRemoteSysModel().getModelSnModel().getSelection();
        String sn = this.getSerialNumberStrFromModelSnStr(controllerId, modelSn);
        for (SJctrJnlMirrorInfo jnlMirror : this.totalJnlMirrorInfo[mjnl]) {
            if (null == jnlMirror || jnlMirror.getMirrorId() != mirror || jnlMirror.getSn().equals(sn) && jnlMirror.getPathGrpId() == pathGrp) continue;
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206037);
        }
    }

    private void checkTcmfFreeSvolLdevId(int usedSvolSize, int selectedLdevsSize) {
        if (this.copyType == 1 && usedSvolSize + selectedLdevsSize > SJmoDataMacro_IF.MAX_LDEV_CU) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206039);
        }
    }

    private boolean isAvailableControllerId(int controllerId) {
        return 6 <= controllerId && controllerId <= 255;
    }

    private void setEnableEventListner(boolean flg) {
        SJctrComboBoxDataModel cmbLocalCu = this.getLocalCuDataModel();
        SJctrRadioButtonGroupDataModel radioPortKind = this.getSelectionObjectRadioButtonModel();
        SJctrComboBoxDataModel cmbLcalPortId = this.getLocalPortIdModel();
        SJctrComboBoxDataModel cmbLocalHgName = this.getLocalHgNameModel();
        cmbLocalCu.setEnableListener(flg);
        radioPortKind.setEnableListener(flg);
        cmbLcalPortId.setEnableListener(flg);
        cmbLocalHgName.setEnableListener(flg);
    }

    private List<SJmoReplicationPairVolInfo> getSortedAvaLdevsURReplicaPairVolInfoList(List<? extends SJmoLdevIndex> availableLdexIndexList) {
        ArrayList<SJmoReplicationPairVolInfo> retList = new ArrayList<SJmoReplicationPairVolInfo>();
        SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        for (SJmoLdevIndex sJmoLdevIndex : availableLdexIndexList) {
            SJmoReplicationPairVolInfo pairVolInfo = urPairVolInfoMgr.getPairVolInfo(sJmoLdevIndex);
            if (pairVolInfo == null) continue;
            retList.add(pairVolInfo);
        }
        Collections.sort(retList);
        return retList;
    }

    private List<SJmoUniversalReplicatorPairVolInfo> getURPairListFromSelectedLDEVs(List<SJmoReplicationPairVolInfo> createPairVolInfoList, List<SJmoLdevIndex> selectedLdevs) {
        Collections.sort(createPairVolInfoList);
        ArrayList<SJmoUniversalReplicatorPairVolInfo> selectedURPairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        for (SJmoLdevIndex ldevIndex : selectedLdevs) {
            List<? extends SJmoLdevIndex> pairVolList;
            int index = Collections.binarySearch(createPairVolInfoList, ldevIndex);
            if (index < 0 || (pairVolList = SJctrRemoteReplicationUtility.getRemoteVolumeInfoList(createPairVolInfoList.get(index))).size() != 1) continue;
            selectedURPairList.add((SJmoUniversalReplicatorPairVolInfo)pairVolList.get(0));
        }
        return selectedURPairList;
    }

    private void checkMultiPairCreate(List<SJmoUniversalReplicatorPairVolInfo> selectedURPairList) {
        if (selectedURPairList.size() > 0) {
            SJmoUniversalReplicatorPairVolInfo urPairInfo = selectedURPairList.get(0);
            int jnlId = SJctrRemoteReplicationUtility.getJnlIdFromPair(urPairInfo);
            int mirrorId = urPairInfo.getMirrorId();
            for (SJmoUniversalReplicatorPairVolInfo compUrPairInfo : selectedURPairList) {
                int compJnlId = SJctrRemoteReplicationUtility.getJnlIdFromPair(compUrPairInfo);
                int compMirrorId = compUrPairInfo.getMirrorId();
                if (jnlId == compJnlId && mirrorId == compMirrorId) continue;
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206289);
            }
            if (mirrorId == SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getMirrorSelectionDataModel().getMirrorIdModel())) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206291);
            }
        }
    }

    public static enum CREATE_PAIRS_MSG implements SJctrNotifyState
    {
        SELECT_COPY_TYPE,
        SELECT_LOCAL_CU,
        SELECT_REMOTE_SYSTEM_MODEL_SN,
        SELECT_REMOTE_SYSTEM_CU_SSID,
        SELECT_USE_EXSIT_UR_PAIRS,
        SELECT_SELECTION_OBJECT,
        SELECT_LU_SELECTION_PORT_ID,
        SELECT_LU_SELECTION_HOST_GROUP_NAME,
        SELECT_SVOL_SELECTION_SEL_TYPE,
        SELECT_MIRROR_SELECTION_MJNL,
        SELECT_MIRROR_SELECTION_MIRROR,
        SELECT_MIRROR_SELECTION_RJNL,
        SELECT_CTG_ID,
        SELECT_ADD,
        SELECT_CHANGE_SETTINGS,
        SELECT_REMOVE;

    }
}

