/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.deletehapairs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaPairTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.deletehapairs.SJctrDeleteHaPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.deletehapairs.SJctrDeleteHaPairsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetQuorumDiskInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrDeleteHaPairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101901;
    private static final String DISP_TITLE = "DELETE_PAIR";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_DELETE_MODE = "COM_DELETE_MODE";
    private static final String KEY_VOLUME_ACCESS = "COM_VOLUME_ACCESS";
    private static final String KEY_VOLUME_ACCESS_ENABLE = "COM_VOLUME_ACCESS_ENABLE";
    private static final String KEY_VOLUME_ACCESS_DISABLE = "COM_VOLUME_ACCESS_DISABLE";
    private boolean isContainSuspend = false;
    private boolean isContainNonSuspend = false;
    private boolean isOnlyCopy = false;
    private static final String KEY_MIXED_FLG = "COM_MIXED_FLG";
    private static final int NOT_MIXED = 0;
    private static final int MIXED = 1;

    public SJctrDeleteHaPairsDC() {
        super(0x1101901);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrDeleteHaPairsTableModel());
        SJctrComboBoxDataModel cmbDeleteMode = new SJctrComboBoxDataModel();
        cmbDeleteMode.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                }
            }
        });
        this.addDataObjectModel(KEY_DELETE_MODE, cmbDeleteMode);
        SJctrRadioButtonGroupDataModel radVolumeAccess = new SJctrRadioButtonGroupDataModel();
        radVolumeAccess.add(KEY_VOLUME_ACCESS_ENABLE);
        radVolumeAccess.add(KEY_VOLUME_ACCESS_DISABLE);
        radVolumeAccess.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                }
            }
        });
        this.addDataObjectModel(KEY_VOLUME_ACCESS, radVolumeAccess);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetHAPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetQuorumDiskInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSsidDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoHAPairVolInfoMgr haPairInfoMgr = SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
            List<SJmoHAPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            SJctrHaUtility.chkCacheHaPairsDetailData(this);
            List<SJmoHAPairVolInfo> pairExist = SJctrHaUtility.checkAndGetExistHaPairInfo(viewData, haPairInfoMgr);
            this.isContainSuspend = SJctrHaUtility.isContainSuspend(pairExist);
            this.isContainNonSuspend = SJctrHaUtility.isContainNonSuspend(pairExist);
            int mixed = this.isContainSuspend && this.isContainNonSuspend ? 1 : 0;
            this.getManageData().setData(KEY_MIXED_FLG, mixed);
            if (!this.isContainSuspend) {
                this.isOnlyCopy = SJctrHaUtility.isOnlyCopy(pairExist);
            }
            SJctrDeleteHaPairsTableModel table = (SJctrDeleteHaPairsTableModel)this.getDataObjectModel(KEY_TABLE);
            table.setBasicDataList(pairExist);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() throws SJcException {
        super.makeDataModel();
        SJctrComboBoxDataModel cmbDeleteMode = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_DELETE_MODE);
        SJctrRadioButtonGroupDataModel radVolumeAccess = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_VOLUME_ACCESS);
        if (this.isContainSuspend) {
            cmbDeleteMode.addItem(Integer.toString(0), this.getComUtility().getGuidance("DELETE_NORMAL"));
            cmbDeleteMode.setEnable(true);
            radVolumeAccess.setEnable(KEY_VOLUME_ACCESS_DISABLE, false);
            radVolumeAccess.setSelect(KEY_VOLUME_ACCESS_ENABLE);
        } else if (this.isOnlyCopy) {
            cmbDeleteMode.setEnable(false);
            radVolumeAccess.setEnable(false);
        } else {
            cmbDeleteMode.setEnable(false);
            radVolumeAccess.setSelect(KEY_VOLUME_ACCESS_DISABLE);
        }
        cmbDeleteMode.addItem(Integer.toString(1), this.getComUtility().getGuidance("DELETE_FORCE"));
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrDeleteHaPairsConfirmData confirmData = new SJctrDeleteHaPairsConfirmData();
            SJctrHaPairTableDataModelBase table = (SJctrHaPairTableDataModelBase)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = table.getAllRowData();
            confirmData.setLUPathMap(SJctrHaUtility.getLDEVLUPathMap(this));
            confirmData.setPairsInfo(selectedList);
            SJctrComboBoxDataModel deleteMode = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_DELETE_MODE);
            int iDeleteMode = SJctrHaUtility.getSelectedComboboxKeyNum(deleteMode);
            if (iDeleteMode == 0) {
                SJmoRemoteReplicationMRCUInfoMgr mrcuMgr = SJctrHaUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
                SJctrResourceGroupUtility rsgUty = SJctrHaUtility.getSJctrResourceGroupUtility(this);
                List<SJmoQuorumDiskInfo> allQuorumDiskInfo = SJctrHaUtility.getSJmoQuorumDiskInfo(this);
                List<SJmoLdevDetail> rsgLdevDetailList = SJctrHaUtility.getSJmoLdevDetailFilteredByAllRsg(this);
                for (SJmoHAPairVolInfo sJmoHAPairVolInfo : selectedList) {
                    if (!SJctrHaUtility.isSuspend(sJmoHAPairVolInfo)) continue;
                    SJctrHaUtility.checkPairPortRsg(sJmoHAPairVolInfo, mrcuMgr, rsgUty);
                    SJctrHaUtility.isAuthorizedQuorumDisk(sJmoHAPairVolInfo, allQuorumDiskInfo, rsgLdevDetailList);
                }
            }
            confirmData.setDeleteMode(iDeleteMode);
            SJctrRadioButtonGroupDataModel volumeAccess = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_VOLUME_ACCESS);
            if (KEY_VOLUME_ACCESS_ENABLE.equals(volumeAccess.getSelect())) {
                confirmData.setVolumeAccess(0);
            } else {
                confirmData.setVolumeAccess(1);
            }
            confirmData.setNeedData(this);
            ArrayList<SJctrDeleteHaPairsConfirmData> confirmDataList = new ArrayList<SJctrDeleteHaPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrDeleteHaPairsConfirmData.class, confirmDataList);
            SJctrHaUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }
}

