/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editmirroropts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.editmirroropts.SJctrEditMirrorOptionsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.editmirroropts.model.SJctrCopyPaceDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editmirroropts.model.SJctrDeltaResyncFailureDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editmirroropts.model.SJctrPathWatchTimeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editmirroropts.model.SJctrPathWatchTimeTransferDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editmirroropts.model.SJctrTransferSpeedDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;

public class SJctrEditMirrorOptionsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831025;
    private static final String DISP_TITLE = "EDIT_MIRROR_OPTION";
    private static final String KEY_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION = "COM_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION";
    private static final String KEY_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL = "COM_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL";
    private static final int ATTRIBUTE_ALL_SAME_VALUE = 1;

    public SJctrEditMirrorOptionsDC() {
        super(17831025);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_PATH_WATCH_TIME_INF", new SJctrPathWatchTimeDataModel());
        this.addDataObjectModel("COM_PATH_WATCH_TIME_TRANSFER_INF", new SJctrPathWatchTimeTransferDataModel());
        this.addDataObjectModel("COM_COPY_PACE_INF", new SJctrCopyPaceDataModel());
        this.addDataObjectModel("COM_TRANSFER_SPEED_INF", new SJctrTransferSpeedDataModel());
        this.addDataObjectModel("COM_DELTA_RESYNC_FAILURE_INF", new SJctrDeltaResyncFailureDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_MIRROR_OPTIONS_MSG.SELECT_PATH_WATCH_TIME, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrPathWatchTimeDataModel pathWatchTimeModel = (SJctrPathWatchTimeDataModel)dstModel.getDataModel("COM_PATH_WATCH_TIME_INF");
                pathWatchTimeModel.setPathWatchTimeTextBoxEnable(true);
                pathWatchTimeModel.changePathWatchTimeTextBoxType(pathWatchTimeModel.getSelectPathWatchTimeType());
                pathWatchTimeModel.setDisplayDataPathWatchTime("");
                pathWatchTimeModel.setDirty("COM_PATH_WATCH_TIME_TEXTBOX");
                pathWatchTimeModel.setDirty("COM_PATH_WATCH_TIME_UNIT_LABEL");
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> selectedList = this.getProxy().getCache("KEY_SELECTED_MIRROR");
        if (selectedList == null) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (selectedList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoMirrorIndex> selectedMirrorList = this.getProxy().getCache("KEY_SELECTED_MIRROR");
            SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList = SJctrRemoteReplicationUtility.checkAndGetExistMirrorInfo(selectedMirrorList, allJnlInfo);
            SJctrRemoteReplicationUtility.checkTopJnlVolRsSelectedMirror(this, mirrorList);
            SJctrRemoteReplicationUtility.checkMirrorTypicalVolRs(this, mirrorList);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForMirror(mirrorList, allJnlInfo);
            if (copytype == -1) {
                this.logUty.putlog("checkConstructData", "Copy type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206010);
                SJcException exp = err.createException();
                throw exp;
            }
            Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap = SJctrRemoteReplicationUtility.getEnableStatusOptionMapForEditMirrorOptions(mirrorList);
            Collection<Boolean> enableStatusValues = enableStatusMap.values();
            if (!Arrays.asList(enableStatusValues.toArray()).contains(true)) {
                this.logUty.putlog("checkConstructData", "Mirror status is invalid.");
                SJctrError err = new SJctrError(210, 22, 206015);
                SJcException exp = err.createException();
                throw exp;
            }
            this.initialSetupDataModel(mirrorList, enableStatusMap);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            SJctrEditMirrorOptionsConfirmData confirmData = new SJctrEditMirrorOptionsConfirmData();
            List<SJmoUniversalReplicatorJnlGrpMirror> jnlgMirrorList = this.getProxy().getCache(KEY_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION);
            List<SJmoUniversalReplicatorJnlGrpMirror> jnlgMirrorOriginalList = this.getProxy().getCache(KEY_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL);
            List<SJmoUniversalReplicatorJnlGrpMirror> sendMirrorList = this.getMergeJnlGrpMirrorList(jnlgMirrorList, jnlgMirrorOriginalList);
            Collections.sort(sendMirrorList);
            SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForMirror(jnlgMirrorList, allJnlInfo);
            confirmData.setMirrorInfo(sendMirrorList);
            confirmData.setCopyType(copytype);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditMirrorOptionsConfirmData> confirmDataList = new ArrayList<SJctrEditMirrorOptionsConfirmData>(1);
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditMirrorOptionsConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return ret;
    }

    private void initialSetupDataModel(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList, Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap) {
        HashMap<InitialSetupDataModelKey, Set<Integer>> initialDataSetMap = new HashMap<InitialSetupDataModelKey, Set<Integer>>();
        HashSet<Integer> pathWatchTimeTypeSet = new HashSet<Integer>();
        HashSet<Integer> pathWatchTimeValueSet = new HashSet<Integer>();
        HashSet<Integer> pathWatchTimeTransferSet = new HashSet<Integer>();
        HashSet<Integer> copyPaceSet = new HashSet<Integer>();
        HashSet<Integer> transferSpeedSet = new HashSet<Integer>();
        HashSet<Integer> deltaResyncSet = new HashSet<Integer>();
        for (SJmoUniversalReplicatorJnlGrpMirror mirror : mirrorList) {
            int pathBlockWatchTime = mirror.getPathBlockWatchTime();
            pathWatchTimeTypeSet.add(pathBlockWatchTime & 0xC0);
            pathWatchTimeValueSet.add(pathBlockWatchTime & 0x3F);
            pathWatchTimeTransferSet.add(mirror.getForward());
            copyPaceSet.add(mirror.getTransferRate());
            transferSpeedSet.add(mirror.getLineSpeed());
            deltaResyncSet.add(mirror.getFailure());
        }
        initialDataSetMap.put(InitialSetupDataModelKey.PATH_WATCH_TIME_TYPE, pathWatchTimeTypeSet);
        initialDataSetMap.put(InitialSetupDataModelKey.PATH_WATCH_TIME_VALUE, pathWatchTimeValueSet);
        initialDataSetMap.put(InitialSetupDataModelKey.PATH_WATCH_TIME_TRANSFER, pathWatchTimeTransferSet);
        initialDataSetMap.put(InitialSetupDataModelKey.COPY_PACE, copyPaceSet);
        initialDataSetMap.put(InitialSetupDataModelKey.TRANSFER_SPEED, transferSpeedSet);
        initialDataSetMap.put(InitialSetupDataModelKey.DELTA_RESYNC_FAILURE, deltaResyncSet);
        this.initialSetupPathWatchTimeDataModel(initialDataSetMap, enableStatusMap);
        this.initialSetupPathWatchTimeTransferDataModel(initialDataSetMap, enableStatusMap);
        this.initialSetupCopyPaceDataModel(initialDataSetMap, enableStatusMap);
        this.initialSetupTransferSpeedDataModel(initialDataSetMap, enableStatusMap);
        this.initialSetupDeltaResyncFailureDataModel(initialDataSetMap, enableStatusMap);
        this.putCache(KEY_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION, mirrorList);
        ArrayList<SJmoUniversalReplicatorJnlGrpMirror> jnlgMirrorListCopy = new ArrayList<SJmoUniversalReplicatorJnlGrpMirror>();
        for (SJmoUniversalReplicatorJnlGrpMirror jnlgMirror : mirrorList) {
            try {
                jnlgMirrorListCopy.add((SJmoUniversalReplicatorJnlGrpMirror)jnlgMirror.clone());
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("initialSetupDataModel", "Information of SJmoUniversalReplicatorJnlGrpMirror cannot clone.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        this.putCache(KEY_EDIT_MIRROR_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL, jnlgMirrorListCopy);
    }

    private void initialSetupPathWatchTimeDataModel(Map<InitialSetupDataModelKey, Set<Integer>> initialDataSetMap, Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap) {
        SJctrPathWatchTimeDataModel pathWatchTimeDataModel = this.getPathWatchTimeDataModel();
        boolean settableStatus = enableStatusMap.get((Object)SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_PATH_WATCH_TIME);
        Set<Integer> pathWatchTimeTypeSet = initialDataSetMap.get((Object)InitialSetupDataModelKey.PATH_WATCH_TIME_TYPE);
        if (pathWatchTimeTypeSet.size() == 1) {
            pathWatchTimeDataModel.setSelectPathWatchTimeType(pathWatchTimeTypeSet.iterator().next());
        } else {
            pathWatchTimeDataModel.setSelectPathWatchTimeType(-1);
        }
        if (pathWatchTimeDataModel.getSelectPathWatchTimeType() != -1) {
            Set<Integer> pathWatchTimeValueSet = initialDataSetMap.get((Object)InitialSetupDataModelKey.PATH_WATCH_TIME_VALUE);
            if (pathWatchTimeValueSet.size() == 1) {
                pathWatchTimeDataModel.setDisplayDataPathWatchTime(String.valueOf(pathWatchTimeValueSet.iterator().next()));
            } else {
                pathWatchTimeDataModel.setDisplayDataPathWatchTime("");
            }
        } else {
            pathWatchTimeDataModel.setDisplayDataPathWatchTime("");
            pathWatchTimeDataModel.setPathWatchTimeTextBoxEnable(false);
        }
        if (!settableStatus) {
            pathWatchTimeDataModel.setEnable(false);
        }
    }

    private void initialSetupPathWatchTimeTransferDataModel(Map<InitialSetupDataModelKey, Set<Integer>> initialDataSetMap, Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap) {
        SJctrPathWatchTimeTransferDataModel pathWatchTimeTransferDataModel = this.getPathWatchTimeTransferDataModel();
        boolean settableStatus = enableStatusMap.get((Object)SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_PATH_WATCH_TIME_TRANSFER);
        pathWatchTimeTransferDataModel.setSelectPathWatchTimeTransferType(0);
        if (!settableStatus) {
            pathWatchTimeTransferDataModel.setEnable(false);
        }
    }

    private void initialSetupCopyPaceDataModel(Map<InitialSetupDataModelKey, Set<Integer>> initialDataSetMap, Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap) {
        SJctrCopyPaceDataModel copyCapeDataModel = this.getCopyPaceDataModel();
        boolean settableStatus = enableStatusMap.get((Object)SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_COPY_PACE);
        Set<Integer> copyPaceSet = initialDataSetMap.get((Object)InitialSetupDataModelKey.COPY_PACE);
        if (copyPaceSet.size() == 1) {
            copyCapeDataModel.setCopyPace(copyPaceSet.iterator().next());
        } else {
            copyCapeDataModel.setCopyPace(-1);
        }
        if (!settableStatus) {
            copyCapeDataModel.setEnable(false);
        }
    }

    private void initialSetupTransferSpeedDataModel(Map<InitialSetupDataModelKey, Set<Integer>> initialDataSetMap, Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap) {
        SJctrTransferSpeedDataModel transferSpeedDataModel = this.getTransferSpeedDataModel();
        boolean settableStatus = enableStatusMap.get((Object)SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_TRANSFER_SPEED);
        Set<Integer> transferSpeedSet = initialDataSetMap.get((Object)InitialSetupDataModelKey.TRANSFER_SPEED);
        if (transferSpeedSet.size() == 1) {
            transferSpeedDataModel.setTransferSpeed(transferSpeedSet.iterator().next());
        } else {
            transferSpeedDataModel.setTransferSpeed(-1);
        }
        if (!settableStatus) {
            transferSpeedDataModel.setEnable(false);
        }
    }

    private void initialSetupDeltaResyncFailureDataModel(Map<InitialSetupDataModelKey, Set<Integer>> initialDataSetMap, Map<SJctrRemoteReplicationDataMacro.EnableStatusKey, Boolean> enableStatusMap) {
        SJctrDeltaResyncFailureDataModel deltaResyncDataModel = this.getDeltaResyncFailureDataModel();
        boolean settableStatus = enableStatusMap.get((Object)SJctrRemoteReplicationDataMacro.EnableStatusKey.ENABLE_DELTA_RESYNC_FAILURE);
        Set<Integer> deltaResyncSet = initialDataSetMap.get((Object)InitialSetupDataModelKey.DELTA_RESYNC_FAILURE);
        if (deltaResyncSet.size() == 1) {
            deltaResyncDataModel.setDeltaResyncFailure(deltaResyncSet.iterator().next());
        } else {
            deltaResyncDataModel.setDeltaResyncFailure(-1);
        }
        if (!settableStatus) {
            deltaResyncDataModel.setEnable(false);
        }
    }

    private List<SJmoUniversalReplicatorJnlGrpMirror> getMergeJnlGrpMirrorList(List<SJmoUniversalReplicatorJnlGrpMirror> jnlgMirrorList, List<SJmoUniversalReplicatorJnlGrpMirror> jnlgMirrorOriginalList) {
        ArrayList<SJmoUniversalReplicatorJnlGrpMirror> retJnlgMirrorList = new ArrayList<SJmoUniversalReplicatorJnlGrpMirror>();
        SJctrPathWatchTimeDataModel pathWatchTimeDataModel = this.getPathWatchTimeDataModel();
        SJctrPathWatchTimeTransferDataModel pathWatchTimeTransferDataModel = this.getPathWatchTimeTransferDataModel();
        SJctrCopyPaceDataModel copyPaceDataModel = this.getCopyPaceDataModel();
        SJctrTransferSpeedDataModel transferSpeedDataModel = this.getTransferSpeedDataModel();
        SJctrDeltaResyncFailureDataModel deltaResyncFailureDataModel = this.getDeltaResyncFailureDataModel();
        for (int i = 0; i < jnlgMirrorList.size(); ++i) {
            SJmoUniversalReplicatorJnlGrpMirror jnlgMirror = jnlgMirrorList.get(i);
            SJmoUniversalReplicatorJnlGrpMirror jnlgMirrorOriginal = jnlgMirrorOriginalList.get(i);
            if (pathWatchTimeDataModel.isSelectCheckBox()) {
                jnlgMirror.setPathBlockWatchTime(pathWatchTimeDataModel.getSelectPathWatchTimeType() + Integer.parseInt(pathWatchTimeDataModel.getDisplayDataPathWatchTime()));
            } else {
                jnlgMirror.setPathBlockWatchTime(jnlgMirrorOriginal.getPathBlockWatchTime());
            }
            if (pathWatchTimeTransferDataModel.isSelectCheckBox()) {
                jnlgMirror.setForward(pathWatchTimeTransferDataModel.getSelectPathWatchTimeTransferType());
            } else {
                jnlgMirror.setForward(jnlgMirrorOriginal.getForward());
            }
            if (copyPaceDataModel.isSelectCheckBox()) {
                jnlgMirror.setTransferRate(copyPaceDataModel.getCopyPace());
            } else {
                jnlgMirror.setTransferRate(jnlgMirrorOriginal.getTransferRate());
            }
            if (transferSpeedDataModel.isSelectCheckBox()) {
                jnlgMirror.setLineSpeed(transferSpeedDataModel.getTransferSpeed());
            } else {
                jnlgMirror.setLineSpeed(jnlgMirrorOriginal.getLineSpeed());
            }
            if (deltaResyncFailureDataModel.isSelectCheckBox()) {
                jnlgMirror.setFailure(deltaResyncFailureDataModel.getDeltaResyncFailure());
            } else {
                jnlgMirror.setFailure(jnlgMirrorOriginal.getFailure());
            }
            retJnlgMirrorList.add(jnlgMirror);
        }
        return retJnlgMirrorList;
    }

    private SJctrPathWatchTimeDataModel getPathWatchTimeDataModel() {
        return (SJctrPathWatchTimeDataModel)this.getDataObjectModel("COM_PATH_WATCH_TIME_INF");
    }

    private SJctrPathWatchTimeTransferDataModel getPathWatchTimeTransferDataModel() {
        return (SJctrPathWatchTimeTransferDataModel)this.getDataObjectModel("COM_PATH_WATCH_TIME_TRANSFER_INF");
    }

    private SJctrCopyPaceDataModel getCopyPaceDataModel() {
        return (SJctrCopyPaceDataModel)this.getDataObjectModel("COM_COPY_PACE_INF");
    }

    private SJctrTransferSpeedDataModel getTransferSpeedDataModel() {
        return (SJctrTransferSpeedDataModel)this.getDataObjectModel("COM_TRANSFER_SPEED_INF");
    }

    private SJctrDeltaResyncFailureDataModel getDeltaResyncFailureDataModel() {
        return (SJctrDeltaResyncFailureDataModel)this.getDataObjectModel("COM_DELTA_RESYNC_FAILURE_INF");
    }

    public static enum EDIT_MIRROR_OPTIONS_MSG implements SJctrNotifyState
    {
        SELECT_PATH_WATCH_TIME;

    }

    private static enum InitialSetupDataModelKey {
        PATH_WATCH_TIME_TYPE,
        PATH_WATCH_TIME_VALUE,
        PATH_WATCH_TIME_TRANSFER,
        COPY_PACE,
        TRANSFER_SPEED,
        DELTA_RESYNC_FAILURE;

    }
}

