/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editquorumdisks;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationQuorumDiskBaseAC;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationError;
import sanproject.sn2.controller.wizard.replication.remote.editquorumdisks.SJctrEditQuorumDisksConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrEditQuorumDisksAC
extends SJctrOperationQuorumDiskBaseAC {
    private static final long serialVersionUID = 1L;
    private static final int ERROR_FUNCTION_EXIST_NUMBER = 0;
    private static final int ERRORCODE_EXIST_NUMBER = 1;

    public void setApplyData(SJctrEditQuorumDisksConfirmData confirmData) {
        this.applyInfo = confirmData.getQuorumInfo();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        SJdsSupplierAgent supplierAgent = SJdsSupplierMgr.getSupplierMgr().getAgent();
        SanRequest quorumRequestData = supplierAgent.newRequest("HRCFupdateQuorumDisks");
        try {
            SanList quorumDiskSanList = quorumRequestData.newList("QuorumDisks");
            for (SJmoQuorumDiskInfo quorumDiskInfo : this.applyInfo) {
                SanObject quorumDiskParam = quorumDiskSanList.addObj();
                int iQuorumDiskId = quorumDiskInfo.getIQuorumDiskID();
                quorumDiskParam.putInt("Id", iQuorumDiskId);
                SanObject ldevObj = quorumDiskParam.newObj("Ldev");
                SJmoLdevIndex ldevIndex = quorumDiskInfo.getQuorumLdevIndex();
                int[] idArray = new int[]{ldevIndex.getSLdkc(), ldevIndex.getSCu(), ldevIndex.getSLdev()};
                ldevObj.putIntArray("Id", idArray);
                int iBlkRmPathMonSec = quorumDiskInfo.getIReadResGuaranteedTime();
                quorumDiskParam.putInt("ReadResponseGuaranteedTime", iBlkRmPathMonSec);
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "getSetList", "The error occurred during request parameter generation processing of Key-Value." + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        applyList.add(quorumRequestData);
        return applyList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        SJctrError error = new SJctrError(210, 22, 0);
        this.resultData = new ArrayList();
        try {
            if (!(resultObject instanceof SanResponse)) {
                error.setError(107001);
                this.setError(error);
            } else {
                this.setRepError((SanResponse)resultObject, error);
                SanResponse responseObject = (SanResponse)resultObject;
                SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(responseObject);
                if (errorInfo.hasLowerNodeError()) {
                    this.setDetailError((SanResponse)resultObject);
                }
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "setApplyResult", "The error occurred during generating SJctrError from SanResponse." + sdEx.getMessage());
            error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
    }

    private void setRepError(SanResponse resultObject, SJctrError error) throws SanDataException {
        SanObject errInfo = resultObject.getObj("ErrorInfo");
        int[] errMsgId = errInfo.getIntArray("MessageId");
        if (0 != errMsgId[1]) {
            error = new SJctrError(errMsgId[0] / 100, errMsgId[0] % 100, errMsgId[1]);
        }
        this.setError(error);
    }

    private void setDetailError(SanResponse resultObject) throws SanDataException {
        SanList quorumList = resultObject.getList("QuorumDisks");
        if (null == quorumList) {
            SJctrLogUty.info(this.title, "setDetailError", "quorumList is null.");
        } else {
            int index = 0;
            for (SanObject result : quorumList) {
                SanObject errInfo = result.getObj("ErrorInfo");
                int[] errMsgId = errInfo.getIntArray("MessageId");
                if (0 != errMsgId[1]) {
                    SJctrRcOperationError operationError = new SJctrRcOperationError(errMsgId[0] / 100, errMsgId[0] % 100, errMsgId[1], index);
                    this.resultData.add(operationError);
                }
                ++index;
            }
        }
    }
}

