/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.hactgprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.comparator.SJctrHAPairInfoComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaCtgInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.remote.hactgprops.SJctrHaCtgPropsHaPairsTableModel;
import sanproject.sn2.controller.wizard.replication.remote.hactgprops.SJctrHaCtgPropsSummaryModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrHaViewPairPropertiesDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrHaCtgPropsDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664545;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE_HA_PAIRS = "COM_TABLE_HA_PAIRS";
    private static final String KEY_DETAIL = "COM_DETAIL";
    public static final String KEY_TOP_SELECTED_HACTG = "KEY_SELECTED_CTG";
    public static final String KEY_ALL_HA_PAIRS = "COM_ALL_HA_PAIRS";
    public static final String KEY_ALUA_APPLY_ERROR = "COM_ALUA_APPLY_ERROR";
    public static final String KEY_FROM_DISP = "COM_FROM_DISP";
    public static final int FROM_CONFIRM = 1;
    public static final String KEY_DETAIL_DISP = "COM_DETAIL_DISP";
    public static final int DETAIL_HIDE = 0;
    public static final int DETAIL_SHOW = 1;
    private static final String KEY_SELECTED_HA_PAIRS = "KEY_SELECTED_REMOTE_VOL";

    public SJctrHaCtgPropsDC() throws SJcException {
        super(34664545);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrHaCtgPropsSummaryModel());
        this.addDataObjectModel(KEY_TABLE_HA_PAIRS, new SJctrHaCtgPropsHaPairsTableModel());
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrHaCtgPropsDC.this.fireMessageEvent(HA_CTGPROPS_MSG.SELECT_DETAIL);
                }
            }
        });
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(HA_CTGPROPS_MSG.SELECT_DETAIL, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHaCtgPropsDC.this.makeDetailAction(event, dstModel);
            }
        });
    }

    private void makeDetailAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrHaCtgPropsHaPairsTableModel haPairaTableModel = (SJctrHaCtgPropsHaPairsTableModel)this.getDataObjectModel(KEY_TABLE_HA_PAIRS);
        if (haPairaTableModel == null) {
            this.getLogUty().putlog("makeDetailAction", "HA Pairs Table is null.");
            return;
        }
        List<Object> haPairVolList = haPairaTableModel.getSelectedRowData();
        int selectedPairsNum = haPairVolList.size();
        if (selectedPairsNum <= 0) {
            this.getLogUty().putlog("makeDetailAction", "Not selected.");
            return;
        }
        if (selectedPairsNum > 256) {
            this.getLogUty().putlog("makeDetailAction", "Selected Pairs Num is Limit Over.");
            SJctrError err = new SJctrError(210, 22, 206085);
            SJcException exp = err.createException();
            throw exp;
        }
        HashMap param = new HashMap();
        param.put(KEY_SELECTED_HA_PAIRS, haPairVolList);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrHaViewPairPropertiesDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetHAPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        List<?> haCtgInfoList = this.getProxy().getCache(KEY_TOP_SELECTED_HACTG);
        if (haCtgInfoList == null) {
            this.logUty.putlog("checkStartData", "Information of data list is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (haCtgInfoList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of data list is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrHaCtgInfo haCtgInfo = (SJctrHaCtgInfo)haCtgInfoList.get(0);
        if (haCtgInfo == null) {
            this.logUty.putlog("checkStartData", "Information of selected data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoHAPairVolInfoMgr haPairMgr = SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
            List<SJmoLdevDetail> ldevDetails = SJctrReplicationUtility.getSJmoLdevDetail(this);
            List<SJmoRSGgetAllRsgs> allRsgsInfo = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            List<SJmoHUVMVirtualLdev> virtualLdevList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
            List<SJmoHUVMVirtualDkc> virtualDkcList = SJctrHaUtility.getSJmoHUVMVirtualDkc(this);
            List<SJmoHAPairVolInfo> haPairListWithRsg = null;
            SJctrHaCtgInfo currentHaCtgInfo = null;
            List<?> fromDisp = this.getProxy().getCache(KEY_FROM_DISP);
            if (fromDisp != null && (Integer)fromDisp.get(0) == 1) {
                this.getManageData().setData(KEY_DETAIL_DISP, 0);
                haPairListWithRsg = this.getProxy().getCache(KEY_ALL_HA_PAIRS);
                List<?> haCtgInfoList = this.getProxy().getCache(KEY_TOP_SELECTED_HACTG);
                SJctrHaCtgInfo haCtgInfo = (SJctrHaCtgInfo)haCtgInfoList.get(0);
                currentHaCtgInfo = SJctrHaUtility.getHaCtgInfo(haCtgInfo.getCtgId(), haPairListWithRsg, virtualLdevList, virtualDkcList);
            } else {
                this.getManageData().setData(KEY_DETAIL_DISP, 1);
                SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(this.getOwner(), SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, allRsgsInfo));
                haPairListWithRsg = SJctrHaUtility.getHaPairVolInfoList(haPairMgr, rsgUty, ldevDetails);
                List<?> haCtgInfoList = this.getProxy().getCache(KEY_TOP_SELECTED_HACTG);
                SJctrHaCtgInfo haCtgInfo = (SJctrHaCtgInfo)haCtgInfoList.get(0);
                currentHaCtgInfo = SJctrHaUtility.getHaCtgInfo(haCtgInfo.getCtgId(), SJctrHaUtility.getHaPairVolInfoListNoResourceCheck(haPairMgr, ldevDetails), virtualLdevList, virtualDkcList);
            }
            ArrayList<SJmoHAPairVolInfo> haPairListWithCtgId = SJctrHaUtility.getTargetCtgHAPairVolInfoList(currentHaCtgInfo, haPairListWithRsg);
            Collections.sort(haPairListWithCtgId, new SJctrHAPairInfoComparator());
            SJctrHaCtgPropsHaPairsTableModel haPairsTable = (SJctrHaCtgPropsHaPairsTableModel)this.getDataObjectModel(KEY_TABLE_HA_PAIRS);
            haPairsTable.setBasicDataList(haPairListWithCtgId);
            SJctrHaCtgPropsSummaryModel summary = (SJctrHaCtgPropsSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
            summary.setData(currentHaCtgInfo);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        List<SJctrErrorColumnData> errorInfo = this.getProxy().getCache(KEY_ALUA_APPLY_ERROR);
        if (null != errorInfo) {
            SJctrHaCtgPropsHaPairsTableModel haPairsTable = (SJctrHaCtgPropsHaPairsTableModel)this.getDataObjectModel(KEY_TABLE_HA_PAIRS);
            SJctrErrorTableModel errTable = new SJctrErrorTableModel();
            this.addDataObjectModel(KEY_TABLE_HA_PAIRS, errTable);
            errTable.initialize(haPairsTable, errorInfo, new SJctrErrorColumnDataComparator());
            errTable.makeDataModel();
        }
    }

    public static enum HA_CTGPROPS_MSG implements SJctrNotifyState
    {
        SELECT_DETAIL;

    }
}

