/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.removessids;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteConnectionUtility;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrLocalStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemotePathDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.removessids.SJctrRemoveSsidsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrRemoveSsidsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101611;
    private static final String DISP_TITLE = "REMOVE_SSIDS";
    private static final String KEY_SELECT_INDEX_MODEL = "COM_SELECT_INDEX_MODEL";
    private static final String KEY_SELECT_INDEX = "COM_SELECT_INDEX";
    private static final String KEY_SELECTED_RCU_INFO = "COM_SELECTED_RCU_INFO";

    public SJctrRemoveSsidsDC() {
        super(0x1101611);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrLocalStorageSysDataModel localSysModel = new SJctrLocalStorageSysDataModel();
        this.addDataObjectModel("COM_LOCAL_STORAGE_SYS_PANEL", localSysModel);
        SJctrRemoteStorageSysDataModel remoteSysModel = new SJctrRemoteStorageSysDataModel();
        this.addDataObjectModel("COM_REMOTE_STORAGE_SYS_PANEL", remoteSysModel);
        SJctrRemotePathDataModel remotePathModel = new SJctrRemotePathDataModel();
        this.addDataObjectModel("COM_REMOTE_PATHS_PANEL", remotePathModel);
        SJctrSimpleDataModel selectIndexModel = new SJctrSimpleDataModel();
        selectIndexModel.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrDataObject data;
                Integer index;
                if (setObject instanceof SJctrDataObject && (index = (Integer)(data = (SJctrDataObject)setObject).getData(SJctrRemoveSsidsDC.KEY_SELECT_INDEX)) != null) {
                    SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)SJctrRemoveSsidsDC.this.getDataObjectModel(SJctrRemoveSsidsDC.KEY_SELECT_INDEX_MODEL);
                    ((SJctrDataObject)selectIndexModel.getManageData()).setData(SJctrRemoveSsidsDC.KEY_SELECT_INDEX, index);
                    SJctrRemoveSsidsDC.this.fireMessageEvent(REMOVE_SSID_MSG.CHECK_REMOVE_SSID);
                }
            }
        });
        this.addDataObjectModel(KEY_SELECT_INDEX_MODEL, selectIndexModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(REMOVE_SSID_MSG.CHECK_REMOVE_SSID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoveSsidsDC.this.chgStateReomoveCheckboxAction(event, dstModel);
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (null == viewDataList.get(0)) {
            this.logUty.putlog("checkStartData", "Information of selected RCU is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            List<SJmoPortDetail> portDtlList = SJctrReplicationUtility.getSJmoPortDetail(this);
            List<SJmoRSGgetAllRsgs> allRsgInfoList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs allRsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, allRsgInfoList);
            List<SJmoRemoteReplicationRCUInfo> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
            List<SJmoRemoteReplicationRCUInfo> selectedRCUInfoList = SJctrRemoteReplicationUtility.checkAndGetExistConnectionInfo(viewDataList, mrcuInfoMgr);
            SJmoRemoteReplicationRCUInfo selectedRCUInfo = selectedRCUInfoList.get(0);
            this.putCache(KEY_SELECTED_RCU_INFO, selectedRCUInfoList);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo);
            if (!SJctrRemoteReplicationUtility.hasRcuPortRs(selectedRCUInfo, rsgUtil)) {
                this.logUty.putlog("checkConstructData", "Can't remove ssid because local port don't have resource authorization exist.");
                SJctrError err = new SJctrError(210, 22, 206041);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getICUFree() != 0) {
                this.logUty.putlog("checkConstructData", "Can't remove ssid because connection type selected connection is not cu.");
                SJctrError err = new SJctrError(210, 22, 206054);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getINumofSSID() <= 1) {
                this.logUty.putlog("checkConstructData", "Can't remove ssid because minimum ssids already has be set.");
                SJctrError err = new SJctrError(210, 22, 206056);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getRCUOption().getINumofMimPath() > selectedRCUInfo.getPathInfoList().size()) {
                this.logUty.putlog("checkConstructData", "Can't remove ssid because set path count under the minimum path count.");
                SJctrError err = new SJctrError(210, 22, 206148);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrRemoteConnectionUtility.setRemoteConnLocalStorageSysLabelPanel(subsysInfo, this, selectedRCUInfo, this.getComUtility());
            this.setRemoteSystemModelPanel(selectedRCUInfo);
            SJctrRemoteConnectionUtility.setRemoteConnRemotePathLabelPanel(this, selectedRCUInfo, portDtlList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            List<?> moRcuInfoList = this.getCache(KEY_SELECTED_RCU_INFO);
            SJmoRemoteReplicationRCUInfo rcuInfo = (SJmoRemoteReplicationRCUInfo)moRcuInfoList.get(0);
            SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
            ArrayList<Boolean> checkOnOffList = this.getCheckOnOffList();
            int checkOnCount = 0;
            for (boolean bCheck : checkOnOffList) {
                if (!bCheck) continue;
                ++checkOnCount;
            }
            int ssidCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_DISP_SSID_COUNT");
            rcuInfo.setINumofSSID(ssidCount - checkOnCount);
            int[] removeSSIDList = new int[checkOnCount];
            int[] ramainSSIDList = new int[ssidCount - checkOnCount];
            int removeCount = 0;
            int remainCount = 0;
            int ssidValue = 0;
            for (int idx = 0; idx < ssidCount; ++idx) {
                SJctrTextBoxDataModel ssidText = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(this, idx);
                ssidValue = 0;
                try {
                    ssidValue = Integer.parseInt(ssidText.getValue(), 16);
                }
                catch (NumberFormatException ne) {
                    this.logUty.putlog("checkEndData", "The error occurred at the SSID" + idx + " getting. NumberFormatException : " + ne.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
                if (checkOnOffList.get(idx).booleanValue()) {
                    removeSSIDList[removeCount] = ssidValue;
                    ++removeCount;
                    continue;
                }
                ramainSSIDList[remainCount] = ssidValue;
                ++remainCount;
            }
            rcuInfo.setISSID(ramainSSIDList);
            ArrayList<SJmoRemoteReplicationRCUInfo> rcuInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
            rcuInfoList.add(rcuInfo);
            SJctrRemoveSsidsConfirmData confirmData = new SJctrRemoveSsidsConfirmData();
            confirmData.setRCUInfo(rcuInfoList);
            confirmData.setRemoveSSIDList(removeSSIDList);
            ArrayList<SJctrRemoveSsidsConfirmData> confirmDataList = new ArrayList<SJctrRemoveSsidsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrRemoveSsidsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    protected void chgStateReomoveCheckboxAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
            int ssidCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_DISP_SSID_COUNT");
            int checkedCount = 0;
            ArrayList<SJctrCheckBoxDataModel> checkOffs = new ArrayList<SJctrCheckBoxDataModel>();
            for (int pid = 0; pid < ssidCount; ++pid) {
                SJctrCheckBoxDataModel chkBox = SJctrRemoteConnectionUtility.getSSIDRemoveCheckboxModel(this, pid);
                if (chkBox.isSelect()) {
                    ++checkedCount;
                    continue;
                }
                checkOffs.add(chkBox);
            }
            boolean bEnable = true;
            if (ssidCount - checkedCount <= 1) {
                bEnable = false;
            }
            for (int idx = 0; idx < checkOffs.size(); ++idx) {
                SJctrCheckBoxDataModel rmCheckbox = (SJctrCheckBoxDataModel)checkOffs.get(idx);
                rmCheckbox.setEnable(bEnable);
            }
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void setRemoteSystemModelPanel(SJmoRemoteReplicationRCUInfo rcuInfo) {
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_MODEL_STR", SJctrRemoteReplicationUtility.getModelNameString(rcuInfo.getIControllerID(), this.getComUtility()));
        SJctrTextBoxDataModel serialtext = SJctrRemoteConnectionUtility.getRemoteSerialNumberTextModel(this);
        serialtext.setValue(rcuInfo.getStrSN());
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_CU_STR", SJctrComUtility.toHexString(rcuInfo.getSCu(), 2, true));
        int ssidNum = rcuInfo.getINumofSSID();
        for (int ssidIdx = 0; ssidIdx < ssidNum; ++ssidIdx) {
            SJctrTextBoxDataModel ssidtext = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(this, ssidIdx);
            ssidtext.setValue(SJctrComUtility.toHexString(rcuInfo.getISSID()[ssidIdx], 4, true));
        }
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_DISP_SSID_COUNT", ssidNum);
    }

    private ArrayList<Boolean> getCheckOnOffList() {
        ArrayList<Boolean> ssidCheck = new ArrayList<Boolean>();
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
        int ssidCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_DISP_SSID_COUNT");
        for (int ssid = 0; ssid < ssidCount; ++ssid) {
            SJctrCheckBoxDataModel chkBox = SJctrRemoteConnectionUtility.getSSIDRemoveCheckboxModel(this, ssid);
            ssidCheck.add(chkBox.isSelect());
        }
        return ssidCheck;
    }

    private static enum REMOVE_SSID_MSG implements SJctrNotifyState
    {
        CHECK_REMOVE_SSID;

    }
}

