/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynchactgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaCtgInfo;
import sanproject.sn2.controller.wizard.replication.remote.resynchactgs.SJctrResyncHaCtgsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.resynchactgs.SJctrResyncHaCtgsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrResyncHaCtgsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1102021;
    private static final String DISP_TITLE = "RESYNC_CTG";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_COPY_PACE = "COM_COPY_PACE";
    private static final String KEY_ALUA_MODE = "COM_ALUA_MODE";
    private static final String KEY_HEAD_HA_PAIRS_INFO = "COM_HEAD_HA_PAIRS_INFO";
    private static final String KEY_ALL_HA_PAIRS = "COM_ALL_HA_PAIRS";
    private static final String LOG_TITLE = SJctrResyncHaCtgsDC.class.getSimpleName();

    public SJctrResyncHaCtgsDC() {
        super(0x1102021);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    private void initDataModel() {
        SJctrTextBoxDataModel copyPaceTxt = new SJctrTextBoxDataModel();
        copyPaceTxt.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrHaUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel(KEY_COPY_PACE, copyPaceTxt);
        SJctrComboBoxDataModel cmbAluaMode = new SJctrComboBoxDataModel();
        cmbAluaMode.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrHaUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel(KEY_ALUA_MODE, cmbAluaMode);
        this.addDataObjectModel(KEY_TABLE, new SJctrResyncHaCtgsTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetHAPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSsidDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_CTG");
        if (viewDataList == null) {
            SJctrLogUty.error(LOG_TITLE, "checkStartData", "Inherited list data is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        if (viewDataList.size() == 0) {
            SJctrLogUty.error(LOG_TITLE, "checkStartData", "Size of inherited list data is zero.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJctrUserController uc = this.getOwner();
            SJctrHaUtility.chkCacheHaCtgsDetailData(this);
            SJctrHaUtility.checkPpLicenseForGADList(uc, 1);
            List<SJctrHaCtgInfo> viewHaCtgsList = this.getProxy().getCache("KEY_SELECTED_CTG");
            SJmoHAPairVolInfoMgr haPairInfoMgr = SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            List<SJmoHUVMVirtualLdev> virtualLdevsList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
            List<SJmoHUVMVirtualDkc> virtualDkcList = SJctrHaUtility.getSJmoHUVMVirtualDkc(this);
            List<SJmoRSGgetAllRsgs> rsgAllList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs rsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, rsgAllList);
            SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, rsgInfo);
            ArrayList<SJmoHAPairVolInfo> haPairsList = SJctrHaUtility.getHaPairVolInfoListNoResourceCheck(haPairInfoMgr, ldevDetailList);
            List<SJctrHaCtgInfo> existHaCtgs = SJctrHaUtility.getTargetHaCtgInfo(viewHaCtgsList, haPairsList, virtualLdevsList, virtualDkcList);
            boolean isExistHaPairInHaCtgs = SJctrHaUtility.checkExistHaPairInHaCtgs(existHaCtgs);
            if (!isExistHaPairInHaCtgs) {
                SJctrLogUty.error(LOG_TITLE, "checkConstructData", "Some of Selected Consistency Groups table data have no Pair.");
                throw SJctrHaUtility.createRemoteReplicationException(206244);
            }
            boolean isEnableResyncHaCtgStatus = SJctrHaUtility.checkEnableResyncHaCtgStatus(existHaCtgs);
            if (!isEnableResyncHaCtgStatus) {
                SJctrLogUty.error(LOG_TITLE, "checkConstructData", "Contained invalid Consistency Group Status.");
                throw SJctrHaUtility.createRemoteReplicationException(206255);
            }
            ArrayList<SJmoHAPairVolInfo> headhaPairsList = SJctrHaUtility.getTargetCtgTopHAPairVolInfoList(existHaCtgs, haPairsList);
            boolean isRsgHaPairs = SJctrHaUtility.checkRsgHaPairs(headhaPairsList, rsgUty);
            if (!isRsgHaPairs) {
                SJctrLogUty.error(LOG_TITLE, "checkConstructData", "Some of specified HA Consistency Groups are not authorized.");
                throw SJctrHaUtility.createRemoteReplicationException(206248);
            }
            boolean st = SJctrHaUtility.checkResyncHaPairStatus(headhaPairsList);
            if (!st) {
                SJctrLogUty.error(LOG_TITLE, "checkConstructData", "Contains a pair of invalid pair position.");
                SJctrError err = new SJctrError(210, 22, 206257);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrResyncHaCtgsTableModel table = (SJctrResyncHaCtgsTableModel)this.getDataObjectModel(KEY_TABLE);
            table.setBasicDataList(existHaCtgs);
            this.putCache(KEY_HEAD_HA_PAIRS_INFO, headhaPairsList);
            ArrayList<SJmoHAPairVolInfo> allHaPairs = SJctrHaUtility.getHaPairVolInfoList(haPairInfoMgr, rsgUty, ldevDetailList);
            this.putCache(KEY_ALL_HA_PAIRS, allHaPairs);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrTextBoxDataModel copyPaceTxt = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_COPY_PACE);
        copyPaceTxt.setValue("15");
        copyPaceTxt.setMin("1");
        copyPaceTxt.setMax("15");
        SJctrComUtility comUty = this.getOwner().getComUtility();
        SJctrComboBoxDataModel aluaMode = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_ALUA_MODE);
        aluaMode.addItem(String.valueOf(0), comUty.getGuidance("DEPEND_ON_PVOL_SETTINGS"));
        aluaMode.addItem(String.valueOf(1), comUty.getGuidance("ENABLE"));
        aluaMode.addItem(String.valueOf(2), comUty.getGuidance("DISABLE"));
        aluaMode.setSelection(String.valueOf(0));
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
            List<SJmoHAPairVolInfo> headHaPairsList = this.getCache(KEY_HEAD_HA_PAIRS_INFO);
            List<SJmoHAPairVolInfo> allHaPairs = this.getCache(KEY_ALL_HA_PAIRS);
            SJctrResyncHaCtgsTableModel table = (SJctrResyncHaCtgsTableModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = table.getAllRowData();
            SJctrTextBoxDataModel copyPaceTxt = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_COPY_PACE);
            int copyPace = SJctrHaUtility.getValueTextBoxNum(copyPaceTxt);
            int aluaModeSelection = SJctrHaUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel(KEY_ALUA_MODE));
            ArrayList<SJmoLdevDetail> confirmLdevDetails = new ArrayList<SJmoLdevDetail>();
            HashMap<String, Integer> mapLdevCtg = new HashMap<String, Integer>();
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            ArrayList cloneLdevDetails = SJmoDataUtility.alDeepCopy(new ArrayList<SJmoLdevDetail>(ldevDetailList));
            for (SJctrHaCtgInfo sJctrHaCtgInfo : selectedList) {
                ArrayList<SJmoHAPairVolInfo> ctgHaPairs = SJctrHaUtility.getTargetCtgHAPairVolInfoList(sJctrHaCtgInfo, allHaPairs);
                for (SJmoHAPairVolInfo ctgHaPair : ctgHaPairs) {
                    SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(ctgHaPair);
                    if (localVol == null) {
                        this.logUty.putlog("checkEndData", "Information of SJmoReplicationPairVolInfo is null.");
                        continue;
                    }
                    mapLdevCtg.put(localVol.getIndexKey(), ctgHaPair.getIGroup());
                    int index = Collections.binarySearch(cloneLdevDetails, localVol);
                    if (index < 0) continue;
                    SJmoLdevDetail cloneLdev = (SJmoLdevDetail)cloneLdevDetails.get(index);
                    if (aluaModeSelection != 0) {
                        cloneLdev.setBAluaMode(aluaModeSelection == 1);
                    }
                    confirmLdevDetails.add(cloneLdev);
                }
            }
            for (SJctrHaCtgInfo sJctrHaCtgInfo : selectedList) {
                sJctrHaCtgInfo.setCopyPace(copyPace);
            }
            for (SJmoHAPairVolInfo sJmoHAPairVolInfo : headHaPairsList) {
                sJmoHAPairVolInfo.setICopyPace(copyPace);
            }
            SJctrResyncHaCtgsConfirmData confirmData = new SJctrResyncHaCtgsConfirmData();
            confirmData.setPairsInfo(headHaPairsList);
            confirmData.setCtgInfo(selectedList);
            confirmData.setAluaModeSelection(aluaModeSelection);
            Collections.sort(confirmLdevDetails);
            confirmData.setConfirmLdevDetails(confirmLdevDetails);
            confirmData.setAllHaPairs(allHaPairs);
            confirmData.setMapLdevCtg(mapLdevCtg);
            confirmData.setLUPathMap(SJctrHaUtility.getLDEVLUPathMap(this));
            SJmoSubsystemInfo sJmoSubsystemInfo = SJctrHaUtility.getSJmoSubsystemInfo(this);
            int modelID = remoteUty.getModelIDfromSubsysInfo(sJmoSubsystemInfo);
            confirmData.setModelID(modelID);
            confirmData.setNeedData(this);
            ArrayList<SJctrResyncHaCtgsConfirmData> confirmDataList = new ArrayList<SJctrResyncHaCtgsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrResyncHaCtgsConfirmData.class, confirmDataList);
            SJctrHaUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }
}

