/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynctcpairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrHAPairInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoComparator;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.replication.remote.hapairs.SJctrRemoteReplicationHaPairsTopTableModel;
import sanproject.sn2.controller.topwindow.replication.remote.tcpairs.SJctrRemoteReplicationTcPairsTopTableModel;
import sanproject.sn2.controller.topwindow.replication.remote.urpairs.SJctrRemoteReplicationUrPairsTopTableModel;
import sanproject.sn2.controller.wizard.replication.remote.resynchapairs.SJctrResyncHaPairsSubWizard;
import sanproject.sn2.controller.wizard.replication.remote.resynctcpairs.SJctrResyncTCPairsSubWizard;
import sanproject.sn2.controller.wizard.replication.remote.resyncurpairs.SJctrResyncURPairsSubWizard;

public class SJctrItemSelectListenerResyncPairs
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            ArrayList<Object> param = new ArrayList();
            int dispId = dc.getDisplayId();
            if (dispId == 13313) {
                param = this.makeParamFromTcPairs(dc);
            } else if (dispId == 13314) {
                param = this.makeParamFromUrPairs(dc);
            } else if (dispId == 13317) {
                param = this.makeParamFromHaPairs(dc);
            } else {
                SJctrUserController uc = dc.getOwner();
                uc.getLogUty().putlog("selectChanged", "Invalid Display ID.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }

    private ArrayList<Object> makeParamFromTcPairs(SJctrDataController dc) {
        SJctrUserController uc = dc.getOwner();
        SJctrRemoteReplicationTcPairsTopTableModel pairsTopTable = (SJctrRemoteReplicationTcPairsTopTableModel)dc.getDataObjectModel("COM_TABLE");
        if (pairsTopTable == null) {
            uc.getLogUty().putlog("makeParamFromTcPairs", "SJctrRemoteReplicationTcPairsTopTableModel is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedPairsList = pairsTopTable.getSelectedRowData();
        if (selectedPairsList == null || selectedPairsList.size() == 0) {
            uc.getLogUty().putlog("makeParamFromTcPairs", "Selected pairs table data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVol(selectedPairsList);
        if (-1 == copytype) {
            uc.getLogUty().putlog("makeParamFromTcPairs", "Selected pairs copytype are mixed.");
            SJctrError err = new SJctrError(210, 22, 206009);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean pairPos = SJctrRemoteReplicationUtility.isTrueCopyPairPositionPrimary(selectedPairsList);
        if (!pairPos) {
            uc.getLogUty().putlog("makeParamFromTcPairs", "Contains a pair of invalid pair position.");
            SJctrError err = new SJctrError(210, 22, 206005);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean st = SJctrRemoteReplicationUtility.checkResyncTCPairStatus(selectedPairsList);
        if (!st) {
            uc.getLogUty().putlog("selectChanged", "PairStatus is invalid.");
            SJctrError err = new SJctrError(210, 22, 206014);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        Collections.sort(selectedPairsList, new SJctrTrueCopyPairInfoComparator());
        paramMap.put("KEY_SELECTED_REMOTE_VOL", selectedPairsList);
        param.add(SJctrResyncTCPairsSubWizard.class);
        param.add(paramMap);
        return param;
    }

    private ArrayList<Object> makeParamFromUrPairs(SJctrDataController dc) {
        SJctrUserController uc = dc.getOwner();
        SJctrRemoteReplicationUrPairsTopTableModel pairsTopTable = (SJctrRemoteReplicationUrPairsTopTableModel)dc.getDataObjectModel("COM_TABLE");
        if (pairsTopTable == null) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "SJctrRemoteReplicationUrPairsTopTableModel is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedPairsList = pairsTopTable.getSelectedRowData();
        if (selectedPairsList == null || selectedPairsList.size() == 0) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "Selected pairs table data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVol(selectedPairsList);
        if (-1 == copytype) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "Selected pairs copytype are mixed.");
            SJctrError err = new SJctrError(210, 22, 206009);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean pairPos = SJctrRemoteReplicationUtility.checkURPairPositionPrimary(selectedPairsList);
        if (!pairPos) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "Contains a pair of invalid pair position.");
            SJctrError err = new SJctrError(210, 22, 206005);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean st = SJctrRemoteReplicationUtility.checkResyncURPairStatus(selectedPairsList);
        if (!st) {
            uc.getLogUty().putlog("makeParamFromUrPairs", "Pair Status is invalid.");
            SJctrError err = new SJctrError(210, 22, 206014);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        Collections.sort(selectedPairsList, new SJctrUniversalReplicatorPairInfoComparator());
        paramMap.put("KEY_SELECTED_REMOTE_VOL", selectedPairsList);
        param.add(SJctrResyncURPairsSubWizard.class);
        param.add(paramMap);
        return param;
    }

    private ArrayList<Object> makeParamFromHaPairs(SJctrDataController dc) {
        SJctrUserController uc = dc.getOwner();
        SJctrRemoteReplicationHaPairsTopTableModel pairsTopTable = (SJctrRemoteReplicationHaPairsTopTableModel)dc.getDataObjectModel("COM_TABLE");
        if (pairsTopTable == null) {
            uc.getLogUty().putlog("makeParamFromHaPairs", "SJctrRemoteReplicationHaPairsTopTableModel is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedPairsList = pairsTopTable.getSelectedRowData();
        if (selectedPairsList == null || selectedPairsList.size() == 0) {
            uc.getLogUty().putlog("makeParamFromHaPairs", "Selected pairs table data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean st = SJctrHaUtility.checkResyncHaPairStatus(selectedPairsList);
        if (!st) {
            uc.getLogUty().putlog("makeParamFromHaPairs", "PairStatus is invalid.");
            SJctrError err = new SJctrError(210, 22, 206161);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(selectedPairsList, new SJctrHAPairInfoComparator());
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        paramMap.put("KEY_SELECTED_REMOTE_VOL", selectedPairsList);
        param.add(SJctrResyncHaPairsSubWizard.class);
        param.add(paramMap);
        return param;
    }
}

