/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynctcpairs;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.RMCPResume1Pair;
import sanproject.serverux.dataimpl.RMCPResumePair;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoPriorityComparator;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationTcPairBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.resynctcpairs.SJctrResyncTCPairsConfirmData;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;

public class SJctrResyncTCPairsAC
extends SJctrOperationTcPairBaseAC {
    private static final long serialVersionUID = -2530127736618837295L;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;
    private final int RMISET_FENCELEVEL0 = 0;
    private final int RMISET_FENCELEVEL1 = 1;
    private final int RMISET_FENCELEVEL2 = 2;
    private final int RMISET_COPYTYPE = 7;
    private final int RMISET_TIME_TRANSFER = 10;

    public void setApplyData(SJctrResyncTCPairsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.copyType = confirmData.getCopyType();
        this.portLunMap = confirmData.getLUPathMap();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<RMCPResumePair> applyList = null;
        ArrayList<RMCPResumePair> applyData = new ArrayList<RMCPResumePair>(1);
        RMCPResume1Pair[] resyncPairList = new RMCPResume1Pair[this.applyInfo.size()];
        ArrayList<SJmoTrueCopyPairVolInfo> applySortInfo = new ArrayList<SJmoTrueCopyPairVolInfo>();
        for (SJmoTrueCopyPairVolInfo info : this.applyInfo) {
            try {
                applySortInfo.add((SJmoTrueCopyPairVolInfo)info.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(this.title, "getSetList", "Information of SJmoTrueCopyPairVolInfo cannot clone.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        }
        Collections.sort(applySortInfo, new SJctrTrueCopyPairInfoPriorityComparator());
        for (int i = 0; i < applySortInfo.size(); ++i) {
            SJmoTrueCopyPairVolInfo pairInfo = (SJmoTrueCopyPairVolInfo)applySortInfo.get(i);
            RMCPResume1Pair resync1Pair = new RMCPResume1Pair();
            SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(pairInfo);
            resync1Pair.CUNo = localVol.getSCu();
            resync1Pair.LDEVNo = localVol.getSLdev();
            resync1Pair.LDKC = localVol.getSLdkc();
            resync1Pair.PairLDEVNo = this.getPairLDEVNo(pairInfo);
            resync1Pair.PLU = SJctrRemoteReplicationUtility.getLocalRMCPHorcLU(localVol, this.copyType, this.portLunMap);
            resync1Pair.SLU = SJctrRemoteReplicationUtility.getRemoteRMCPHorcLU(pairInfo, this.copyType);
            resync1Pair.SN = pairInfo.getStrPairSN();
            resync1Pair.SSID = this.getPairSSID(pairInfo);
            resync1Pair.CUFree = pairInfo.getICUFree();
            resync1Pair.RCUID = this.getPairRCUID(pairInfo);
            resync1Pair.ControllerID = pairInfo.getIPairControllerID();
            resync1Pair.Priority = pairInfo.getIPriority();
            resync1Pair.Tracks = pairInfo.getITracks();
            resync1Pair.Option = this.getResyncOption(pairInfo);
            resyncPairList[i] = resync1Pair;
        }
        RMCPResumePair resyncPair = new RMCPResumePair();
        resyncPair.Resume1Pair = resyncPairList;
        resyncPair.NumofPair = resyncPairList.length;
        applyData.add(resyncPair);
        applyList = applyData;
        return applyList;
    }

    private int getResyncOption(SJmoTrueCopyPairVolInfo pairInfo) {
        BitSet pairBehavior = pairInfo.getBehaviorBitSet();
        BitSet bitOpt = new BitSet();
        bitOpt.set(0, pairBehavior.get(2));
        bitOpt.set(1, pairBehavior.get(3));
        bitOpt.set(2, pairBehavior.get(4));
        bitOpt.set(7, this.copyType == 1);
        if (this.copyType == 0) {
            bitOpt.set(10, pairBehavior.get(12));
        }
        return SJctrRemoteReplicationUtility.bitSetToint(bitOpt);
    }

    private int getPairLDEVNo(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (this.copyType == 0) {
            rtn = pairInfo.getSLdev();
        }
        return rtn;
    }

    private int getPairSSID(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (pairInfo.getICUFree() != 1) {
            rtn = pairInfo.getIPairSSID();
        }
        return rtn;
    }

    private int getPairRCUID(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (pairInfo.getICUFree() == 1) {
            rtn = pairInfo.getIPairRCUID();
        }
        return rtn;
    }
}

