/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.suspendhactgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.comparator.SJctrHACtgInfoComparator;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.replication.remote.hactgs.SJctrHaCtgsTopTableModel;
import sanproject.sn2.controller.wizard.replication.remote.suspendhactgs.SJctrSuspendHaCtgsSubWizard;

public class SJctrItemSelectListenerSuspendHaCtgs
implements SJctrItemSelectListener {
    private static final String LOG_TITLE = SJctrItemSelectListenerSuspendHaCtgs.class.getSimpleName();

    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            ArrayList<Object> param = new ArrayList<Object>();
            SJctrDataController dc = event.getSource().getDataController();
            SJctrHaCtgsTopTableModel topTable = (SJctrHaCtgsTopTableModel)dc.getDataObjectModel("COM_TABLE");
            if (topTable == null) {
                SJctrLogUty.error(LOG_TITLE, "selectChanged", "SJctrHaCtgsTopTableModel is null.");
                throw SJctrHaUtility.createRemoteReplicationException(107001);
            }
            List<Object> selectedCtgsList = topTable.getSelectedRowData();
            if (selectedCtgsList == null || selectedCtgsList.size() == 0) {
                SJctrLogUty.error(LOG_TITLE, "selectChanged", "Selected Consistency Groups table data is invalid.");
                throw SJctrHaUtility.createRemoteReplicationException(107001);
            }
            boolean isExistHaPairInHaCtgs = SJctrHaUtility.checkExistHaPairInHaCtgs(selectedCtgsList);
            if (!isExistHaPairInHaCtgs) {
                SJctrLogUty.error(LOG_TITLE, "selectChanged", "Some of Selected Consistency Groups table data have no Pair.");
                throw SJctrHaUtility.createRemoteReplicationException(206245);
            }
            boolean isEnableSuspendHaCtgStatus = SJctrHaUtility.checkEnableSuspendHaCtgStatus(selectedCtgsList);
            if (!isEnableSuspendHaCtgStatus) {
                SJctrLogUty.error(LOG_TITLE, "selectChanged", "Contained invalid Consistency Group Status.");
                throw SJctrHaUtility.createRemoteReplicationException(206247);
            }
            Collections.sort(selectedCtgsList, new SJctrHACtgInfoComparator());
            HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
            paramMap.put("KEY_SELECTED_CTG", selectedCtgsList);
            param.add(SJctrSuspendHaCtgsSubWizard.class);
            param.add(paramMap);
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }
}

