/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.RMCPget1PairDetail;
import sanproject.serverux.dataimpl.RMCPgetHorcPairLU;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrSelectedRmPathTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrGetRmcp1PairDetailList;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrRemotePairPropNumOfLunPathTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrRemotePairPropPathGroupTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.com.SJctrViewRemotePairPropertiesDataMacro;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrTcViewPairPropertiesPropertiesDataModel
extends SJctrSimpleDataModel {
    protected static final String IMAGE_PATH_HI = "image/remote/";
    protected static final String IMAGE_PATH_HP = "image/remote/hp/";
    protected static final String BG_FILE_TC = "gp_tc_bkg.png";
    protected static final String BG_FILE_TCMF = "gp_tc_bkg_mf.png";
    protected static final String GP_ERROR_L = "image/remote/gp_error_l.png";
    protected static final String COPY_DIRECTION_TO_REMOTE = "image/remote/gp_tc_to_remote.png";
    protected static final String COPY_DIRECTION_TO_LOCAL = "image/remote/gp_tc_to_local.png";
    private static final int DIGIT_HG = 2;
    private static final int DIGIT_LUN = 4;
    private static final int DIGIT_SSID = 4;
    private static final int DIGIT_PATH_ID = 2;
    private String imageDirectory = "image/remote/";
    private List<RMCPget1PairDetail> rmiPairList = null;
    private List<SJmoLdevDetail> ldevDetailList = null;
    private List<SJmoLdevNicknameInfo> ldevNameList = null;
    private List<SJmoLdevLuseInfo> luseList = null;
    private List<SJmoClprInfo> clprList = null;
    private SJmoSubsystemInfo subsystemInfo = null;
    private SJmoRemoteReplicationMRCUInfoMgr mrcuMgr = null;

    public SJctrTcViewPairPropertiesPropertiesDataModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataModel("COM_LOCAL_STORAGE_SYSTEM_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_REMOTE_STORAGE_SYSTEM_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_TABLE_NUM_OF_PATHS", new SJctrRemotePairPropNumOfLunPathTableDataModel());
        this.addDataModel("COM_TABLE_PATH_GROUP", new SJctrRemotePairPropPathGroupTableDataModel());
    }

    @Override
    public void makeDataObject() {
        if (SJctrRemoteReplicationUtility.isHP()) {
            this.imageDirectory = IMAGE_PATH_HP;
        }
        this.rmiPairList = this.getDataController().getProxy().getCache(SJctrGetRmcp1PairDetailList.class);
        this.ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this.getDataController());
        Collections.sort(this.ldevDetailList);
        this.ldevNameList = SJctrReplicationUtility.getSJmoLdevNicknameInfo(this.getDataController());
        Collections.sort(this.ldevNameList);
        this.luseList = SJctrReplicationUtility.getSJmoLdevLuseInfo(this.getDataController());
        Collections.sort(this.luseList);
        this.clprList = SJctrReplicationUtility.getSJmoClprInfo(this.getDataController());
        Collections.sort(this.clprList);
        this.subsystemInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this.getDataController());
        this.mrcuMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this.getDataController());
    }

    public void makeProperties(SJmoTrueCopyPairVolInfo pairInfo, SJctrDataController dc) {
        SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(pairInfo);
        this.setCopyTypeImage(pairInfo);
        RMCPget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairList, pairInfo);
        if (rmiPair == null) {
            this.logUty.putlog("makeProperties", "RMI Pair Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.setConnectionInfo(pairInfo, rmiPair);
        this.setLocalStorageSystemInfo(localVol, rmiPair, pairInfo, dc);
        this.setRemoteStorageSystemInfo(pairInfo, rmiPair);
        if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
            SJctrRemotePairPropNumOfLunPathTableDataModel lunTable = (SJctrRemotePairPropNumOfLunPathTableDataModel)this.getDataModel("COM_TABLE_NUM_OF_PATHS");
            lunTable.updateNumOfPaths(localVol);
        }
        SJctrRemotePairPropPathGroupTableDataModel pathGrpTable = (SJctrRemotePairPropPathGroupTableDataModel)this.getDataModel("COM_TABLE_PATH_GROUP");
        this.setPortAttribute(pairInfo);
        SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteReplicationUtility.getPairRcuInfoNoThrow(pairInfo, this.mrcuMgr);
        pathGrpTable.updatePathTable(rcuInfo);
    }

    private void setConnectionInfo(SJmoTrueCopyPairVolInfo remoteVol, RMCPget1PairDetail rmiPair) {
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        String status = remoteUty.getTcCopyStatusString(remoteVol);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS", status);
        int statusIconId = SJctrRemoteReplicationUtility.getTcPairStatusIconId(remoteVol);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON", statusIconId);
        if (statusIconId == 16405) {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W", GP_ERROR_L);
        } else {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W", "");
        }
        if (rmiPair.VolumeType == 0) {
            ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION", COPY_DIRECTION_TO_REMOTE);
        } else if (rmiPair.VolumeType == 1) {
            ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION", COPY_DIRECTION_TO_LOCAL);
        } else {
            this.logUty.putlog("makeProperties", "Local Pair Position is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean cuFreeFlg = false;
        if (rmiPair.CUFree == 1) {
            cuFreeFlg = true;
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_PATH_GROUP_FLG", cuFreeFlg);
        boolean pathLinkFlg = rmiPair.VolumeType == 0;
        ((SJctrDataObject)this.getManageData()).setData(SJctrViewRemotePairPropertiesDataMacro.KEY_PATH_LINK_FLG, pathLinkFlg);
        String pathGrpStr = null;
        pathGrpStr = cuFreeFlg ? SJctrComUtility.toHexString(rmiPair.PairRCUID, 2, true) : (pathLinkFlg ? this.getComUtility().getGuidance("RMT_PATH") : "");
        ((SJctrDataObject)this.getManageData()).setData("COM_PATH_GROUP", pathGrpStr);
    }

    private void setLocalStorageSystemInfo(SJmoReplicationPairVolInfo localVol, RMCPget1PairDetail rmiPair, SJmoTrueCopyPairVolInfo remoteVol, SJctrDataController dc) {
        String ldevAttr;
        SJctrSimpleDataModel localSysInfo = (SJctrSimpleDataModel)this.getDataModel("COM_LOCAL_STORAGE_SYSTEM_INF");
        SJmoLdevDetail ldevDetail = null;
        int index = Collections.binarySearch(this.ldevDetailList, localVol);
        if (0 > index) {
            this.logUty.putlog("setLocalStorageSystemInfo", "LDEV Detail Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ldevDetail = this.ldevDetailList.get(index);
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        SJctrLdevUtility ldevUty = this.getComUtility().getLdevUtility();
        String ldevId = SJctrRemoteReplicationUtility.getLdevIdWithLdevName(localVol, this.ldevNameList, ldevUty);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_LDEV_ID", ldevId);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_NUM_OF_PATHS", String.valueOf(ldevDetail.getILUPathNumber()));
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_NUM_OF_PATHS_FLG", SJctrRemoteReplicationUtility.isOpen(remoteVol));
        String provisioningType = ldevUty.toVolumeTypeDisplay(ldevDetail);
        String encrypted = remoteUty.getLocalEncryptedStr(ldevDetail);
        String t10pi = SJctrRemoteReplicationUtility.addDelimiter(remoteUty.getT10PIString(ldevDetail));
        if (!"".equals(encrypted)) {
            provisioningType = provisioningType + " , " + encrypted;
        }
        provisioningType = provisioningType + t10pi;
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_PROVISIONING_TYPE", provisioningType);
        String emuCap = "";
        emuCap = SJctrDataController.isHM() ? (ldevUty.isLdevAttributeNone(ldevAttr = ldevUty.toLdevAttributeDisplay(ldevDetail)) ? this.getLocalCapacityStr(rmiPair, remoteVol) : ldevAttr + " , " + this.getLocalCapacityStr(rmiPair, remoteVol)) : this.getLocalEmuTypeStr(rmiPair, remoteVol) + " , " + this.getLocalCapacityStr(rmiPair, remoteVol);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_EMULATION_TYPE_CAP", emuCap);
        int modelId = remoteUty.getModelIDfromSubsysInfo(this.subsystemInfo);
        String modelIdString = dc.getOwner().getProductName();
        String serialNumber = this.subsystemInfo.getDKCSNString();
        SJmoClprIndex clprIndex = new SJmoClprIndex();
        clprIndex.setSClpr(ldevDetail.getSCLPR());
        index = Collections.binarySearch(this.clprList, clprIndex);
        String clprString = "?";
        if (0 <= index) {
            clprString = ldevUty.toClprDisplay(this.clprList.get(index));
        }
        String modelSnClpr = modelIdString + " / " + serialNumber + " , " + clprString;
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_MODEL_SERIAL_NUM_CLPR", modelSnClpr);
    }

    private void setRemoteStorageSystemInfo(SJmoTrueCopyPairVolInfo remoteVol, RMCPget1PairDetail rmiPair) {
        SJctrSimpleDataModel remoteStorageSystemInfo = (SJctrSimpleDataModel)this.getDataModel("COM_REMOTE_STORAGE_SYSTEM_INF");
        SJctrLdevUtility ldevUty = this.getComUtility().getLdevUtility();
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        String ldevId = ldevUty.toLdevDisplay(remoteVol);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_LDEV_ID", ldevId);
        boolean lunDispFlg = SJctrRemoteReplicationUtility.isOpen(remoteVol);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_PORT_HOSTGROUP_LUN_FLG", lunDispFlg);
        if (lunDispFlg) {
            RMCPgetHorcPairLU rmiRemoteLun = null;
            if (rmiPair.VolumeType == 0) {
                rmiRemoteLun = rmiPair.SLUN;
            } else if (rmiPair.VolumeType == 1) {
                rmiRemoteLun = rmiPair.PLUN;
            } else {
                this.logUty.putlog("makeProperties", "Local Pair Position is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            String portId = this.getComUtility().getGuidance("PORT_NAME_PART_CL");
            portId = portId + SJctrRemoteReplicationUtility.getPortNameMap(rmiPair.PairControllerID).get((short)rmiRemoteLun.PortNo);
            String hgId = SJctrComUtility.toHexString(rmiRemoteLun.GroupNo, 2, true);
            String lunId = null;
            lunId = SJctrRemoteReplicationUtility.isLunDec(this.getDataController().getOwner().getUserSession()) ? String.valueOf(rmiRemoteLun.LUN) : SJctrComUtility.toHexString(rmiRemoteLun.LUN, 4, true);
            String portHgLun = portId + " / " + hgId + " / " + lunId;
            ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_PORT_HOSTGROUP_LUN", portHgLun);
        }
        String emuCap = "";
        emuCap = SJctrDataController.isHM() ? this.getRemoteCapacityStr(rmiPair, remoteVol) : this.getRemoteEmuTypeStr(rmiPair, remoteVol) + " , " + this.getRemoteCapacityStr(rmiPair, remoteVol);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_EMULATION_TYPE_CAP", emuCap);
        String modelSnStr = remoteUty.getModelSNoString(rmiPair.PairControllerID, rmiPair.SN);
        if (rmiPair.CUFree == 0) {
            String ssid = SJctrComUtility.toHexString(rmiPair.SSID, 4, true);
            modelSnStr = modelSnStr + " , " + ssid;
        }
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_MODEL_SERIAL_NUM_SSID", modelSnStr);
    }

    private void setCopyTypeImage(SJmoTrueCopyPairVolInfo pairInfo) {
        String copyTypeImage = this.imageDirectory;
        if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
            copyTypeImage = copyTypeImage + BG_FILE_TC;
        } else if (SJctrRemoteReplicationUtility.isMainframe(pairInfo)) {
            copyTypeImage = copyTypeImage + BG_FILE_TCMF;
        } else {
            this.logUty.putlog("makeProperties", "Unknown Copy Type.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_COPY_TYPE_IMAGE", copyTypeImage);
    }

    private void setPortAttribute(SJmoTrueCopyPairVolInfo tcPair) {
        int attribute = SJctrRemoteReplicationUtility.getPairPortAttribute(tcPair);
        SJctrSelectedRmPathTableDataModelBase table = (SJctrSelectedRmPathTableDataModelBase)this.getDataModel("COM_TABLE_PATH_GROUP");
        table.setPortAttribute(attribute);
    }

    private String getLocalEmuTypeStr(RMCPget1PairDetail rmiPair, SJmoTrueCopyPairVolInfo modelPair) {
        String ret = "?";
        if (SJctrRemoteReplicationUtility.isPvol(modelPair)) {
            ret = rmiPair.SVolEmulation;
        } else if (SJctrRemoteReplicationUtility.isSvol(modelPair)) {
            ret = rmiPair.PVolEmulation;
        }
        return ret;
    }

    private String getLocalCapacityStr(RMCPget1PairDetail rmiPair, SJmoTrueCopyPairVolInfo modelPair) {
        String ret = "?";
        SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
        if (SJctrRemoteReplicationUtility.isOpenPvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.SVolCapacity);
        } else if (SJctrRemoteReplicationUtility.isOpenSvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.PVolCapacity);
        } else if (SJctrRemoteReplicationUtility.isMainframePvol(modelPair)) {
            ret = String.valueOf(rmiPair.SVolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        } else if (SJctrRemoteReplicationUtility.isMainframeSvol(modelPair)) {
            ret = String.valueOf(rmiPair.PVolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        }
        return ret;
    }

    private String getRemoteEmuTypeStr(RMCPget1PairDetail rmiPair, SJmoTrueCopyPairVolInfo modelPair) {
        String ret = "?";
        if (SJctrRemoteReplicationUtility.isPvol(modelPair)) {
            ret = rmiPair.PVolEmulation;
        } else if (SJctrRemoteReplicationUtility.isSvol(modelPair)) {
            ret = rmiPair.SVolEmulation;
        }
        return ret;
    }

    private String getRemoteCapacityStr(RMCPget1PairDetail rmiPair, SJmoTrueCopyPairVolInfo modelPair) {
        String ret = "?";
        SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
        if (SJctrRemoteReplicationUtility.isOpenPvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.PVolCapacity);
        } else if (SJctrRemoteReplicationUtility.isOpenSvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.SVolCapacity);
        } else if (SJctrRemoteReplicationUtility.isMainframePvol(modelPair)) {
            ret = String.valueOf(rmiPair.PVolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        } else if (SJctrRemoteReplicationUtility.isMainframeSvol(modelPair)) {
            ret = String.valueOf(rmiPair.SVolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        }
        return ret;
    }
}

