/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.serverux.dataimpl.HURget1PairDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrGetHurPairDetail;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;

public class SJctrUrViewPairPropertiesDetailDataModel
extends SJctrSimpleDataModel {
    private List<HURget1PairDetail> rmiPairList = null;

    public SJctrUrViewPairPropertiesDetailDataModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataModel("COM_PAIR1_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_PAIR2_INF", new SJctrSimpleDataModel());
    }

    @Override
    protected void makeModelDirect() {
        super.makeModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public void makeDataObject() {
        this.rmiPairList = this.getDataController().getProxy().getCache(SJctrGetHurPairDetail.class);
    }

    public void makeSummary(List<SJmoUniversalReplicatorPairVolInfo> remoteVolList) {
        if (remoteVolList.size() == 0) {
            this.logUty.putlog("makeSummary", "size of Remote Volume List is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(remoteVolList, new Comparator(){

            public int compare(Object o1, Object o2) {
                int ret = ((SJmoUniversalReplicatorPairVolInfo)o1).getMirrorId() - ((SJmoUniversalReplicatorPairVolInfo)o2).getMirrorId();
                return ret;
            }
        });
        SJmoUniversalReplicatorPairVolInfo remoteVol1 = remoteVolList.get(0);
        HURget1PairDetail rmiPair1 = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairList, remoteVol1);
        if (rmiPair1 == null) {
            this.logUty.putlog("makeSummary", "First RMI Pair Information  is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.setPairSummary("COM_PAIR1_INF", rmiPair1, remoteVol1);
        if (remoteVolList.size() > 1) {
            SJmoUniversalReplicatorPairVolInfo remoteVol2 = remoteVolList.get(1);
            HURget1PairDetail rmiPair2 = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairList, remoteVol2);
            if (rmiPair2 == null) {
                this.logUty.putlog("makeSummary", "Second RMI Pair Information is null.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            this.setPairSummary("COM_PAIR2_INF", rmiPair2, remoteVol2);
        }
    }

    private void setPairSummary(String pairInfoKey, HURget1PairDetail rmiPairInfo, SJmoUniversalReplicatorPairVolInfo remoteVol) {
        int targetLdev;
        if (null == rmiPairInfo) {
            this.logUty.putlog("setPairSummary", "RMI Pair Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoHUVMVirtualLdev huvmVirtualLdev = null;
        List<SJmoHUVMVirtualLdev> huvmVirtualLdevList = SJctrRemoteReplicationUtility.getSJmoHUVMVirtualLdev(this.getDataController());
        SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolume(remoteVol);
        if (localVol != null && 0 <= (targetLdev = Collections.binarySearch(huvmVirtualLdevList, localVol))) {
            huvmVirtualLdev = huvmVirtualLdevList.get(targetLdev);
        }
        SJmoHUVMVirtualDkc huvmVirtualDkc = null;
        if (huvmVirtualLdev != null) {
            int targetDkc;
            List<SJmoHUVMVirtualDkc> huvmVirtualDkcList = SJctrRemoteReplicationUtility.getSJmoHUVMVirtualDkc(this.getDataController());
            SJmoHUVMvboxIndex vBoxIndex = huvmVirtualLdev.getVBoxIndex();
            if (vBoxIndex != null && 0 <= (targetDkc = Collections.binarySearch(huvmVirtualDkcList, vBoxIndex))) {
                huvmVirtualDkc = huvmVirtualDkcList.get(targetDkc);
            }
        }
        SJctrSimpleDataModel pairDataModel = (SJctrSimpleDataModel)this.getDataModel(pairInfoKey);
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        SJctrRsgUtility rsgUty = this.getComUtility().getRsgUtility();
        SJctrLdevUtility ldevUty = this.getComUtility().getLdevUtility();
        String statusStr = remoteUty.getUrCopyStatusString(remoteVol, true);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_STATUS", statusStr);
        String ctgStr = remoteUty.getUrCtgIdString(remoteVol);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_CTG_ID", ctgStr);
        String subStatusStr = remoteUty.getSubStatusString(remoteVol);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_SUB_STATUS", subStatusStr);
        String reverseResyncStr = remoteUty.getReverseResyncStr(rmiPairInfo.reverseResync);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_REVERSE_RESYNC", reverseResyncStr);
        String errLvStr = remoteUty.getErrorLevelString(remoteVol);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_ERROR_LEVEL", errLvStr);
        String svolWritten = remoteUty.getSecondaryVolumeWritten(rmiPairInfo);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_SECONDARY_VOLUME_WRITTEN", svolWritten);
        String initialCopyPriority = remoteUty.getUrCopyPriorityString(remoteVol);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_INITIAL_COPY_PRIORITY", initialCopyPriority);
        String pairedTime = SJctrRemoteReplicationUtility.convertRmiTime(rmiPairInfo.establishedTime);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_PAIRED_TIME", pairedTime);
        String updateTime = SJctrRemoteReplicationUtility.convertRmiTime(rmiPairInfo.updateTime);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_LAST_UPDATE_TIME", updateTime);
        String copyTime = SJctrRemoteReplicationUtility.getCopyTimeStringUR(rmiPairInfo);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_PAIR_COPY_TIME", copyTime);
        String ctTime = SJctrRemoteReplicationUtility.convertConsistencyTime(rmiPairInfo.timerKind, rmiPairInfo.ct);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_CONSISTENCY_TIME", ctTime);
        String timerType = remoteUty.getTimerTypeString(remoteVol, rmiPairInfo.timerKind);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_TIMER_TYPE", timerType);
        String cfw = remoteUty.getCfwString(remoteVol);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_CFW", cfw);
        if (pairInfoKey == "COM_PAIR1_INF") {
            String localVdkc = rsgUty.toDispStringVssModelSerialNo(huvmVirtualDkc);
            ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_LOCAL_VDKC", localVdkc);
            String localVldevId = rsgUty.toDispStringVssLdevID(huvmVirtualLdev, ldevUty);
            ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_LOCAL_VLDEV_ID", localVldevId);
            String localDeviceName = rsgUty.toDispStringVssDeviceName(huvmVirtualLdev, ldevUty);
            ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_LOCAL_DEVICE_NAME", localDeviceName);
            String localVssid = rsgUty.toDispStringVssSsid(huvmVirtualLdev);
            ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_LOCAL_VSSID", localVssid);
        }
        String remoteVdkc = remoteUty.getVssModelSNString(remoteVol);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_REMOTE_VDKC", remoteVdkc);
        String remoteVldevId = remoteUty.getVirtualPairLDEVString(remoteVol, ldevUty);
        ((SJctrDataObject)pairDataModel.getManageData()).setData("COM_REMOTE_VLDEV_ID", remoteVldevId);
    }
}

