/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_RJiHURgetPairsInfo;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.dataimpl.RJiHURget1PairInfo;
import sanproject.serverux.dataimpl.RJiHURgetPairsInfo_IN;
import sanproject.serverux.dataimpl.RJiHURgetPairsInfo_OUT;
import sanproject.serverux.dataimpl.RJiInputHurPairParam;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrViewPairSyncrateInfoMsgFlagData;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrGetRJiHURgetPairsInfo;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateUrTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateUrUrmfInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;

public class SJctrViewPairSyncRateUrDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 35385397;
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_TABLE_VIEW_INFO = "COM_TABLE_VIEW_INFO";
    private static final String KEY_TABLE_UR = "COM_TABLE_UR";
    private static final String KEY_REFRESH = "COM_REFRESH";
    private static final String KEY_VIEWMSG = "COM_VIEWMSG";

    public SJctrViewPairSyncRateUrDC() {
        super(35385397);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrViewPairSyncRateUrTableDataModel viewPairSyncRateTableModel = new SJctrViewPairSyncRateUrTableDataModel();
        this.addDataObjectModel(KEY_TABLE, viewPairSyncRateTableModel);
        SJctrButtonDataModel refreshButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REFRESH, refreshButton);
        refreshButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewPairSyncRateUrDC.this.fireMessageEvent(SYNC_RATE_MSG.SELECT_REFRESH);
            }
        });
        this.addDataObjectModel(KEY_VIEWMSG, new SJctrViewPairSyncrateInfoMsgFlagData());
        this.getManageData().setData(KEY_TABLE_VIEW_INFO, KEY_TABLE_UR);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(SYNC_RATE_MSG.SELECT_REFRESH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewPairSyncRateUrDC.this.refreshTableAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> inheritedList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == inheritedList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == inheritedList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        try {
            List<?> inheritedList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            List<?> urPairInfoMgrList = SJctrRemoteReplicationUtility.getSpecifiedModelInfoMgrNotUsedCache(this, new SJmoGetUniversalReplicatorPairVolInfoMgr());
            SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel = (SJctrViewPairSyncrateInfoMsgFlagData)this.getDataObjectModel(KEY_VIEWMSG);
            List<SJctrViewPairSyncRateUrUrmfInfo> rmiDataList = this.createConstructData(inheritedList, (SJmoUniversalReplicatorPairVolInfoMgr)urPairInfoMgrList.get(0), informationFlagModel);
            SJctrViewPairSyncRateUrTableDataModel pairTable = (SJctrViewPairSyncRateUrTableDataModel)this.getDataObjectModel(KEY_TABLE);
            pairTable.setBasicDataList(rmiDataList);
            pairTable.setInfoLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevDetail()));
            pairTable.setInfoLdevNickname(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevNicknameInfo()));
            pairTable.setInfoClpr(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetClprInfo()));
            pairTable.setInfoVirtualDkc(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualDkc()));
            pairTable.setInfoVirtualLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualLdev()));
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107002);
        }
        return ret;
    }

    private void refreshTableAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrViewPairSyncRateUrTableDataModel pairTable = (SJctrViewPairSyncRateUrTableDataModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> inheritedList = pairTable.getAllRowData();
            List<?> urPairInfoMgrList = SJctrRemoteReplicationUtility.getSpecifiedModelInfoMgrNotUsedCache(this, new SJmoGetUniversalReplicatorPairVolInfoMgr());
            SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel = (SJctrViewPairSyncrateInfoMsgFlagData)this.getDataObjectModel(KEY_VIEWMSG);
            List<SJctrViewPairSyncRateUrUrmfInfo> rmiDataList = this.createConstructData(inheritedList, (SJmoUniversalReplicatorPairVolInfoMgr)urPairInfoMgrList.get(0), informationFlagModel);
            pairTable.setBasicDataList(rmiDataList);
            pairTable.setInfoLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevDetail()));
            pairTable.setInfoLdevNickname(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevNicknameInfo()));
            pairTable.setInfoClpr(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetClprInfo()));
            pairTable.setInfoVirtualDkc(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualDkc()));
            pairTable.setInfoVirtualLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualLdev()));
            List<Object> selectData = pairTable.getSelectedRowData();
            pairTable.doRefresh();
            pairTable.addRowSelectionList(selectData);
            informationFlagModel.setDirty();
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107004);
        }
    }

    private List<SJctrViewPairSyncRateUrUrmfInfo> createConstructData(List<?> inheritedList, SJmoUniversalReplicatorPairVolInfoMgr urPairInfoMgr, SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel) {
        ArrayList<SJctrViewPairSyncRateUrUrmfInfo> rmiDataList = new ArrayList();
        List<Object> checkPairList = new ArrayList();
        checkPairList = SJctrRemoteReplicationUtility.getExistUrPairVolInfo(inheritedList, urPairInfoMgr);
        if (checkPairList.isEmpty()) {
            this.logUty.putlog("createConstructData", "Size of checkPairList is zero.");
            SJctrError err = new SJctrError(210, 22, 206502);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoUniversalReplicatorPairVolInfo> urPairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        ArrayList<SJmoUniversalReplicatorPairVolInfo> urmfPairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        this.setPairListSeparateUrUrmf(urPairList, urmfPairList, checkPairList);
        Robj_interface_RJiHURgetPairsInfo urRmiData = null;
        Robj_interface_RJiHURgetPairsInfo urmfRmiData = null;
        if (!urPairList.isEmpty()) {
            urRmiData = this.getPairSynchRateInfo(urPairList);
        }
        if (!urmfPairList.isEmpty()) {
            urmfRmiData = this.getPairSynchRateInfo(urmfPairList);
        }
        rmiDataList = this.makeDataList(urRmiData, urmfRmiData, checkPairList);
        this.removeInvalidStatusPair(rmiDataList);
        Collections.sort(rmiDataList, new SJctrUniversalReplicatorPairInfoComparator());
        if (0 == rmiDataList.size()) {
            this.logUty.putlog("createConstructData", "Size of rmiDataList is zero.");
            SJctrError err = new SJctrError(210, 22, 206502);
            SJcException exp = err.createException();
            throw exp;
        }
        if (rmiDataList.size() < inheritedList.size()) {
            informationFlagModel.setInformationFlag(1);
        } else {
            informationFlagModel.setInformationFlag(0);
        }
        return rmiDataList;
    }

    private Robj_interface_RJiHURgetPairsInfo getPairSynchRateInfo(List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        List<SJmoThroughRmiData> rmiData = this.getSyncRateModelDirect(pairList);
        RJiHURgetPairsInfo_OUT pairRateInfo = (RJiHURgetPairsInfo_OUT)rmiData.get(0).getObjRmi();
        Robj_interface_RJiHURgetPairsInfo pairRate = pairRateInfo.getDataObject();
        return pairRate;
    }

    private List<SJmoThroughRmiData> getSyncRateModelDirect(List<SJmoUniversalReplicatorPairVolInfo> pairlist) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        RJiInputHurPairParam paramPairRate = this.createParamPairRate(pairlist);
        RJiHURgetPairsInfo_IN pairRate = new RJiHURgetPairsInfo_IN(paramPairRate);
        SJctrGetRJiHURgetPairsInfo kindPairSyncRate = new SJctrGetRJiHURgetPairsInfo(pairRate);
        SJmoGetRange_IF rangePairSyncRate = null;
        ArrayList filterPairSyncRate = new ArrayList();
        SJmoGetDirect directPairSyncRate = new SJmoGetDirect(kindPairSyncRate, rangePairSyncRate, filterPairSyncRate);
        SJctrGetDirectWrapper wrapperPairSyncRate = new SJctrGetDirectWrapper(directPairSyncRate);
        wrapperPairSyncRate.setCacheMode(false);
        set.add(wrapperPairSyncRate);
        SJctrLogUty.info("SJctrViewPairSyncRateUrDC", "getSyncRateModelDirect", "Number of Pair = " + pairlist.size() + ", Kind Class = " + SJctrGetRJiHURgetPairsInfo.class.getName());
        Map<SJctrGetDirectWrapper, List<?>> map = this.getProxy().getDataInf(set);
        List<SJmoThroughRmiData> syncRateData = map.get(wrapperPairSyncRate);
        return syncRateData;
    }

    private RJiInputHurPairParam createParamPairRate(List<SJmoUniversalReplicatorPairVolInfo> pairList) {
        RJiInputHurPairParam pairRate = new RJiInputHurPairParam();
        if (null == pairList || 0 == pairList.size()) {
            this.logUty.putlog("createParamPairRate", "pairList is null or size zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Robj_interface_RJiLDEVIndex[] param = null;
        param = SJctrRemoteReplicationUtility.createPairDetailUrParam(pairList);
        pairRate.setLDEVs(param);
        if (SJctrRemoteReplicationUtility.isOpen(pairList.get(0))) {
            pairRate.setPP((short)1);
        } else if (SJctrRemoteReplicationUtility.isMainframe(pairList.get(0))) {
            pairRate.setPP((short)0);
        } else {
            this.logUty.putlog("createParamPairRate", "pairList is not Open or Mainframe.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return pairRate;
    }

    private List<SJctrViewPairSyncRateUrUrmfInfo> makeDataList(Robj_interface_RJiHURgetPairsInfo rmiUrData, Robj_interface_RJiHURgetPairsInfo rmiUrmfData, List<SJmoUniversalReplicatorPairVolInfo> checkPairList) {
        if (null == rmiUrData && null == rmiUrmfData) {
            this.logUty.putlog("makeDataList", "Parameter is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJctrViewPairSyncRateUrUrmfInfo> rtnList = new ArrayList<SJctrViewPairSyncRateUrUrmfInfo>();
        this.setViewPairSyncRateUrUrmfInfo(rtnList, rmiUrData, 1, checkPairList);
        this.setViewPairSyncRateUrUrmfInfo(rtnList, rmiUrmfData, 0, checkPairList);
        return rtnList;
    }

    private void setPairListSeparateUrUrmf(List<SJmoUniversalReplicatorPairVolInfo> urPairList, List<SJmoUniversalReplicatorPairVolInfo> urmfPairList, List<SJmoUniversalReplicatorPairVolInfo> checkPairList) {
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : checkPairList) {
            if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
                urPairList.add(pairInfo);
                continue;
            }
            if (!SJctrRemoteReplicationUtility.isMainframe(pairInfo)) continue;
            urmfPairList.add(pairInfo);
        }
    }

    private void setViewPairSyncRateUrUrmfInfo(List<SJctrViewPairSyncRateUrUrmfInfo> pairInfoList, Robj_interface_RJiHURgetPairsInfo rmiData, int copytype, List<SJmoUniversalReplicatorPairVolInfo> checkPairList) {
        ArrayList<SJctrViewPairSyncRateUrUrmfInfo> syncPairList = new ArrayList<SJctrViewPairSyncRateUrUrmfInfo>();
        if (null != rmiData) {
            ArrayList rmiPairInfoList = rmiData.getPairInfo();
            for (RJiHURget1PairInfo pairInfo : rmiPairInfoList) {
                if (pairInfo == null) continue;
                SJctrLogUty.info(SJctrViewPairSyncRateUrDC.class.getSimpleName(), "setViewPairSyncRateUrUrmfInfo", "PairVolumePosition = " + pairInfo.getPairKind() + ", CopyType = " + copytype + ", PairStatus = " + pairInfo.getPairStatus() + ", QueueState = " + pairInfo.copyQueue + ", SynchronousRate = " + pairInfo.getProgress());
                SJctrViewPairSyncRateUrUrmfInfo pairVolInfo = new SJctrViewPairSyncRateUrUrmfInfo(pairInfo);
                pairVolInfo.setQueu(pairInfo.copyQueue);
                pairVolInfo.setSyncRate(pairInfo.getProgress());
                pairVolInfo.setIPairVolPos(SJctrRemoteReplicationUtility.getPairVolPosInfoFromPairSummaryURURMF(copytype, pairInfo));
                if (SJctrRemoteReplicationUtility.isPvol(pairVolInfo)) {
                    ArrayList<SJmoReplicationPairVolInfo> alSVolIndex = new ArrayList<SJmoReplicationPairVolInfo>(1);
                    SJmoReplicationPairVolInfo sVolIndex = new SJmoReplicationPairVolInfo();
                    sVolIndex.setLdevIndex(pairInfo.getSVolInfo().getSLDKC(), pairInfo.getSVolInfo().getSCU(), pairInfo.getSVolInfo().getSLDEV());
                    alSVolIndex.add(sVolIndex);
                    pairVolInfo.setAlSVolIndex(alSVolIndex);
                } else if (SJctrRemoteReplicationUtility.isSvol(pairVolInfo)) {
                    ArrayList<SJmoReplicationPairVolInfo> alPVolIndex = new ArrayList<SJmoReplicationPairVolInfo>(1);
                    SJmoReplicationPairVolInfo pVolIndex = new SJmoReplicationPairVolInfo();
                    pVolIndex.setLdevIndex(pairInfo.getPVolInfo().getSLDKC(), pairInfo.getPVolInfo().getSCU(), pairInfo.getPVolInfo().getSLDEV());
                    alPVolIndex.add(pVolIndex);
                    pairVolInfo.setAlPVolIndex(alPVolIndex);
                } else {
                    this.logUty.putlog("setrViewPairSyncRateTcTcmfInfo", "Pair position is invalid.");
                    SJctrError err = new SJctrError(210, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
                syncPairList.add(pairVolInfo);
            }
        }
        Collections.sort(syncPairList);
        for (SJmoUniversalReplicatorPairVolInfo selectedPair : checkPairList) {
            int index = Collections.binarySearch(syncPairList, selectedPair);
            if (index < 0) continue;
            pairInfoList.add((SJctrViewPairSyncRateUrUrmfInfo)syncPairList.get(index));
        }
    }

    private void removeInvalidStatusPair(List<SJctrViewPairSyncRateUrUrmfInfo> rmiPairList) {
        Iterator<SJctrViewPairSyncRateUrUrmfInfo> ite = rmiPairList.iterator();
        while (ite.hasNext()) {
            SJctrViewPairSyncRateUrUrmfInfo rmiPair = ite.next();
            if (this.checkViewPairSyncRateUrStatus(rmiPair.getDelta(), rmiPair.getPairStatus())) continue;
            ite.remove();
        }
    }

    private boolean checkViewPairSyncRateUrStatus(int iDelta, int pairStatus) {
        boolean rtn = false;
        rtn = iDelta == 0 ? SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_PAIR_SYNC_RATE_UR_URMF.contains(pairStatus) : true;
        return rtn;
    }

    public static enum SYNC_RATE_MSG implements SJctrNotifyState
    {
        SELECT_REFRESH;

    }
}

