/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewremoteconnprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.replication.connections.to.SJctrRemoteConnectionsToDC;
import sanproject.sn2.controller.topwindow.replication.journals.mirrors.SJctrJnlsMirrorsDC;
import sanproject.sn2.controller.topwindow.replication.remote.hapairs.SJctrRemoteReplicationHaPairsDC;
import sanproject.sn2.controller.topwindow.replication.remote.mirrors.SJctrRemoteReplicationMirrorsDC;
import sanproject.sn2.controller.topwindow.replication.remote.tcpairs.SJctrRemoteReplicationTcPairsDC;
import sanproject.sn2.controller.topwindow.replication.remote.urpairs.SJctrRemoteReplicationUrPairsDC;
import sanproject.sn2.controller.wizard.replication.remote.viewremoteconnprops.SJctrViewRemoteConnPropsDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;

public class SJctrItemSelectListenerViewRemoteConnProps
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            SJctrUserController uc = dc.getOwner();
            List<Object> selectedConnectList = new ArrayList();
            int attribute = -1;
            if (dc instanceof SJctrRemoteConnectionsToDC) {
                SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
                if (table == null) {
                    uc.getLogUty().putlog("selectChanged", "Top table data model is null.");
                    SJctrError err = new SJctrError(210, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
                selectedConnectList = table.getSelectedRowData();
                attribute = 5;
            } else if (dc instanceof SJctrRemoteReplicationTcPairsDC) {
                selectedConnectList = this.getRCUInfoFromTcPair(dc);
                attribute = this.getPortAttributeTcPair(dc);
            } else if (dc instanceof SJctrRemoteReplicationUrPairsDC) {
                selectedConnectList = this.getRCUInfoFromUrPair(dc);
                attribute = this.getPortAttributeUrPair(dc);
            } else if (dc instanceof SJctrRemoteReplicationMirrorsDC) {
                selectedConnectList = this.getRCUInfoFromMirror(dc);
                attribute = this.getPortAttributeMirror(dc);
            } else if (dc instanceof SJctrRemoteReplicationHaPairsDC) {
                selectedConnectList = this.getRCUInfoFromHaPair(dc);
                attribute = this.getPortAttributeHaPair(dc);
            } else if (dc instanceof SJctrJnlsMirrorsDC) {
                selectedConnectList = this.getRCUInfoFromMirror(dc);
                attribute = this.getPortAttributeMirror(dc);
            } else {
                uc.getLogUty().putlog("selectChanged", "Inherited Information is null.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedConnectList.size() == 0) {
                uc.getLogUty().putlog("selectChanged", "selectedConnectList is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<Object> param = new ArrayList<Object>();
            HashMap paramMap = new HashMap();
            paramMap.put("KEY_REMOTE_SELECTED_CONNECTION", selectedConnectList);
            ArrayList<Integer> attributeList = new ArrayList<Integer>(1);
            attributeList.add(attribute);
            paramMap.put("KEY_REMOTE_SELECTED_CONNECTION_ATTRIBUTE", attributeList);
            param.add(SJctrViewRemoteConnPropsDC.class);
            param.add(paramMap);
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_DIALOG_EX, param);
        }
    }

    private List<SJmoRemoteReplicationRCUInfo> getRCUInfoFromTcPair(SJctrDataController dc) {
        ArrayList<SJmoRemoteReplicationRCUInfo> retList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        if (table == null) {
            dc.getLogUty().putlog("getRCUInfoFromTcPair", "Table data model is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoTrueCopyPairVolInfo tcPair = (SJmoTrueCopyPairVolInfo)table.getSelectedRowData().get(0);
        SJmoRemoteReplicationRCUInfo keyInfo = new SJmoRemoteReplicationRCUInfo();
        keyInfo.setSLdkc(tcPair.getSLdkc());
        ArrayList<Object> rcuInfoList = new ArrayList();
        if (1 == tcPair.getICUFree()) {
            keyInfo.setSCu((short)-1);
            keyInfo.setSCUNo((short)-1);
            SJmoRemoteReplicationMRCUInfo mrcuFreeInfo = this.getMRCUInfoMgr(dc).getMRCUFreeInfo();
            rcuInfoList = mrcuFreeInfo.getTrueCopyRCUInfoList();
        } else {
            keyInfo.setSCu(tcPair.getSCu());
            keyInfo.setSCUNo(SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(tcPair).getSCu());
            SJmoRemoteReplicationMRCUInfo mrcuInfo = this.getMRCUInfoMgr(dc).getMRCUInfo(SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(tcPair).getSCu());
            rcuInfoList = mrcuInfo.getTrueCopyRCUInfoList();
        }
        keyInfo.setStrSN(tcPair.getStrPairSN());
        keyInfo.setIRCUID(tcPair.getIPairRCUID());
        keyInfo.setIControllerID(tcPair.getIPairControllerID());
        int i = Collections.binarySearch(rcuInfoList, keyInfo);
        if (i < 0) {
            dc.getLogUty().putlog("getRCUInfoFromTcPair", "Information of SJmoRemoteReplicationRCUInfo data list is null.");
            SJctrError err = new SJctrError(210, 22, 206501);
            SJcException exp = err.createException();
            throw exp;
        }
        retList.add((SJmoRemoteReplicationRCUInfo)rcuInfoList.get(i));
        return retList;
    }

    private List<SJmoRemoteReplicationRCUInfo> getRCUInfoFromUrPair(SJctrDataController dc) {
        ArrayList<SJmoRemoteReplicationRCUInfo> retList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        if (table == null) {
            dc.getLogUty().putlog("getRCUInfoFromUrPair", "Table data model is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoUniversalReplicatorPairVolInfo urPair = (SJmoUniversalReplicatorPairVolInfo)table.getSelectedRowData().get(0);
        SJmoRemoteReplicationRCUInfo keyInfo = new SJmoRemoteReplicationRCUInfo();
        keyInfo.setSLdkc(urPair.getSLdkc());
        keyInfo.setSCu((short)-1);
        keyInfo.setSCUNo((short)-1);
        keyInfo.setStrSN(urPair.getPairSN());
        keyInfo.setIRCUID(urPair.getPathID());
        keyInfo.setIControllerID(urPair.getModelId());
        ArrayList<Object> rcuInfoList = new ArrayList();
        SJmoRemoteReplicationMRCUInfo mrcuFreeInfo = this.getMRCUInfoMgr(dc).getMRCUFreeInfo();
        rcuInfoList = mrcuFreeInfo.getTrueCopyRCUInfoList();
        int i = Collections.binarySearch(rcuInfoList, keyInfo);
        if (i < 0) {
            dc.getLogUty().putlog("getRCUInfoFromUrPair", "Information of SJmoRemoteReplicationRCUInfo data list is null.");
            SJctrError err = new SJctrError(210, 22, 206501);
            SJcException exp = err.createException();
            throw exp;
        }
        retList.add((SJmoRemoteReplicationRCUInfo)rcuInfoList.get(i));
        return retList;
    }

    private List<SJmoRemoteReplicationRCUInfo> getRCUInfoFromMirror(SJctrDataController dc) {
        ArrayList<SJmoRemoteReplicationRCUInfo> retList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        if (table == null) {
            dc.getLogUty().putlog("getRCUInfoFromMirror", "Table data model is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror = (SJmoUniversalReplicatorJnlGrpMirror)table.getSelectedRowData().get(0);
        if (0 == jnlGrpMirror.getStatus()) {
            dc.getLogUty().putlog("getRCUInfoFromMirror", "conenction is not exist.");
            SJctrError err = new SJctrError(210, 22, 206016);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRemoteReplicationRCUInfo keyInfo = new SJmoRemoteReplicationRCUInfo();
        keyInfo.setSLdkc((short)jnlGrpMirror.getLdkc());
        keyInfo.setSCUNo((short)-1);
        keyInfo.setStrSN(jnlGrpMirror.getPairSN());
        keyInfo.setSCu((short)-1);
        keyInfo.setIRCUID(jnlGrpMirror.getPathIdList().get(0));
        keyInfo.setIControllerID(jnlGrpMirror.getModelId());
        SJmoRemoteReplicationMRCUInfo mrcuFreeInfo = this.getMRCUInfoMgr(dc).getMRCUFreeInfo();
        ArrayList<SJmoRemoteReplicationRCUInfo> rcuInfoList = mrcuFreeInfo.getTrueCopyRCUInfoList();
        int i = Collections.binarySearch(rcuInfoList, keyInfo);
        if (i < 0) {
            dc.getLogUty().putlog("getRCUInfoFromMirror", "conenction is not exist.");
            SJctrError err = new SJctrError(210, 22, 206501);
            SJcException exp = err.createException();
            throw exp;
        }
        retList.add(rcuInfoList.get(i));
        return retList;
    }

    private SJmoRemoteReplicationMRCUInfoMgr getMRCUInfoMgr(SJctrDataController dc) {
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetRemoteReplicationMRCUInfoMgr kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct);
        directWrapper.setCacheMode(false);
        wrapperSet.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> dataMap = dc.getProxy().getDataInf(wrapperSet);
        List<?> mrcuInfoMgrList = dataMap.get(directWrapper);
        if (null == mrcuInfoMgrList) {
            dc.getLogUty().putlog("getMRCUInfoMgr", "Information of SJmoRemoteReplicationMRCUInfoMgr data list is null.");
            SJctrError err = new SJctrError(210, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == mrcuInfoMgrList.size()) {
            dc.getLogUty().putlog("getMRCUInfoMgr", "Size of SJmoRemoteReplicationMRCUInfoMgr data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = (SJmoRemoteReplicationMRCUInfoMgr)mrcuInfoMgrList.get(0);
        if (null == mrcuInfoMgr) {
            dc.getLogUty().putlog("getMRCUInfoMgr", "Information of SJmoRemoteReplicationMRCUInfoMgr is null.");
            SJctrError err = new SJctrError(210, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return mrcuInfoMgr;
    }

    private List<SJmoRemoteReplicationRCUInfo> getRCUInfoFromHaPair(SJctrDataController dc) {
        ArrayList<SJmoRemoteReplicationRCUInfo> retList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        if (table == null) {
            dc.getLogUty().putlog("getRCUInfoFromHaPair", "Table data model is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoHAPairVolInfo haPair = (SJmoHAPairVolInfo)table.getSelectedRowData().get(0);
        SJmoRemoteReplicationRCUInfo keyInfo = new SJmoRemoteReplicationRCUInfo();
        keyInfo.setSLdkc(haPair.getSLdkc());
        ArrayList<Object> rcuInfoList = new ArrayList();
        keyInfo.setSCu((short)-1);
        keyInfo.setSCUNo((short)-1);
        SJmoRemoteReplicationMRCUInfo mrcuFreeInfo = this.getMRCUInfoMgr(dc).getMRCUFreeInfo();
        rcuInfoList = mrcuFreeInfo.getTrueCopyRCUInfoList();
        keyInfo.setStrSN(haPair.getStrPairSN());
        keyInfo.setIRCUID(haPair.getIPathGroup());
        keyInfo.setIControllerID(haPair.getIPairModel());
        int i = Collections.binarySearch(rcuInfoList, keyInfo);
        if (i < 0) {
            dc.getLogUty().putlog("getRCUInfoFromHaPair", "Information of SJmoRemoteReplicationRCUInfo data list is null.");
            SJctrError err = new SJctrError(210, 22, 206501);
            SJcException exp = err.createException();
            throw exp;
        }
        retList.add((SJmoRemoteReplicationRCUInfo)rcuInfoList.get(i));
        return retList;
    }

    private int getPortAttributeTcPair(SJctrDataController dc) {
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        SJmoTrueCopyPairVolInfo tcPair = (SJmoTrueCopyPairVolInfo)table.getSelectedRowData().get(0);
        int attribute = SJctrRemoteReplicationUtility.getPairPortAttribute(tcPair);
        if (4 == attribute) {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206005);
        }
        return attribute;
    }

    private int getPortAttributeUrPair(SJctrDataController dc) {
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        SJmoUniversalReplicatorPairVolInfo urPair = (SJmoUniversalReplicatorPairVolInfo)table.getSelectedRowData().get(0);
        int attribute = SJctrRemoteReplicationUtility.getPairPortAttribute(urPair);
        if (4 == attribute) {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206005);
        }
        return attribute;
    }

    private int getPortAttributeMirror(SJctrDataController dc) {
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        SJmoUniversalReplicatorJnlGrpMirror mirror = (SJmoUniversalReplicatorJnlGrpMirror)table.getSelectedRowData().get(0);
        int attribute = -1;
        switch (mirror.getAttribute()) {
            case 1: {
                attribute = 5;
                break;
            }
            default: {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206007);
            }
        }
        return attribute;
    }

    private int getPortAttributeHaPair(SJctrDataController dc) {
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        SJmoHAPairVolInfo haPair = (SJmoHAPairVolInfo)table.getSelectedRowData().get(0);
        int attribute = SJctrHaUtility.getPairPortAttribute(haPair);
        if (4 == attribute) {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206005);
        }
        return attribute;
    }
}

