/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.addextvols;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrExtVolsDC;
import sanproject.sn2.controller.wizard.uvm.editpolicy.SJctrExdPolicyData;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrClprDataModel
extends SJctrComboBoxDataModel {
    Map<String, Short> clprMap = null;

    @Override
    protected void makeDataObject() {
        SJctrExtVolsDC dc = (SJctrExtVolsDC)this.getDataController();
        List<?> modelClprInfoList = dc.getCache(SJmoGetClprInfo.class);
        this.clprMap = new HashMap<String, Short>(modelClprInfoList.size());
        SJctrLdevUtility ldevUtil = dc.getOwner().getComUtility().getLdevUtility();
        for (SJmoClprInfo clprInfo : modelClprInfoList) {
            short clpr = clprInfo.getSClpr();
            String name = SJctrComUtility.toHexString(clpr, 2, true);
            String label = ldevUtil.toClprDisplay(clprInfo);
            this.addItem(name, label);
            this.clprMap.put(name, clpr);
        }
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrExdPolicyData policyData = new SJctrExdPolicyData(uc);
        short defaultValue = policyData.getClpr();
        this.setSelection(SJctrComUtility.toHexString(defaultValue, 2, true));
    }

    public short getSelectClpr() {
        String name = this.getSelection();
        short clpr = this.clprMap.get(name);
        return clpr;
    }
}

