/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.assignmpblade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDExternalVolumeOwnership;
import sanproject.serverux.dataimpl.EXDPathGroup;
import sanproject.serverux.dataimpl.EXDgetExternalVolumeOwnership_IN;
import sanproject.serverux.dataimpl.EXDgetExternalVolumeOwnership_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipUtility;
import sanproject.sn2.controller.wizard.uvm.assignmpblade.SJctrAssignMpBladeComboBoxDataModel;
import sanproject.sn2.controller.wizard.uvm.assignmpblade.SJctrAssignMpBladeConfirmData;
import sanproject.sn2.controller.wizard.uvm.assignmpblade.SJctrAssignMpBladeSubWizard;
import sanproject.sn2.controller.wizard.uvm.com.SJctrGetExternalVolumeOwnership;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrExternalVolumeManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPathGroupManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPhysicalPathManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoMPBladeInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrAssignMpBladeDC
extends SJctrUvmWizardDataController {
    private static final int DISP_ID = 0x1101101;
    public static final String TITLE = "GUID_PROCESSOR_BLADE";
    private static final String KEY_MPBLADE = "COM_MPBLADE";
    private static final String KEY_TABLE = "COM_TABLE";
    public static int RESULT_NORMAL = 0;
    public static int ASSIGN_MP_BLADE_NOT_FOUND_PARAM = 107001;
    public static int ASSIGN_MP_BLADE_NOT_FOUND_MODEL = 107018;
    public static int ASSIGN_MP_BLADE_NOT_EQUIP = 106529;
    public static int ASSIGN_MP_BLADE_UNUSABLE_PATHGRP = 105278;
    public static int ASSIGN_MP_BLADE_UNUSABLE_RSGPG = 105269;
    public static int ASSIGN_MP_BLADE_UNUSABLE_RSGLDEV = 105270;
    List<SJmoPgIndex> mPgIndexList = new ArrayList<SJmoPgIndex>();
    List<SJmoExdVolumeInfo> mExdVolInfoList = new ArrayList<SJmoExdVolumeInfo>();
    SJctrAssignMpBladeComboBoxDataModel mMpBladeComboBox = null;
    SJctrExternalVolumeManager mExtVolInfoMgr = null;
    List<EXDExternalVolumeOwnership> mRmiOwnershipInfoList = null;
    List<EXDExternalVolumeOwnership> mOwnershipInfoList = new ArrayList<EXDExternalVolumeOwnership>();
    List<SJmoAllDKCInfo> mAllDkcInfoList = null;
    SJmoExDVirtualPgInfo mExdVpgInfo = null;
    List<SJmoExDPgInfo> mExdPgInfoList = new ArrayList<SJmoExDPgInfo>();
    List<SJmoLdevNicknameInfo> mLdevNameInfoList = null;
    List<SJmoLdevNicknameInfo> mTopLdevNameInfoList = new ArrayList<SJmoLdevNicknameInfo>();

    public SJctrAssignMpBladeDC() throws SJcException {
        super(0x1101101);
        this.initDataModel();
        this.initManager();
    }

    private void initDataModel() {
        SJctrAssignMpBladeComboBoxDataModel comboBox = new SJctrAssignMpBladeComboBoxDataModel();
        this.addDataObjectModel(KEY_MPBLADE, comboBox);
        comboBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrAssignMpBladeDC.this.getWizardWindow().rollback();
                }
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> targetList = this.getCache(SJctrAssignMpBladeSubWizard.ASSIGN_MP_BLADE_DATA);
        if (targetList == null || targetList.size() == 0) {
            errorCode = ASSIGN_MP_BLADE_NOT_FOUND_PARAM;
        } else {
            for (Object targetObj : targetList) {
                if (targetObj instanceof SJmoPgIndex) continue;
                errorCode = ASSIGN_MP_BLADE_NOT_FOUND_PARAM;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> dat = this.getCache(SJctrAssignMpBladeSubWizard.ASSIGN_MP_BLADE_DATA);
        this.mPgIndexList = dat;
        ret = this.getModelData();
        this.mMpBladeComboBox = (SJctrAssignMpBladeComboBoxDataModel)this.getDataObjectModel(KEY_MPBLADE);
        SJctrUserController uc = this.getOwner();
        List<?> rsgInfoList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgInfoList == null || rsgInfoList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, rsgInfo);
        List<SJmoLdevDetail> ldevDtlList = this.getCache(SJmoGetLdevDetail.class);
        if (ldevDtlList == null) {
            SJctrError err = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrExternalVolumeManager extVolInfoMgr = this.getManager(SJctrExternalVolumeManager.class);
        if (extVolInfoMgr == null) {
            SJctrError err = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoExdVolumeInfoOnPathGroup> extVolInfoList = extVolInfoMgr.getExternalVolumeList();
        SJctrPathGroupManager pathGrpMgr = this.getManager(SJctrPathGroupManager.class);
        if (pathGrpMgr == null) {
            SJctrError err = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrExtUtility exdUtil = uc.getComUtility().getExtUtility();
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        List<SJctrErrorColumnData> errList = null;
        if (ret && (errList = this.checkEquipExdVolumeInfo()).size() > 0) {
            ret = false;
        }
        if (ret && (errList = this.checkEquipOwnershipInfo(this.mRmiOwnershipInfoList, true)).size() > 0) {
            ret = false;
        }
        if (ret && (errList = this.checkEquipExdVpgInfo()).size() > 0) {
            ret = false;
        }
        if (ret) {
            errList = new ArrayList<SJctrErrorColumnData>(this.mPgIndexList.size());
            for (SJmoPgIndex pgIndex : this.mPgIndexList) {
                boolean result = true;
                boolean volFound = false;
                int error = RESULT_NORMAL;
                int pathGrpId = 0;
                for (SJmoExdVolumeInfoOnPathGroup extVolInfo : extVolInfoList) {
                    SJmoExdVolumeInfo volume = extVolInfo.getExdVolumeInfo(pgIndex.getFB4(), pgIndex.getPG());
                    if (volume == null) continue;
                    volFound = true;
                    pathGrpId = extVolInfo.getIPathGroupId();
                    break;
                }
                if (!volFound) {
                    result = false;
                    error = ASSIGN_MP_BLADE_NOT_EQUIP;
                } else {
                    SJmoExdPathGroupInfo pathGrpIndfo = pathGrpMgr.getPathGroupInfo(pathGrpId);
                    if (!this.isUsablePathGroupRSG(pathGrpIndfo, rsgUtil)) {
                        result = false;
                        error = ASSIGN_MP_BLADE_UNUSABLE_PATHGRP;
                    }
                }
                ArrayList<SJmoPgIndex> chkPgList = new ArrayList<SJmoPgIndex>();
                chkPgList.add(pgIndex);
                if (rsgUtil.extractImpossiblePg(chkPgList).size() > 0) {
                    error = ASSIGN_MP_BLADE_UNUSABLE_RSGPG;
                    result = false;
                } else {
                    List<SJmoLdevDetail> pgLdevList = exdUtil.getLdevDetailinPG(pgIndex, ldevDtlList);
                    if (rsgUtil.extractImpossibleLdev(pgLdevList).size() > 0) {
                        error = ASSIGN_MP_BLADE_UNUSABLE_RSGLDEV;
                        result = false;
                    }
                }
                if (result) continue;
                SJctrError errInfo = new SJctrError(6, 22, error);
                EXDExternalVolume targetData = new EXDExternalVolume();
                targetData.setIFB4(pgIndex.getFB4());
                targetData.setIPG(pgIndex.getPG());
                SJmoExdVolumeInfo targetInfo = new SJmoExdVolumeInfo(targetData);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(targetInfo, errInfo);
                errList.add(errData);
                ret = false;
            }
        }
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.updateMpBladeComboBox();
        return ret;
    }

    private List<SJctrErrorColumnData> checkEquipExdVolumeInfo() {
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.mPgIndexList.size());
        List<SJmoExdVolumeInfoOnPathGroup> extVolInfoList = this.mExtVolInfoMgr.getExternalVolumeList();
        Iterator<SJmoPgIndex> i$ = this.mPgIndexList.iterator();
        while (i$.hasNext()) {
            SJmoPgIndex selectData;
            SJmoPgIndex pg = selectData = i$.next();
            boolean result = true;
            if (extVolInfoList.size() == 0) {
                result = false;
            } else {
                boolean found = false;
                for (SJmoExdVolumeInfoOnPathGroup extVolInfo : extVolInfoList) {
                    SJmoExdVolumeInfo volume = extVolInfo.getExdVolumeInfo(pg.getFB4(), pg.getPG());
                    if (volume == null) continue;
                    this.mExdVolInfoList.add(volume);
                    found = true;
                    break;
                }
                if (!found) {
                    result = false;
                }
            }
            if (result) continue;
            SJctrError errInfo = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_EQUIP);
            EXDExternalVolume targetData = new EXDExternalVolume();
            targetData.setIFB4(pg.getFB4());
            targetData.setIPG(pg.getPG());
            SJmoExdVolumeInfo targetInfo = new SJmoExdVolumeInfo(targetData);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(targetInfo, errInfo);
            errList.add(errData);
        }
        return errList;
    }

    private List<SJctrErrorColumnData> checkEquipOwnershipInfo(List<EXDExternalVolumeOwnership> ownershipInfoList, boolean store) {
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.mPgIndexList.size());
        Iterator<SJmoPgIndex> i$ = this.mPgIndexList.iterator();
        while (i$.hasNext()) {
            SJmoPgIndex selectData;
            SJmoPgIndex pg = selectData = i$.next();
            boolean result = true;
            if (ownershipInfoList.size() == 0) {
                result = false;
            } else {
                boolean found = false;
                for (EXDExternalVolumeOwnership ownership : ownershipInfoList) {
                    if (pg.getFB4() != ownership.getIFB4() || pg.getPG() != ownership.getIPG()) continue;
                    if (store) {
                        this.mOwnershipInfoList.add(ownership);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    result = false;
                }
            }
            if (result) continue;
            SJctrError errInfo = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_EQUIP);
            EXDExternalVolume targetData = new EXDExternalVolume();
            targetData.setIFB4(pg.getFB4());
            targetData.setIPG(pg.getPG());
            SJmoExdVolumeInfo targetInfo = new SJmoExdVolumeInfo(targetData);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(targetInfo, errInfo);
            errList.add(errData);
        }
        return errList;
    }

    private List<SJctrErrorColumnData> checkEquipExdVpgInfo() {
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.mPgIndexList.size());
        Iterator<SJmoPgIndex> i$ = this.mPgIndexList.iterator();
        while (i$.hasNext()) {
            SJmoPgIndex selectData;
            SJmoPgIndex pg = selectData = i$.next();
            boolean result = true;
            ArrayList exdPgInfoList = this.mExdVpgInfo.getAlVpgForExd();
            Collections.sort(exdPgInfoList);
            Collections.sort(this.mLdevNameInfoList);
            if (exdPgInfoList.size() == 0) {
                result = false;
            } else {
                int pgIndex = Collections.binarySearch(exdPgInfoList, pg);
                if (pgIndex >= 0) {
                    SJmoLdevIndex startLdevIndex;
                    int ldevIndex;
                    SJmoExDPgInfo pgInfo = (SJmoExDPgInfo)exdPgInfoList.get(pgIndex);
                    this.mExdPgInfoList.add(pgInfo);
                    if (pgInfo.getSNumOfLdev() > 0 && (ldevIndex = Collections.binarySearch(this.mLdevNameInfoList, startLdevIndex = pgInfo.getStartLdevId())) >= 0) {
                        SJmoLdevNicknameInfo ldev = this.mLdevNameInfoList.get(ldevIndex);
                        this.mTopLdevNameInfoList.add(ldev);
                    }
                } else {
                    result = false;
                }
            }
            if (result) continue;
            SJctrError errInfo = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_EQUIP);
            EXDExternalVolume targetData = new EXDExternalVolume();
            targetData.setIFB4(pg.getFB4());
            targetData.setIPG(pg.getPG());
            SJmoExdVolumeInfo targetInfo = new SJmoExdVolumeInfo(targetData);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(targetInfo, errInfo);
            errList.add(errData);
        }
        return errList;
    }

    private boolean getModelData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        this.mExtVolInfoMgr = this.getManager(SJctrExternalVolumeManager.class);
        if (this.mExtVolInfoMgr == null) {
            errorCode = ASSIGN_MP_BLADE_NOT_FOUND_MODEL;
        }
        if (errorCode == RESULT_NORMAL) {
            this.mRmiOwnershipInfoList = this.getOwnershipData();
            if (this.mRmiOwnershipInfoList == null || this.mRmiOwnershipInfoList.size() == 0) {
                errorCode = ASSIGN_MP_BLADE_NOT_FOUND_MODEL;
            }
        }
        if (errorCode == RESULT_NORMAL) {
            this.mAllDkcInfoList = this.getCache(SJmoGetAllDKCInfo.class);
            if (this.mAllDkcInfoList == null || this.mAllDkcInfoList.size() == 0) {
                errorCode = ASSIGN_MP_BLADE_NOT_FOUND_MODEL;
            }
        }
        if (errorCode == RESULT_NORMAL) {
            List<?> exdVpgInfoList = this.getCache(SJmoGetExDVirtualPgInfo.class);
            if (exdVpgInfoList == null || exdVpgInfoList.size() == 0) {
                errorCode = ASSIGN_MP_BLADE_NOT_FOUND_MODEL;
            } else {
                this.mExdVpgInfo = (SJmoExDVirtualPgInfo)exdVpgInfoList.get(0);
            }
        }
        if (errorCode == RESULT_NORMAL) {
            this.mLdevNameInfoList = this.getCache(SJmoGetLdevNicknameInfo.class);
            if (this.mLdevNameInfoList == null) {
                errorCode = ASSIGN_MP_BLADE_NOT_FOUND_MODEL;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private List<EXDExternalVolumeOwnership> getOwnershipData() {
        ArrayList<EXDExternalVolumeOwnership> ret = null;
        EXDgetExternalVolumeOwnership_IN input = new EXDgetExternalVolumeOwnership_IN();
        SJctrGetExternalVolumeOwnership kind = new SJctrGetExternalVolumeOwnership(input);
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)this.getModelData(wrapper).get(0);
        EXDgetExternalVolumeOwnership_OUT output = (EXDgetExternalVolumeOwnership_OUT)rmiObj.getObjRmi();
        if (output != null) {
            int size = output.getDataList().length;
            ret = new ArrayList<EXDExternalVolumeOwnership>(size);
            EXDExternalVolumeOwnership[] outputList = output.getDataList();
            for (int index = 0; index < size; ++index) {
                ret.add(outputList[index]);
            }
        }
        return ret;
    }

    private void updateMpBladeComboBox() {
        SJctrComUtility util = this.getOwner().getComUtility();
        SJctrExtUtility extUtil = util.getExtUtility();
        this.mMpBladeComboBox.addItem("");
        boolean auto = false;
        SJmoAllDKCInfo allDkcInfo = this.mAllDkcInfoList.get(0);
        ArrayList<SJmoDKCInfo> dkcInfoList = allDkcInfo.getDKCInfo();
        for (SJmoDKCInfo dkcInfo : dkcInfoList) {
            ArrayList<SJmoMPBladeInfo> mpBladeInfoList = dkcInfo.getMPBladeInfo();
            for (SJmoMPBladeInfo mpBladeInfo : mpBladeInfoList) {
                int mpBladeId = mpBladeInfo.getMpBladeId();
                String name = Integer.toString(mpBladeId);
                String label = SJctrOwnerShipUtility.toMpBladeIdDisplay(util, mpBladeId);
                this.mMpBladeComboBox.addItem(name, label);
            }
        }
        HashSet<String> mix = new HashSet<String>();
        for (EXDExternalVolumeOwnership ownership : this.mOwnershipInfoList) {
            byte mpBladeId = ownership.getCurrentMPBladeID();
            mix.add(Integer.toHexString(mpBladeId));
        }
        if (mix.size() == 0) {
            this.mMpBladeComboBox.setSelection("");
        } else if (mix.size() == 1) {
            this.mMpBladeComboBox.removeItem("");
            Object[] objArray = mix.toArray();
            String name = (String)objArray[0];
            this.mMpBladeComboBox.setSelection(name);
        } else if (mix.size() > 1) {
            this.mMpBladeComboBox.setSelection("");
        }
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<EXDExternalVolumeOwnership> rmiOwnershipDataList = this.getOwnershipData();
        if (rmiOwnershipDataList == null || rmiOwnershipDataList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        List<SJctrErrorColumnData> errList = null;
        errList = this.checkEquipOwnershipInfo(rmiOwnershipDataList, false);
        if (errList.size() > 0) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        String name = this.mMpBladeComboBox.getSelection();
        short mpBladeId = Short.valueOf(name, 16);
        ArrayList<EXDExternalVolumeOwnership> ownershipInfoList = new ArrayList<EXDExternalVolumeOwnership>(this.mOwnershipInfoList.size());
        for (EXDExternalVolumeOwnership ownership : this.mOwnershipInfoList) {
            EXDExternalVolumeOwnership data = new EXDExternalVolumeOwnership();
            data.setPGIndex(ownership.getIFB4(), ownership.getIPG());
            data.byUserMPBladeID = ownership.getByUserMPBladeID();
            data.byCurrentMPBladeID = ownership.getCurrentMPBladeID();
            data.byUserMPBladeID = (byte)mpBladeId;
            ownershipInfoList.add(data);
        }
        Collections.sort(this.mExdVolInfoList);
        Collections.sort(this.mExdPgInfoList);
        Collections.sort(ownershipInfoList);
        ArrayList<SJmoExDVirtualPgInfo> exdVpgInfoList = new ArrayList<SJmoExDVirtualPgInfo>(1);
        SJmoExDVirtualPgInfo exdVpgInfo = new SJmoExDVirtualPgInfo();
        exdVpgInfo.setAlVpgForExd((ArrayList)this.mExdPgInfoList);
        exdVpgInfoList.add(exdVpgInfo);
        ArrayList<SJctrAssignMpBladeConfirmData> confirmDataList = new ArrayList<SJctrAssignMpBladeConfirmData>(1);
        SJctrAssignMpBladeConfirmData confirmData = new SJctrAssignMpBladeConfirmData();
        confirmData.setExdVolumeInfo(this.mExdVolInfoList);
        confirmData.setOwnershipInfo(ownershipInfoList);
        confirmData.setExdVpgInfo(exdVpgInfoList);
        confirmData.setLdevNameInfo(this.mTopLdevNameInfoList);
        confirmDataList.add(confirmData);
        this.putCache(SJctrAssignMpBladeConfirmData.ASSIGN_MP_BLADE_CONFIRM_DATA, confirmDataList);
        return ret;
    }

    private void checkMpBladeComboBox(short mpBladeId) {
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.mExdVolInfoList.size());
        Collections.sort(this.mExdVolInfoList);
        boolean result = true;
        for (EXDExternalVolumeOwnership ownership : this.mOwnershipInfoList) {
            if (result) continue;
            SJmoPgIndex pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(ownership.getIFB4());
            pgIndex.setPG(ownership.getIPG());
            int index = Collections.binarySearch(this.mExdVolInfoList, pgIndex);
            SJmoExdVolumeInfo volume = this.mExdVolInfoList.get(index);
            SJctrError errInfo = new SJctrError(6, 22, ASSIGN_MP_BLADE_NOT_EQUIP);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(volume, errInfo);
            errList.add(errData);
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetAllDKCInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExDVirtualPgInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    boolean isUsablePathGroupRSG(SJmoExdPathGroupInfo pathGrpInfo, SJctrResourceGroupUtility rsgUtil) {
        boolean result = true;
        EXDPathGroup rmiPathGrp = pathGrpInfo.getRmiExdPathGroupInfo();
        int[] pysicalPathIdList = rmiPathGrp.referAllPhysicalPathList();
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        ArrayList<SJmoPortIndex> portList = new ArrayList<SJmoPortIndex>(pysicalPathIdList.length);
        for (int portcnt = 0; portcnt < pysicalPathIdList.length && pysicalPathIdList[portcnt] != -1; ++portcnt) {
            int physicalPathId = pysicalPathIdList[portcnt];
            SJmoExdPhysicalPathInfo phsicalPathInfo = physicalPathMgr.getPhysicalPathInfo(physicalPathId);
            int portId = phsicalPathInfo.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort((short)portId);
            portList.add(portIndex);
        }
        List<SJmoPortIndex> unUsableList = rsgUtil.extractImpossiblePort(portList);
        if (unUsableList.size() != 0) {
            result = false;
        }
        return result;
    }

    private void initManager() {
        this.addManager(SJctrExternalVolumeManager.class);
        this.addManager(SJctrPathGroupManager.class);
        this.addManager(SJctrPhysicalPathManager.class);
    }
}

