/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.data.ChangeDataString;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrChaUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.uvm.com.SJctrEmulationTypeInfo;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.data.device.SJmoChaDetail;

public class SJctrEmulationTypeManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private List<SJmoChaDetail> chaDetailList;
    private Map<String, SJctrEmulationTypeInfo> supportTypes;
    private SJctrEmulationTypeInfo directMappEmulationTypeInfo = null;
    private Set<SJctrEmulationTypeInfo> ignoreAdaptiveTypes;
    private List<SJctrEmulationTypeInfo> selectionTypes;
    private emulationTypeNameComparator emuNameComp;

    public SJctrEmulationTypeManager() {
        this.initField();
    }

    private void initField() {
        this.chaDetailList = Collections.emptyList();
        this.supportTypes = new HashMap<String, SJctrEmulationTypeInfo>();
        this.ignoreAdaptiveTypes = new HashSet<SJctrEmulationTypeInfo>();
        this.selectionTypes = Collections.emptyList();
        this.emuNameComp = new emulationTypeNameComparator();
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetChaDetail kind = new SJmoGetChaDetail();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetChaDetail.class.getName());
        if (getList != null && getList.size() > 0) {
            this.chaDetailList = getList;
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
        SJctrComUtility util = this.getComUtility();
        SJmoDataChange dataChange = util.getDataChangeTable();
        ArrayList emuTypeList = dataChange.gete_typeList();
        for (int i = 0; i < emuTypeList.size(); ++i) {
            String emuTypeName = (String)emuTypeList.get(i);
            int emuKind = dataChange.getEmuFlg(emuTypeName);
            SJctrEmulationTypeInfo info = SJctrEmulationTypeInfo.createEmulationTypeInfo(emuTypeName, emuKind);
            info.initInfo(util);
            this.supportTypes.put(emuTypeName, info);
        }
        ChangeDataString[] emuIds = dataChange.getEmulationIDData();
        for (int i = 0; i < emuIds.length; ++i) {
            String emuTypeName = emuIds[i].strChangeData1;
            int emuId = emuIds[i].nMibData;
            SJctrEmulationTypeInfo info = this.supportTypes.get(emuTypeName);
            if (info == null) {
                // empty if block
            }
            info.setEmulationId(emuId);
        }
        SJctrEmulationTypeInfo openv_info = this.supportTypes.get("OPEN-V");
        if (openv_info != null) {
            this.directMappEmulationTypeInfo = SJctrEmulationTypeInfo.createDirectMappingEmulationTypeInfo(util);
            this.directMappEmulationTypeInfo.setEmulationId(openv_info.getEmulationId());
        }
        this.initSelectionType();
    }

    private void initSelectionType() {
        boolean openFlg = false;
        boolean mfFlg = false;
        for (SJmoChaDetail chaDetail : this.chaDetailList) {
            if (SJctrChaUtility.isPkgMF(chaDetail)) {
                mfFlg = true;
            } else {
                openFlg = true;
            }
            if (!mfFlg || !openFlg) continue;
            break;
        }
        this.selectionTypes = new ArrayList<SJctrEmulationTypeInfo>(this.supportTypes.size());
        for (SJctrEmulationTypeInfo info : this.supportTypes.values()) {
            if (info.isOpenType()) {
                if (!openFlg) continue;
                this.selectionTypes.add(info);
                continue;
            }
            if (!mfFlg) continue;
            this.selectionTypes.add(info);
        }
        Collections.sort(this.selectionTypes, this.emuNameComp);
        this.addIgnoreAdaptiveType("OPEN-L");
        this.addIgnoreAdaptiveType("6588-A");
    }

    public SJctrEmulationTypeInfo getEmulationTypeInfo(int emuId) {
        SJmoDataChange dataChange = this.getComUtility().getDataChangeTable();
        String emuTypeName = dataChange.getEmulationTypeName(emuId);
        return this.getEmulationTypeInfo(emuTypeName);
    }

    public SJctrEmulationTypeInfo getEmulationTypeInfo(String emuTypeName) {
        return this.supportTypes.get(emuTypeName);
    }

    public List<SJctrEmulationTypeInfo> getEmulationTypeList() {
        return this.getEmulationTypeList(true);
    }

    public List<SJctrEmulationTypeInfo> getEmulationTypeList(boolean allOpen) {
        List<SJctrEmulationTypeInfo> retList = this.selectionTypes;
        if (!allOpen) {
            int size = this.selectionTypes.size();
            retList = new ArrayList<SJctrEmulationTypeInfo>(size);
            for (int i = 0; i < size; ++i) {
                SJctrEmulationTypeInfo info = this.selectionTypes.get(i);
                if (info.isOpenType() && !info.isOpenV()) continue;
                retList.add(info);
            }
        }
        for (SJctrEmulationTypeInfo ignoreAdaptiveType : this.ignoreAdaptiveTypes) {
            retList.remove(ignoreAdaptiveType);
        }
        return retList;
    }

    public SJctrEmulationTypeInfo getDirectMappEmulationTypeInfo() {
        return this.directMappEmulationTypeInfo;
    }

    public void addIgnoreAdaptiveType(String emuName) {
        SJctrEmulationTypeInfo info = this.getEmulationTypeInfo(emuName);
        if (info != null) {
            this.ignoreAdaptiveTypes.add(info);
        }
    }

    public void removeIgnoreAdaptiveType(String emuName) {
        SJctrEmulationTypeInfo info = this.getEmulationTypeInfo(emuName);
        this.ignoreAdaptiveTypes.remove(info);
    }

    private class emulationTypeNameComparator
    implements Comparator<Object> {
        private emulationTypeNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String emuName1 = this.getValue(o1);
            String emuName2 = this.getValue(o2);
            return emuName1.compareTo(emuName2);
        }

        private String getValue(Object obj) {
            String ret = "";
            if (obj instanceof SJctrEmulationTypeInfo) {
                SJctrEmulationTypeInfo emutype = (SJctrEmulationTypeInfo)obj;
                ret = emutype.getEmulationName();
            } else {
                ret = (String)obj;
            }
            return ret;
        }
    }
}

