/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.comdialog.changesetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDExternalVolumeEx;
import sanproject.serverux.dataimpl.EXDLDEVInfoDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.comparator.uvm.SJctrPgIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxAreaDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVIDData;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVSettingDC;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddVolumeInfo;
import sanproject.sn2.controller.wizard.uvm.com.SJctrEmulationTypeInfo;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmDialogDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrEmulationTypeManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrExternalVolumeManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrLdevManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrLdevNickNameManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrSsidManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrVpgManager;
import sanproject.sn2.controller.wizard.uvm.comdialog.changesetting.SJctrLdevsTableModel;
import sanproject.sn2.controller.wizard.uvm.comdialog.changesetting.SJctrMpBladeIdInfoDataModel;
import sanproject.sn2.controller.wizard.uvm.comdialog.changesetting.SJctrParityGrpInfoDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilLdev;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilSsid;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoCuLdevIdInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.data.volume.SJmoSsidSummary;

public class SJctrChangeSettingDC
extends SJctrUvmDialogDataController {
    private static final int DISP_ID = 33595430;
    public static final String GUID_TITLE = "DISP_DD26_TITLE";
    public static final String KEY_CHANGE_TARGET_EXDVOL = "CHANGE_TARGET_EXDVOL";
    public static final String KEY_CHANGED_TARGET_EXDVOL = "CHANGED_TARGET_EXDVOL";
    public static final String KEY_CHANGE_TARGET_MAPLDEV = "CHANGE_TARGET_MAPLDEV";
    public static final String KEY_CHANGED_TARGET_MAPLDEV = "CHANGED_TARGET_MAPLDEV";
    public static final String KEY_CHANGED_LDEV_NICKNAME = "CHANGED_LDEV_NICKNAME";
    public static final String KEY_DD12_DIALOG_OUT = "KEY_DD12_DIALOG_OUT";
    private static final String KEY_PGINF = "COM_ARYGRPINF";
    private static final String KEY_MPPKGINF = "COM_MPPKGINF";
    public static final String KEY_LDEVCHECKBOX = "COM_LDEVCHECKBOX";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_EDITLDEV_BTN = "COM_EDITLDEV_BTN";
    private static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    static final int MSG_ERR_CACHE_DATA = 107001;
    static final int MSG_ERR_CACHE_MODEL = 107018;
    static final int MSG_ERR_INPUT_INVALID_DATA = 105084;
    static final int MSG_ERR_VPG_ALLOCATE = 105238;
    static final int MSG_ERR_LDEV_ALLOCATE = 105265;
    static final int MSG_ERR_SSID_ALLOCATE = 105246;
    static final int MSG_ERR_LDEVNAME_SET_FAILED = 105257;
    static final int MSG_ERR_SETTING_SOME_EMUTYPE = 105243;
    private List<SJctrAddVolumeInfo> selectVolInfo = null;
    private Map<String, List<EXDLDEVInfoDetail>> mapLdevInfo = null;
    private List<SJmoCuLdevIdInfo> cuLdevIdList = null;
    private List<SJmoSsidDetail> ssidDtlList = null;
    private List<SJmoLdevNicknameInfo> ldevNameList = null;
    private List<SJctrAddVolumeInfo> orignVolInfo = null;
    private List<SJmoLdevDetail> originLdevList = null;
    private SJctrResourceGroupUtility rsgUtil = null;
    private List<SJmoHUVMVirtualLdev> vLdevList = Collections.emptyList();
    private int INVALID_VALUE = -1;
    private String STR_OPENV = "OPEN-V";

    public SJctrChangeSettingDC() throws SJcException {
        super(33595430);
        this.initDataModel();
        this.initManager();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> extVolList = this.getCache(KEY_CHANGE_TARGET_EXDVOL);
        if (extVolList == null || extVolList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> mapLdevList = this.getCache(KEY_CHANGE_TARGET_MAPLDEV);
        if (mapLdevList == null || mapLdevList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.selectVolInfo = extVolList;
        this.mapLdevInfo = (Map)mapLdevList.get(0);
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        return ret;
    }

    @Override
    public boolean checkEndData() {
        SJctrMpBladeIdInfoDataModel mpBladIdDataModel;
        SJctrCheckBoxAreaDataModel ldevChkBoxAria;
        boolean result = true;
        boolean changeVpg = false;
        boolean changeLdevName = false;
        boolean changeLdevId = false;
        boolean changeMpBlade = false;
        SJctrVpgManager vpgMgr = this.getManager(SJctrVpgManager.class);
        ArrayList<SJmoExDPgInfo> changeVpgList = new ArrayList<SJmoExDPgInfo>(this.selectVolInfo.size());
        SJctrVpgManager.ChangeVpgData changeVpgData = null;
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(this.selectVolInfo.size());
        List<SJmoLdevNicknameInfo> changeNameList = this.makeLdevNameInfo();
        ArrayList<SJmoExdVolumeInfo> cloneVolInfo = this.makeCloneExdVolData();
        HashMap<String, List<EXDLDEVInfoDetail>> cloneLdevMap = new HashMap<String, List<EXDLDEVInfoDetail>>(this.selectVolInfo.size());
        SJctrParityGrpInfoDataModel pgInfoDataModel = (SJctrParityGrpInfoDataModel)this.getDataObjectModel(KEY_PGINF);
        if (pgInfoDataModel.isSelectCheckBox()) {
            int startFb4 = pgInfoDataModel.getFB4Value();
            int startPg = pgInfoDataModel.getPGValue();
            if (!SJctrVpgManager.checkExg(startFb4) || !SJctrVpgManager.checkVpg(startPg)) {
                SJctrError err = new SJctrError(6, 22, 105084);
                SJcException exp = err.createException();
                throw exp;
            }
            changeVpgData = this.changeVPG(startFb4, startPg, changeVpgList, errColumnList);
            List<SJmoExDPgInfo> ngList = changeVpgData.getNgVpgList();
            if (ngList.size() != 0) {
                result = false;
            }
            changeVpg = true;
        }
        if (result && (ldevChkBoxAria = (SJctrCheckBoxAreaDataModel)this.getDataObjectModel(KEY_LDEVCHECKBOX)).isSelectCheckBox()) {
            this.changeLdevInfo(cloneLdevMap, errColumnList);
            changeLdevId = true;
        }
        if (result && (mpBladIdDataModel = (SJctrMpBladeIdInfoDataModel)this.getDataObjectModel(KEY_MPPKGINF)).isSelectCheckBox()) {
            changeMpBlade = true;
        }
        if (result) {
            if (changeVpg) {
                this.setChangeVpgData(cloneVolInfo, changeVpgList);
                this.putCache(KEY_CHANGED_TARGET_EXDVOL, cloneVolInfo);
            }
            if (changeLdevId) {
                this.setChangeLdevIdData(cloneVolInfo, cloneLdevMap);
                ArrayList<HashMap<String, List<EXDLDEVInfoDetail>>> list = new ArrayList<HashMap<String, List<EXDLDEVInfoDetail>>>(1);
                list.add(cloneLdevMap);
                this.putCache(KEY_CHANGED_TARGET_MAPLDEV, list);
                this.putCache(KEY_CHANGED_LDEV_NICKNAME, this.ldevNameList);
            }
            if (changeMpBlade) {
                this.setChangeMpBladeId(cloneVolInfo);
                this.putCache(KEY_CHANGED_TARGET_EXDVOL, cloneVolInfo);
            }
        } else {
            if (changeVpg) {
                vpgMgr.restoreVpgInfo(changeVpgData);
            }
            if (changeLdevId) {
                this.resetLdevId(cloneLdevMap);
            }
            SJctrTableDataModel table = this.getErrorDialogTable();
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(table, errColumnList);
            SJctrError errInfo = errDc.getRepresentativeError(errColumnList, 7);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return result;
    }

    private SJctrVpgManager.ChangeVpgData changeVPG(int startFb4, int StartPg, List<SJmoExDPgInfo> changeList, List<SJctrErrorColumnData> errColumnList) {
        SJctrVpgManager.ChangeVpgData changeVpgData = null;
        HashMap<SJmoExDPgInfo, SJmoExdVolumeInfo> vpgMap = new HashMap<SJmoExDPgInfo, SJmoExdVolumeInfo>(this.selectVolInfo.size());
        SJctrVpgManager vpgMgr = this.getManager(SJctrVpgManager.class);
        List<SJmoExDPgInfo> pgList = vpgMgr.getExdPgList();
        for (SJmoExdVolumeInfo sJmoExdVolumeInfo : this.selectVolInfo) {
            int fb4 = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getIFB4();
            int pg = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getIPG();
            SJmoPgIndex pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(fb4);
            pgIndex.setPG(pg);
            SJmoExDPgInfo vpgInfo = vpgMgr.getVpgInfo(pgIndex);
            changeList.add(vpgInfo);
            vpgMap.put(vpgInfo, sJmoExdVolumeInfo);
        }
        changeVpgData = vpgMgr.changeVpgInfo(startFb4, StartPg, changeList);
        List<SJmoExDPgInfo> ngList = changeVpgData.getNgVpgList();
        if (ngList.size() != 0) {
            for (SJmoExDPgInfo pgInfo : ngList) {
                SJmoExdVolumeInfo exdVol = (SJmoExdVolumeInfo)vpgMap.get(pgInfo);
                SJctrError err = new SJctrError(6, 22, 105238);
                SJctrErrorColumnData oneErrorColumn = new SJctrErrorColumnData(exdVol, err);
                errColumnList.add(oneErrorColumn);
            }
        }
        return changeVpgData;
    }

    private boolean changeLdevInfo(Map<String, List<EXDLDEVInfoDetail>> cloneLdevMap, List<SJctrErrorColumnData> errColumnList) {
        boolean result = true;
        SJctrPgIndexComparator pgComp = new SJctrPgIndexComparator();
        SJctrLdevManager ldevMgr = this.getManager(SJctrLdevManager.class);
        SJctrEmulationTypeManager emuMgr = this.getManager(SJctrEmulationTypeManager.class);
        SJctrSsidManager ssidMgr = this.getManager(SJctrSsidManager.class);
        SJctrLdevNickNameManager nameMgr = this.getManager(SJctrLdevNickNameManager.class);
        ldevMgr.removeLdevId(this.originLdevList);
        for (SJmoLdevIndex sJmoLdevIndex : this.originLdevList) {
            ssidMgr.removeSsid(sJmoLdevIndex);
        }
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> list = table.getAllRowData();
        Collections.sort(list);
        SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
        for (Object rowData : list) {
            SJmoLdevDetail ldevInfo = (SJmoLdevDetail)rowData;
            SJmoPgIndex ppgIndex = new SJmoPgIndex();
            ppgIndex.setFB4(ldevInfo.getIFB4());
            ppgIndex.setPG(ldevInfo.getIPG());
            int index = Collections.binarySearch(this.orignVolInfo, ppgIndex, pgComp);
            if (index < 0) continue;
            SJctrAddVolumeInfo exdVol = this.orignVolInfo.get(index);
            String identity2 = exdVol.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2();
            List<EXDLDEVInfoDetail> ldevList = null;
            ldevList = cloneLdevMap.containsKey(identity2) ? cloneLdevMap.get(identity2) : new ArrayList<EXDLDEVInfoDetail>(exdVol.getSAddNum());
            SJctrLDEVDetail ldevDtl = new SJctrLDEVDetail();
            int baseEmuId = exdVol.getRmiExdVolumeInfo().getIBaseEmulationType();
            SJctrEmulationTypeInfo emuInfo = emuMgr.getEmulationTypeInfo(baseEmuId);
            if (!ldevMgr.setLdevId(ldevDtl, emuInfo, ldevInfo, 0, cvsUtil, this.vLdevList)) {
                SJctrError err = new SJctrError(6, 22, 105265);
                SJctrErrorColumnData oneErrorColumn = new SJctrErrorColumnData(this.selectVolInfo.get(index), err);
                errColumnList.add(oneErrorColumn);
                result = false;
                break;
            }
            EXDLDEVInfoDetail ldevData = new EXDLDEVInfoDetail();
            ldevData.setLDEVIndex(ldevInfo.getSLdkc(), ldevInfo.getSCu(), ldevInfo.getSLdev());
            ldevData.setLLDEVLBASize(ldevInfo.getLLDEVLBASize());
            int ssid = SJctrCVSUtility.getSSID(ldevInfo.getSLdkc(), ldevInfo.getSCu(), ldevInfo.getSLdev(), this.ssidDtlList);
            ssidMgr.setSsid(ldevInfo, ssid);
            ldevData.setSSID(ssid);
            ldevList.add(ldevData);
            cloneLdevMap.put(identity2, ldevList);
        }
        return result;
    }

    private void setChangeVpgData(List<SJmoExdVolumeInfo> cloneVolInfo, List<SJmoExDPgInfo> changeVpgList) {
        for (int index = 0; index < cloneVolInfo.size(); ++index) {
            SJmoExdVolumeInfo volInfo = cloneVolInfo.get(index);
            EXDExternalVolume rmiExdVol = volInfo.getRmiExdVolumeInfo();
            SJmoExDPgInfo pgInfo = changeVpgList.get(index);
            rmiExdVol.setPGIndex(pgInfo.getFB4(), pgInfo.getPG());
        }
    }

    private void setChangeLdevIdData(List<SJmoExdVolumeInfo> cloneVolInfo, Map<String, List<EXDLDEVInfoDetail>> cloneLdevMap) {
        SJctrVpgManager vpgMgr = this.getManager(SJctrVpgManager.class);
        for (SJmoExdVolumeInfo exdVol : cloneVolInfo) {
            EXDExternalVolume rmiExdVol = exdVol.getRmiExdVolumeInfo();
            String identity2 = rmiExdVol.getExternalDeviceInfo().getIdentity2();
            List<EXDLDEVInfoDetail> ldevList = cloneLdevMap.get(identity2);
            if (ldevList == null) continue;
            EXDLDEVInfoDetail startLdev = ldevList.get(0);
            SJmoLdevIndex startLdevIndex = new SJmoLdevIndex();
            startLdevIndex.setLdevIndex(startLdev.getSLDKC(), startLdev.getSCU(), startLdev.getSLDEV());
            SJmoExDPgInfo exdPgInfo = vpgMgr.getVpgInfo(rmiExdVol.getIFB4(), rmiExdVol.getIPG());
            exdPgInfo.setStartLdevId(startLdevIndex);
            exdPgInfo.setSNumOfLdev((short)ldevList.size());
        }
    }

    private void setChangeMpBladeId(List<SJmoExdVolumeInfo> cloneVolInfo) {
        SJctrMpBladeIdInfoDataModel mpBladIdDataModel = (SJctrMpBladeIdInfoDataModel)this.getDataObjectModel(KEY_MPPKGINF);
        String name = mpBladIdDataModel.getSelectMpBladeIDItem();
        if (name != null) {
            short mpBladeId = Short.parseShort(name);
            for (SJmoExdVolumeInfo volInfo : cloneVolInfo) {
                volInfo.getRmiExdVolumeInfo().setOwnership(mpBladeId);
            }
        }
    }

    private void resetLdevId(Map<String, List<EXDLDEVInfoDetail>> cloneLdevMap) {
        String identity2;
        SJctrLdevManager ldevMgr = this.getManager(SJctrLdevManager.class);
        SJctrEmulationTypeManager emuMgr = this.getManager(SJctrEmulationTypeManager.class);
        SJctrSsidManager ssidMgr = this.getManager(SJctrSsidManager.class);
        for (SJmoExdVolumeInfo sJmoExdVolumeInfo : this.selectVolInfo) {
            identity2 = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2();
            List<EXDLDEVInfoDetail> changeList = cloneLdevMap.get(identity2);
            if (changeList == null) continue;
            ArrayList<SJmoLdevIndex> ldevIndexList = new ArrayList<SJmoLdevIndex>(this.selectVolInfo.size());
            for (EXDLDEVInfoDetail rmiLdevDtl : changeList) {
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex(rmiLdevDtl.getSLDKC(), rmiLdevDtl.getSCU(), rmiLdevDtl.getSLDEV());
                ssidMgr.removeSsid(ldevIndex);
                ldevIndexList.add(ldevIndex);
            }
            ldevMgr.removeLdevId(ldevIndexList);
        }
        for (SJmoExdVolumeInfo sJmoExdVolumeInfo : this.selectVolInfo) {
            identity2 = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2();
            int baseEmuId = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getIBaseEmulationType();
            SJctrEmulationTypeInfo emuInfo = emuMgr.getEmulationTypeInfo(baseEmuId);
            List<EXDLDEVInfoDetail> ldevList = this.mapLdevInfo.get(identity2);
            if (ldevList == null) continue;
            SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
            for (EXDLDEVInfoDetail rmiLdevDtl : ldevList) {
                SJmoLdevDetail startLdev = new SJmoLdevDetail();
                startLdev.setSLdkc(rmiLdevDtl.getSLDKC());
                startLdev.setSCu(rmiLdevDtl.getSCU());
                startLdev.setSLdev(rmiLdevDtl.getSLDEV());
                SJmoLdevDetail ldevDtl = new SJmoLdevDetail();
                ldevDtl.setLLDEVLBASize(rmiLdevDtl.getLLDEVLBASize());
                ldevMgr.setLdevId(ldevDtl, emuInfo, startLdev, 0, cvsUtil, this.vLdevList);
                rmiLdevDtl.setSLDKC(ldevDtl.getSLdkc());
                rmiLdevDtl.setSCU(ldevDtl.getSCu());
                rmiLdevDtl.setSLDEV(ldevDtl.getSLdev());
                int ssid = rmiLdevDtl.getSSID();
                ssidMgr.setSsid(ldevDtl, ssid);
            }
        }
    }

    @Override
    public void makeDataModel() {
        Object[] pgArray;
        super.makeDataModel();
        SJctrParityGrpInfoDataModel pgInfoDataModel = (SJctrParityGrpInfoDataModel)this.getDataObjectModel(KEY_PGINF);
        SJctrMpBladeIdInfoDataModel mpBladeIdInfoDataModel = (SJctrMpBladeIdInfoDataModel)this.getDataObjectModel(KEY_MPPKGINF);
        HashSet<Integer> fb4Set = new HashSet<Integer>(this.selectVolInfo.size());
        HashSet<Integer> pgSet = new HashSet<Integer>(this.selectVolInfo.size());
        HashSet<Short> mpBladeIdSet = new HashSet<Short>(this.selectVolInfo.size());
        for (SJctrAddVolumeInfo oneVolume : this.selectVolInfo) {
            int fb4 = oneVolume.getRmiExdVolumeInfo().getDisplayFB4No();
            int pg = oneVolume.getRmiExdVolumeInfo().getIPG();
            short mpBladeId = oneVolume.getRmiExdVolumeInfo().getOwnership();
            fb4Set.add(fb4);
            pgSet.add(pg);
            mpBladeIdSet.add(mpBladeId);
        }
        if (fb4Set.size() == 1) {
            Object[] fb4Array = fb4Set.toArray();
            int defFb4 = (Integer)fb4Array[0];
            pgInfoDataModel.setFB4DispValue(defFb4);
        }
        if (pgSet.size() == 1) {
            pgArray = pgSet.toArray();
            int defpg = (Integer)pgArray[0];
            pgInfoDataModel.setPGValue(defpg);
        }
        if (mpBladeIdSet.size() == 1) {
            mpBladeIdInfoDataModel.removeMpBladeIDItem("");
            pgArray = mpBladeIdSet.toArray();
            short defmpBladeId = (Short)pgArray[0];
            mpBladeIdInfoDataModel.setSelectMpBladeIDItem(SJctrComUtility.toDecString(defmpBladeId));
        }
        boolean bLdev = false;
        SJctrLdevNickNameManager ldevNameMgr = this.getManager(SJctrLdevNickNameManager.class);
        int setLdkc = this.INVALID_VALUE;
        int setCu = this.INVALID_VALUE;
        int setLdev = this.INVALID_VALUE;
        this.originLdevList = new ArrayList<SJmoLdevDetail>(2048);
        this.ldevNameList = new ArrayList<SJmoLdevNicknameInfo>(this.selectVolInfo.size());
        SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
        for (SJmoExdVolumeInfo sJmoExdVolumeInfo : this.selectVolInfo) {
            EXDExternalVolume rmiExdVol = sJmoExdVolumeInfo.getRmiExdVolumeInfo();
            String identity2 = rmiExdVol.getExternalDeviceInfo().getIdentity2();
            List<EXDLDEVInfoDetail> ldevList = this.mapLdevInfo.get(identity2);
            if (ldevList == null) continue;
            int emutype = rmiExdVol.getIBaseEmulationType();
            byte emuflg = (byte)cvsUtil.getEmuFlg(cvsUtil.getEmulationTypeName(emutype));
            ArrayList<EXDLDEVInfoDetail> cloneLdevList = new ArrayList<EXDLDEVInfoDetail>(ldevList.size());
            for (EXDLDEVInfoDetail ldevInfo : ldevList) {
                cloneLdevList.add((EXDLDEVInfoDetail)ldevInfo.clone());
                short ldkc = ldevInfo.getSLDKC();
                short cu = ldevInfo.getSCU();
                short ldev = ldevInfo.getSLDEV();
                SJmoLdevDetail ldevIndex = new SJmoLdevDetail();
                ldevIndex.setIFB4(rmiExdVol.getIFB4());
                ldevIndex.setIPG(rmiExdVol.getIPG());
                ldevIndex.setSLdkc(ldkc);
                ldevIndex.setSCu(cu);
                ldevIndex.setSLdev(ldev);
                ldevIndex.setLLDEVLBASize(ldevInfo.getLLDEVLBASize());
                ldevIndex.setIEmulationType(emutype);
                ldevIndex.setbCacheMode(rmiExdVol.getCacheMode());
                ldevIndex.setByCurrentMPBladeID((byte)rmiExdVol.getOwnership());
                this.originLdevList.add(ldevIndex);
                SJmoLdevNicknameInfo ldevNameInfo = ldevNameMgr.getLdevNameInfo(ldevIndex);
                if (ldevNameInfo != null) {
                    try {
                        this.ldevNameList.add((SJmoLdevNicknameInfo)ldevNameInfo.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        this.getLogUty().putlog("makeDataModel", "ldevNameInfo clone fail", e, 40000);
                    }
                }
                if (!bLdev) {
                    setLdkc = ldkc;
                    setCu = cu;
                    setLdev = ldev;
                    bLdev = true;
                    continue;
                }
                if (setLdkc != this.INVALID_VALUE && setLdkc != ldkc) {
                    setLdkc = this.INVALID_VALUE;
                }
                if (setCu != this.INVALID_VALUE && setCu != cu) {
                    setCu = this.INVALID_VALUE;
                }
                if (setLdev == this.INVALID_VALUE || setLdev == ldev) continue;
                setLdev = this.INVALID_VALUE;
            }
        }
        if (!this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(41)) {
            SJctrMpBladeIdInfoDataModel mpBladIdDataModel = (SJctrMpBladeIdInfoDataModel)this.getDataObjectModel(KEY_MPPKGINF);
            mpBladIdDataModel.setActiv(false);
        }
        this.orignVolInfo = SJctrDefaultUvmManager.createCloneList(this.selectVolInfo);
        Collections.sort(this.orignVolInfo, new SJctrPgIndexComparator());
        SJctrLdevManager ldevMgr = this.getManager(SJctrLdevManager.class);
        this.cuLdevIdList = SJctrLdevManager.cloneLDEVID(ldevMgr.getLdevIdInfoList());
        Collections.sort(this.ldevNameList);
        SJctrSsidManager sJctrSsidManager = this.getManager(SJctrSsidManager.class);
        this.ssidDtlList = SJctrDefaultUvmManager.createCloneList(sJctrSsidManager.getSsidDetailList());
        this.makeTableData();
        SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)this.getCache(SJmoGetRSGgetAllRsgs.class).get(0);
        this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), rsgInfo);
        this.vLdevList = this.getCache(SJmoGetHUVMVirtualLdev.class);
    }

    public ArrayList<SJmoExdVolumeInfo> makeCloneExdVolData() {
        ArrayList<SJmoExdVolumeInfo> cloneVolInfo = new ArrayList<SJmoExdVolumeInfo>(this.selectVolInfo.size());
        for (SJmoExdVolumeInfo sJmoExdVolumeInfo : this.selectVolInfo) {
            EXDExternalVolumeEx rmiexdvolex = (EXDExternalVolumeEx)sJmoExdVolumeInfo.getRmiExdVolumeInfo();
            EXDExternalVolumeEx cloneRmiExdVolEx = (EXDExternalVolumeEx)rmiexdvolex.cloneSC();
            SJctrAddVolumeInfo clone = new SJctrAddVolumeInfo(cloneRmiExdVolEx);
            cloneVolInfo.add(clone);
        }
        return cloneVolInfo;
    }

    public HashMap<String, List<EXDLDEVInfoDetail>> makeCloneMapLdevData() {
        HashMap<String, List<EXDLDEVInfoDetail>> cloneLdevMap = new HashMap<String, List<EXDLDEVInfoDetail>>(this.selectVolInfo.size());
        for (SJmoExdVolumeInfo sJmoExdVolumeInfo : this.selectVolInfo) {
            String identity2 = sJmoExdVolumeInfo.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2();
            List<EXDLDEVInfoDetail> ldevList = this.mapLdevInfo.get(identity2);
            if (ldevList == null) continue;
            ArrayList<EXDLDEVInfoDetail> cloneLdevList = new ArrayList<EXDLDEVInfoDetail>(ldevList.size());
            for (EXDLDEVInfoDetail ldevInfo : ldevList) {
                EXDLDEVInfoDetail cloneData = (EXDLDEVInfoDetail)ldevInfo.clone();
                cloneData.setLDEVIndex(ldevInfo.getSLDKC(), ldevInfo.getSCU(), ldevInfo.getSLDEV());
                cloneData.setLLDEVLBASize(ldevInfo.getLLDEVLBASize());
                cloneData.setSSID(ldevInfo.getSSID());
                cloneLdevList.add(cloneData);
            }
            cloneLdevMap.put(identity2, cloneLdevList);
        }
        return cloneLdevMap;
    }

    public List<SJmoLdevNicknameInfo> makeLdevNameInfo() {
        ArrayList<SJmoLdevNicknameInfo> ldevNameList = new ArrayList<SJmoLdevNicknameInfo>(this.originLdevList.size());
        SJctrLdevNickNameManager ldevNameMgr = this.getManager(SJctrLdevNickNameManager.class);
        for (SJmoLdevIndex sJmoLdevIndex : this.originLdevList) {
            SJmoLdevNicknameInfo ldevName = ldevNameMgr.getLdevNameInfo(sJmoLdevIndex);
            try {
                ldevNameList.add((SJmoLdevNicknameInfo)ldevName.clone());
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("makeLdevNameInfo", "ldevName clone fail", e, 40000);
            }
        }
        Collections.sort(ldevNameList);
        return ldevNameList;
    }

    public void makeTableData() {
        SJctrLdevNickNameManager ldevNameMgr = this.getManager(SJctrLdevNickNameManager.class);
        List<SJmoLdevDetail> ldevDtlList = SJctrDefaultUvmManager.createCloneList(this.originLdevList);
        List<SJmoLdevNicknameInfo> changeNameList = this.makeLdevNameInfo();
        Collections.sort(changeNameList);
        SJctrSsidManager ssidMgr = this.getManager(SJctrSsidManager.class);
        List<SJmoSsidDetail> ssidDtlList = SJctrDefaultUvmManager.createCloneList(ssidMgr.getSsidDetailList());
        SJctrLdevsTableModel table = (SJctrLdevsTableModel)this.getDataObjectModel(KEY_TABLE);
        table.setBasicDataList(ldevDtlList);
        table.setBasicData(SJmoGetLdevNicknameInfo.class, changeNameList);
        table.setBasicData(SJmoGetSsidDetail.class, ssidDtlList);
        table.doRefresh();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("UVM", GUID_TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_PGINF, new SJctrParityGrpInfoDataModel());
        this.addDataObjectModel(KEY_MPPKGINF, new SJctrMpBladeIdInfoDataModel());
        this.addDataObjectModel(KEY_LDEVCHECKBOX, new SJctrCheckBoxAreaDataModel());
        this.addDataObjectModel(KEY_TABLE, new SJctrLdevsTableModel());
        SJctrButtonDataModel btn = new SJctrButtonDataModel();
        btn.setReceiveOnly();
        btn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrChangeSettingDC.this.changeLdevSettingAction();
            }
        });
        this.addDataObjectModel(KEY_EDITLDEV_BTN, btn);
        SJctrFooterDataModel footer = new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL);
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    private void changeLdevSettingAction() {
        List<SJmoCuLdevIdInfo> cloneCuLdevIdList = SJctrLdevManager.cloneLDEVID(this.cuLdevIdList);
        List<SJmoSsidDetail> cloneSSIDDtl = SJctrDefaultUvmManager.createCloneList(this.ssidDtlList);
        SJctrSsidManager ssidMgr = this.getManager(SJctrSsidManager.class);
        ArrayList<SJmoSsidSummary> ssidSummaryList = new ArrayList<SJmoSsidSummary>();
        SJmoSsidSummary ssidSummary = ssidMgr.getSsidSummary();
        ssidSummaryList.add(ssidSummary);
        List<SJmoSsidDetail> olgssidDtlList = ssidMgr.getSsidDetailList();
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selRowList = table.getSelectedRowDataOrder();
        ArrayList<SJctrLDEVDetail> ldevDtlList = new ArrayList<SJctrLDEVDetail>(selRowList.size());
        for (Object selData : selRowList) {
            SJctrLDEVDetail ldevDtl = new SJctrLDEVDetail();
            ldevDtl.setDetailData((SJmoLdevDetail)selData);
            int ldevNameIndex = Collections.binarySearch(this.ldevNameList, ldevDtl);
            if (ldevNameIndex >= 0) {
                SJmoLdevNicknameInfo ldevNameInfo = this.ldevNameList.get(ldevNameIndex);
                ldevDtl.setStrLdevName(ldevNameInfo.getStrNickname());
            }
            SJctrCVSUtility.deleteLdevID(ldevDtl, cloneCuLdevIdList);
            SJctrCVSUtility.delSSID(ldevDtl, cloneCuLdevIdList, cloneSSIDDtl, olgssidDtlList);
            ldevDtlList.add(ldevDtl);
        }
        HashMap map = new HashMap();
        ArrayList<SJctrChangeLDEVIDData> changeLDEVIDDataList = new ArrayList<SJctrChangeLDEVIDData>(1);
        SJctrChangeLDEVIDData changeLDEVIDData = new SJctrChangeLDEVIDData();
        changeLDEVIDData.setSelectCuLdevIdList(cloneCuLdevIdList);
        changeLDEVIDData.setSelectLdevDetailList(ldevDtlList);
        changeLDEVIDData.setSelectSsidSummaryList(ssidSummaryList);
        changeLDEVIDData.setSelectSsidDetailList(cloneSSIDDtl);
        changeLDEVIDData.setVLdevList(this.vLdevList);
        List<?> AllDkcList = this.getCache(SJmoGetAllDKCInfo.class);
        changeLDEVIDData.setSelectAllDKCInfoList(AllDkcList);
        changeLDEVIDData.setRscLdevUtyList(this.getCache(SJmoGetRscUtilLdev.class));
        changeLDEVIDData.setRscSsidUtyList(this.getCache(SJmoGetRscUtilSsid.class));
        changeLDEVIDData.setRsgUty(this.rsgUtil);
        changeLDEVIDDataList.add(changeLDEVIDData);
        map.put("CHANGE_LDEVID", changeLDEVIDDataList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrChangeLDEVSettingDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    public void exitDialogAction(Map<String, List<?>> carryMap) {
        List<?> carryLdevList = carryMap.get(KEY_DD12_DIALOG_OUT);
        if (carryLdevList != null && carryLdevList.size() != 0) {
            List oldLdev = (List)carryLdevList.get(0);
            this.deleteLDEV(oldLdev);
            List newLdev = (List)carryLdevList.get(1);
            this.createLDEV(newLdev);
            this.setChangeLdevData(newLdev, oldLdev);
            SJctrCheckBoxAreaDataModel ldevChkAria = (SJctrCheckBoxAreaDataModel)this.getDataObjectModel(KEY_LDEVCHECKBOX);
            ldevChkAria.setSelectCheckBox(true);
            ldevChkAria.setDirty();
        }
    }

    public void deleteLDEV(List<SJctrLDEVDetail> ldevList) {
        SJctrSsidManager ssidMgr = this.getManager(SJctrSsidManager.class);
        List<SJmoSsidDetail> olgssidDtlList = ssidMgr.getSsidDetailList();
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = ldevList.get(i);
            SJctrCVSUtility.deleteLdevID(ldev, this.cuLdevIdList);
            SJctrCVSUtility.delSSID(ldev, this.cuLdevIdList, this.ssidDtlList, olgssidDtlList);
            int nameIndex = Collections.binarySearch(this.ldevNameList, ldev);
            if (nameIndex < 0) continue;
            this.ldevNameList.remove(nameIndex);
        }
    }

    public void createLDEV(List<SJctrLDEVDetail> ldevList) {
        SJctrSsidManager ssidMgr = this.getManager(SJctrSsidManager.class);
        SJmoSsidSummary ssidSummaryList = ssidMgr.getSsidSummary();
        SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = ldevList.get(i);
            String strEmu = cvsUtil.getEmulationTypeName(ldev.getIEmulationType());
            int iEmuGrouopID = cvsUtil.getEmuTypeGroup(strEmu);
            SJctrCVSUtility.createLDEVID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), iEmuGrouopID, this.cuLdevIdList);
            if (SJctrCVSUtility.getSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), this.ssidDtlList) == 0) {
                this.ssidDtlList = SJctrCVSUtility.setSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), ldev.getISSID(), this.ssidDtlList, ssidSummaryList.getSSIDBoundary());
            }
            SJmoLdevNicknameInfo newldevName = new SJmoLdevNicknameInfo();
            newldevName.setSLdkc(ldev.getSLdkc());
            newldevName.setSCu(ldev.getSCu());
            newldevName.setSLdev(ldev.getSLdev());
            newldevName.setStrNickname(ldev.getStrLdevName());
            this.ldevNameList.add(newldevName);
        }
        Collections.sort(this.ldevNameList);
    }

    public void setChangeLdevData(List<SJctrLDEVDetail> newLDEVList, List<SJctrLDEVDetail> oldLDEVList) {
        Collections.sort(this.ldevNameList);
        ArrayList newNameList = new ArrayList(newLDEVList.size());
        SJctrLdevsTableModel table = (SJctrLdevsTableModel)this.getDataObjectModel(KEY_TABLE);
        table.setBasicData(SJmoGetSsidDetail.class, this.ssidDtlList);
        table.setBasicData(SJmoGetLdevNicknameInfo.class, this.ldevNameList);
        List<Object> ldevList = table.removeSelectedRowData();
        List<Object> allRowList = table.getAllRowData();
        table.clearRowData();
        for (int ldevCnt = 0; ldevCnt < ldevList.size(); ++ldevCnt) {
            SJmoLdevDetail befLdevDtl = (SJmoLdevDetail)ldevList.get(ldevCnt);
            SJctrLDEVDetail chgldev = newLDEVList.get(ldevCnt);
            try {
                SJmoLdevDetail newldevDtl = (SJmoLdevDetail)befLdevDtl.clone();
                newldevDtl.setLdevIndex(chgldev.getSLdkc(), chgldev.getSCu(), chgldev.getSLdev());
                allRowList.add(newldevDtl);
                continue;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        Collections.sort(allRowList);
        Collections.sort(allRowList, new SJctrArrayGroupIndexComparator());
        table.addRowData(allRowList);
    }

    private SJctrTableDataModel getErrorDialogTable() {
        SJctrDataController parentDc = this.getRelatedDataController().get(0);
        SJctrTableDataModel table = (SJctrTableDataModel)parentDc.getDataObjectModel(KEY_TABLE_SELECTED);
        return table;
    }

    private void initListener() {
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrChangeSettingDC.this.construct();
                Map param = (Map)event.getNofifyObject();
                SJctrChangeSettingDC.this.exitDialogAction(param);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRscUtilLdev();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilSsid();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetAllDKCInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initManager() {
        this.addManager(SJctrEmulationTypeManager.class);
        this.addManager(SJctrExternalVolumeManager.class);
        this.addManager(SJctrLdevManager.class);
        this.addManager(SJctrSsidManager.class);
        this.addManager(SJctrVpgManager.class);
        this.addManager(SJctrLdevNickNameManager.class);
    }
}

