/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.comdialog.discovernewstoragesystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmDialogDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPortManager;
import sanproject.sn2.controller.wizard.uvm.comdialog.discovernewstoragesystem.SJctrAvailableExtPortTableModel;
import sanproject.sn2.controller.wizard.uvm.comdialog.discovernewstoragesystem.SJctrSelectedExtPortTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrDiscoverNewStorageSystemDialogDC
extends SJctrUvmDialogDataController {
    private static final int DISP_ID = 33595401;
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    static final int MSG_NOT_SELECT_TARGET = 105236;
    List<SJmoPortDetail> portDtlList = null;
    List<SJmoPortAttributeInfo> portAttrList = null;

    public SJctrDiscoverNewStorageSystemDialogDC() throws SJcException {
        super(33595401);
        this.initDataModel();
        this.initManager();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAvailableExtPortTableModel());
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrSelectedExtPortTableModel());
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrDiscoverNewStorageSystemDialogDC.this.addAction();
            }
        });
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrDiscoverNewStorageSystemDialogDC.this.removeAction();
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> rowData = selectedTable.getAllRowData();
        if (rowData.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 105236);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> portList = rowData;
        this.putCache("COM_DISCOVERY_PORTLIST", portList);
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        return ret;
    }

    @Override
    public void restoreControlData() {
    }

    private void initManager() {
        this.addManager(SJctrPortManager.class);
    }

    List<SJmoPortDetail> getAvailableTableData() {
        SJmoRSGgetAllRsgs allRsg = (SJmoRSGgetAllRsgs)this.getCache(SJmoGetRSGgetAllRsgs.class).get(0);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsg);
        SJctrPortManager manager = this.getManager(SJctrPortManager.class);
        List<SJmoPortDetail> portList = manager.getPortDetailListbyAttribute(SJctrExtUtility.DISCOVERY_PORT_ATTR_SET);
        List<SJmoPortIndex> unUsablePortList = rsgUtil.extractImpossiblePort(portList);
        Collections.sort(unUsablePortList);
        ArrayList<SJmoPortDetail> retList = new ArrayList<SJmoPortDetail>(portList.size());
        for (SJmoPortDetail portDtl : portList) {
            if (SJctrPortUtility.isHnasPort(portDtl) || Collections.binarySearch(unUsablePortList, portDtl) >= 0) continue;
            retList.add(portDtl);
        }
        return retList;
    }

    private void addAction() {
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> list = avaliableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(list);
        this.updateFooter();
    }

    private void removeAction() {
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> list = selectedTable.removeSelectedRowData();
        avaliableTable.addRowDataTop(list);
        this.updateFooter();
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

