/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.editpathgrp.table;

import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrSubsytemManager;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;

public class SJctrExternalStorageSystemDataModel
extends SJctrComboBoxDataModel {
    public static int INVALID_VALUE = -1;
    private boolean noData = true;

    public SJctrExternalStorageSystemDataModel() {
        this.initListener();
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                int id;
                if (!event.isSelect() || (id = SJctrExternalStorageSystemDataModel.this.getSelectId()) != INVALID_VALUE) {
                    // empty if block
                }
            }
        });
    }

    @Override
    protected void makeDataObject() {
        SJctrExtUtility extUtil = this.getComUtility().getExtUtility();
        SJctrUvmWizardDataController dc = (SJctrUvmWizardDataController)this.getDataController();
        SJctrSubsytemManager subsysMgr = dc.getManager(SJctrSubsytemManager.class);
        List<SJmoExdSubsystemInfo> subsysList = subsysMgr.getAllSubsystemList();
        for (SJmoExdSubsystemInfo subsys : subsysList) {
            int subsystemId = subsys.getRmiExdSubsystemInfo().getId();
            int profileId = subsys.getRmiExdSubsystemInfo().referProfileId();
            SJmoExdProfileInfo profile = subsysMgr.getProfileInfo(profileId);
            String name = String.valueOf(subsystemId);
            String label = extUtil.toSubSystemName(subsys, profile);
            this.addItem(name, label);
            this.noData = false;
        }
        this.setSelectedIndex(0);
    }

    public void selectComboBoxItem(int subsystemId) {
        String itemName = String.valueOf(subsystemId);
        HashMap<String, Object> comboMap = this.getItem(itemName);
        if (comboMap == null) {
            this.removeAllItems();
            this.addItem("");
            this.clearSelection();
        } else {
            String name = (String)comboMap.get("name");
            String label = (String)comboMap.get("label");
            this.removeAllItems();
            this.addItem(name, label);
            this.setSelection(name);
        }
    }

    public void upDateComboBoxItem(int subsystemId) {
        String name = String.valueOf(subsystemId);
        if (this.getItem(name) == null) {
            SJctrUvmWizardDataController dc = (SJctrUvmWizardDataController)this.getDataController();
            SJctrSubsytemManager subsysMgr = dc.getManager(SJctrSubsytemManager.class);
            SJctrExtUtility extUtil = dc.getOwner().getComUtility().getExtUtility();
            SJmoExdSubsystemInfo subsys = subsysMgr.getSubsystemInfo(subsystemId);
            if (subsys == null) {
                return;
            }
            int profileId = subsys.getRmiExdSubsystemInfo().referProfileId();
            SJmoExdProfileInfo profile = subsysMgr.getProfileInfo(profileId);
            String label = extUtil.toSubSystemName(subsys, profile);
            this.addItem(name, label);
            if (this.noData) {
                this.setSelectedIndex(0);
                this.noData = false;
            }
            this.setDirty();
        }
    }

    public int getSelectId() {
        int id = INVALID_VALUE;
        String selection = this.getSelection();
        if (selection != null) {
            id = Integer.valueOf(selection);
        }
        return id;
    }
}

