/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.editpolicy;

import java.io.Serializable;
import java.util.Properties;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.model.SJmoDataChange;

public class SJctrExdPolicyData
implements Serializable {
    private static final long serialVersionUID = -7109093901564604984L;
    public static String EXD_POLICY_DATA = "EXD_POLICY";
    transient SJctrUserController mUserCtrl = null;
    private boolean mCarryOn = true;
    private boolean mInherit = true;
    private String mLdevNum = "";
    public static final int EMUTYPE_OPEN_V = 625;
    private int mEmulationTypeID = 625;
    public static final String EMUTYPE_NAME_OPEN_V = "OPEN-V";
    private String mEmulationTypeName = "OPEN-V";
    private short mClpr = 0;
    private String mClprName = "";
    private boolean mCacheMode = false;
    boolean mInflowCtrl = false;
    short mLBM = 0;
    short mMpBladeId = (short)255;
    private boolean mInternalUsage = false;
    private boolean mInternalUsageVislble = false;
    private int policyVersion = 1;

    public SJctrExdPolicyData(SJctrUserController uc) {
        this.setUserController(uc);
        this.initProperty();
    }

    public void setUserController(SJctrUserController uc) {
        this.mUserCtrl = uc;
    }

    public void initProperty() {
        Serializable Obj = this.mUserCtrl.getUserSession().getUserProperty(EXD_POLICY_DATA);
        if (Obj != null) {
            SJctrExdPolicyData getPolicyData = (SJctrExdPolicyData)Obj;
            this.policyVersionUp(getPolicyData);
            SJctrExdPolicyData policyData = getPolicyData;
            policyData.setUserController(this.mUserCtrl);
            policyData.setProperty();
        }
    }

    public void setCarryOn(boolean flg) {
        this.mCarryOn = flg;
    }

    public boolean isCarryOn() {
        boolean ret = this.mCarryOn;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_CARRYON.toString());
        if (data != null) {
            ret = Boolean.valueOf(data);
        }
        return ret;
    }

    public void setInherit(boolean flg) {
        this.mInherit = flg;
    }

    public boolean isInherit() {
        boolean ret = this.mInherit;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_INHERIT.toString());
        if (data != null) {
            ret = Boolean.valueOf(data);
        }
        return ret;
    }

    public void setLdevNum(String num) {
        this.mLdevNum = num;
    }

    public String getLdevNum() {
        String ret = this.mLdevNum;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_LDEVNUM.toString());
        if (data != null) {
            ret = data;
        }
        return ret;
    }

    public void setClpr(short clpr, String clprName) {
        this.mClpr = clpr;
        this.mClprName = clprName;
    }

    public short getClpr() {
        short ret = this.mClpr;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_CLPR_NUMBER.toString());
        if (data != null) {
            ret = Short.valueOf(data, 16);
        }
        return ret;
    }

    public String getClprName() {
        return this.mClprName;
    }

    public void setBaseEmulation(int id, String name) {
        this.mEmulationTypeID = id;
        this.mEmulationTypeName = name;
    }

    public int getBaseEmuTypeId() {
        return this.mEmulationTypeID;
    }

    public String getBaseEmuTypeName() {
        String ret = this.mEmulationTypeName;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_EMULATIONTYPE_NAME.toString());
        if (data != null && data.length() > 0) {
            ret = data;
        }
        return ret;
    }

    public void setCacheMode(boolean flg) {
        this.mCacheMode = flg;
    }

    public boolean isCacheMode() {
        boolean ret = this.getDefaultCacheMode();
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_CACHEMODE.toString());
        if (data != null) {
            ret = Boolean.valueOf(data);
        }
        return ret;
    }

    private boolean getDefaultCacheMode() {
        boolean cacheMode = false;
        SJmoDataChange dataChange = this.mUserCtrl.getComUtility().getDataChangeTable();
        if (dataChange.isOemType(126976)) {
            cacheMode = true;
        }
        return cacheMode;
    }

    public void setInflowCtrl(boolean flg) {
        this.mInflowCtrl = flg;
    }

    public boolean isInflowCtrl() {
        boolean ret = this.mInflowCtrl;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_INFLOWCTRL.toString());
        if (data != null) {
            ret = Boolean.valueOf(data);
        }
        return ret;
    }

    public void setLoadBalanceMode(short mode) {
        this.mLBM = mode;
    }

    public short getLoadBalanceMode() {
        short ret = this.mLBM;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_LBM.toString());
        if (data != null) {
            ret = Short.valueOf(data);
        }
        return ret;
    }

    public void setMpBladeId(short id) {
        this.mMpBladeId = id;
    }

    public short getMpBladeId() {
        short ret = this.mMpBladeId;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_MPBLADE.toString());
        if (data != null) {
            ret = Short.valueOf(data);
        }
        return ret;
    }

    public void setInternalUsage(boolean flg, boolean visible) {
        this.mInternalUsage = flg;
        this.mInternalUsageVislble = visible;
    }

    public boolean isInternalUsage() {
        boolean ret = this.mInternalUsage;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_INTERNALUSAGE.toString());
        if (data != null) {
            ret = Boolean.valueOf(data);
        }
        return ret;
    }

    public boolean isInternalUsageVisible() {
        boolean ret = this.mInternalUsageVislble;
        String data = this.mUserCtrl.getProperty(EXD_POLICY_ITEM.EXD_INTERNALUSAGE_VISIBLE.toString());
        if (data != null) {
            ret = Boolean.valueOf(data);
        }
        return ret;
    }

    private int getPolicyVer() {
        return this.policyVersion;
    }

    private void setPolicyVer(int version) {
        this.policyVersion = version;
    }

    private void policyVersionUp(SJctrExdPolicyData policyData) {
        int currenVer;
        for (currenVer = policyData.getPolicyVer(); currenVer < this.policyVersion; ++currenVer) {
            switch (currenVer) {
                case 0: {
                    policyData.setLoadBalanceMode((short)0);
                }
            }
        }
        policyData.setPolicyVer(currenVer);
    }

    public void setProperty() {
        Properties property = this.mUserCtrl.getProperty();
        String key = EXD_POLICY_ITEM.EXD_CARRYON.toString();
        String value = Boolean.toString(this.mCarryOn);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_INHERIT.toString();
        value = Boolean.toString(this.mInherit);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_LDEVNUM.toString();
        value = "";
        if (this.mLdevNum != null) {
            value = this.mLdevNum;
        }
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_CLPR_NUMBER.toString();
        value = SJctrComUtility.toHexString(this.mClpr, 2, true);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_EMULATIONTYPE_NAME.toString();
        value = this.mEmulationTypeName;
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_CACHEMODE.toString();
        value = Boolean.toString(this.mCacheMode);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_INFLOWCTRL.toString();
        value = Boolean.toString(this.mInflowCtrl);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_LBM.toString();
        value = Short.toString(this.mLBM);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_MPBLADE.toString();
        value = Short.toString(this.mMpBladeId);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_INTERNALUSAGE.toString();
        value = Boolean.toString(this.mInternalUsage);
        property.setProperty(key, value);
        key = EXD_POLICY_ITEM.EXD_INTERNALUSAGE_VISIBLE.toString();
        value = Boolean.toString(this.mInternalUsageVislble);
        property.setProperty(key, value);
    }

    public String getProperty(EXD_POLICY_ITEM item) {
        String data = "";
        Properties property = this.mUserCtrl.getProperty();
        String result = property.getProperty(item.toString());
        if (result != null) {
            data = result;
        }
        return data;
    }

    public static enum EXD_POLICY_ITEM {
        EXD_CARRYON,
        EXD_INHERIT,
        EXD_CLPR_NUMBER,
        EXD_EMULATIONTYPE_NAME,
        EXD_LDEVNUM,
        EXD_CACHEMODE,
        EXD_INFLOWCTRL,
        EXD_LBM,
        EXD_MPBLADE,
        EXD_INTERNALUSAGE,
        EXD_INTERNALUSAGE_VISIBLE;

    }
}

