/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty.SJctrClprPropertyDialogSummaryModel;
import sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty.SJctrClprPropertyPgTableModel;
import sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty.SJctrClprPropertyVVolTableModel;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrClprPropertyDialogDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595496;
    private static final String GUID_TITLE = "CLPR_PROPERTY";
    public static final String KEY_SELECT_CLPR_INDEX = "KEY_SELECT_CLPR_INDEX";
    public static final String KEY_DETAIL_CLPR_DETAIL = "KEY_DETAIL_CLPR_DETAIL";
    public static final String KEY_DETAIL_PG_DETAIL = "KEY_DETAIL_PG_DETAIL";
    public static final String KEY_DETAIL_LDEV_DETAIL = "KEY_DETAIL_LDEV_DETAIL";
    public static final String KEY_GET_BASE_CLPRINFO = "KEY_GET_BASE_CLPRINFO";
    private SJctrClprPropertyDialogSummaryModel clprSummary = null;
    private SJctrClprPropertyPgTableModel pgTable = null;
    private SJctrClprPropertyVVolTableModel vVolTable = null;

    public SJctrClprPropertyDialogDC() throws SJcException {
        super(33595496);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        List<?> clprIndexList = this.getCache(KEY_SELECT_CLPR_INDEX);
        if (clprIndexList == null || clprIndexList.isEmpty()) {
            SJctrLogUty.warn("SJctrClprPropertyDialogDC", "checkStartData", "Argument Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJmoClprInfo clprInfo = (SJmoClprInfo)this.getCache(KEY_SELECT_CLPR_INDEX).get(0);
        List<?> clprInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        List<?> pgDetaListl = this.getCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL);
        List<?> ldevDetaListl = this.getCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL);
        if (clprInfo == null || clprInfoList == null || clprInfoList.isEmpty() || pgDetaListl == null || ldevDetaListl == null) {
            SJctrLogUty.warn("SJctrClprPropertyDialogDC", "checkConstructData", "Argument Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        ArrayList<SJctrPGDetail> clprPgDtlList = new ArrayList<SJctrPGDetail>();
        ArrayList<SJmoLdevDetail> clprVvolDtlList = new ArrayList<SJmoLdevDetail>();
        for (SJctrPGDetail pgDtl : pgDetaListl) {
            if (pgDtl.getCLPR() != clprInfo.getSClpr() || !pgDtl.isScTopPG()) continue;
            clprPgDtlList.add(pgDtl);
        }
        for (SJmoLdevDetail ldevDtl : ldevDetaListl) {
            if (ldevDtl.getSCLPR() != clprInfo.getSClpr()) continue;
            clprVvolDtlList.add(ldevDtl);
        }
        this.putCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL, clprPgDtlList);
        this.putCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL, clprVvolDtlList);
        return true;
    }

    private void initDataModel() {
        this.clprSummary = new SJctrClprPropertyDialogSummaryModel();
        this.addDataObjectModel("COM_SUMMARY", this.clprSummary);
        this.pgTable = new SJctrClprPropertyPgTableModel();
        this.addDataObjectModel("COM_TABLE_PG", this.pgTable);
        this.vVolTable = new SJctrClprPropertyVVolTableModel();
        this.addDataObjectModel("COM_TABLE_VVOL", this.vVolTable);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(GUID_TITLE);
    }

    @Override
    public void makeDataModel() {
        if (this.getCache(KEY_GET_BASE_CLPRINFO) != null) {
            this.pgTable.setBasicData(SJctrVpmUtility.KEY_CLASS_CLPR_INFO, this.getCache(KEY_GET_BASE_CLPRINFO));
            this.vVolTable.setBasicData(SJctrVpmUtility.KEY_CLASS_CLPR_INFO, this.getCache(KEY_GET_BASE_CLPRINFO));
        }
        super.makeDataModel();
    }
}

