/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.datasupplier;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.io.FileInputStream;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Properties;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.serverux.data.CheckRetEx;
import sanproject.serverux.data.RmiControlObj;
import sanproject.serverux.data.SANRmiException;
import sanproject.serverux.sn.RmiObj_Webcon;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.datasupplier.SJdsRmiErrorInf;
import sanproject.sn2.datasupplier.SJdsSupplierConst;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;

public class SJdsRmiConnector
implements SJdsSupplierConst {
    private RmiObj_Webcon m_RmiObj = null;
    private SanRemote m_RmiObjKV = null;
    private SanData m_generalParam = null;
    private CheckRetEx m_CheckRetObj = null;
    private SJdsRmiErrorInf m_ErrInf = new SJdsRmiErrorInf();
    private int m_iRmiLkupTimeOutCnt = 0;
    static final String SN_ROOT_PATH = "SN_RootPath";

    public boolean loginRmi(String strRmiUrl, String strUser, String strPass, int iVender, String strOwnUrl, URL urlHostPath) {
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "Start");
        boolean bLogin = false;
        this.m_ErrInf.delInformation();
        RmiControlObj rmicontrol = null;
        this.m_iRmiLkupTimeOutCnt = 0;
        String sCurrentpath = "";
        String sEnvPath = "";
        String sDkcPath = "";
        while (this.m_iRmiLkupTimeOutCnt < 1800000) {
            try {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi RmiObj(KeyValue) lookup Start", "");
                sEnvPath = SJcEnvUty.getCmnBasePath() + "dkcman\\cnf\\env.properties";
                FileInputStream StreamEnv = new FileInputStream(sEnvPath);
                Properties PrptEnv = new Properties();
                PrptEnv.load(StreamEnv);
                String sPortNo = PrptEnv.getProperty("com.hitachi.sanproject.registry.privateport");
                StreamEnv.close();
                sDkcPath = SJcEnvUty.getSnBasePath() + "..\\dkc.properties";
                FileInputStream StreamDkc = new FileInputStream(sDkcPath);
                Properties PrptDkc = new Properties();
                PrptDkc.load(StreamDkc);
                String sModel = PrptDkc.getProperty("com.hitachi.sanproject.storage.model");
                int iModel = Integer.parseInt(sModel);
                String sSerialNo = PrptDkc.getProperty("com.hitachi.sanproject.storage.serialnumber");
                int iSerialNo = Integer.parseInt(sSerialNo);
                StreamDkc.close();
                String sUserName = SJcEnvUty.getManageUserName();
                String sPassword = SJcEnvUty.getManagePassword();
                SanRemote rmiObjKV = (SanRemote)Naming.lookup("rmi://127.0.0.1:" + sPortNo + "/com.hitachi.sanproject.rmi.supervisor.rmiserver");
                this.setRmiObjectKV(rmiObjKV);
                this.m_generalParam = rmiObjKV.newData("GeneralParameter");
                this.m_generalParam.newObj("ClientInfo").putString("HostName", "localhost");
                SanRequest sanReq = rmiObjKV.newRequest(this.m_generalParam, "SANreadStorageManagementServer");
                sanReq.putInt("Model", iModel);
                sanReq.putInt("SerialNumber", iSerialNo);
                SanResponse sanRes = rmiObjKV.invoke(this.m_generalParam, sanReq);
                this.m_generalParam.newObj("StorageInfo").putInt("Model", iModel);
                this.m_generalParam.getObj("StorageInfo").putInt("SerialNumber", iSerialNo);
                this.m_generalParam.newObj("AccountInfo").putString("UserName", sUserName);
                this.m_generalParam.getObj("AccountInfo").putString("Password", sPassword);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "RmiControlObj lookup Start");
                String strRmiBindName = sanRes.getString("RmiControlObjBindName");
                rmicontrol = (RmiControlObj)Naming.lookup("rmi://127.0.0.1:" + sPortNo + "/" + strRmiBindName);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "RmiControlObj lookup Normal End");
                if (this.m_CheckRetObj == null) {
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "checkLicenseSx Start");
                    this.m_CheckRetObj = (CheckRetEx)rmicontrol.checkLicenseSx(strUser, strPass, iVender, strOwnUrl, "");
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "checkLicenseSx Normal End");
                }
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi RmiObj lookup Start", "");
                RmiObj_Webcon rmiObj = (RmiObj_Webcon)Naming.lookup("rmi://127.0.0.1:" + sPortNo + "/" + this.m_CheckRetObj.getStrLocalRegBindName());
                this.setRmiObject(rmiObj);
                this.m_ErrInf.setInformation(0, 0, 0);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi RmiObj lookup lookup Normal", "");
                this.m_iRmiLkupTimeOutCnt = 0;
                bLogin = true;
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi Finish Success", "");
                break;
            }
            catch (SANRmiException e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi SANRmiException", "", e);
                this.m_ErrInf.setInformationFromOldCode(e.nErrCode, e.nErrData);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "FuncID=" + this.m_ErrInf.getFuncID() + " ModuleID=" + this.m_ErrInf.getModuleID() + " MsgID=" + this.m_ErrInf.getMsgID());
            }
            catch (NotBoundException e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi NotBoundException", "", e);
                this.m_ErrInf.setInformation(201, 23, 107015);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "FuncID=" + this.m_ErrInf.getFuncID() + " ModuleID=" + this.m_ErrInf.getModuleID() + " MsgID=" + this.m_ErrInf.getMsgID());
            }
            catch (RemoteException e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi RemoteException", "", e);
                this.m_ErrInf.setInformation(201, 23, 107015);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "FuncID=" + this.m_ErrInf.getFuncID() + " ModuleID=" + this.m_ErrInf.getModuleID() + " MsgID=" + this.m_ErrInf.getMsgID());
            }
            catch (Exception e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi Exception", "", e);
                this.m_ErrInf.setInformation(201, 23, 107015);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "FuncID=" + this.m_ErrInf.getFuncID() + " ModuleID=" + this.m_ErrInf.getModuleID() + " MsgID=" + this.m_ErrInf.getMsgID());
            }
            catch (Error e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi Fatal Error", "", e);
                this.m_ErrInf.setInformation(201, 23, 107015);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "FuncID=" + this.m_ErrInf.getFuncID() + " ModuleID=" + this.m_ErrInf.getModuleID() + " MsgID=" + this.m_ErrInf.getMsgID());
            }
            try {
                Thread.sleep(20000L);
                this.m_iRmiLkupTimeOutCnt += 20000;
                if (0 != this.m_iRmiLkupTimeOutCnt % 200000) continue;
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "GC start");
                System.gc();
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "GC end");
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "loginRmi", "End");
        return bLogin;
    }

    public void setRmiObject(RmiObj_Webcon rmiobj) {
        this.m_RmiObj = rmiobj;
    }

    public RmiObj_Webcon getRmiObject() {
        return this.m_RmiObj;
    }

    public void setRmiObjectKV(SanRemote rmiobjKV) {
        this.m_RmiObjKV = rmiobjKV;
    }

    public SanRemote getRmiObjectKV() {
        return this.m_RmiObjKV;
    }

    public SanData getSanData() {
        return this.m_generalParam;
    }

    public SJdsRmiErrorInf getRmiErrInf() {
        return this.m_ErrInf;
    }

    public RCobj_interface_CheckRet getCheckRet() {
        return this.m_CheckRetObj;
    }

    public void stopLoginRmi() {
        this.m_iRmiLkupTimeOutCnt = 1800000;
    }

    public String makeLookupPath(String sOrgPath) {
        String rootpath = "";
        try {
            rootpath = SJcEnvUty.getDkcRootName();
        }
        catch (Exception ex) {
            SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsRmiConnector", "makeLookupPath", "Exception", ex);
        }
        return sOrgPath + "--" + rootpath;
    }
}

