/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.com;

import java.util.Formatter;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;

public class SJhtclStringUty {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclStringUty.class.getSimpleName();
    public static final String LINE_FEED_STR = "\n";
    public static final char LINE_FEED_CHR = '\n';
    public static final String CARRIAGE_RETURN_STR = "\r";
    private static final String BLANK = " ";
    private static final String HYPHEN = "-";
    private static final String ARC_LEFT = "(";
    private static final String ARC_RIGHT = ")";
    private static final String CARRIAGE_RETURN = "\r";
    private static final String LINE_FEED_MSG_STR = "\\\\n";

    public static String treatString(String str, int maxLen) {
        String result = "";
        if (str.length() > maxLen) {
            result = str.substring(0, maxLen - 3) + "...";
        } else {
            Formatter formatter = new Formatter();
            result = formatter.format("%-" + maxLen + "s", str).toString();
        }
        return result;
    }

    public static String cnvTimeStr(String str) {
        String result = "";
        if (str.length() == 14) {
            int year = Integer.parseInt(str.substring(0, 4));
            int month = Integer.parseInt(str.substring(4, 6));
            int day = Integer.parseInt(str.substring(6, 8));
            int hour = Integer.parseInt(str.substring(8, 10));
            int min = Integer.parseInt(str.substring(10, 12));
            int sec = Integer.parseInt(str.substring(12, 14));
            Formatter formatter = new Formatter();
            result = formatter.format("%04d/%02d/%02d-%02d:%02d:%02d", year, month, day, hour, min, sec).toString();
        } else {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "cnvTimeStr", "Failed to cnvTimeStr.");
        }
        return result;
    }

    public static String formatLineFeed(String str) {
        str = str.replace("\r\n", LINE_FEED_STR);
        if ((str = str.replace("\r", LINE_FEED_STR)).charAt(str.length() - 1) != '\n') {
            str = str + LINE_FEED_STR;
        }
        return str;
    }

    public static String formatErrorMessage(SJcMessage msg) {
        String formattedMessage = "";
        if (null != msg) {
            String functionID = msg.getFunctionID();
            String moduleID = msg.getModuleID();
            String msgID = msg.getMsgID();
            SJcMessageHandleInterface messageHundle = SJcWordUty.getMessageInfo("EN");
            String message = messageHundle.getMessage(functionID, moduleID, msgID);
            message = SJhtclStringUty.trimLineFeed(message);
            String measure = messageHundle.getMeasuresMessage(functionID, moduleID, msgID);
            measure = SJhtclStringUty.trimLineFeed(measure);
            String code = SJhtclStringUty.formatErrorCode(functionID, moduleID, msgID);
            formattedMessage = message + LINE_FEED_STR + measure + code;
        }
        return formattedMessage;
    }

    private static String trimLineFeed(String str) {
        if (str != null) {
            str = str.replace("\r\n", BLANK);
            str = str.replace(LINE_FEED_STR, BLANK);
            str = str.replace("\r", BLANK);
            str = str.replace(LINE_FEED_MSG_STR, LINE_FEED_STR);
        }
        return str;
    }

    private static String formatErrorCode(String functionID, String moduleID, String msgID) {
        String code = "";
        code = ARC_LEFT + functionID + moduleID + HYPHEN + msgID + ARC_RIGHT;
        return code;
    }
}

