/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.controller;

import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserCtrInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclPluginUty;
import sanproject.sn2.httpcli.exec.inf.SJhtclExecInterface;

public class SJhtclController
implements SJbaseUserCtrInterface {
    private static String LOG_FUNCTION = "HTTP_CLI";
    private static String LOG_TITLE = SJhtclController.class.getSimpleName();
    private static SJcLoggerInterface htclLogger = null;
    SJbaseUserSessionInterface userSession = null;

    @Override
    public void finish() {
        String LOG_SUBTITLE = "finish";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "finish", LOG_TITLE + " is finished.");
    }

    @Override
    public void initialize(SJbaseUserSessionInterface userSession) throws Exception {
        this.userSession = userSession;
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    public SJctrRequestDataObject post(SJctrRequestDataObject dataObj) throws Exception {
        String LOG_SUBTITLE = "post";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "post", "Start.");
        HashMap<String, Object> responseMap = null;
        String act = null;
        String obj = null;
        if (!this.checkParameters(dataObj.getDataMap())) {
            responseMap = SJhtclHttpCliUty.getErrorMapBase("107003");
        } else {
            try {
                HashMap<String, Object> rootMap = dataObj.getDataMap();
                Map map = (Map)rootMap.get("RequestKey");
                act = SJhtclParameterUty.getStrFromMap(map, "act");
                obj = SJhtclParameterUty.getStrFromMap(map, "obj");
                SJhtclExecInterface executer = SJhtclPluginUty.getExecPlugin(map);
                if (executer != null) {
                    responseMap = executer.exec();
                } else {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "post", "Failed to execute command. -act:" + act + " -obj:" + obj);
                    responseMap = SJhtclHttpCliUty.getErrorMapBase("107008");
                }
            }
            catch (SJcException sjce) {
                responseMap = SJhtclHttpCliUty.getErrorMap(sjce.getMsg());
            }
            catch (Throwable th) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "post", "Failed to execute command. -act:" + act + " -obj:" + obj, th);
                responseMap = SJhtclHttpCliUty.getErrorMapBase("107001");
            }
        }
        SJctrRequestDataObject result = new SJctrRequestDataObject();
        HashMap<String, Object> rootMap = result.getDataMap();
        rootMap.put("ResponseKey", responseMap);
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "post", "End.");
        return result;
    }

    private boolean checkParameters(Map<String, Object> map) {
        String LOG_SUBTITLE = "checkParameters";
        boolean res = true;
        if (map == null) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "Parameter map is null.");
            res = false;
        } else {
            HashMap reqMap = (HashMap)map.get("RequestKey");
            if (reqMap == null) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "RequestKey is null.");
                res = false;
            } else if (SJhtclParameterUty.getStrFromMap(reqMap, "act") == null) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "act is null.");
                res = false;
            } else if (SJhtclParameterUty.getStrFromMap(reqMap, "obj") == null) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "obj is null.");
                res = false;
            }
        }
        return res;
    }
}

