/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclRelocationLogUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;

public class SJhtclRelocationLogList
extends SJhtclExecBase {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRelocationLogList.class.getSimpleName();

    public SJhtclRelocationLogList(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
    }

    @Override
    protected boolean checkRole() {
        boolean bResult = false;
        SJcRoleResourceContainer role = this.session.getRoleResourceInfo();
        if (role.checkAuthority(32)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected boolean checkPP() {
        boolean bResult = false;
        if (this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        HashMap<String, Object> responseMap = new HashMap();
        try {
            HashMap<String, Date> logInfMap = null;
            try {
                List<String> strFileList = SJhtclRelocationLogUty.getRelocationLogFileList();
                logInfMap = SJhtclRelocationLogUty.makeRelocationLogInfo(strFileList);
            }
            catch (FileNotFoundException ex) {
                htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "DirectoryNotFound. directoryPath:" + ex.getMessage());
            }
            String strResult = SJhtclRelocationLogUty.createResponseContents(logInfMap, this.session);
            responseMap = SJhtclHttpCliUty.getTextMap(strResult);
        }
        catch (SJcException ex) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJceException ex:" + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }
}

