/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sanproject.serverux.dataimpl.REPORTgetReportHistory;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclDef;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclReportUty;
import sanproject.sn2.httpcli.com.SJhtclStringUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;
import sanproject.sn2.httpcli.exec.com.SJhtclReportRMIUtility;

public class SJhtclReportCreate
extends SJhtclExecBase {
    private static final String SPACE = " ";
    private static final String CHANGE_LINE = "\n";
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclReportCreate.class.getSimpleName();

    public SJhtclReportCreate(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    protected boolean checkParameters() {
        boolean res = true;
        String reportName = SJhtclParameterUty.getStrFromMap(this.requestMap, "report");
        if (reportName == null || reportName.trim().length() <= 0) {
            res = false;
        }
        return res;
    }

    @Override
    protected boolean checkRole() {
        SJcRoleResourceContainer resourceContainer = this.session.getRoleResourceInfo();
        return resourceContainer.checkAuthority(32);
    }

    @Override
    protected boolean checkPP() {
        boolean res = true;
        if (!this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            res = false;
        }
        return res;
    }

    public String responseFormmat(String createUser, String reportName, String createTime) {
        SJcGuidanceHandleInterface guidHandler = this.session.getGuidanceInfo();
        String guidnaceReportName = guidHandler.getGuidance("XPDT_CLI_REPORT_NAME");
        String guidnaceCreateUser = guidHandler.getGuidance("XPDT_CLI_USER_NAME");
        String guidnaceCreateTime = guidHandler.getGuidance("XPDT_CLI_CREATE_TIME");
        String result = SJhtclStringUty.treatString(guidnaceReportName, 32) + SPACE + SJhtclStringUty.treatString(guidnaceCreateUser, 16) + SPACE + SJhtclStringUty.treatString(guidnaceCreateTime, 19);
        result = result + CHANGE_LINE + SJhtclStringUty.treatString(reportName, 32) + SPACE + SJhtclStringUty.treatString(createUser, 16) + SPACE + SJhtclStringUty.treatString(createTime, 19);
        return result;
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        HashMap<String, Object> responseMap = new HashMap();
        try {
            String reportName = SJhtclParameterUty.getStrFromMap(this.requestMap, "report");
            if (32 < reportName.trim().length()) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "MAX_SIZE_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107013");
                return responseMap;
            }
            for (String checkStr : SJhtclDef.ReportCheckList) {
                if (reportName.indexOf(checkStr) < 0) continue;
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "INPUT_CHECK_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107014");
                return responseMap;
            }
            REPORTgetReportHistory reportHistory = SJhtclReportRMIUtility.getReportList();
            if (!SJhtclReportUty.checkMaxCount(reportHistory)) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "MAX_COUNT_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107005");
                return responseMap;
            }
            Date date = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
            String submittedTime = df.format(date);
            SJhtclReportRMIUtility.createReport(reportName, this.session, date);
            String result = this.responseFormmat(this.session.getUserName(), reportName, submittedTime);
            responseMap.put("ResponseKeyType", "TXT");
            responseMap.put("Text", result);
        }
        catch (SJcException ex) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJceException ex:" + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }
}

