/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.CryptographicParameters;
import sanproject.sn2.kms.kmip.client.info.common.Digest;
import sanproject.sn2.kms.kmip.client.info.common.Name;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.info.common.Revocation;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVByteString;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterGetAttributes
extends Converter {
    private static final String module = "ConverterGetAttributes";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        ArrayList<String> uidList = ii.getLocatedUniqueIdentifierList();
        if (uidList == null || uidList.size() < 1) {
            STD_LOGGER.info(module, method, " - check UUID", " - invalid");
            throw new KeyInfoBlankException();
        }
        int mode = this.getMode(ii);
        if (mode == 0) {
            STD_LOGGER.info(module, method, " - check Info", " - invalid");
            throw new KeyInfoBlankException();
        }
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(uidList.size());
        }
        tReq.addValue(this.getRequestHeader(rhc, uidList.size()));
        block9: for (int i = 0; i < uidList.size(); ++i) {
            TTLVStructure tBI = this.getBatchItem(11, i + 1);
            tReq.addValue(tBI);
            TTLVStructure tPay = new TTLVStructure(121);
            tBI.addValue(tPay);
            String s = uidList.get(i);
            if (s == null || s.length() == 0) {
                throw new KeyInfoBlankException();
            }
            tPay.addValue(new TTLVTextString(-108, s));
            switch (mode) {
                case 1: {
                    tPay.addValue(new TTLVTextString(10, "x-BackupDate"));
                    tPay.addValue(new TTLVTextString(10, "x-BackupComment"));
                    tPay.addValue(new TTLVTextString(10, "x-RegularBackup"));
                    continue block9;
                }
                case 2: {
                    tPay.addValue(new TTLVTextString(10, "x-KeyMaterialFormatID"));
                    tPay.addValue(new TTLVTextString(10, "x-HashAlgorithm"));
                    tPay.addValue(new TTLVTextString(10, "x-Hash"));
                    tPay.addValue(new TTLVTextString(10, "x-KEKUID"));
                    tPay.addValue(new TTLVTextString(10, "x-BackupDataSize"));
                    continue block9;
                }
                case 3: {
                    tPay.addValue(new TTLVTextString(10, "x-HashAlgorithm"));
                    tPay.addValue(new TTLVTextString(10, "x-Hash"));
                    continue block9;
                }
                case 4: {
                    tPay.addValue(new TTLVTextString(10, "x-KEKUID"));
                    continue block9;
                }
                case 5: {
                    tPay.addValue(new TTLVTextString(10, "x-KeyMaterialFormatID"));
                    tPay.addValue(new TTLVTextString(10, "x-HashAlgorithm"));
                    tPay.addValue(new TTLVTextString(10, "x-Hash"));
                    tPay.addValue(new TTLVTextString(10, "x-AddAttributeDate"));
                    continue block9;
                }
                case 6: {
                    tPay.addValue(new TTLVTextString(10, "x-BackupDate"));
                    tPay.addValue(new TTLVTextString(10, "x-BackupComment"));
                    tPay.addValue(new TTLVTextString(10, "x-RegularBackup"));
                    tPay.addValue(new TTLVTextString(10, "x-KEKUID"));
                    tPay.addValue(new TTLVTextString(10, "x-SplitNum"));
                    tPay.addValue(new TTLVTextString(10, "x-SplitID"));
                    continue block9;
                }
                case 7: {
                    String[] attributeNameArray = ii.getAttrNeedsMap().keySet().toArray(new String[0]);
                    for (int j = 0; j < attributeNameArray.length; ++j) {
                        tPay.addValue(new TTLVTextString(10, attributeNameArray[j]));
                    }
                    continue block9;
                }
            }
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    protected int getMode(InputInfo ii) {
        String method = "getMode";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String[] compareString = new String[]{"ReferData", "GetDEKData", "GetKEKData", "GetKEKUID", "GetKEKdynData", "GetSplitInfo", "GetSpecifiedAttr"};
        String s = ii.getInfo();
        if (s == null) {
            STD_LOGGER.info(module, method, " - Check Info", " - invalid");
            return 0;
        }
        for (int i = 0; i < compareString.length; ++i) {
            if (s.compareToIgnoreCase(compareString[i]) != 0) continue;
            STD_LOGGER.info(module, method, " - ", " - end");
            return i + 1;
        }
        STD_LOGGER.info(module, method, " - Check Info", " - mismatch");
        return 0;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        for (int i = 0; i < al.size(); ++i) {
            OutputInfo oi = new OutputInfo();
            if (al.get(i).getType() != 1) {
                STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
                throw new ResponseException();
            }
            TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(i), oi);
            if (tRP != null) {
                this.checkValue(tRP, (byte)-108, (byte)7, 1);
                TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
                ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
                uniqueIdentifierList.add(tUI.getValue());
                oi.setUniqueIdentifierList(uniqueIdentifierList);
                ArrayList<TTLV> al_attribute = tRP.getValueList((byte)8);
                if (al_attribute != null) {
                    for (int j = 0; j < al_attribute.size(); ++j) {
                        if (al_attribute.get(j).getType() != 1) {
                            STD_LOGGER.info(module, method, " - check Type of Attribute", " - invalid");
                            throw new ResponseException();
                        }
                        this.parseAttribute((TTLVStructure)al_attribute.get(j), oi);
                    }
                }
            }
            oiList.add(oi);
        }
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }

    protected void parseAttribute(TTLVStructure t, OutputInfo oi) throws ResponseException {
        String method = "parseAttribute";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        if (t.getValueSize((byte)10) == 1 && t.getValueSize((byte)11) == 1) {
            this.checkValue(t, (byte)10, (byte)7, 1);
            TTLVTextString tAttrName = (TTLVTextString)t.getValueList((byte)10).get(0);
            TTLV tAttrValue = t.getValueList((byte)11).get(0);
            String attrName = tAttrName.getValue();
            if (attrName.compareToIgnoreCase("x-BackupDate") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setBackupDate(ts.getValue());
            } else if (attrName.compareToIgnoreCase("x-BackupComment") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setBackupComment(ts.getValue());
            } else if (attrName.compareToIgnoreCase("x-RegularBackup") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setRegularBackup(Integer.parseInt(ts.getValue()));
            } else if (attrName.compareToIgnoreCase("x-KeyMaterialFormatID") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setKeyMaterialFormatID(Integer.parseInt(ts.getValue(), 16));
            } else if (attrName.compareToIgnoreCase("x-HashAlgorithm") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setHashAlgrithm(Integer.parseInt(ts.getValue(), 16));
            } else if (attrName.compareToIgnoreCase("x-Hash") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setHash(ts.getValue());
            } else if (attrName.compareToIgnoreCase("x-KEKUID") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setBackupKEKUID(ts.getValue());
            } else if (attrName.compareToIgnoreCase("x-BackupDataSize") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setBackupDataSize(Integer.parseInt(ts.getValue(), 16));
            } else if (attrName.compareToIgnoreCase("x-AddAttributeDate") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setAddAttributeDate(ts.getValue());
            } else if (attrName.compareToIgnoreCase("x-SplitNum") == 0) {
                TTLVInteger ti = (TTLVInteger)tAttrValue;
                oi.setSplitNum(ti.getValue());
            } else if (attrName.compareToIgnoreCase("x-SplitID") == 0) {
                TTLVInteger ti = (TTLVInteger)tAttrValue;
                oi.setSplitID(ti.getValue());
            } else if (attrName.compareToIgnoreCase("x-BackupTaskName") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setBackupTaskName(ts.getValue());
            } else if (attrName.compareToIgnoreCase("Name") == 0) {
                TTLVStructure st = (TTLVStructure)tAttrValue;
                TTLVTextString ts = (TTLVTextString)st.getValueList((byte)85).get(0);
                TTLVEnumeration te = (TTLVEnumeration)st.getValueList((byte)84).get(0);
                oi.setName(new Name(ts.getValue(), te.getValue()));
            } else if (attrName.compareToIgnoreCase("Object Type") == 0) {
                TTLVEnumeration te = (TTLVEnumeration)tAttrValue;
                oi.setObjectType(te.getValue());
            } else if (attrName.compareToIgnoreCase("Cryptographic Algorithm") == 0) {
                TTLVEnumeration te = (TTLVEnumeration)tAttrValue;
                oi.setCryptographicAlgorithm(te.getValue());
            } else if (attrName.compareToIgnoreCase("Cryptographic Algorithm") == 0) {
                TTLVInteger ti = (TTLVInteger)tAttrValue;
                oi.setCryptographicLength(ti.getValue());
            } else if (attrName.compareToIgnoreCase("Cryptographic Parameters") == 0) {
                boolean[] AttrNeeds = new boolean[4];
                TTLVStructure st = (TTLVStructure)tAttrValue;
                TTLVEnumeration te1 = (TTLVEnumeration)st.getValueList((byte)17).get(0);
                TTLVEnumeration te2 = (TTLVEnumeration)st.getValueList((byte)95).get(0);
                TTLVEnumeration te3 = (TTLVEnumeration)st.getValueList((byte)56).get(0);
                TTLVEnumeration te4 = (TTLVEnumeration)st.getValueList((byte)-125).get(0);
                oi.setCryptographicParameters(new CryptographicParameters(te1.getValue(), te2.getValue(), te3.getValue(), te4.getValue(), AttrNeeds));
            } else if (attrName.compareToIgnoreCase("Digest") == 0) {
                TTLVStructure st = (TTLVStructure)tAttrValue;
                TTLVEnumeration te1 = (TTLVEnumeration)st.getValueList((byte)56).get(0);
                TTLVByteString te2 = (TTLVByteString)st.getValueList((byte)53).get(0);
                TTLVEnumeration te3 = (TTLVEnumeration)st.getValueList((byte)66).get(0);
                oi.setDigest(new Digest(te1.getValue(), te2.getValueByArray(), te3.getValue()));
            } else if (attrName.compareToIgnoreCase("Operation Policy Name") == 0) {
                TTLVTextString ts = (TTLVTextString)tAttrValue;
                oi.setOperationPolicyName(ts.getValue());
            } else if (attrName.compareToIgnoreCase("Cryptographic Usage Mask") == 0) {
                TTLVInteger ti = (TTLVInteger)tAttrValue;
                oi.setCryptographicUsageMask(ti.getValue());
            } else if (attrName.compareToIgnoreCase("State") == 0) {
                TTLVEnumeration te = (TTLVEnumeration)tAttrValue;
                oi.setState(te.getValue());
            } else if (attrName.compareToIgnoreCase("Initial Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setInitialDate(td.getValue());
            } else if (attrName.compareToIgnoreCase("Activation Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setActivationDate(td.getValue());
            } else if (attrName.compareToIgnoreCase("Deactivation Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setDeactivationDate(td.getValue());
            } else if (attrName.compareToIgnoreCase("Compromise Occurrence Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setCompromiseOccurrenceDate(td.getValue());
            } else if (attrName.compareToIgnoreCase("Compromise Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setCompromiseDate(td.getValue());
            } else if (attrName.compareToIgnoreCase("Revocation Reason") == 0) {
                TTLVStructure st = (TTLVStructure)tAttrValue;
                TTLVEnumeration te1 = (TTLVEnumeration)st.getValueList((byte)-126).get(0);
                TTLVTextString te2 = (TTLVTextString)st.getValueList((byte)-128).get(0);
                oi.setRevocationReason(new Revocation(te1.getValue(), te2.getValue()));
            } else if (attrName.compareToIgnoreCase("Last Change Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setLastChangeDate(td.getValue());
            } else if (attrName.compareToIgnoreCase("Process Start Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setProcessStartDate(td.getValue());
            } else if (attrName.compareToIgnoreCase("Protect Stop Date") == 0) {
                TTLVDateTime td = (TTLVDateTime)tAttrValue;
                oi.setProtectStopDate(td.getValue());
            }
        }
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

