/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVBigInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVBoolean;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVByteString;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInterval;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVLongInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVFactory {
    private static final String module = "TTLVFactory";

    public static TTLV makeTTLVByBinary(byte[] data) throws ResponseException {
        String method = "makeTTLVByBinary";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        if (data == null) {
            return null;
        }
        TTLVStructure ts = new TTLVStructure(0);
        TTLVFactory.makeTTLVByBinary(data, 0, data.length, ts);
        return ts.getValueSize() == 1 ? ts.getValue(0) : null;
    }

    protected static void makeTTLVByBinary(byte[] data, int pos, int len, TTLVStructure parent) throws ResponseException {
        TTLV t;
        String method = "makeTTLVByBinary";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        int goal = pos + len;
        for (int nowPos = pos; nowPos < goal; nowPos += t.getBinaryDataSize()) {
            boolean isInvalid = false;
            switch (data[nowPos + 0]) {
                case 66: {
                    if (data[nowPos + 0 + 2] != 0) break;
                    isInvalid = true;
                    break;
                }
                case 84: {
                    break;
                }
                default: {
                    isInvalid = true;
                }
            }
            if (isInvalid) {
                String msg = "[Error] tag = [";
                for (int i = 0; i < 3; ++i) {
                    msg = msg + String.format("%02X", data[nowPos + i]);
                }
                msg = msg + "] is invalid";
                throw new ResponseException();
            }
            t = null;
            switch (data[nowPos + 3]) {
                case 1: {
                    TTLVStructure ts = new TTLVStructure(data, nowPos);
                    TTLVFactory.makeTTLVByBinary(data, nowPos + 8, ts.getLength(), ts);
                    t = ts;
                    break;
                }
                case 2: {
                    t = new TTLVInteger(data, nowPos);
                    break;
                }
                case 3: {
                    t = new TTLVLongInteger(data, nowPos);
                    break;
                }
                case 4: {
                    t = new TTLVBigInteger(data, nowPos);
                    break;
                }
                case 5: {
                    t = new TTLVEnumeration(data, nowPos);
                    break;
                }
                case 6: {
                    t = new TTLVBoolean(data, nowPos);
                    break;
                }
                case 7: {
                    t = new TTLVTextString(data, nowPos);
                    break;
                }
                case 8: {
                    t = new TTLVByteString(data, nowPos);
                    break;
                }
                case 9: {
                    t = new TTLVDateTime(data, nowPos);
                    break;
                }
                case 10: {
                    t = new TTLVInterval(data, nowPos);
                    break;
                }
                default: {
                    String msg = "[Error] type = [" + String.format(" %02X", data[3]) + "] is invalid";
                    throw new ResponseException();
                }
            }
            parent.addValue(t);
        }
    }
}

