/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.util.KmsConfiguration;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class KmsConfigurationFactory {
    private static final String module = "KmsConfigurationFactory";
    public static final String KMS_BASE = "kms";
    public static final String SERVER_ENABLED = "server.enabled";
    public static final String SERVER_TYPE = "server.type";
    public static final String SERVER_NAME = "server.name";
    public static final String REGULARBACKUP_ENABLED = "regularbackup.enabled";
    public static final String REGULARBACKUP_SCHEDULE = "regularbackup.schedule";
    public static final String REGULARBACKUP_USERID = "regularbackup.userid";
    public static final String REGULARBACKUP_PASSWD = "regularbackup.passwd";
    public static final String HOSTENABLED = "hostenabled";
    public static final String HOST = "host";
    public static final String HOSTTYPE = "hosttype";
    public static final String VERSION = "version";
    public static final String PORT = "port";
    public static final String AUTH = "authentication";
    public static final String RETRY_TIMES = "retry.times";
    public static final String RETRY_INTERVAL = "retry.interval";
    public static final String TIMEOUT = "timeout";
    public static final int PORT_MIN = 0;
    public static final int PORT_MAX = 65535;
    public static final int RETRY_TIMES_MIN = 1;
    public static final int RETRY_TIMES_MAX = 50;
    public static final int RETRY_TIMES_DEF = 3;
    public static final int RETRY_INTERVAL_MIN = 1;
    public static final int RETRY_INTERVAL_MAX = 60;
    public static final int RETRY_INTERVAL_DEF = 1;
    public static final int TIMEOUT_MIN = 1;
    public static final int TIMEOUT_MAX = 999;
    public static final int TIMEOUT_DEF = 10;
    public static final String[] KMSNAME = new String[]{"PrimaryServer", "SecondaryServer"};

    private KmsConfigurationFactory() {
    }

    public static List<String> getServerNames(Properties properties) throws SJcException {
        KmsConfiguration[] configs = KmsConfigurationFactory.getConfigrations(properties);
        return KmsConfigurationFactory.getServerNames(configs);
    }

    public static List<String> getServerNames(KmsConfiguration[] configs) throws SJcException {
        ArrayList<String> ret = new ArrayList<String>();
        for (KmsConfiguration config : configs) {
            if (config == null || !config.getEnabled()) continue;
            ret.add(config.getServerName());
        }
        return ret;
    }

    public static KmsConfiguration[] getConfigrations(Properties properties) throws SJcException {
        int i;
        KmsConfiguration[] configs;
        String method = "getConfigrations";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        if (properties == null) {
            STD_LOGGER.info(module, method, " - Check the configuration file object", " - object does not exist");
            configs = new KmsConfiguration[]{};
        } else {
            configs = new KmsConfiguration[KMSNAME.length];
            for (i = 0; i < KMSNAME.length; ++i) {
                String tmpKmsName = KMSNAME[i];
                String Servname = properties.getProperty("kms.server.name");
                if (Servname.indexOf(tmpKmsName) == -1) {
                    throw new SJcException();
                }
                STD_LOGGER.info(module, method, " - Start to construct the configuration object", " - " + tmpKmsName);
                String basekey = "kms.kmip." + tmpKmsName + ".";
                KmsConfiguration tmpConf = new KmsConfiguration();
                KmsConfigurationFactory.setKmsName(tmpConf, tmpKmsName);
                KmsConfigurationFactory.setHost(tmpConf, tmpKmsName, basekey, properties);
                KmsConfigurationFactory.setPort(tmpConf, tmpKmsName, basekey, properties);
                KmsConfigurationFactory.setAuthentication(tmpConf, tmpKmsName, basekey, properties);
                KmsConfigurationFactory.setTimeout(tmpConf, tmpKmsName, basekey, properties);
                KmsConfigurationFactory.setRetryTimes(tmpConf, tmpKmsName, basekey, properties);
                KmsConfigurationFactory.setRetryInterval(tmpConf, tmpKmsName, basekey, properties);
                KmsConfigurationFactory.setHostEnabled(tmpConf, tmpKmsName, basekey, properties);
                tmpConf.setServerType("kmip");
                tmpConf.setHosttype(properties.getProperty(basekey + HOSTTYPE));
                tmpConf.setVersion(properties.getProperty(basekey + VERSION));
                KmsConfigurationFactory.setRegularbackupEnabled(tmpConf, properties);
                KmsConfigurationFactory.setRegularbackupSchedule(tmpConf, properties);
                KmsConfigurationFactory.setRegularbackupUserid(tmpConf, properties);
                KmsConfigurationFactory.setRegularbackupPasswd(tmpConf, properties);
                STD_LOGGER.info(module, method, " - Finish constructing the configuration object", " - " + tmpKmsName);
                configs[i] = tmpConf;
            }
        }
        for (i = 0; i < KMSNAME.length; ++i) {
            if (configs[i] == null) {
                throw new SJcException();
            }
            if (configs[i].getConfigErrCode() == 0) continue;
            throw new SJcException();
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return configs;
    }

    public static void setKmsName(KmsConfiguration conf, String kmsName) {
        String method = "setKmsName";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        conf.setKmsName(kmsName);
        STD_LOGGER.info(module, method, kmsName, " - end");
    }

    public static void setHost(KmsConfiguration conf, String kmsName, String basekey, Properties properties) {
        String method = "setHost";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String tmpHost = properties.getProperty(basekey + HOST);
        if (tmpHost == null) {
            STD_LOGGER.info(module, method, " - the value is non", " - host");
            conf.setConfigErrCode(10);
        } else {
            conf.setHost(tmpHost);
        }
        STD_LOGGER.info(module, method, tmpHost, " - end");
    }

    public static void setPort(KmsConfiguration conf, String kmsName, String basekey, Properties properties) {
        String method = "setPort";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        int tmpPort = 0;
        try {
            tmpPort = Integer.parseInt(properties.getProperty(basekey + PORT));
            if (tmpPort < 0 || tmpPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            STD_LOGGER.info(module, method, " - the value is invalid", " - port\uff1a" + tmpPort);
            conf.setConfigErrCode(10);
        }
        conf.setPort(tmpPort);
        STD_LOGGER.info(module, method, "" + tmpPort, " - end");
    }

    public static void setAuthentication(KmsConfiguration conf, String kmsName, String basekey, Properties properties) {
        String method = "setAuthentication";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String tmpAuth = properties.getProperty(basekey + AUTH);
        if (tmpAuth == null || tmpAuth.length() == 0) {
            STD_LOGGER.info(module, method, " - the value is non", " - auth");
            tmpAuth = "false";
            conf.setAuthentication("false");
        } else if (tmpAuth.equalsIgnoreCase("true") || tmpAuth.equalsIgnoreCase("false")) {
            conf.setAuthentication(tmpAuth);
        } else {
            STD_LOGGER.info(module, method, " - the value is invalid : " + tmpAuth, " - auth");
            tmpAuth = "false";
            conf.setAuthentication("false");
        }
        STD_LOGGER.info(module, method, tmpAuth, " - end");
    }

    public static void setTimeout(KmsConfiguration conf, String kmsName, String basekey, Properties properties) {
        String method = "setTimeout";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        int tmpTimeout = 10;
        try {
            tmpTimeout = Integer.parseInt(properties.getProperty(basekey + TIMEOUT));
            if (tmpTimeout < 1 || tmpTimeout > 999) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            STD_LOGGER.info(module, method, " - the value is invalid: " + tmpTimeout, " - timeout");
            tmpTimeout = 10;
        }
        catch (NullPointerException e) {
            STD_LOGGER.info(module, method, " - the value is invalid(null)", " - timeout");
            tmpTimeout = 10;
        }
        conf.setTimeout(tmpTimeout);
        STD_LOGGER.info(module, method, "" + tmpTimeout, " - end");
    }

    public static void setRetryTimes(KmsConfiguration conf, String kmsName, String basekey, Properties properties) {
        String method = "setRetryTimes";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        int tmpRetryTimes = 3;
        try {
            tmpRetryTimes = Integer.parseInt(properties.getProperty(basekey + RETRY_TIMES));
            if (tmpRetryTimes < 1 || tmpRetryTimes > 50) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            STD_LOGGER.info(module, method, " - the value is invalid: " + tmpRetryTimes, " - retry times");
            tmpRetryTimes = 3;
        }
        catch (NullPointerException e) {
            STD_LOGGER.info(module, method, " - the value is invalid(null)", " - retry times");
            tmpRetryTimes = 3;
        }
        conf.setRetryTimes(tmpRetryTimes);
        STD_LOGGER.info(module, method, "" + tmpRetryTimes, " - end");
    }

    public static void setRetryInterval(KmsConfiguration conf, String kmsName, String basekey, Properties properties) {
        String method = "setRetryInterval";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        int tmpRetryInterval = 1;
        try {
            tmpRetryInterval = Integer.parseInt(properties.getProperty(basekey + RETRY_INTERVAL));
            if (tmpRetryInterval < 1 || tmpRetryInterval > 60) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            STD_LOGGER.info(module, method, " - the value is invalid: " + tmpRetryInterval, " - retry interval");
            tmpRetryInterval = 1;
        }
        catch (NullPointerException e) {
            STD_LOGGER.info(module, method, " - the value is invalid(null)", " - retry interval");
            tmpRetryInterval = 1;
        }
        conf.setRetryInterval(tmpRetryInterval);
        STD_LOGGER.info(module, method, "" + tmpRetryInterval, " - end");
    }

    public static void setHostEnabled(KmsConfiguration conf, String kmsName, String basekey, Properties properties) {
        String method = "setHostEnabled";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String tmpHostEnabled = properties.getProperty(basekey + HOSTENABLED);
        if (tmpHostEnabled == null || tmpHostEnabled.length() == 0) {
            STD_LOGGER.info(module, method, " - the value is non", " - auth");
            conf.setEnabled(false);
        } else if (tmpHostEnabled.equalsIgnoreCase("true") || tmpHostEnabled.equalsIgnoreCase("false")) {
            if (tmpHostEnabled.equalsIgnoreCase("true")) {
                conf.setEnabled(true);
            } else {
                conf.setEnabled(false);
            }
        } else {
            STD_LOGGER.info(module, method, " - the value is invalid : " + tmpHostEnabled, " - auth");
            conf.setEnabled(false);
        }
        STD_LOGGER.info(module, method, tmpHostEnabled, " - end");
    }

    public static void setRegularbackupEnabled(KmsConfiguration conf, Properties properties) {
        String method = "setRegularbackupEnabled";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String regularbackupEnabled = properties.getProperty("kms.regularbackup.enabled");
        if (regularbackupEnabled == null || regularbackupEnabled.length() == 0) {
            STD_LOGGER.info(module, method, " - the value is non", " - auth");
            conf.setRegularbackupEnabled(false);
        } else if (regularbackupEnabled.equalsIgnoreCase("true") || regularbackupEnabled.equalsIgnoreCase("false")) {
            if (regularbackupEnabled.equalsIgnoreCase("true")) {
                conf.setRegularbackupEnabled(true);
            } else {
                conf.setRegularbackupEnabled(false);
            }
        } else {
            STD_LOGGER.info(module, method, " - the value is invalid : " + regularbackupEnabled, " - auth");
            conf.setRegularbackupEnabled(false);
        }
        STD_LOGGER.info(module, method, regularbackupEnabled, " - end");
    }

    public static void setRegularbackupSchedule(KmsConfiguration conf, Properties properties) {
        String method = "setRegularbackupSchedule";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String regularbackupSchedule = properties.getProperty("kms.regularbackup.schedule");
        if (regularbackupSchedule == null || regularbackupSchedule.length() == 0) {
            STD_LOGGER.info(module, method, " - the value is non", " - auth");
            conf.setRegularbackupSchedule("");
        } else {
            conf.setRegularbackupSchedule(regularbackupSchedule);
        }
        STD_LOGGER.info(module, method, regularbackupSchedule, " - end");
    }

    public static void setRegularbackupUserid(KmsConfiguration conf, Properties properties) {
        String method = "setRegularbackupUserid";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String regularbackupUserid = properties.getProperty("kms.regularbackup.userid");
        if (regularbackupUserid == null || regularbackupUserid.length() == 0) {
            STD_LOGGER.info(module, method, " - the value is non", " - auth");
            conf.setRegularbackupUserid("");
        } else {
            conf.setRegularbackupUserid(regularbackupUserid);
        }
        STD_LOGGER.info(module, method, regularbackupUserid, " - end");
    }

    public static void setRegularbackupPasswd(KmsConfiguration conf, Properties properties) {
        String method = "setRegularbackupPasswd";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String regularbackupPasswd = properties.getProperty("kms.regularbackup.passwd");
        if (regularbackupPasswd == null || regularbackupPasswd.length() == 0) {
            STD_LOGGER.info(module, method, " - the value is non", " - auth");
            conf.setRegularbackupPasswd("");
        } else {
            conf.setRegularbackupPasswd(regularbackupPasswd);
        }
        STD_LOGGER.info(module, method, "******", " - end");
    }
}

