/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.device;

import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serverux.dataimpl.DKCgetPDEVInfoEntry2;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoPdevDetail
extends SJmoModelData_Base
implements SJmoData_IF {
    static final long serialVersionUID = 7523114027721399186L;
    private SJmoPdevDetail ScPGTarget;
    private int iCDEV = -1;
    private int iRDEV = -1;
    private String strHDDSerialNo = "";
    private String strHDDLocation = "";
    private String strHDDKind = "";
    private long lHDDCapa = -1L;
    private String strHDDver = "";
    private int iHDDrpm = -1;
    private int iDriveKind = -1;
    private int iFB4 = -1;
    private int iPG = -1;
    private short sCLPR = (short)-1;
    private String strPdevIndexKey = "";
    private byte byDriveType = (byte)-1;
    private int iHDDStatus = -1;
    private long lHDDCapa2 = -1L;

    public int getCDEV() {
        return this.iCDEV;
    }

    public void setCDEV(int icdev) {
        this.iCDEV = icdev;
    }

    public int getRDEV() {
        return this.iRDEV;
    }

    public void setRDEV(int irdev) {
        this.iRDEV = irdev;
    }

    public String getHDDSerialNo() {
        return this.strHDDSerialNo;
    }

    public void setHDDSerialNo(String strHDDSerialNo) {
        this.strHDDSerialNo = strHDDSerialNo;
    }

    public String getHDDLocation() {
        return this.strHDDLocation;
    }

    public void setHDDLocation(String strHDDLocation) {
        this.strHDDLocation = strHDDLocation;
    }

    public String getHDDKind() {
        return this.strHDDKind;
    }

    public void setHDDKind(String strHDDKind) {
        this.strHDDKind = strHDDKind;
    }

    public long getHDDCapa() {
        return this.lHDDCapa;
    }

    public void setHDDCapa(long capa) {
        this.lHDDCapa = capa;
    }

    public String getHDDver() {
        return this.strHDDver;
    }

    public void setHDDver(String strHDDver) {
        this.strHDDver = strHDDver;
    }

    public int getHDDrpm() {
        return this.iHDDrpm;
    }

    public void setHDDrpm(int drpm) {
        this.iHDDrpm = drpm;
    }

    public int getDriveKind() {
        return this.iDriveKind;
    }

    public void setDriveKind(int driveKind) {
        this.iDriveKind = driveKind;
    }

    public int getFB4() {
        return this.iFB4;
    }

    public void setFB4(int ifb4) {
        this.iFB4 = ifb4;
    }

    public int getPG() {
        return this.iPG;
    }

    public void setPG(int ipg) {
        this.iPG = ipg;
    }

    public short getCLPR() {
        return this.sCLPR;
    }

    public void setCLPR(short sclpr) {
        this.sCLPR = sclpr;
    }

    public byte getDriveType() {
        return this.byDriveType;
    }

    public void setDriveType(byte byDrivePrm) {
        this.byDriveType = byDrivePrm;
    }

    public int getHDDStatus() {
        return this.iHDDStatus;
    }

    public void setHDDStatus(int iHDDStatus) {
        this.iHDDStatus = iHDDStatus;
    }

    public long getHDDCapa2() {
        return this.lHDDCapa2;
    }

    public void setHDDCapa2(long lHDDCapa2) {
        this.lHDDCapa2 = lHDDCapa2;
    }

    public SJmoPdevDetail() {
    }

    public SJmoPdevDetail(DKCgetPDEVInfoEntry2 rmiData) throws SJmoException {
        this.setAllData(rmiData);
    }

    public void setAllData(DKCgetPDEVInfoEntry2 rmiData) throws SJmoException {
        if (null != rmiData) {
            this.setCDEV(rmiData.getICDEV());
            this.setRDEV(rmiData.getIRDEV());
            this.getKey();
            if (null != rmiData.getStrHDDSerialNo()) {
                this.setHDDSerialNo(rmiData.getStrHDDSerialNo());
            }
            if (null != rmiData.getStrHDDLocation()) {
                this.setHDDLocation(rmiData.getStrHDDLocation());
            }
            if (null != rmiData.getStrHDDKind()) {
                this.setHDDKind(rmiData.getStrHDDKind());
            }
            this.setHDDCapa(rmiData.getLHDDCapa());
            if (null != rmiData.getStrHDDver()) {
                this.setHDDver(rmiData.getStrHDDver());
            }
            this.setHDDrpm(rmiData.getIHDDrpm());
            this.setDriveKind(rmiData.getIDriveKind());
            Robj_interface_RJiPGIndex pgIdx = rmiData.getObjPGIndex();
            if (null != pgIdx) {
                this.setFB4(pgIdx.getIFB4());
                this.setPG(pgIdx.getIPG());
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPdevDetail", "setAllData");
        }
        this.setCLPR(rmiData.getSCLPRNo());
        this.setDriveType(SJmoUtility.convertDriveType(rmiData.getByDriveTypeDetail()));
        this.setHDDStatus(rmiData.getHDDStatus());
        this.setHDDCapa2(rmiData.getLHDDCapa2());
    }

    public int getKeyIndex() {
        int iPdevIndex = -1;
        if (this.isValidKey()) {
            iPdevIndex = this.iCDEV << 8 | this.iRDEV;
        }
        return iPdevIndex;
    }

    public String getKey() {
        if (0 == this.strPdevIndexKey.length()) {
            this.strPdevIndexKey = this.makeKey();
        }
        return this.strPdevIndexKey;
    }

    public boolean isValidKey() {
        boolean bRet = true;
        if (0 > this.iCDEV || SJmoDataMacro_IF.NUM_MAX_CDEV < this.iCDEV) {
            bRet = false;
        } else if (0 > this.iRDEV || SJmoDataMacro_IF.NUM_MAX_RDEV < this.iRDEV) {
            bRet = false;
        }
        return bRet;
    }

    public String makeKey() {
        String strKey = "";
        if (this.isValidKey()) {
            strKey = SJmoUtility.itoh(this.getKeyIndex(), 4);
        }
        return strKey;
    }

    @Override
    public int compareTo(Object KeyObj) {
        return this.getKey().compareTo(KeyObj.toString());
    }

    public String toString() {
        return this.getKey();
    }
}

