/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.update;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import sanproject.serverux.dataimpl.RJiPortInfoDetail;
import sanproject.serverux.dataimpl.RJiPortInfoDetail_IN;
import sanproject.serverux.dataimpl.RJiPortInfoDetail_OUT;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.data.SJmoModelDataMgr;
import sanproject.sn2.model.data.util.SJmoIscsiUtility;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;
import sanproject.sn2.model.update.SJmoDataUpdate;

public class SJmoPortDetailUpdate
extends SJmoDataUpdate
implements SJmoKeyValueDefine_IF {
    private static final int RMIDATA_ARRAYLIST_SIZE = 4;
    private static final int RMIDATA_INDEX_PORT_DETAIL = 0;
    private static final int RMIDATA_INDEX_ISCSI_PORT = 1;
    private static final int RMIDATA_INDEX_ISCSI_PORT_CURRENT = 2;
    private static final int RMIDATA_INDEX_ISCSI_PORT_INITIATOR = 3;

    @Override
    protected Object getRmiData() throws SJmoException {
        ArrayList<Object> retList;
        block10: {
            retList = new ArrayList<Object>(4);
            RJiPortInfoDetail_IN portInput = new RJiPortInfoDetail_IN();
            try {
                RJiPortInfoDetail_OUT portOutput = (RJiPortInfoDetail_OUT)this.m_supAgnt.getDataInf(portInput, false);
                if (null == portOutput) {
                    this.m_strLog = "[SJmoPortDetailUpdate]getRmi:getDataInf port detail data is null";
                    this.putLog(this.m_strLog);
                    throw this.throwExp("SJmoPortDetailUpdate", "getRmiData");
                }
                retList.add(portOutput.getDataObject());
                SanRequest iscsiPortRequest = this.m_supAgnt.newRequest("iSCSIreadAllPortInfo");
                SanRequest iscsiPortInitiatorRequest = this.m_supAgnt.newRequest("iSCSIreadAlliScsiInitiators");
                SanResponse iscsiPortResponse = this.m_supAgnt.getDataInf(iscsiPortRequest, false);
                SanResponse iscsiPortInitiatorResponse = this.m_supAgnt.getDataInf(iscsiPortInitiatorRequest, false);
                if (null != iscsiPortResponse && null != iscsiPortInitiatorResponse) {
                    SJmoIscsiUtility.checkErrorInfo(iscsiPortResponse, "SJmoPortDetailUpdate", "getRmiData");
                    SJmoIscsiUtility.checkErrorInfo(iscsiPortInitiatorResponse, "SJmoPortDetailUpdate", "getRmiData");
                    SanList iscsiPortList = iscsiPortResponse.getList("iScsiPorts");
                    if (iscsiPortList.size() > 0) {
                        SanList iscsiPorInitiatortList = iscsiPortInitiatorResponse.getList("iScsiPorts");
                        if (iscsiPortList.size() != iscsiPorInitiatortList.size()) {
                            this.m_strLog = "[SJmoPortDetailUpdate]getRmi:getDataInf iscsiPortList size not equal iscsiPorInitiatortList size.";
                            this.putLog(this.m_strLog);
                        }
                        SanRequest iscsiPortCurRequest = this.m_supAgnt.newRequest("iSCSIreadPortNetworkConditions");
                        SanList reqestList = iscsiPortCurRequest.newList("iScsiPorts");
                        for (SanObject portObj : iscsiPortList) {
                            reqestList.addObj().putInt("Id", portObj.getInt("Id"));
                        }
                        SanResponse iscsiPortCurResponse = this.m_supAgnt.getDataInf(iscsiPortCurRequest, false);
                        if (null == iscsiPortCurResponse) {
                            this.m_strLog = "[SJmoPortDetailUpdate]getRmi:getDataInf iscsi port current data is null";
                            this.putLog(this.m_strLog);
                            throw this.throwExp("SJmoPortDetailUpdate", "getRmiData");
                        }
                        SJmoIscsiUtility.checkErrorInfo(iscsiPortCurResponse, "SJmoPortDetailUpdate", "getRmiData");
                        retList.add(iscsiPortResponse);
                        retList.add(iscsiPortCurResponse);
                        retList.add(iscsiPortInitiatorResponse);
                    } else {
                        retList.add(null);
                        retList.add(null);
                        retList.add(null);
                    }
                    break block10;
                }
                this.m_strLog = "[SJmoPortDetailUpdate]getRmi:getDataInf iscsi port data is null";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoPortDetailUpdate", "getRmiData");
            }
            catch (SanDataException e) {
                this.putLog(e.getMessage());
                throw this.throwExp("SJmoPortDetailUpdate", "getRmiData");
            }
            catch (SJdsSupplierException suExp) {
                throw suExp;
            }
        }
        return retList;
    }

    @Override
    protected boolean setModelData(SJmoModelDataMgr dataMgr, Object objRmi) throws SJmoException {
        Object iscsiPortInitiatorData;
        Object iscsiPortCurData;
        Object iscsiPortData;
        Object portDetailData;
        boolean bRet = true;
        if (null != objRmi) {
            if (!(objRmi instanceof ArrayList)) {
                this.m_strLog = "[SJmoPortDetailUpdate]setModelData:objRmi is invalied";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoPortDetailUpdate", "setModelData");
            }
            ArrayList rmiDataList = (ArrayList)objRmi;
            if (rmiDataList.size() != 4) {
                this.m_strLog = "[SJmoPortDetailUpdate]setModelData:objRmi list size is invalied";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoPortDetailUpdate", "setModelData");
            }
            portDetailData = rmiDataList.get(0);
            iscsiPortData = rmiDataList.get(1);
            iscsiPortCurData = rmiDataList.get(2);
            iscsiPortInitiatorData = rmiDataList.get(3);
            if (!(portDetailData instanceof RJiPortInfoDetail[])) {
                this.m_strLog = "[SJmoPortDetailUpdate]setModelData:objRmi is invalied";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoPortDetailUpdate", "setModelData");
            }
            if (iscsiPortData != null && !(iscsiPortData instanceof SanResponse)) {
                this.m_strLog = "[SJmoPortDetailUpdate]setModelData:objRmi is invalied";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoPortDetailUpdate", "setModelData");
            }
            if (iscsiPortCurData != null && !(iscsiPortCurData instanceof SanResponse)) {
                this.m_strLog = "[SJmoPortDetailUpdate]setModelData:objRmi is invalied";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoPortDetailUpdate", "setModelData");
            }
            if (iscsiPortInitiatorData != null && !(iscsiPortInitiatorData instanceof SanResponse)) {
                this.m_strLog = "[SJmoPortDetailUpdate]setModelData:objRmi is invalied";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoPortDetailUpdate", "setModelData");
            }
        } else {
            this.m_strLog = "[SJmoPortDetailUpdate]setModelData:objRmi is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoPortDetailUpdate", "setModelData");
        }
        dataMgr.setRenewPortDetailData((RJiPortInfoDetail[])portDetailData, (SanResponse)iscsiPortData, (SanResponse)iscsiPortCurData, (SanResponse)iscsiPortInitiatorData);
        return bRet;
    }
}

