/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtSsidInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;
import sanproject.sn2.rptdt.util.SJdtRPTDTUtils;

public class SJdtLogicaldeviceReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Logicaldevice";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"ldevId", "ldevName", "capacity", "emulationType", "resourceGroupName", "resourceGroupId", "pg", "raidLevel", "driveTypeRpm", "driveTypeCode", "driveCapacity", "pgMembers", "allocated", "ssid", "cvs", "ocs", "attribute", "provisioningType", "poolName", "poolID", "currentMpb", "settingMpb", "commandDeviceSecurity", "commandDeviceUserAuthentication", "commandDeviceDeviceGroupDefinition", "encryption"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"ldevId", "ldevName", "capacity", "emulationType", "resourceGroupName", "resourceGroupId", "pg", "raidLevel", "driveTypeRpm", "driveTypeCode", "driveCapacity", "pgMembers", "allocated", "ssid", "cvs", "ocs", "attribute", "provisioningType", "poolName", "poolID", "currentMpu", "settingMpu", "commandDeviceSecurity", "commandDeviceUserAuthentication", "commandDeviceDeviceGroupDefinition", "encryption", "aluaMode", "t10pi"};
    private static final int COLUMN_LENGTH = SJdtLogicaldeviceReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final int HM_COLUMN_LENGTH = SJdtLogicaldeviceReportGenerator.getColumnLengthForKeySort(HM_HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Logicaldevice";
    private static final String EXPLANATION_KEY = "Common.explanation.Logicaldevice";
    private static final String TABLE_HEADER_BASE_KEY = "Logicaldevice.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Logicaldevice.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Logicaldevice.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Logicaldevice.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Logicaldevice.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Logicaldevice.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Logicaldevice.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtSsidInfoCSVWrapper ssidInfo = (SJdtSsidInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("SsidInfo.csv");
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        List<String[]> csvDataList = ldevInfo.getCsvDataList();
        for (String[] ldevInfoRecord : csvDataList) {
            String aluaMode;
            String t10pi;
            String encryption;
            String settingMpBlade;
            String currentMpBlade;
            String poolID;
            String poolName;
            String ldevType;
            String ldevAttribute;
            String ocs;
            String cvs;
            String allocated;
            String eccGroup;
            String emulationType;
            String volumeSize;
            String ldevName;
            String[] oneRecord = null;
            oneRecord = SJdtRPTDTDevice.isHmdev() ? new String[HM_COLUMN_LENGTH] : new String[COLUMN_LENGTH];
            String ldev = ldevInfo.getValue(ldevInfoRecord, "LDEV#");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"ldevId")).intValue()] = ldev.toUpperCase();
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"ldevName")).intValue()] = ldevName = ldevInfo.getValue(ldevInfoRecord, "LDEV Name");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"capacity")).intValue()] = volumeSize = ldevInfo.getValue(ldevInfoRecord, "Volume Size(MB)");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"emulationType")).intValue()] = emulationType = ldevInfo.getValue(ldevInfoRecord, "LDEV Emulation");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = ldevInfo.getValue(ldevInfoRecord, "Resource Group Name (LDEV)");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = ldevInfo.getValue(ldevInfoRecord, "Resource Group ID (LDEV)");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"pg")).intValue()] = eccGroup = ldevInfo.getValue(ldevInfoRecord, "ECC Group");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"allocated")).intValue()] = allocated = ldevInfo.getValue(ldevInfoRecord, "Allocated");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"cvs")).intValue()] = cvs = ldevInfo.getValue(ldevInfoRecord, "CVS");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"ocs")).intValue()] = ocs = ldevInfo.getValue(ldevInfoRecord, "ORACLE CHECK SUM");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"attribute")).intValue()] = ldevAttribute = ldevInfo.getValue(ldevInfoRecord, "LDEV Attribute");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"provisioningType")).intValue()] = ldevType = ldevInfo.getValue(ldevInfoRecord, "LDEV Type");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"poolName")).intValue()] = poolName = ldevInfo.getValue(ldevInfoRecord, "Pool Name");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"poolID")).intValue()] = poolID = this.changeHyphenDisplayStr(ldevInfo.getValue(ldevInfoRecord, "Pool ID"));
            if (SJdtRPTDTDevice.isHmdev()) {
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"currentMpu")).intValue()] = currentMpBlade = ldevInfo.getValue(ldevInfoRecord, "Current MPU");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"settingMpu")).intValue()] = settingMpBlade = ldevInfo.getValue(ldevInfoRecord, "Setting MPU");
            } else {
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"currentMpb")).intValue()] = currentMpBlade = ldevInfo.getValue(ldevInfoRecord, "Current MP Blade");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"settingMpb")).intValue()] = settingMpBlade = ldevInfo.getValue(ldevInfoRecord, "Setting MP Blade");
            }
            if ("CMDDEV".equals(ldevAttribute)) {
                String cmdDevDevGrpDef;
                String cmdDevUserAuthentication;
                String cmdDevSecurity;
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"commandDeviceSecurity")).intValue()] = cmdDevSecurity = ldevInfo.getValue(ldevInfoRecord, "CmdDevSecurity");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"commandDeviceUserAuthentication")).intValue()] = cmdDevUserAuthentication = ldevInfo.getValue(ldevInfoRecord, "CmdDevUserAuth");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"commandDeviceDeviceGroupDefinition")).intValue()] = cmdDevDevGrpDef = ldevInfo.getValue(ldevInfoRecord, "CmdDevDevGrpDef");
            } else {
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"commandDeviceSecurity")).intValue()] = "-";
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"commandDeviceUserAuthentication")).intValue()] = "-";
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"commandDeviceDeviceGroupDefinition")).intValue()] = "-";
            }
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"encryption")).intValue()] = encryption = ldevInfo.getValue(ldevInfoRecord, "Encryption");
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"t10pi")).intValue()] = t10pi = ldevInfo.getValue(ldevInfoRecord, "T10 PI");
            if (this.isInternalGroup(eccGroup)) {
                String pdevLocation;
                String deviceCapacity;
                String deviceTypeCode;
                String raidLevel;
                String[] pdevInfoRecord = pdevInfo.getMatchedOneRecord(eccGroup, "ECC Group");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"raidLevel")).intValue()] = raidLevel = pdevInfo.getValue(pdevInfoRecord, "RAID Level");
                String deviceType = pdevInfo.getValue(pdevInfoRecord, "Device Type");
                String rpm = pdevInfo.getValue(pdevInfoRecord, "RPM");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"driveTypeRpm")).intValue()] = this.getDriveTypeRpm(deviceType, rpm);
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = deviceTypeCode = pdevInfo.getValue(pdevInfoRecord, "Device Type-Code");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = deviceCapacity = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
                List<String> pdevLocationList = pdevInfo.getMatchedAllRecordColumnValue(eccGroup, "ECC Group", "PDEV Location");
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"pgMembers")).intValue()] = pdevLocation = SJdtRPTDTUtils.getAddSeparatorStr(pdevLocationList, ";");
            } else {
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"raidLevel")).intValue()] = "-";
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"driveTypeRpm")).intValue()] = "-";
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = "-";
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = "-";
                oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"pgMembers")).intValue()] = "-";
            }
            String ssid = ssidInfo.getSsid(ldev);
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"ssid")).intValue()] = ssid.toUpperCase();
            oneRecord[((Integer)SJdtLogicaldeviceReportGenerator.headerMap.get((Object)"aluaMode")).intValue()] = aluaMode = ldevInfo.getValue(ldevInfoRecord, "ALUA Mode");
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }
}

