/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtELunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtJnlInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMfDMInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMpPcbStatusCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtMpbladedetailReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Mpbladedetail";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"mpBladeId", "mpBladeName", "autoAssignment", "resourceId", "resourceName", "type"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"mpUnitId", "autoAssignment", "resourceId", "resourceName", "type"};
    private static final int COLUMN_LENGTH = SJdtMpbladedetailReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final int HM_COLUMN_LENGTH = SJdtMpbladedetailReportGenerator.getColumnLengthForKeySort(HM_HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Mpbladedetail";
    private static final String EXPLANATION_KEY = "Common.explanation.Mpbladedetail";
    private static final String TABLE_HEADER_BASE_KEY = "Mpbladedetail.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Mpbladedetail.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Mpbladedetail.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Mpbladedetail.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Mpbladedetail.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Mpbladedetail.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Mpbladedetail.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtELunInfoCSVWrapper eLunInfo = (SJdtELunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ELunInfo.csv");
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        SJdtJnlInfoCSVWrapper jnlInfo = (SJdtJnlInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("JnlInfo.csv");
        SJdtMfDMInfoCSVWrapper mfDMInfo = (SJdtMfDMInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MfDMInfo.csv");
        if (SJdtRPTDTDevice.isHmdev()) {
            for (int i = 0; i < mpPcbStatus.getCsvDataListSize(); ++i) {
                String[] oneRecord;
                String mpPuId = mpPcbStatus.getValue(i, "MPU ID");
                String autoAssignment = mpPcbStatus.getValue(i, "Auto Assignment");
                List<String[]> ldevInfoRecordList = ldevInfo.getMatchedAllRecord(mpPuId, "Current MPU");
                List<String> eccGroupList = eLunInfo.getMatchedAllRecordColumnValue(mpPuId, "Current MPU", "ECC Group");
                LinkedHashSet<String> eccGroupSet = new LinkedHashSet<String>(eccGroupList);
                List<String[]> jnlInfoRecordList = jnlInfo.getMatchedAllRecord(mpPuId, "Current MPU");
                for (String[] ldevInfoRecord : ldevInfoRecordList) {
                    oneRecord = new String[HM_COLUMN_LENGTH];
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpUnitId")).intValue()] = mpPuId;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = autoAssignment;
                    String ldev = ldevInfo.getValue(ldevInfoRecord, "LDEV#");
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceId")).intValue()] = ldev.toUpperCase();
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceName")).intValue()] = ldevInfo.getValue(ldevInfoRecord, "LDEV Name");
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"type")).intValue()] = "LDEV";
                    tableDataList.add(oneRecord);
                }
                for (String[] jnlInfoRecord : jnlInfoRecordList) {
                    oneRecord = new String[HM_COLUMN_LENGTH];
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpUnitId")).intValue()] = mpPuId;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = autoAssignment;
                    String jnl = jnlInfo.getValue(jnlInfoRecord, "JNL#");
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceId")).intValue()] = jnl.toUpperCase();
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceName")).intValue()] = "-";
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"type")).intValue()] = "Journal";
                    tableDataList.add(oneRecord);
                }
                for (String eccGroup : eccGroupSet) {
                    oneRecord = new String[HM_COLUMN_LENGTH];
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpUnitId")).intValue()] = mpPuId;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = autoAssignment;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceId")).intValue()] = eccGroup;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceName")).intValue()] = "-";
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"type")).intValue()] = "External Volume";
                    tableDataList.add(oneRecord);
                }
            }
        } else {
            for (int i = 0; i < mpPcbStatus.getCsvDataListSize(); ++i) {
                String[] oneRecord;
                String mpPcbId = mpPcbStatus.getValue(i, "MP PCB ID");
                String mpPcbLocation = mpPcbStatus.getValue(i, "MP PCB Location");
                String autoAssignment = mpPcbStatus.getValue(i, "Auto Assignment");
                String mpBlade = mpPcbId + ";" + mpPcbLocation;
                List<String[]> ldevInfoRecordList = ldevInfo.getMatchedAllRecord(mpBlade, "Current MP Blade");
                List<String> eccGroupList = eLunInfo.getMatchedAllRecordColumnValue(mpBlade, "Current MP Blade", "ECC Group");
                LinkedHashSet<String> eccGroupSet = new LinkedHashSet<String>(eccGroupList);
                List<String[]> jnlInfoRecordList = jnlInfo.getMatchedAllRecord(mpBlade, "Current MP Blade");
                List<String[]> mVolGroupList = mfDMInfo.getMatchedAllRecord(mpBlade, "Current MP Blade");
                for (String[] ldevInfoRecord : ldevInfoRecordList) {
                    oneRecord = new String[COLUMN_LENGTH];
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeId")).intValue()] = mpPcbId;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeName")).intValue()] = mpPcbLocation;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = autoAssignment;
                    String ldev = ldevInfo.getValue(ldevInfoRecord, "LDEV#");
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceId")).intValue()] = ldev.toUpperCase();
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceName")).intValue()] = ldevInfo.getValue(ldevInfoRecord, "LDEV Name");
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"type")).intValue()] = "LDEV";
                    tableDataList.add(oneRecord);
                }
                for (String[] jnlInfoRecord : jnlInfoRecordList) {
                    oneRecord = new String[COLUMN_LENGTH];
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeId")).intValue()] = mpPcbId;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeName")).intValue()] = mpPcbLocation;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = autoAssignment;
                    String jnl = jnlInfo.getValue(jnlInfoRecord, "JNL#");
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceId")).intValue()] = jnl.toUpperCase();
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceName")).intValue()] = "-";
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"type")).intValue()] = "Journal";
                    tableDataList.add(oneRecord);
                }
                for (String eccGroup : eccGroupSet) {
                    oneRecord = new String[COLUMN_LENGTH];
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeId")).intValue()] = mpPcbId;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeName")).intValue()] = mpPcbLocation;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = autoAssignment;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceId")).intValue()] = eccGroup;
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceName")).intValue()] = "-";
                    oneRecord[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"type")).intValue()] = "External Volume";
                    tableDataList.add(oneRecord);
                }
                for (String[] mfDMInfoRecord : mVolGroupList) {
                    String[] oneRecord2 = new String[COLUMN_LENGTH];
                    oneRecord2[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeId")).intValue()] = mpPcbId;
                    oneRecord2[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"mpBladeName")).intValue()] = mpPcbLocation;
                    oneRecord2[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"autoAssignment")).intValue()] = autoAssignment;
                    String mfDM = mfDMInfo.getValue(mfDMInfoRecord, "Migration Volume Group");
                    oneRecord2[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceId")).intValue()] = mfDM.toUpperCase();
                    oneRecord2[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"resourceName")).intValue()] = "-";
                    oneRecord2[((Integer)SJdtMpbladedetailReportGenerator.headerMap.get((Object)"type")).intValue()] = "External Volume";
                    tableDataList.add(oneRecord2);
                }
            }
        }
        return tableDataList;
    }
}

